ORCA/M Asm65816 2.1.0

0001 E000              *******************************************************************************
0002 E000              *
0003 E000              *               Copyright (c) 1987-1992
0004 E000              *               Apple Computer, Inc.
0005 E000              *               All rights reserved.
0006 E000              *
0007 E000              *******************************************************************************
0008 E000              *
0009 E000              *               GS/OS Device Dispatcher
0010 E000              *
0011 E000              *               This binary file to be loaded into
0012 E000              *               location $E0E000.
0013 E000              *
0014 E000              *               Written by: Raymond B. Montagne
0015 E000              *
0016 E000              *******************************************************************************
0017 E000              *
0018 E000              * Revision History:
0019 E000              *
0020 E000              * mm/dd/yy Ver.   Who What
0021 E000              *
0022 E000              * 04/13/87 through 6/07/89
0023 E000              *                 GAB For revision history within these dates, see an archived
0024 E000              *                       version of this file.
0025 E000              *
0026 E000              * 03/11/91 6.0d28 GAB During a full shutdown (command == 3), the dispatcher
0027 E000              *                       will now call each driver that supports removeable
0028 E000              *                       media to perform an Eject command.
0029 E000              *                     sp_trans_id table changed so that a device with a
0030 E000              *                       SmartPort ID of $0D is now translated to a GS/OS
0031 E000              *                       device ID of $0B (printer).
0032 E000              *
0033 E000              * 03/25/91 6.0d30 GAB set_wait_mode was not validating the request count
0034 E000              *                       correctly.  It would return an invalid parameter error
0035 E000              *                       when the request count != 0, instead of != 2.  Fixed.
0036 E000              *                     Various call dispatches have been enhanced to use the
0037 E000              *                       Absolute Indexed Indirect addressing mode.
0038 E000              *
0039 E000              * 04/11/91 6.0d32 GAB Find_File fixed so that it compares the two string lengths
0040 E000              *                       prior to comparing the contents of the strings.
0041 E000              *                     Replaced all calls to get_cold_flag with a direct access load
0042 E000              *                       of the warm/cold boot flag.  Sure, it may cost one extra
0043 E000              *                       byte per access, but it's also 12 cycles faster.
0044 E000              *                     do_file_load now saves the carry flag correctly on entry.
0045 E000              *
0046 E000              * 04/15/91 6.0d32 GAB Duplicate supervisor drivers are now unloaded correctly with
0047 E000              *                       the supervisor list being patched up properly.  Prior versions
0048 E000              *                       were modifying the supervisor headers instead of the
0049 E000              *                       supervisor list.
0050 E000              *
0051 E000              * 07/12/91 6.0d44 GAB Problem: When switching back to GSOS from P8, GQuit is passing
0052 E000              *                       the address of Boot.Driver to the device dispatcher for the
0053 E000              *                       restart.  During the original boot, though, the device
0054 E000              *                       dispatcher disposed of Boot.Driver when the loaded AppleTalk
0055 E000              *                       driver was brought into memory to replace it.  I fixed it so
0056 E000              *                       that if BOOT.DRIVER is replaced by a subsequent loaded
0057 E000              *                       driver, BOOT.DRIVER is simply sent a Shutdown command, but
0058 E000              *                       no UserShutdown is performed (i.e. it's not removed from
0059 E000              *                       memory).
0060 E000              *
0061 E000              * 09/05/91 6.0d48 GAB Bug fix:  During dd_shutdown, the System Loader was making
0062 E000              *                       OS calls to close the load file when a non-restartable
0063 E000              *                       driver was shutdown.  This trashed the driver number that
0064 E000              *                       the dispatcher was using as an index into the device list
0065 E000              *                       to ensure that all drivers were shutdown.  This has been
0066 E000              *                       fixed by saving and restoring the driver number around
0067 E000              *                       the call to shutdn_driver.
0068 E000              *                     Bug fix:  In shutdn_driver, the code was checking the boot
0069 E000              *                       device to see if it was a generated driver, and not shutting
0070 E000              *                       it down if it is (since it was never really started up in
0071 E000              *                       the first place).  Unfortunately, it was using a leftover
0072 E000              *                       driver_dib_ptr.  I added a call to set_dib_ptr just prior
0073 E000              *                       to the check to ensure that we're looking at the correct
0074 E000              *                       DIB.
0075 E000              *
0076 E000              * 09/26/91 6.0d51 GAB Bug fix:  During startup, the dispatcher was not respecting
0077 E000              *                       the setting of the "hardware independent" bit of a driver's
0078 E000              *                       slot number (stored in the DIB).  Fixed by storing the
0079 E000              *                       full 16-bit value of the driver's slot number in
0080 E000              *                       copy_cur_name (instead of zeroing the upper 8 bits), and
0081 E000              *                       skipping the check in slot_unit_chk if the current
0082 E000              *                       DIB's bit is set.
0083 E000              *
0084 E000              * 11/13/91 6.0d58 GAB Add logic to generated driver READ handler so that read
0085 E000              *                       requests to a Pascal interface will always return a
0086 E000              *                       character in the user's buffer if the firmware actually
0087 E000              *                       returns a character to us.  The generated core has been
0088 E000              *                       modified to always return a character in the low byte
0089 E000              *                       of the accumulator, and any possible error code in the
0090 E000              *                       high byte.  If an error did occur, the carry will be
0091 E000              *                       set on return from the bank 0 core, and the error code
0092 E000              *                       will be shifted up from $2x (what the firmware returns)
0093 E000              *                       to $3x (which will take it out of the range of the "real"
0094 E000              *                       device driver errors.
0095 E000              *
0096 E000              * 9-Mar-93 6.0.1d14 JCM No code-level changes in this file. I updated the diagrams
0097 E000              *                       of the device characteristics word to cover the newly defined
0098 E000              *                       "device follows guidelines" bit ($0010).
0099 E000              *
0100 E000              *******************************************************************************
0101 E000              scsi_alert equ   43
0102 E000              unidisk_alert equ   44
0103 E000              appledisk_alert equ   45
0104 E000
0105 E000                       print off
0106 E000                       include 'gsos.macros.src' 
0107 E000                       include 'common.equ.src' 
0108 E000                       include 'hw.equ.src' 
0109 E000                       include 'driver.equ.src' 
0110 E000
0111 E000
0112 E000                       import b0_core
0113 E000                       import bank0_dsptch
0114 E000                       import block_cnt
0115 E000                       import buf_to_system
0116 E000                       import buff_to_cache
0117 E000                       import cache_to_buff
0118 E000                       import call_list_ptr
0119 E000                       import config_ram
0120 E000
0121 E000                       import get_fmt_list
0122 E000                       import get_fmt_reqcnt
0123 E000                       import get_fmt_slist
0124 E000                       import get_fmt_unit
0125 E000                       import machine_id
0126 E000                       import param_list_ptr
0127 E000                       import set_fmt_clist
0128 E000                       import set_fmt_list
0129 E000                       import set_fmt_req
0130 E000                       import set_fmt_unit
0131 E000                       import sys_buffer
0132 E000                       import system_to_buf
0133 E000                       import sp_stat3
0134 E000                       import esp_stat3
0135 E000                       import slot_arbiter
0136 E000                       import set_gsos_speed
0137 E000                       import lc_dispatcher
0138 E000                       import STOP_SCRN_CHK
0139 E000                       import start_scrn_chk
0140 E000
0141 E000                       print on
0142 E000
0143 E000                       eject 
0144 E000              ***************************************************************
0145 E000              *
0146 E000              * The following are signature bytes for ProDOS block devices.
0147 E000              *
0148 E000              ***************************************************************
0149 E000                       export bank_e0_segr
0150 E000              bank_e0_segr proc 
0151 E000                       DataChk off
0152 E000
0153 E000              pro_sig   
0154 E000 03                    DC B:$03                       ; $Cn05 signature
0155 E001 00                    DC B:$00                       ; $Cn03 signature
0156 E002 20                    DC B:$20                       ; $Cn01 signature
0157 E003 00                    DC B:$00                       ; $Cn07 SmartPort signature
0158 E004
0159 E004              ***************************************************************
0160 E004              *
0161 E004              * The following are signature bytes for Pascal1.1 devices.
0162 E004              *
0163 E004              ***************************************************************
0164 E004              pascal_sig  
0165 E004 38                    DC B:$38                       ; $Cn05 signature
0166 E005 18                    DC B:$18                       ; $Cn07 signature
0167 E006 01                    DC B:$01                       ; $Cn0B signature
0168 E007
0169 E007              ***************************************************************
0170 E007              *
0171 E007              * The following are $Cn0C type bytes for Pascal1.1 devices.
0172 E007              * Note that the least significant nibble is not relevant to
0173 E007              * the Pascal1.1 device type.
0174 E007              *
0175 E007              ***************************************************************
0176 E007              pascal_type  
0177 E007 10                    DC B:$10                       ; printer
0178 E008 30                    DC B:$30                       ; serial
0179 E009 40                    DC B:$40                       ; modem
0180 E00A 80                    DC B:$80                       ; 80 Column
0181 E00B 90                    DC B:$90                       ; Network / Bus
0182 E00C
0183 E00C              ***************************************************************
0184 E00C              *
0185 E00C              * The following data is for a SmartPort parameter list
0186 E00C              * to be used in making a Unit 0 status call to determine
0187 E00C              * the number of devices connect to the SmartPort interface.
0188 E00C              * Note that this data must be moved to bank 0 for a standard
0189 E00C              * SmartPort call.
0190 E00C              *
0191 E00C              ***************************************************************
0192 E00C              sp_unit0  
0193 E00C 03                    DC B:$03                       ; parameter count
0194 E00D 00                    DC B:$00                       ; unit 0
0195 E00E 00 AA                 DC W:sys_buffer                ; buffer pointer
0196 E010 00                    DC B:$00                       ; status code
0197 E011 00                    DC B:$00                       ; spare (required for g.read)
0198 E012 00                    DC B:$00
0199 E013
0200 E013                       eject 
0201 E013              *****************************************************************
0202 E013              *
0203 E013              * This table is used to translate SmartPort type bytes
0204 E013              * into GSOS Driver ID Numbers.  GS/OS ID numbers are as
0205 E013              * follows:
0206 E013              *
0207 E013              *       $0000   AppleDisk 5.25
0208 E013              *       $0001   Profile (5 Meg)
0209 E013              *       $0002   Profile (10 Meg)
0210 E013              *       $0003   AppleDisk 3.5 or UniDisk 3.5
0211 E013              *       $0004   SCSI Generic
0212 E013              *       $0005   SCSI Hard Disk
0213 E013              *       $0006   SCSI Tape Drive
0214 E013              *       $0007   SCSI CD ROM
0215 E013              *       $0008   SCSI Printer
0216 E013              *       $0009   Modem
0217 E013              *       $000A   Console
0218 E013              *       $000B   Printer
0219 E013              *       $000C   Serial LaserWriter
0220 E013              *       $000D   AppleTalk LaserWriter
0221 E013              *       $000E   RAM Disk
0222 E013              *       $000F   ROM Disk
0223 E013              *       $0010   File Server
0224 E013              *       $0011   IBX Driver
0225 E013              *       $0012   Apple DeskTop Bus
0226 E013              *       $0013   Hard Disk Generic
0227 E013              *       $0014   Floppy Disk Generic
0228 E013              *       $0015   Tape Drive Generic
0229 E013              *       $0016   Character Device Generic
0230 E013              *       $0017   MFM Floppy Disk
0231 E013              *       $0018   Network Generic
0232 E013              *       $0019   SCSI Sequential Access Device
0233 E013              *
0234 E013              *****************************************************************
0235 E013              sp_trans_id                             ; sp = GS/OS Device ID Number
0236 E013 0E 00                 DC W:$000E                     ; 00 = 0E Ram Disk
0237 E015 03 00                 DC W:$0003                     ; 01 = 03 Disk 3.5
0238 E017 02 00                 DC W:$0002                     ; 02 = 02 JVC HD (ProFILE)
0239 E019 04 00                 DC W:$0004                     ; 03 = 04 SCSI (generic)
0240 E01B 0F 00                 DC W:$000F                     ; 04 = 0F Rom Disk
0241 E01D 07 00                 DC W:$0007                     ; 05 = 07 SCSI CD-ROM
0242 E01F 06 00                 DC W:$0006                     ; 06 = 06 SCSI Tape
0243 E021 05 00                 DC W:$0005                     ; 07 = 05 SCSI HD
0244 E023 19 00                 DC W:$0019                     ; 08 = 19 SCSI Sequential Device
0245 E025 1A 00                 DC W:$001A                     ; 09 = 1A SCSI Printer
0246 E027 00 00                 DC W:$0000                     ; 0A = 00 AppleDisk5.25
0247 E029 14 00                 DC W:$0014                     ; 0B = 14 Reserved (BERT)
0248 E02B 00 00                 DC W:$0000                     ; 0C = 00 Reserved (BERT)
0249 E02D 0B 00                 DC W:$000B                     ; 0D = 0B Printer
0250 E02F 00 00                 DC W:$0000                     ; 0E = 00 Clock (not for A//GS)
0251 E031 09 00                 DC W:$0009                     ; 0F = 09 Modem
0252 E033 03 00                 DC W:$0003                     ; 10 = 03 Super Drive
0253 E035              *
0254 E035              * Note that SmartPort ID's above $0F will be translated to GS/OS ID $0014
0255 E035              * signifying a generic floppy disk.
0256 E035              *
0257 E035                       eject 
0258 E035              ***************************************************************
0259 E035              *
0260 E035              * Variables, Handles and ID's are stored in this data area.
0261 E035              *
0262 E035              ***************************************************************
0263 E035 09 3F        dev_list_id DC W:0                      ; save device list ID here
0264 E037 D0 19 E1 00  dev_list_hndl DC L:0                    ; save device list handle here
0265 E03B 3C 00 00 00  dev_list_size DC L:0                    ; size of device list handle
0266 E03F 3C 00 00 00  handle_size DC L:0                      ; handle size used by set_handle_size
0267 E043
0268 E043              ***************************************************************
0269 E043              *
0270 E043              *       The following variables are used in managing the
0271 E043              *       device dispatcher file list associated with the
0272 E043              *       P8 restart from memory code.
0273 E043              *
0274 E043              ***************************************************************
0275 E043 0A 3F        file_list_id DC W:0                     ; user ID assigned to the file list
0276 E045 E4 19 E1 00  file_list_hndl DC L:0                   ; handle assigned to the file list
0277 E049 60 00 00 00  file_list_size DC L:0                   ; size of file list handle
0278 E04D 00 00        file_list_index DC W:0                  ; current index into the file list
0279 E04F 00 00        file_list_entry DC W:0
0280 E051 02 00        file_list_cnt DC W:0                    ; number of entries in the file list
0281 E053
0282 E053              ***************************************************************
0283 E053              *
0284 E053              *       The following variables are used in managing the
0285 E053              *       device and supervisor list as well as generated DIBs.
0286 E053              *
0287 E053              ***************************************************************
0288 E053 0B 3D        gen_drvr_id DC W:0                      ; generated driver list id here
0289 E055 F8 19 E1 00  gen_drvr_hndl DC L:0                    ; generated driver list handle
0290 E059 C8 01 00 00  drvr_list_size DC L:0                   ; size of DIB/GDIB list
0291 E05D
0292 E05D 01 00        gen_count DC W:0                        ; running count of generated drivers
0293 E05F 00 00        gen_slot_num DC W:0                     ; slot for current device generation
0294 E061 06 00        total_gen DC W:0                        ; total number of generated drivers
0295 E063
0296 E063 20 20 20 20  name_buff DS B:8                        ; buffer for device name generation
0297 E06B
0298 E06B 0E 00        drvr_list DC W:14
0299 E06D 53 59 53 54  drvr_list_str DC B:'SYSTEM:DRIVERS'
0300 E07B
0301 E07B 00 00        drvr_list_id DC W:0                     ; user id for 'DRVR.LIST'
0302 E07D 00 00        drvr_file_num DC W:0                    ; file number for 'DRVR.LIST'
0303 E07F
0304 E07F 11 00        driver_count DC W:1                     ; number of devices
0305 E081 05 00        load_device DC W:2                      ; current device being loaded
0306 E083
0307 E083 00 00        old_dev_num DC W:0                      ; device number of replaced device
0308 E085 01 00        cur_dev_num DC W:0                      ; device number of current device
0309 E087 04 44 45 56  current_name DS B:32                    ; name of current loaded driver
0310 E0A7 0F 00        current_slot DC W:0                     ; slot for current device
0311 E0A9 01 00        current_unit DC W:0                     ; unit for current device
0312 E0AB 01 00        current_version DC W:0                  ; version for current device
0313 E0AD 02 00        current_dev_id DC W:0                   ; Device ID for current device
0314 E0AF 0E 39        cur_user_id DC W:0                      ; user ID for loaded device
0315 E0B1
0316 E0B1 00 00        shutdown_id DC W:0                      ; current ID of driver being purged
0317 E0B3 00 00        dd_os_call DC W:0                       ; OS call that currently is executing
0318 E0B5
0319 E0B5 00 00        dib_count DC W:0                        ; number of dibs this file
0320 E0B7 01 00        start_count DC W:0                      ; number of DIBs indicated by auxtype
0321 E0B9
0322 E0B9 02 00        purge_flag DC W:0                       ; non zero if 1 loaded device started
0323 E0BB
0324 E0BB 0F 00        d_boot_slot DC W:0                      ; my boot slot
0325 E0BD
0326 E0BD 0C 3E        sup_drvr_id DC W:0                      ; user ID for supervisor driver list
0327 E0BF 0C 1A E1 00  sup_drvr_hndl DC L:0                    ; handle for supervisor driver list
0328 E0C3 00 00        sup_drvr_cnt DC W:0                     ; count of supervisor drivers
0329 E0C5 00 00        sup_drvr_num DC W:0                     ; supervisory driver number
0330 E0C7 00 00        cur_sib_id DC W:0                       ; current supervisor ID
0331 E0C9 00 00        cur_sib_ver DC W:0                      ; current supervisor version
0332 E0CB 00 00        cur_sup  DC W:0                         ; current supervisor duplicate search
0333 E0CD
0334 E0CD 00 00        pro_char DC W:0                         ; for building device characteristics
0335 E0CF
0336 E0CF              *
0337 E0CF              * The following variables are used to manage the alert dialog
0338 E0CF              * display when a device driver is required.
0339 E0CF              *
0340 E0CF 00 00        ud_count DC W:0                         ; number of UniDisks found
0341 E0D1 00 00        ad_count DC W:0                         ; number of AppleDisks found
0342 E0D3 00 00        scsi_count DC W:0                       ; number of SCSI's found
0343 E0D5
0344 E0D5                       eject 
0345 E0D5              *******************************************************************************
0346 E0D5              *
0347 E0D5              * A driver's DIB must contain the following information:
0348 E0D5              *
0349 E0D5              *               Long    Link Pointer
0350 E0D5              *               Long    Entry Pointer
0351 E0D5              *               Word    Device Characteristics (see below)
0352 E0D5              *  ___ ___ ___ ___ ___ ___ ___ ___ ___ ___ ___ ___ ___ ___ ___ ___
0353 E0D5              * |   |   |   |   |   |   |   |   |   |   |   |   |   |   |   |   |
0354 E0D5              * | F | E | D | C | B | A | 9 | 8 | 7 | 6 | 5 | 4 | 3 | 2 | 1 | 0 |
0355 E0D5              * |___|___|___|___|___|___|___|___|___|___|___|___|___|___|___|___|
0356 E0D5              *   |   |   |   |   |   |   |   |   |   |   |   |   |   |   |   |__ RESERVED (cleared to 0)
0357 E0D5              *   |   |   |   |   |   |   |   |   |   |   |   |   |   |   |______ RESERVED (cleared to 0)
0358 E0D5              *   |   |   |   |   |   |   |   |   |   |   |   |   |   |__________ Media remov
0359 E0D5              *   |   |   |   |   |   |   |   |   |   |   |   |   |______________ Format
0360 E0D5              *   |   |   |   |   |   |   |   |   |   |   |   |__________________ Driver follows guidelines
0361 E0D5              *   |   |   |   |   |   |   |   |   |   |   |______________________ Read
0362 E0D5              *   |   |   |   |   |   |   |   |   |   |__________________________ Write
0363 E0D5              *   |   |   |   |   |   |   |   |   |______________________________ Block Dev
0364 E0D5              *   |   |   |   |   |   |   |   |__________________________________ Speed Group
0365 E0D5              *   |   |   |   |   |   |   |______________________________________ Speed Group
0366 E0D5              *   |   |   |   |   |   |__________________________________________ Fixed Name
0367 E0D5              *   |   |   |   |   |______________________________________________ Restartable
0368 E0D5              *   |   |   |   |__________________________________________________ Device Busy (managed by dispatcher)
0369 E0D5              *   |   |   |______________________________________________________ Linked
0370 E0D5              *   |   |__________________________________________________________ Generated
0371 E0D5              *   |______________________________________________________________ RamRom Disk
0372 E0D5              *
0373 E0D5              *               Long    Block Count
0374 E0D5              *               32      Device Name
0375 E0D5              *               Word    Slot Number
0376 E0D5              *               Word    Unit Number
0377 E0D5              *               Word    Version Number as follows:
0378 E0D5              *                       XYYZ where: X  = Major release version
0379 E0D5              *                                   YY = Minor release version
0380 E0D5              *                                   Z  = (A)lpha, (B)eta, (E)xerimental or
0381 E0D5              *                                        0 for final release.
0382 E0D5              *               Word    Device ID Number     (Icon selector)
0383 E0D5              *               Word    Head Device Link     (Logically linked device)
0384 E0D5              *               Word    Forward Device Link  (Logically linked device)
0385 E0D5              *               Long    Extended DIB Pointer (only if external access to data is allowed)
0386 E0D5              *               Word    DIB Device Number    (initialized by device dispatcher)
0387 E0D5              *
0388 E0D5              * The following is the DIB for the boot volume driver.
0389 E0D5              *
0390 E0D5              *******************************************************************************
0391 E0D5              boot_dib  
0392 E0D5 00 00 00 00           DC L:$00000000                 ; link_ptr
0393 E0D9 58 F2 E0 00           DC L:g_dispatch                ; entry_ptr
0394 E0DD E8 43                 DC W:$43EC                     ; dev_char %0100001111101100
0395 E0DF FF FF 00 00           DC L:$FFFFFFFF                 ; blk_cnt    (default = max.)
0396 E0E3 04                    DC B:$04                       ; dev_name   (default = DEV1)
0397 E0E4 44 45 56 31           DC B:'DEV1                           '
0398 E103 0F 00                 DC W:0                         ; slot_num   (default set by bootinit)
0399 E105 01 00                 DC W:1                         ; unit_num   (default = Unit #1)
0400 E107 01 00                 DC W:0                         ; ver_num    (default = 0.00)
0401 E109 02 00                 DC W:4                         ; dev_id_num (default = AppleDisk3.5)
0402 E10B 00 00                 DC W:0                         ; head device link
0403 E10D 00 00                 DC W:0                         ; forward device link
0404 E10F 00 00 00 00           DC L:0                         ; Extended DIB pointer
0405 E113 01 00                 DC W:1                         ; DIB device number
0406 E115              *
0407 E115              * The following is a GDIB for a generated driver.  Note that
0408 E115              * many DIB and GDIB parameters will have to be modified
0409 E115              * conditional on the actual device for which a driver is
0410 E115              * being generated for.
0411 E115              *
0412 E115 02 00                 DC W:1                         ; drvr_class (default std SmartPort)
0413 E117 02 00                 DC W:$0001                     ; drvr_type (default = DISK3.5)
0414 E119 A0 00                 DC W:$00C0                     ; drvr_subtype (default = AppleDisk3.5)
0415 E11B FF FF                 DC W:$FFFF                     ; cache_mask
0416 E11D 00 02                 DC W:512                       ; block_size   (default = $0200 = 512)
0417 E11F 01 00                 DC W:1                         ; Hardware Unit Number
0418 E121
0419 E121                       eject 
0420 E121              *****************************************************************
0421 E121              *
0422 E121              * The following data structures are used by the device dispatcher
0423 E121              * only while loading device drivers as a result of a STARUP call
0424 E121              * being issued to the device dispatcher (Device #0).  Note that
0425 E121              * these data areas should probably be defined as equates in
0426 E121              * bank 0 Ram since they waste memory here and bank 0 is safe
0427 E121              * when these data areas are needed.
0428 E121              *
0429 E121              *****************************************************************
0430 E121              dev_os_data  
0431 E121
0432 E121 01 00        d_boot_vol_list DC W:1                  ; pcount
0433 E123 27 E1 E0 00           DC L:boot_vol_name
0434 E127 40 00        boot_vol_name DC W:32                   ; string buffer length
0435 E129
0436 E129 06 00 3A 49  boot_vol_str DS B:34                    ; string and string length
0437 E14B
0438 E14B 53 59 53 54  sys_drivers DC B:'SYSTEM:DRIVERS'
0439 E159
0440 E159 02 00        d_open_list DC W:2                      ; pcount = minimum
0441 E15B 01 00        d_open_ref_num DC W:0                   ; reference number
0442 E15D 29 E1 E0 00  d_open_path DC L:boot_vol_str
0443 E161
0444 E161 01 00        d_close_list DC W:1                     ; pcount = minimum
0445 E163 01 00        d_close_ref_num DC W:0                  ; reference number
0446 E165
0447 E165 0D 00        dir_entry_list DC W:13                  ; pcount (need AuxType)
0448 E167 01 00        dir_ref_num DC W:0                      ; reference number
0449 E169 00 00        dir_entry_null DC W:0
0450 E16B 01 00        dir_entry_base DC W:0                   ; base
0451 E16D 01 00        dir_entry_disp DC W:0                   ; displacement
0452 E16F CD E1 E0 00  dir_entry_name DC L:d_file_name         ; pointer to name string
0453 E173 03 00        dir_entry_num DC W:0                    ; entry number
0454 E175 BB 00        dir_entry_ft DC W:0                     ; FileType
0455 E177 72 1D 00 00  dir_entry_eof DC L:0                    ; EOF
0456 E17B 10 00 00 00  dir_entry_blk DC L:0                    ; block count
0457 E17F 00 03 11 5D  dir_entry_date DS B:8                   ; create date / time (must be manually converted)
0458 E187 00 03 11 5D  dir_entry_mod DS B:8                    ; mod date / time (must be manually converted)
0459 E18F E3 00        dir_entry_acc DC W:0                    ; access
0460 E191 01 01 00 00  dir_entry_aux DC L:0                    ; AuxType
0461 E195 00 00        dir_entry_fst DC W:0                    ; file system ID
0462 E197 00 00 00 00  dir_entry_ol DC L:0                     ; option list pointer
0463 E19B
0464 E19B 04 00        dev_get_f_info DC W:4                   ; pcount
0465 E19D A9 E1 E0 00  get_file_path DC L:driver_name          ; file to get info on
0466 E1A1 00 00                 DC W:0                         ; access
0467 E1A3 00 00        dev_file_type DC W:0                    ; FileType must be $BB
0468 E1A5 00 00 00 00  dev_aux_type DC L:0                     ; AuxType must be $01XX
0469 E1A9
0470 E1A9 20 00        driver_name DC W:32
0471 E1AB 00 00 00 00  driver_name_str DS B:34
0472 E1CD
0473 E1CD 20 00        d_file_name DC W:32
0474 E1CF 0E 00 43 6F  file_name_str DS B:34
0475 E1F1
0476 E1F1 02 00        set_prefix_list DC W:2                  ; pcount
0477 E1F3 00 00        prefix_num DC W:0                       ; prefix number
0478 E1F5 29 E1 E0 00  prefix_str DC L:boot_vol_str
0479 E1F9
0480 E1F9 01 00        x_unit   DC W:0                         ; hardware unit number
0481 E1FB
0482 E1FB EA BC        stack_address DC W:0
0483 E1FD
0484 E1FD                       eject 
0485 E1FD              ****************************************************************
0486 E1FD              *
0487 E1FD              * This is the main entry point for the device dispatcher.
0488 E1FD              * Note that calls to device zero specify calls to the dispatcher
0489 E1FD              * and not to a particular device.  Non-zero device numbers
0490 E1FD              * will be passed on to that specific device.
0491 E1FD              *
0492 E1FD              * ENTRY:        A Reg = Undefined
0493 E1FD              *               X Reg = Undefined
0494 E1FD              *               Y Reg = Undefined
0495 E1FD              *             DIR Reg = GS/OS Direct Page
0496 E1FD              *               B Reg = Undefined
0497 E1FD              *               P Reg = N V M X D I Z C  E
0498 E1FD              *                       • • 0 0 0 • • •  0
0499 E1FD              *
0500 E1FD              * EXIT:         A Reg = Error code
0501 E1FD              *               X Reg = Undefined
0502 E1FD              *               Y Reg = Undefined
0503 E1FD              *             DIR Reg = GS/OS Direct Page
0504 E1FD              *               B Reg = Same as on entry
0505 E1FD              *               P Reg = N V M X D I Z C  E
0506 E1FD              *                       • • 0 0 0 • • 0  0      if no error
0507 E1FD              *                       • • 0 0 0 • • 1  0      if error
0508 E1FD              *
0509 E1FD              ****************************************************************
0510 E1FD                       export dev_dispatch
0511 E1FD              dev_dispatch  
0512 E1FD                       longa on
0513 E1FD                       longi on
0514 E1FD
0515 E1FD A5 02                 lda   <drvr_call_num           ; is it a startup or shutdown?
0516 E1FF C9 01 00              cmp   #$0001
0517 E202 F0 04                 beq   a_drvr_done_it           ; no, dont modify the flag or purging breaks!!!
0518 E204 8F B3 E0 E0           sta   >dd_os_call
0519 E208              a_drvr_done_it  
0520 E208 C9 04 00              cmp   #$0004                   ; is it a legal command?
0521 E20B B0 0A                 bge   illegal_req              ; no
0522 E20D 0A                    asl   a                        ; make index to dispatch table
0523 E20E AA                    tax   
0524 E20F 8B                    phb   
0525 E210 4B                    phk   
0526 E211 AB                    plb   
0527 E212 FC 1C E2              jsr   (dev_d_table,x)          ; get dispatch entry
0528 E215 AB                    plb   
0529 E216 6B                    rtl   
0530 E217
0531 E217              *
0532 E217              * Received an illegal request.  Return with an error.
0533 E217              *
0534 E217              illegal_req  
0535 E217 A9 20 00              lda   #drvr_bad_req            ; set error
0536 E21A 38                    sec   
0537 E21B 6B                    rtl   
0538 E21C
0539 E21C              *
0540 E21C              * The following is a table of dispatch entry points for the
0541 E21C              * device dispatcher functions.
0542 E21C              *
0543 E21C              *               $0000   Startup call to device dispatcher.
0544 E21C              *               $0001   Call to set DIB pointer for current device.
0545 E21C              *               $0002   Shutdown call to device dispatcher.
0546 E21C              *               $0003   Full shutdown call to device dispatcher (with eject).
0547 E21C              *               $0004 - $FFFF Are not implemented.
0548 E21C              *
0549 E21C 33 E2        dev_d_table DC W:dd_boot                ; startup call
0550 E21E 29 F1                 DC W:dd_get_dib                ; set DIB pointer
0551 E220 73 F1                 DC W:dd_shutdn                 ; shutdown call
0552 E222 46 F1                 DC W:dd_full_shutdn
0553 E224
0554 E224                       eject 
0555 E224              ***************************************************************
0556 E224              *
0557 E224              * This routine sets the Y register to point into the
0558 E224              * device list to the current device entry based on
0559 E224              * drvr_dev_num on direct page.  The device list must
0560 E224              * contain a longword count of entries in the device
0561 E224              * list followed by 8 bytes per device entry.  The index
0562 E224              * is set as follows:
0563 E224              *
0564 E224              * INDEX = ((drvr_dev_num-1) * 8) + 4
0565 E224              *
0566 E224              * ENTRY:        A Reg = Unspecified
0567 E224              *               X Reg = Unspecified
0568 E224              *               Y Reg = Unspecified
0569 E224              *               B Reg = Unspecified
0570 E224              *             Dir Reg = GS/OS Direct Page
0571 E224              *               P Reg = N V M X D I Z C  E
0572 E224              *                       • • 0 0 0 • • •  0
0573 E224              *
0574 E224              * EXIT:         A Reg = unchanged
0575 E224              *               X Reg = unchanged
0576 E224              *               Y Reg = index for [<drvr_dev_ptr],y - points at current device
0577 E224              *               B Reg = unchanged
0578 E224              *             Dir Reg = GS/OS Direct Page
0579 E224              *               P Reg = N V M X D I Z C  E
0580 E224              *                       • • 0 0 0 • • •  0
0581 E224              *
0582 E224              ***************************************************************
0583 E224              set_dev_index  
0584 E224                       longa on
0585 E224                       longi on
0586 E224
0587 E224 48                    pha                            ; preserve through call
0588 E225 A5 00                 lda   <drvr_dev_num
0589 E227 20 2C E2              jsr   times_8_plus_4           ; Y = (A * 8) + 4
0590 E22A 68                    pla   
0591 E22B 60                    rts   
0592 E22C
0593 E22C              times_8_plus_4  
0594 E22C                       longa on
0595 E22C                       longi on
0596 E22C
0597 E22C 3A                    dec   a                        ; calculate supervisory list entry
0598 E22D 38                    sec   
0599 E22E 2A                    rol   a
0600 E22F 0A                    asl   a
0601 E230 0A                    asl   a
0602 E231 A8                    tay                            ; set SIB pointer
0603 E232 60                    rts   
0604 E233
0605 E233                       eject 
0606 E233              ****************************************************************
0607 E233              *
0608 E233              * This routine is used to install a driver for the boot
0609 E233              * volume that can be used by the GS/OS and System Loader
0610 E233              * to bring in the rest of the operating system.  If the 
0611 E233              * DRVR_DIB_PTR is NIL at startup then a generated driver
0612 E233              * will be installed as the initial boot device.  This driver
0613 E233              * may be replaced at any time during the boot process if a
0614 E233              * duplicate loaded driver exists for the same slot and unit
0615 E233              * that the boot is occuring from.  If the DRVR_DIB_PTR is
0616 E233              * not NIL then a loaded driver will be used during the boot
0617 E233              * process.  Regardless of which type of driver is used during
0618 E233              * the boot process, a default generated DIB will be used as a
0619 E233              * master copy when generating device drivers for peripherals
0620 E233              * that have no loaded driver.
0621 E233              *
0622 E233              * (1) Allocate new handle for device list of size = 12 bytes
0623 E233              * (2) Set device count to $00000001
0624 E233              * IF DRVR_DIB_PTR = NIL THEN
0625 E233              * (3) Set 1st DIB pointer entry to point to boot volume driver
0626 E233              * (4) Set correct slot in boot volume DIB.
0627 E233              * ELSE
0628 E233              * (3) Install BOOT.DRIVER DIB pointer in device list.
0629 E233              * (4) Install BOOT.DRIVER User ID in device list.
0630 E233              * THEN
0631 E233              * (5) Load supervisory drivers
0632 E233              * (6) Start supervisory drivers
0633 E233              * (7) Load device drivers
0634 E233              * (8) Start device drivers
0635 E233              * (9) Generate drivers
0636 E233              * END
0637 E233              *
0638 E233              * Each device list entry is 8 bytes.  The device list will
0639 E233              * consist of a longword count of the number of entries in
0640 E233              * the device list as well as the entries for each device.
0641 E233              * The entries for each device consists of a longword pointer
0642 E233              * to the devices DIB followed by a word used to maintain the
0643 E233              * disk switched status when bouncing through FST's and an
0644 E233              * additional word reserved for future expansion.
0645 E233              *
0646 E233              * ENTRY:        A Reg = Unspecified
0647 E233              *               X Reg = Unspecified
0648 E233              *               Y Reg = Unspecified
0649 E233              *               B Reg = Unspecified
0650 E233              *             Dir Reg = GS/OS Direct Page
0651 E233              *               P Reg = N V M X D I Z C  E
0652 E233              *                       • • 0 0 0 • • •  0
0653 E233              *        DRVR_DIB_PTR = NIL if no BOOT.DRIVER or . . .
0654 E233              *                       Address of BOOT.DRIVER DIB
0655 E233              *        BOOT_USER_ID = User ID of BOOT.DRIVER ($3Fxx)
0656 E233              *
0657 E233              * EXIT:         A Reg = Error code
0658 E233              *               X Reg = Unspecified
0659 E233              *               Y Reg = Unspecified
0660 E233              *               B Reg = Unspecified
0661 E233              *             Dir Reg = GS/OS Direct Page
0662 E233              *               P Reg = N V M X D I Z C  E
0663 E233              *                       • • 0 0 0 • • 0  0      if no error
0664 E233              *                       • • 0 0 0 • • 1  0      if error
0665 E233              *
0666 E233              ****************************************************************
0667 E233              dd_boot   
0668 E233                       longa on
0669 E233                       longi on
0670 E233
0671 E233 AF F0 B9 00           lda   >dev_start_flag          ; for thermometer to poll for safe OS calls
0672 E237 3A                    dec   a
0673 E238 8F F0 B9 00           sta   >dev_start_flag
0674 E23C
0675 E23C 64 6C                 stz   <post_drvr_tbl           ; make sure no drivers are posted
0676 E23E 64 6E                 stz   <post_drvr_tbl+2
0677 E240
0678 E240              *
0679 E240              * Set the ProDOS global page to NIL.  This prevents incompatable
0680 E240              * applications from running by luck.  NOTE that $BF32 must be maintained
0681 E240              * as $00 for compatibility with SCSI2 while $BF00 must be maintained 
0682 E240              * as $4C for the Apple][ Memory Expansion Card (Slinky).
0683 E240              *
0684 E240 A2 3F 00              ldx   #$003F
0685 E243 A9 00 00              lda   #$0000
0686 E246              global_nil  
0687 E246 9F 00 BF 00           sta   >$00BF00,x
0688 E24A CA                    dex   
0689 E24B 10 F9                 bpl   global_nil
0690 E24D              *
0691 E24D              * In case there are any Apple][ Memory Expansion cards residing
0692 E24D              * in the slots, need to initialize $BF00 so that these devices
0693 E24D              * will format themselves as ProDOS devices.
0694 E24D              *
0695 E24D A9 4C 00              lda   #$004C                   ; Place a 'JMP' instruction in $BF00
0696 E250 8F 00 BF 00           sta   >$00BF00
0697 E254
0698 E254 AF D0 01 E1           lda   >warm_cold_flag          ; is this a warm start?
0699 E258 D0 33                 bne   build_dev_list           ; yes, dont need parameters or newhandle
0700 E25A              *
0701 E25A              * Setup Class 0 configuration ram.
0702 E25A              *
0703 E25A F4 00 00              pea   sys_buffer>>16           ; pointer to buffer
0704 E25D F4 00 AA              pea   sys_buffer
0705 E260 A2 03 0A 22           _readbram 
0706 E267 A2 11 AC              ldx   #config_ram              ; point at configuration ram
0707 E26A AF 84 AA 00           lda   >sys_buffer+$84
0708 E26E 9F 00 00 00           sta   >0,x                     ; ProDOS configuration
0709 E272
0710 E272                       eject 
0711 E272              *
0712 E272              * Now allocate an 12 byte block for the device list.
0713 E272              *        _________________
0714 E272              * $0000 |_               _|   Count of number of devices
0715 E272              *       |_               _|
0716 E272              *       |_               _|
0717 E272              *       |_________________|
0718 E272              * $0004 |_               _|   Pointer to device #1 DIB
0719 E272              *       |_               _|
0720 E272              *       |_               _|
0721 E272              *       |_________________|
0722 E272              * $0008 |_               _|   Device #1 dispatcher maintained diskswitch
0723 E272              *       |_________________|
0724 E272              * $000A |_               _|   Device #1 Driver User ID (loaded driver only)
0725 E272              *       |_________________|
0726 E272              *
0727 E272              * First need to get an ID for the memory segment that will
0728 E272              * be allocated for the device list.
0729 E272              *
0730 E272 A9 00 3F              lda   #$3F00                   ; get a $3Fxx user id
0731 E275 20 E4 E4              jsr   get_new_id
0732 E278 8D 35 E0              sta   |dev_list_id             ; save device list handle ID
0733 E27B A2 0C 00              ldx   #$000C
0734 E27E 8E 3B E0              stx   |dev_list_size
0735 E281 A0 08 80              ldy   #$8008                   ; locked, fixed & no special mem
0736 E284 20 F2 E4              jsr   get_new_handle
0737 E287 8E 37 E0              stx   |dev_list_hndl
0738 E28A 8C 39 E0              sty   |dev_list_hndl+2
0739 E28D              *
0740 E28D              * Now build the device list.  Number of devices will be set to one.
0741 E28D              * The first entry in the device list will point at the boot volume
0742 E28D              * driver.
0743 E28D              *
0744 E28D              build_dev_list  
0745 E28D 20 4D E7              jsr   deref_dev_list           ; dereference device list handle
0746 E290 A0 02 00              ldy   #$0002                   ; point at device count
0747 E293 A9 01 00              lda   #$0001                   ; device count = $00000001
0748 E296 87 24                 sta   [<drvr_dev_ptr]
0749 E298 3A                    dec   a
0750 E299 97 24                 sta   [<drvr_dev_ptr],y
0751 E29B C8                    iny                            ; point at first DIB entry
0752 E29C C8                    iny   
0753 E29D              *
0754 E29D              * The following code was added for system disk 4.1 to accomodate booting
0755 E29D              * from a BOOT.DRIVER such as AppleTalk.
0756 E29D              *
0757 E29D A5 20                 lda   <drvr_dib_ptr            ; Is boot occuring from a BOOT.DRIVER?
0758 E29F 05 22                 ora   <drvr_dib_ptr+2
0759 E2A1 F0 0C                 beq   no_boot_drvr             ; no, use default DIB for booting
0760 E2A3              *
0761 E2A3              * Boot is occuring from a BOOT.DRIVER.  Install boot driver DIB address and
0762 E2A3              * User ID into the device list and proceed with the boot process.
0763 E2A3              *
0764 E2A3 A5 20                 lda   <drvr_dib_ptr            ; install BOOT.DRIVER DIB
0765 E2A5 97 24                 sta   [<drvr_dev_ptr],y
0766 E2A7 A5 22                 lda   <drvr_dib_ptr+2
0767 E2A9 C8                    iny   
0768 E2AA C8                    iny   
0769 E2AB 97 24                 sta   [<drvr_dev_ptr],y
0770 E2AD 80 12                 bra   set_boot_id
0771 E2AF              *
0772 E2AF              * Boot is occuring from a built in firmware peripheral driver.  Install
0773 E2AF              * the default DIB into the device list and proceed with the boot process.
0774 E2AF              *
0775 E2AF              no_boot_drvr  
0776 E2AF 64 6A                 stz   <boot_user_id            ; no user ID on generated boot driver
0777 E2B1 A9 D5 E0              lda   #boot_dib                ; set entry = boot volume DIB address
0778 E2B4 97 24                 sta   [<drvr_dev_ptr],y
0779 E2B6 85 20                 sta   <drvr_dib_ptr            ; and set current DIB pointer
0780 E2B8 C8                    iny   
0781 E2B9 C8                    iny   
0782 E2BA A9 E0 00              lda   #boot_dib>>16            ; NOTE: location must be bank $E0
0783 E2BD 97 24                 sta   [<drvr_dev_ptr],y
0784 E2BF 85 22                 sta   <drvr_dib_ptr+2
0785 E2C1              set_boot_id  
0786 E2C1 A9 00 00              lda   #$0000                   ; init disk switched status
0787 E2C4 C8                    iny   
0788 E2C5 C8                    iny   
0789 E2C6 97 24                 sta   [<drvr_dev_ptr],y
0790 E2C8 C8                    iny                            ; init driver User ID
0791 E2C9 C8                    iny   
0792 E2CA A5 6A                 lda   <boot_user_id            ; init disk switched status & user ID
0793 E2CC 97 24                 sta   [<drvr_dev_ptr],y
0794 E2CE              *
0795 E2CE              * Now set the slot in the DIB for the boot volume.
0796 E2CE              *
0797 E2CE E6 00                 inc   <drvr_dev_num            ; boot volume is device #1
0798 E2D0 20 5B E7              jsr   set_dib_ptr              ; set DIB ptr on direct page
0799 E2D3 A5 04                 lda   <boot_slot               ; get boot slot
0800 E2D5 EB                    xba                            ; set for dib construction routine
0801 E2D6 85 28                 sta   <fw_addr
0802 E2D8 64 2A                 stz   <fw_addr+2
0803 E2DA A9 01 00              lda   #$0001                   ; unit number
0804 E2DD 20 8F F0              jsr   generate_slot            ; generate DIB slot and unit numbers
0805 E2E0 A0 2E 00              ldy   #slot_num                ; set boot slot parameter int/ext
0806 E2E3 B7 20                 lda   [<drvr_dib_ptr],y
0807 E2E5 85 04                 sta   <boot_slot
0808 E2E7 8D BB E0              sta   |d_boot_slot
0809 E2EA              *
0810 E2EA              * Correct default driver class and cache mask if not a
0811 E2EA              * SmartPort interface for boot device.  (Rev v0.27)
0812 E2EA              *
0813 E2EA A0 08 00              ldy   #dev_char
0814 E2ED B7 20                 lda   [<drvr_dib_ptr],y
0815 E2EF 29 00 40              and   #$4000                   ; is device generated?
0816 E2F2 F0 17                 beq   class_ok                 ; no, dont modify the DIB
0817 E2F4
0818 E2F4 A0 07 C0              ldy   #$C007                   ; need ($Cn07)
0819 E2F7 B7 28                 lda   [<fw_addr],y
0820 E2F9 29 FF 00              and   #$00FF                   ; is this a smartport interface
0821 E2FC F0 0D                 beq   class_ok
0822 E2FE
0823 E2FE A9 00 00              lda   #$0000                   ; dont cache ProDOS devices
0824 E301 A0 40 00              ldy   #drvr_class
0825 E304 97 20                 sta   [<drvr_dib_ptr],y
0826 E306 A0 46 00              ldy   #cache_mask
0827 E309 97 20                 sta   [<drvr_dib_ptr],y
0828 E30B              class_ok   
0829 E30B                       eject 
0830 E30B              *
0831 E30B              * Now allocate an 1 longword block for the filename list.  Eventually, this
0832 E30B              * handle will be set to the maximum number of files contained in the 
0833 E30B              * :boot:system:drivers directory.  After drivers have been loaded, the
0834 E30B              * handle will be reduced to fit the number of actual file name entries.
0835 E30B              * The structure of the filename list is as follows:
0836 E30B              *
0837 E30B              *                        _________________
0838 E30B              *       BASE            |_               _|   Filename entry #1
0839 E30B              *                       |_               _|
0840 E30B              *                       |_               _|
0841 E30B              *                       |_________________|
0842 E30B              *                                •
0843 E30B              *                                •
0844 E30B              *                                •
0845 E30B              *                        _________________
0846 E30B              *       BASE+(n*48)     |_               _|   Filename entry #n
0847 E30B              *                       |_               _|
0848 E30B              *                       |_               _|
0849 E30B              *                       |_________________|
0850 E30B              *
0851 E30B              * The structure of each filename entry is a 48 byte structure as follows:
0852 E30B              *
0853 E30B              *                        _________________
0854 E30B              *       BASE=0          |_               _|   FileType of filename entry
0855 E30B              *                       |_________________|
0856 E30B              *       BASE+2          |_               _|   AuxType of filename entry
0857 E30B              *                       |_________________|
0858 E30B              *       BASE+4          |_               _|   User ID of filename entry
0859 E30B              *                       |_________________|
0860 E30B              *       BASE+6          |_               _|   Load Address of filename entry
0861 E30B              *                       |_               _|
0862 E30B              *                       |_               _|
0863 E30B              *                       |_________________|
0864 E30B              *       BASE+10         |_               _|   32 byte filename
0865 E30B              *                       |                 |
0866 E30B              *                                •
0867 E30B              *                                •
0868 E30B              *                                •
0869 E30B              *                       |_               _|
0870 E30B              *                       |_________________|
0871 E30B              *       BASE+42         |_               _|   Restart Flag of filename entry
0872 E30B              *                       |_________________|
0873 E30B              *       BASE+44         |_               _|   Base device number of filename entry
0874 E30B              *                       |_________________|
0875 E30B              *       BASE+46         |_               _|   RESERVED for filename entry
0876 E30B              *                       |_________________|
0877 E30B              *
0878 E30B              * First need to get an ID for the memory segment that will be allocated for the filename list.
0879 E30B              *
0880 E30B AF D0 01 E1           lda   >warm_cold_flag          ; is this a warm start?
0881 E30F D0 18                 bne   have_fl_hndl             ; yes
0882 E311
0883 E311 A9 00 3F              lda   #$3F00                   ; get a $3Fxx user id
0884 E314 20 E4 E4              jsr   get_new_id
0885 E317 8D 43 E0              sta   |file_list_id            ; save device list handle ID
0886 E31A A2 04 00              ldx   #$0004                   ; size of block
0887 E31D A0 08 80              ldy   #$8008                   ; locked, fixed & no special mem
0888 E320 20 F2 E4              jsr   get_new_handle
0889 E323 8E 45 E0              stx   |file_list_hndl
0890 E326 8C 47 E0              sty   |file_list_hndl+2
0891 E329              have_fl_hndl  
0892 E329
0893 E329                       eject 
0894 E329              ****************************************************************
0895 E329              *
0896 E329              * This routine counts how many loaded and generated drivers
0897 E329              * exist excluding the boot volume slot (don't need to allocate
0898 E329              * space in list twice for this device).  The device list handle
0899 E329              * size will be increased to accomodate the number of devices
0900 E329              * that are to be installed in the device list.  In addition, the
0901 E329              * dispatcher error list handle will be increased.  Then each
0902 E329              * loaded driver and generated driver will be installed into the
0903 E329              * device list.  After being installed in the device list, each
0904 E329              * driver will be issued a 'drvr_startup' call.  If a driver
0905 E329              * returns an error from this call, the driver will be removed
0906 E329              * from the device list and both the device list and error list
0907 E329              * handle sizes will be updated.
0908 E329              *
0909 E329              * WARNING!!!!!!
0910 E329              *               This call must not be issued until the
0911 E329              *               bank 0 dispatcher is loaded.
0912 E329              *
0913 E329              ****************************************************************
0914 E329                       longa on
0915 E329                       longi on
0916 E329              *
0917 E329              * Need to determine how many loaded drivers exist.
0918 E329              * Result count of how many loaded drivers is added
0919 E329              * to the value of the transfer count on direct page.
0920 E329              *
0921 E329 9C 61 E0              stz   |total_gen               ; no generated drivers have been built yet
0922 E32C D4 04                 pei   <boot_slot               ; preserve boot slot around drvr calls
0923 E32E 20 84 E5              jsr   count_l_drvr             ; count loaded drivers
0924 E331              *
0925 E331              * This following routine was added for the P8 switch and grows the size of the
0926 E331              * file list handle to accomodate the maximum number of driver files contained
0927 E331              * in the driver directory.
0928 E331              *
0929 E331 AF D0 01 E1           lda   >warm_cold_flag          ; is this a warm start?
0930 E335 D0 3B                 bne   fl_size_ok               ; no, leave the file list alone
0931 E337
0932 E337 AD 51 E0              lda   |file_list_cnt           ; get current driver count
0933 E33A 20 E8 FD              jsr   calc_file_index          ; determine handle size
0934 E33D 8D 49 E0              sta   |file_list_size
0935 E340 20 A2 FE              jsr   put_handle_size          ; save parameters for set_handle_size
0936 E343
0937 E343 AE 45 E0              ldx   |file_list_hndl          ; this is the handle for sethandlesize
0938 E346 AC 47 E0              ldy   |file_list_hndl+2
0939 E349 20 10 E5              jsr   set_handle_size          ; set the file list handle size
0940 E34C 90 03                 bcc   have_fl_h
0941 E34E 4C 0B E5              jmp   time_to_die
0942 E351              have_fl_h  
0943 E351 AD 45 E0              lda   |file_list_hndl          ; dereference the file list handle
0944 E354 AE 47 E0              ldx   |file_list_hndl+2
0945 E357 20 4D FE              jsr   deref_handle
0946 E35A 85 2C                 sta   <file_list_ptr
0947 E35C 84 2E                 sty   <file_list_ptr+2
0948 E35E
0949 E35E AC 49 E0              ldy   |file_list_size
0950 E361 88                    dey   
0951 E362 88                    dey   
0952 E363 A9 00 00              lda   #0
0953 E366              clr_file_list  
0954 E366 97 2C                 sta   [<file_list_ptr],y
0955 E368 88                    dey   
0956 E369 88                    dey   
0957 E36A 10 FA                 bpl   clr_file_list
0958 E36C
0959 E36C 9C 4F E0              stz   |file_list_entry
0960 E36F 9C 29 FE              stz   |current_file
0961 E372              *
0962 E372              * End of code added for P8 switch....
0963 E372              *
0964 E372              fl_size_ok  
0965 E372 68                    pla   
0966 E373 85 04                 sta   <boot_slot
0967 E375              *
0968 E375              * Need to determine how many generated drivers exist.
0969 E375              * Result count of how many generated drivers is added
0970 E375              * to the value of the transfer count on direct page.
0971 E375              *
0972 E375 20 25 E6              jsr   count_g_drvr             ; count generated drivers
0973 E378
0974 E378                       eject 
0975 E378              *
0976 E378              * Device list requires 8 bytes per device.  Multiply device
0977 E378              * count by 8 before setting device list handle size.  The total
0978 E378              * maximum number of devices that may be installed is 8190.
0979 E378              *
0980 E378              * Each device list entry consists of:
0981 E378              *        _________________
0982 E378              *       |_               _|   Pointer to device's DIB
0983 E378              *       |_               _|
0984 E378              *       |_               _|
0985 E378              *       |_________________|
0986 E378              *       |_               _|   Device's dispatcher maintained diskswitch
0987 E378              *       |_________________|
0988 E378              *       |_               _|   Device's Driver User ID (loaded driver only)
0989 E378              *       |_________________|
0990 E378              *
0991 E378 A0 02 00              ldy   #$0002                   ; set device count
0992 E37B A9 00 00              lda   #$0000
0993 E37E 97 24                 sta   [<drvr_dev_ptr],y
0994 E380 AD 7F E0              lda   |driver_count
0995 E383 87 24                 sta   [<drvr_dev_ptr]
0996 E385 20 A9 FE              jsr   calc_dev_size            ; calculate device list size
0997 E388 20 A2 FE              jsr   put_handle_size          ; save parameters for set_handle_size
0998 E38B              *
0999 E38B              * Now need to set device list handle size to accomodate drivers.
1000 E38B              *
1001 E38B AE 37 E0              ldx   |dev_list_hndl           ; this is the handle for sethandlesize
1002 E38E AC 39 E0              ldy   |dev_list_hndl+2
1003 E391 20 10 E5              jsr   set_handle_size          ; set the device list handle size
1004 E394 90 03                 bcc   have_dev_h
1005 E396 4C 0B E5              jmp   time_to_die
1006 E399              have_dev_h  
1007 E399 20 4D E7              jsr   deref_dev_list           ; and dereference device list handle
1008 E39C              *
1009 E39C              * During loading of device drivers, the driver's User ID should
1010 E39C              * must be maintained for the first successfully loaded device
1011 E39C              * associated with a driver.  Unsuccessfully loaded devices are
1012 E39C              * purged.  If the first device is purged, the User ID must be
1013 E39C              * maintained for the next device.  This is easily done by pre
1014 E39C              * clearing the device list and only writing the User ID into the
1015 E39C              * device list during the load.
1016 E39C              *
1017 E39C AC 3B E0              ldy   |dev_list_size           ; point at one past last entry
1018 E39F C0 08 00              cpy   #$0008                   ; if only one device its generated
1019 E3A2 F0 1A                 beq   clr_dev_done             ; then dont clear the list
1020 E3A4 A9 00 00              lda   #$0000
1021 E3A7              clr_dev_list  
1022 E3A7 88                    dey                            ; point at user id of previous entry
1023 E3A8 88                    dey   
1024 E3A9 97 24                 sta   [<drvr_dev_ptr],y        ; init device list User ID
1025 E3AB 88                    dey   
1026 E3AC 88                    dey   
1027 E3AD 3A                    dec   a                        ; init device list disk switch status
1028 E3AE 97 24                 sta   [<drvr_dev_ptr],y
1029 E3B0 88                    dey   
1030 E3B1 88                    dey   
1031 E3B2 1A                    inc   a                        ; Init device list dib pointer
1032 E3B3 97 24                 sta   [<drvr_dev_ptr],y
1033 E3B5 88                    dey   
1034 E3B6 88                    dey   
1035 E3B7 97 24                 sta   [<drvr_dev_ptr],y
1036 E3B9 C0 0C 00              cpy   #$000C
1037 E3BC D0 E9                 bne   clr_dev_list
1038 E3BE              clr_dev_done  
1039 E3BE              *
1040 E3BE              * Need an ID for allocation of memory for generated driver's DIB and GDIB.
1041 E3BE              *
1042 E3BE AF D0 01 E1           lda   >warm_cold_flag          ; is this a warm start?
1043 E3C2 D0 09                 bne   no_gdib_id               ; yes
1044 E3C4
1045 E3C4 A9 00 3D              lda   #$3D00                   ; get a $3Fxx user id
1046 E3C7 20 E4 E4              jsr   get_new_id
1047 E3CA 8D 53 E0              sta   |gen_drvr_id             ; save device list handle ID
1048 E3CD              no_gdib_id  
1049 E3CD              *
1050 E3CD              * Now must allocate memory for generated drivers DIB's and GDIB's.
1051 E3CD              *
1052 E3CD              *                DIB    64 bytes per driver
1053 E3CD              *            +__GDIB__  12 bytes per generated driver
1054 E3CD              *              TOTAL    76 bytes per generated driver
1055 E3CD              *
1056 E3CD              * Note that loaded drivers carry their own DIB with the driver so
1057 E3CD              * no additional memory allocation is required for these devices.
1058 E3CD              *
1059 E3CD 48                    pha                            ; space for multiply result
1060 E3CE 48                    pha   
1061 E3CF AD 61 E0              lda   |total_gen               ; number of generated drivers
1062 E3D2 D0 04                 bne   nofixie
1063 E3D4 1A                    inc   a                        ;force one as default
1064 E3D5 8D 61 E0              sta   |total_gen               ; fake out number of generated drivers
1065 E3D8              nofixie   
1066 E3D8 48                    pha                            ; multiplicand = # generated drivers
1067 E3D9 F4 4C 00              pea   dib_size                 ; multiplier = 76 bytes per driver
1068 E3DC A2 0B 09 22           _multiply 
1069 E3E3 90 03                 bcc   have_size                ; if no error
1070 E3E5 4C 0B E5              jmp   time_to_die              ; die if can't get boot volume
1071 E3E8              have_size  
1072 E3E8 FA                    plx                            ; size for new handle
1073 E3E9 8E 59 E0              stx   |drvr_list_size
1074 E3EC 68                    pla   
1075 E3ED 8E 3F E0              stx   |handle_size             ; in case sethandlesize due to warm start
1076 E3F0 8D 41 E0              sta   |handle_size+2
1077 E3F3
1078 E3F3 AF D0 01 E1           lda   >warm_cold_flag          ; is this a warm start?
1079 E3F7 D0 11                 bne   warm_gdib_size           ; yes
1080 E3F9
1081 E3F9 AD 53 E0              lda   |gen_drvr_id             ; get device list handle ID
1082 E3FC A0 08 80              ldy   #$8008                   ; locked, fixed & no special mem
1083 E3FF 20 F2 E4              jsr   get_new_handle
1084 E402 8E 55 E0              stx   |gen_drvr_hndl
1085 E405 8C 57 E0              sty   |gen_drvr_hndl+2
1086 E408 80 0E                 bra   deref_gdib
1087 E40A
1088 E40A              warm_gdib_size  
1089 E40A AE 55 E0              ldx   |gen_drvr_hndl           ; resize GDIB handle on restart
1090 E40D AC 57 E0              ldy   |gen_drvr_hndl+2
1091 E410 20 10 E5              jsr   set_handle_size
1092 E413 90 03                 bcc   deref_gdib
1093 E415 4C 0B E5              jmp   time_to_die
1094 E418              deref_gdib  
1095 E418 20 76 E5              jsr   deref_drv_list           ; and dereference driver list handle
1096 E41B              *
1097 E41B              * Need an ID for allocation of memory for supervisory driver list.
1098 E41B              *
1099 E41B AF D0 01 E1           lda   >warm_cold_flag          ; is this a warm start?
1100 E41F D0 20                 bne   warm_sup_hndl
1101 E421
1102 E421 A9 00 3E              lda   #$3E00                   ; get a $3Exx user id
1103 E424 20 E4 E4              jsr   get_new_id
1104 E427 8D BD E0              sta   |sup_drvr_id             ; save device list handle ID
1105 E42A              *
1106 E42A              * Now must allocate memory for supervisory driver list.
1107 E42A              *
1108 E42A AD C3 E0              lda   |sup_drvr_cnt            ; size of block to create
1109 E42D 38                    sec   
1110 E42E 2A                    rol   a
1111 E42F 0A                    asl   a
1112 E430 0A                    asl   a
1113 E431 AA                    tax                            ; size of new handle
1114 E432 AD BD E0              lda   |sup_drvr_id             ; User ID for new handle
1115 E435 A0 08 80              ldy   #$8008                   ; locked, fixed & no special mem
1116 E438 20 F2 E4              jsr   get_new_handle
1117 E43B 8E BF E0              stx   |sup_drvr_hndl
1118 E43E 8C C1 E0              sty   |sup_drvr_hndl+2
1119 E441              warm_sup_hndl  
1120 E441 AD BF E0              lda   |sup_drvr_hndl           ; dereferenc supervisor handle
1121 E444 AE C1 E0              ldx   |sup_drvr_hndl+2
1122 E447 20 4D FE              jsr   deref_handle
1123 E44A 85 70                 sta   <sup_drvr_ptr
1124 E44C 86 72                 stx   <sup_drvr_ptr+2
1125 E44E
1126 E44E AD C3 E0              lda   |sup_drvr_cnt            ; init supervisor driver count
1127 E451 87 70                 sta   [<sup_drvr_ptr]
1128 E453 A9 00 00              lda   #$0000
1129 E456 A0 02 00              ldy   #$0002
1130 E459 97 70                 sta   [<sup_drvr_ptr],y
1131 E45B              *
1132 E45B              * Now need to load all RAM LOADED DRIVERS.  As each driver is
1133 E45B              * loaded, a pointer to the driver's DIB is placed into the
1134 E45B              * device list and the device count is incremented for each device
1135 E45B              * installed into the device list
1136 E45B              *
1137 E45B A9 02 00              lda   #$0002                   ; set device number = boot volume + 1
1138 E45E 85 00                 sta   <drvr_dev_num
1139 E460 64 6C                 stz   <post_drvr_tbl           ; make sure no drivers are posted
1140 E462 64 6E                 stz   <post_drvr_tbl+2
1141 E464 20 76 E7              jsr   load_drivers             ; load all ram loaded drivers
1142 E467              *
1143 E467              * Now need to generate all RAM LOADED DRIVERS.  As each driver is
1144 E467              * generated, a pointer to the driver's DIB is placed into the
1145 E467              * device list and the device count is incremented.  In addition, a
1146 E467              * DIB is generated as well as a GDIB and placed into the generated
1147 E467              * driver list.
1148 E467              *
1149 E467 20 15 EC              jsr   gen_drivers              ; generate all drivers
1150 E46A              *
1151 E46A              * Now must issue a startup call to each driver.  If a driver
1152 E46A              * returns an error as a result of a DRVR_STARTUP call, the
1153 E46A              * driver will be purged from the device list.
1154 E46A              *
1155 E46A A9 01 00              lda   #$0001                   ; point at boot volume
1156 E46D 85 00                 sta   <drvr_dev_num
1157 E46F              *
1158 E46F              * Update class and device id number for boot volume prior to
1159 E46F              * issuing a drvr_startup call.
1160 E46F              *
1161 E46F 20 5B E7              jsr   set_dib_ptr              ; point at boot volume DIB
1162 E472 A0 08 00              ldy   #dev_char                ; is this a generated driver?
1163 E475 B7 20                 lda   [<drvr_dib_ptr],y
1164 E477 2A                    rol   a
1165 E478 2A                    rol   a
1166 E479 90 2B                 bcc   loaded_boot              ; yes, dont update the DIB
1167 E47B A0 2E 00              ldy   #slot_num
1168 E47E B7 20                 lda   [<drvr_dib_ptr],y
1169 E480 EB                    xba                            ; need $Cn00 before identifying device
1170 E481 29 00 07              and   #$0700
1171 E484 09 00 C0              ora   #$C000
1172 E487 85 28                 sta   <fw_addr
1173 E489 64 2A                 stz   <fw_addr+2
1174 E48B 20 5E E6              jsr   ident_slot               ; X = class
1175 E48E A0 40 00              ldy   #drvr_class              ; update class
1176 E491 8A                    txa   
1177 E492 97 20                 sta   [<drvr_dib_ptr],y
1178 E494 29 03 00              and   #$0003                   ; want class, not subclass
1179 E497 0A                    asl   a
1180 E498 AA                    tax   
1181 E499 A0 01 00              ldy   #$0001                   ; 1 device this slot
1182 E49C 98                    tya                            ; this is unit #1
1183 E49D 8D 5D E0              sta   |gen_count               ; name must remain .D1
1184 E4A0 FC F1 EC              jsr   (build_dib,x)            ; update boot volume dib
1185 E4A3
1186 E4A3 20 25 EB              jsr   startup_l_drvr           ; startup boot device
1187 E4A6              *
1188 E4A6              * Find first generated driver beyond the boot device and then startup
1189 E4A6              * all remaining generated devices.
1190 E4A6              *
1191 E4A6              loaded_boot  
1192 E4A6 E6 00                 inc   <drvr_dev_num            ; search for 1st generated driver
1193 E4A8              find_g_drvr  
1194 E4A8 20 5B E7              jsr   set_dib_ptr              ; point at driver DIB
1195 E4AB A0 08 00              ldy   #dev_char                ; is this a generated driver?
1196 E4AE B7 20                 lda   [<drvr_dib_ptr],y
1197 E4B0 2A                    rol   a
1198 E4B1 2A                    rol   a
1199 E4B2 B0 0C                 bcs   dev_start_loop           ; yes, startup remaining drivers!!!
1200 E4B4 E6 00                 inc   <drvr_dev_num            ; else point at next device
1201 E4B6 A5 00                 lda   <drvr_dev_num
1202 E4B8 C7 24                 cmp   [<drvr_dev_ptr]
1203 E4BA 90 EC                 blt   find_g_drvr
1204 E4BC F0 EA                 beq   find_g_drvr
1205 E4BE 80 0E                 bra   startup_done             ; only startup generated drivers!
1206 E4C0              dev_start_loop  
1207 E4C0 64 02                 stz   <drvr_call_num           ; force device startup call
1208 E4C2 22 00 FC 01           jsl   dev_dispatcher           ; issue startup call to device
1209 E4C6 E6 00                 inc   <drvr_dev_num            ; point at next device to startup
1210 E4C8 A7 24                 lda   [<drvr_dev_ptr]          ; get number of devices
1211 E4CA C5 00                 cmp   <drvr_dev_num            ; check if all devices started
1212 E4CC B0 F2                 bge   dev_start_loop           ; loop until all devices started
1213 E4CE              startup_done  
1214 E4CE 64 00                 stz   <drvr_dev_num            ; restore original input parameters
1215 E4D0 64 0C                 stz   <drvr_tran_cnt           ; no data is returned
1216 E4D2 64 0E                 stz   <drvr_tran_cnt+2
1217 E4D4 20 C6 FD              jsr   fix_dev_handle           ; now set the device list size
1218 E4D7 A9 00 00              lda   #no_error
1219 E4DA 8F F0 B9 00           sta   >dev_start_flag
1220 E4DE 18                    clc   
1221 E4DF 60                    rts   
1222 E4E0              vector_table   
1223 E4E0 5C 70 FC 01           jml   move_info                ; $01FC70 = move routine
1224 E4E4
1225 E4E4                       eject 
1226 E4E4              ***************************************************************
1227 E4E4              *
1228 E4E4              * The following routine returns a user ID from the miscellaneous
1229 E4E4              * tool set.
1230 E4E4              *  ___ ___ ___ ___ ___ ___ ___ ___ ___ ___ ___ ___ ___ ___ ___ ___
1231 E4E4              * |   |   |   |   |   |   |   |   |   |   |   |   |   |   |   |   |
1232 E4E4              * | F | E | D | C | B | A | 9 | 8 | 7 | 6 | 5 | 4 | 3 | 2 | 1 | 0 |
1233 E4E4              * |___|___|___|___|___|___|___|___|___|___|___|___|___|___|___|___|
1234 E4E4              *   |   |   |   |   |   |   |   |   |   |   |   |   |   |   |   |
1235 E4E4              *   |   |   |   |   |   |   |   |   |___|___|___|___|___|___|___|__  Assigned by ID manager
1236 E4E4              *   |   |   |   |   |   |   |   |
1237 E4E4              *   |   |   |   |   |___|___|___|__________________________________  Assigned by Application
1238 E4E4              *   |   |   |   |        
1239 E4E4              *   |___|___|___|__________________________________________________  Legislated by convention
1240 E4E4              *
1241 E4E4              *       $30XX           Cannot be used
1242 E4E4              *       $31XX           SCM
1243 E4E4              *       $32XX           Gloader / Gquit
1244 E4E4              *       $33XX           File System Translators
1245 E4E4              *       $34XX           Express Loader
1246 E4E4              *       $35XX           Reserved:
1247 E4E4              *       $36XX           Reserved:
1248 E4E4              *       $37XX           Reserved:
1249 E4E4              *       $38XX           Reserved:
1250 E4E4              *       $39XX           User ID for loaded device driver
1251 E4E4              *       $3AXX           User ID for loaded supervisor driver
1252 E4E4              *       $3BXX           Segments allocated by supervisor drivers
1253 E4E4              *       $3CXX           Segments allocated by device drivers
1254 E4E4              *       $3DXX           Allocated for generated DIB's
1255 E4E4              *       $3EXX           Supervisory driver list
1256 E4E4              *       $3FXX           Device driver list & Device Dispatcher Components
1257 E4E4              *
1258 E4E4              * ENTRY: Call via 'JSR'
1259 E4E4              *               A Reg = User ID
1260 E4E4              *               X Reg = Undefined
1261 E4E4              *               Y Reg = Undefined
1262 E4E4              *             Dir Reg = GS/OS Direct Page
1263 E4E4              *            Bank Reg = Current bank executing in
1264 E4E4              *           Stack Reg = GS/OS Stack
1265 E4E4              *               P Reg = N V M X D I Z C  E
1266 E4E4              *                       • • 0 0 0 • • •  0
1267 E4E4              *
1268 E4E4              * EXIT:         A Reg = User ID
1269 E4E4              *               X Reg = Undefined
1270 E4E4              *               Y Reg = Undefined
1271 E4E4              *             Dir Reg = GS/OS Direct Page
1272 E4E4              *            Bank Reg = Current bank executing in
1273 E4E4              *           Stack Reg = GS/OS Stack
1274 E4E4              *               P Reg = N V M X D I Z C  E
1275 E4E4              *                       • • 0 0 0 • • 0  0      if no error
1276 E4E4              *                       • • 0 0 0 • • 1  0      if error
1277 E4E4              *
1278 E4E4              ***************************************************************
1279 E4E4              get_new_id  
1280 E4E4                       longa on
1281 E4E4                       longi on
1282 E4E4
1283 E4E4 48                    pha                            ; space for result
1284 E4E5 48                    pha                            ; nyxx ID
1285 E4E6 A2 03 20 22           _getnewid 
1286 E4ED FA                    plx                            ; pull ID off stack
1287 E4EE B0 1B                 bcs   time_to_die              ; die if can't get boot volume
1288 E4F0 8A                    txa   
1289 E4F1 60                    rts   
1290 E4F2
1291 E4F2                       eject 
1292 E4F2              ***************************************************************
1293 E4F2              *
1294 E4F2              * The following routine returns a handle of the length specified.
1295 E4F2              *  ___ ___ ___ ___ ___ ___ ___ ___ ___ ___ ___ ___ ___ ___ ___ ___
1296 E4F2              * |   |   |   |   |   |   |   |   |   |   |   |   |   |   |   |   |
1297 E4F2              * | F | E | D | C | B | A | 9 | 8 | 7 | 6 | 5 | 4 | 3 | 2 | 1 | 0 |
1298 E4F2              * |___|___|___|___|___|___|___|___|___|___|___|___|___|___|___|___|
1299 E4F2              *   |   |   |   |   |   |   |   |   |   |   |   |   |   |   |   |__  AttrBank
1300 E4F2              *   |   |   |   |   |   |   |   |   |   |   |   |   |   |   |______  AttrAddr
1301 E4F2              *   |   |   |   |   |   |   |   |   |   |   |   |   |   |__________  AttrPage
1302 E4F2              *   |   |   |   |   |   |   |   |   |   |   |   |   |______________  AttrNoSpec
1303 E4F2              *   |   |   |   |   |   |   |   |   |   |   |   |__________________  AttrNoCross
1304 E4F2              *   |   |   |   |   |   |   |   |   |___|___|______________________  Reserved
1305 E4F2              *   |   |   |   |   |   |   |___|__________________________________  AttrPurge
1306 E4F2              *   |   |   |___|___|___|__________________________________________  Reserved
1307 E4F2              *   |   |__________________________________________________________  AttrFixed
1308 E4F2              *   |______________________________________________________________  AttrLocked
1309 E4F2              *
1310 E4F2              * ENTRY: Call via 'JSR'
1311 E4F2              *               A Reg = User ID
1312 E4F2              *               X Reg = Size of handle (0 to 65535 bytes)
1313 E4F2              *               Y Reg = Handle Attributes
1314 E4F2              *             Dir Reg = GS/OS Direct Page
1315 E4F2              *            Bank Reg = Current bank executing in
1316 E4F2              *           Stack Reg = GS/OS Stack
1317 E4F2              *               P Reg = N V M X D I Z C  E
1318 E4F2              *                       • • 0 0 0 • • •  0
1319 E4F2              *
1320 E4F2              * EXIT:         A Reg = Error code
1321 E4F2              *               X Reg = Least significant word of handle
1322 E4F2              *               Y Reg = Most significant word of handle
1323 E4F2              *             Dir Reg = GS/OS Direct Page
1324 E4F2              *            Bank Reg = Current bank executing in
1325 E4F2              *           Stack Reg = GS/OS Stack
1326 E4F2              *               P Reg = N V M X D I Z C  E
1327 E4F2              *                       • • 0 0 0 • • 0  0      if no error
1328 E4F2              *                       • • 0 0 0 • • 1  0      if error
1329 E4F2              *
1330 E4F2              ***************************************************************
1331 E4F2              get_new_handle  
1332 E4F2                       longa on
1333 E4F2                       longi on
1334 E4F2
1335 E4F2 48                    pha                            ; space for result
1336 E4F3 48                    pha   
1337 E4F4 F4 00 00              pea   $0000                    ; size of block is 12 bytes
1338 E4F7 DA                    phx   
1339 E4F8 48                    pha                            ; user ID
1340 E4F9 5A                    phy                            ; locked, fixed & no special mem
1341 E4FA F4 00 00              pea   $0000                    ; pointer to block
1342 E4FD F4 00 00              pea   $0000
1343 E500 A2 02 09 22           _newhandle 
1344 E507 FA                    plx                            ; least significant word of handle
1345 E508 7A                    ply                            ; most significant word of handle
1346 E509 90 04                 bcc   have_new_handle
1347 E50B              time_to_die  
1348 E50B 22 44 FC 01           jsl   sys_death                ; return with tool error
1349 E50F              have_new_handle  
1350 E50F 60                    rts   
1351 E510
1352 E510                       eject 
1353 E510              ***************************************************************
1354 E510              *
1355 E510              * The following routine sets the length of a locked handle.
1356 E510              * Note that the maximum handle size is 65535 bytes.
1357 E510              *
1358 E510              * ENTRY: Call via 'JSR'
1359 E510              *         handle_size = Longword value indicating size to set handle to
1360 E510              *               A Reg = Undefined
1361 E510              *               X Reg = Least significant word of handle
1362 E510              *               Y Reg = Most significant word of handle
1363 E510              *             Dir Reg = GS/OS Direct Page
1364 E510              *            Bank Reg = Current bank executing in
1365 E510              *           Stack Reg = GS/OS Stack
1366 E510              *               P Reg = N V M X D I Z C  E
1367 E510              *                       • • 0 0 0 • • •  0
1368 E510              *
1369 E510              * EXIT:         A Reg = Undefined
1370 E510              *               X Reg = Undefined
1371 E510              *               Y Reg = Undefined
1372 E510              *             Dir Reg = GS/OS Direct Page
1373 E510              *            Bank Reg = Current bank executing in
1374 E510              *           Stack Reg = GS/OS Stack
1375 E510              *               P Reg = N V M X D I Z C  E
1376 E510              *                       • • 0 0 0 • • •  0
1377 E510              *
1378 E510              ***************************************************************
1379 E510              set_handle_size  
1380 E510                       longa on
1381 E510                       longi on
1382 E510
1383 E510 3B                    tsc   
1384 E511 8D FB E1              sta   |stack_address
1385 E514
1386 E514 5A                    phy                            ; this will be the handle to lock
1387 E515 DA                    phx   
1388 E516
1389 E516 AD 41 E0              lda   |handle_size+2           ; this will be the handle size
1390 E519 48                    pha   
1391 E51A AD 3F E0              lda   |handle_size
1392 E51D 48                    pha   
1393 E51E 5A                    phy                            ; this is the handle for sethandlesize
1394 E51F DA                    phx   
1395 E520
1396 E520 5A                    phy                            ; this is the handle for hunlock
1397 E521 DA                    phx   
1398 E522 A2 02 22 22           _hunlock                       ; unlock the handle
1399 E529 B0 10                 bcs   tool_err_exit            ; if can't unlock handle
1400 E52B
1401 E52B A2 02 19 22           _sethandlesize                 ; set the handle size
1402 E532 B0 0C                 bcs   lock_it                  ; if can't resize handle
1403 E534              lock_handle  
1404 E534 A2 02 20 22           _hlock                         ; and lock the handle
1405 E53B              tool_err_exit  
1406 E53B AE FB E1              ldx   |stack_address
1407 E53E 9A                    txs   
1408 E53F 60                    rts   
1409 E540
1410 E540              lock_it   
1411 E540 AE FB E1              ldx   |stack_address           ; point at handle to lock
1412 E543 CA                    dex   
1413 E544 CA                    dex   
1414 E545 CA                    dex   
1415 E546 CA                    dex   
1416 E547 9A                    txs   
1417 E548 A2 02 22 22           _hunlock                       ; lock the handle
1418 E54F 38                    sec                            ; an error occurred
1419 E550 A9 FF 02              lda   #$02FF                   ; but I really dont know what it was anymore!
1420 E553 80 E6                 bra   tool_err_exit
1421 E555
1422 E555                       eject 
1423 E555              ***************************************************************
1424 E555              *
1425 E555              * The following routine unlocks and purges a handle.
1426 E555              *
1427 E555              * ENTRY: Call via 'JSR'
1428 E555              *               A Reg = User ID of handle
1429 E555              *               X Reg = Least significant word of handle
1430 E555              *               Y Reg = Most significant word of handle
1431 E555              *             Dir Reg = GS/OS Direct Page
1432 E555              *            Bank Reg = Current bank executing in
1433 E555              *           Stack Reg = GS/OS Stack
1434 E555              *               P Reg = N V M X D I Z C  E
1435 E555              *                       • • 0 0 0 • • •  0
1436 E555              *
1437 E555              * EXIT:         A Reg = Undefined
1438 E555              *               X Reg = Undefined
1439 E555              *               Y Reg = Undefined
1440 E555              *             Dir Reg = GS/OS Direct Page
1441 E555              *            Bank Reg = Current bank executing in
1442 E555              *           Stack Reg = GS/OS Stack
1443 E555              *               P Reg = N V M X D I Z C  E
1444 E555              *                       • • 0 0 0 • • •  0
1445 E555              *
1446 E555              ***************************************************************
1447 E555              dispose_handle  
1448 E555                       longa on
1449 E555                       longi on
1450 E555
1451 E555 48                    pha                            ; dispose the user ID
1452 E556
1453 E556 5A                    phy                            ; this will be the handle to lock
1454 E557 DA                    phx   
1455 E558
1456 E558 5A                    phy                            ; this is the handle for hunlock
1457 E559 DA                    phx   
1458 E55A A2 02 22 22           _hunlock                       ; unlock the handle
1459 E561 B0 A8                 bcs   time_to_die              ; if can't unlock handle
1460 E563
1461 E563 A2 02 10 22           _disposehandle                 ; toss the ma'ma
1462 E56A B0 9F                 bcs   time_to_die              ; if can't unlock handle
1463 E56C
1464 E56C A2 03 21 22           _deleteid 
1465 E573 B0 96                 bcs   time_to_die              ; if can't unlock handle
1466 E575 60                    rts   
1467 E576
1468 E576                       eject 
1469 E576              ***************************************************************
1470 E576              *
1471 E576              * The following routine is used to dereference the handle
1472 E576              * for the memory segment used to maintain generated driver
1473 E576              * DIB's and GDIB's.
1474 E576              *
1475 E576              * ENTRY: Call via 'JSR'
1476 E576              *               A Reg = Undefined
1477 E576              *               X Reg = Undefined
1478 E576              *               Y Reg = Undefined
1479 E576              *             Dir Reg = GS/OS Direct Page
1480 E576              *            Bank Reg = Current bank executing in
1481 E576              *           Stack Reg = GS/OS Stack
1482 E576              *               P Reg = N V M X D I Z C  E
1483 E576              *                       • • 0 0 0 • • •  0
1484 E576              *
1485 E576              * EXIT:         A Reg = Undefined
1486 E576              *               X Reg = Undefined
1487 E576              *               Y Reg = Undefined
1488 E576              *             Dir Reg = GS/OS Direct Page
1489 E576              *            Bank Reg = Current bank executing in
1490 E576              *           Stack Reg = GS/OS Stack
1491 E576              *               P Reg = N V M X D I Z C  E
1492 E576              *                       • • 0 0 0 • • 0  0      if no error
1493 E576              *                       • • 0 0 0 • • 1  0      if error
1494 E576              *
1495 E576              ***************************************************************
1496 E576              deref_drv_list  
1497 E576                       longa on
1498 E576                       longi on
1499 E576
1500 E576 AD 55 E0              lda   |gen_drvr_hndl
1501 E579 AE 57 E0              ldx   |gen_drvr_hndl+2
1502 E57C 20 4D FE              jsr   deref_handle
1503 E57F 85 28                 sta   <gen_drvr_ptr
1504 E581 86 2A                 stx   <gen_drvr_ptr+2
1505 E583 60                    rts   
1506 E584
1507 E584                       eject 
1508 E584              ***************************************************************
1509 E584              *
1510 E584              * This routine counts the number of devices supported by all
1511 E584              * GS/OS device drivers residing in the SYSTEM/DRIVERS
1512 E584              * subdirectory on the boot volume.  GS/OS drivers must have
1513 E584              * a FileType of $BB and an AuxType of $01XX.  The least
1514 E584              * significant 6 bits of least significant byte of the AuxType
1515 E584              * field indicate the number of devices supported by a driver.
1516 E584              * The two most significant bits of the least significant byte
1517 E584              * indicate the type of GS/OS driver (device driver or supervisory
1518 E584              * driver).
1519 E584              *
1520 E584              * AuxType: Device Driver
1521 E584              *  ___ ___ ___ ___ ___ ___ ___ ___ ___ ___ ___ ___ ___ ___ ___ ___
1522 E584              * |   |   |   |   |   |   |   |   |   |   |   |   |   |   |   |   |
1523 E584              * | F | E | D | C | B | A | 9 | 8 | 7 | 6 | 5 | 4 | 3 | 2 | 1 | 0 |
1524 E584              * |___|___|___|___|___|___|___|___|___|___|___|___|___|___|___|___|
1525 E584              *   |   |   |   |   |   |   |   |   |   |   |___|___|___|___|___|_ # Devices
1526 E584              *   |   |   |   |   |   |   |   |   |   |_________________________ 0
1527 E584              *   |   |   |   |   |   |   |   |   |_____________________________ 0
1528 E584              *   |___|___|___|___|___|___|___|_________________________________ = %00000001
1529 E584              *
1530 E584              * AuxType: Supervisory Driver
1531 E584              *  ___ ___ ___ ___ ___ ___ ___ ___ ___ ___ ___ ___ ___ ___ ___ ___
1532 E584              * |   |   |   |   |   |   |   |   |   |   |   |   |   |   |   |   |
1533 E584              * | F | E | D | C | B | A | 9 | 8 | 7 | 6 | 5 | 4 | 3 | 2 | 1 | 0 |
1534 E584              * |___|___|___|___|___|___|___|___|___|___|___|___|___|___|___|___|
1535 E584              *   |   |   |   |   |   |   |   |   |   |   |___|___|___|___|___|_ 0
1536 E584              *   |   |   |   |   |   |   |   |   |   |_________________________ 1
1537 E584              *   |   |   |   |   |   |   |   |   |_____________________________ 0
1538 E584              *   |___|___|___|___|___|___|___|_________________________________ = %00000001
1539 E584              *
1540 E584              * AuxType: Boot Driver
1541 E584              *  ___ ___ ___ ___ ___ ___ ___ ___ ___ ___ ___ ___ ___ ___ ___ ___
1542 E584              * |   |   |   |   |   |   |   |   |   |   |   |   |   |   |   |   |
1543 E584              * | F | E | D | C | B | A | 9 | 8 | 7 | 6 | 5 | 4 | 3 | 2 | 1 | 0 |
1544 E584              * |___|___|___|___|___|___|___|___|___|___|___|___|___|___|___|___|
1545 E584              *   |   |   |   |   |   |   |   |   |   |   |___|___|___|___|___|_ = %000001
1546 E584              *   |   |   |   |   |   |   |   |   |   |_________________________ 0
1547 E584              *   |   |   |   |   |   |   |   |   |_____________________________ 1
1548 E584              *   |___|___|___|___|___|___|___|_________________________________ = %00000001
1549 E584              *
1550 E584              * ENTRY: Call via 'JSR'
1551 E584              *               A Reg = Undefined
1552 E584              *               X Reg = Undefined
1553 E584              *               Y Reg = Undefined
1554 E584              *             Dir Reg = GS/OS Direct Page
1555 E584              *            Bank Reg = Current bank executing in
1556 E584              *           Stack Reg = GS/OS Stack
1557 E584              *               P Reg = N V M X D I Z C  E
1558 E584              *                       • • 0 0 0 • • •  0
1559 E584              *
1560 E584              * EXIT:         A Reg = Undefined
1561 E584              *               X Reg = Undefined
1562 E584              *               Y Reg = Undefined
1563 E584              *             Dir Reg = GS/OS Direct Page
1564 E584              *            Bank Reg = Current bank executing in
1565 E584              *           Stack Reg = GS/OS Stack
1566 E584              *               P Reg = N V M X D I Z C  E
1567 E584              *                       • • 0 0 0 • • •  0
1568 E584              *
1569 E584              ***************************************************************
1570 E584              count_l_drvr  
1571 E584                       longa on
1572 E584                       longi on
1573 E584              *
1574 E584              * Get the boot volume.
1575 E584              *
1576 E584 22 A8 00 E1           _get_boot_vol d_boot_vol_list 
1577 E58E 90 03                 bcc   open_drvr_file
1578 E590 4C 0B E5              jmp   time_to_die              ; die if can't get boot volume
1579 E593              *
1580 E593              * Open '/BOOT/SYSTEM/DRIVERS/'
1581 E593              *
1582 E593              open_drvr_file  
1583 E593 A9 40 00              lda   #64                      ; set buffer length
1584 E596 8D 27 E1              sta   |boot_vol_name
1585 E599
1586 E599 E2 30                 sep   #$30                     ; 8 bit 'm' & 'x'
1587 E59B                       longa off
1588 E59B                       longi off
1589 E59B
1590 E59B AE 29 E1              ldx   |boot_vol_str            ; append 'SYSTEM/DRIVERS'
1591 E59E E8                    inx   
1592 E59F A0 00                 ldy   #0
1593 E5A1              append_str  
1594 E5A1 B9 4B E1              lda   |sys_drivers,y
1595 E5A4 9D 2A E1              sta   |boot_vol_str+1,x
1596 E5A7 E8                    inx   
1597 E5A8 C8                    iny   
1598 E5A9 C0 0E                 cpy   #$0E
1599 E5AB D0 F4                 bne   append_str
1600 E5AD
1601 E5AD C2 30                 rep   #$30                     ; 16 bit 'm' & 'x'
1602 E5AF                       longa on
1603 E5AF                       longi on
1604 E5AF
1605 E5AF CA                    dex   
1606 E5B0 8E 29 E1              stx   |boot_vol_str            ; don't forget to set the string length
1607 E5B3
1608 E5B3 20 BE EA              jsr   do_my_open               ; open driver file
1609 E5B6 90 03                 bcc   it_opened
1610 E5B8 4C 24 E6              jmp   no_loaded_drvrs          ; if no drivers
1611 E5BB              it_opened  
1612 E5BB AD 5B E1              lda   |d_open_ref_num
1613 E5BE 8D 67 E1              sta   |dir_ref_num
1614 E5C1 8D 63 E1              sta   |d_close_ref_num
1615 E5C4              *
1616 E5C4              * Get directory entry with base and displacement values
1617 E5C4              * set to zero to return the number of entries in the DRIVERS
1618 E5C4              * subdirectory.
1619 E5C4              *
1620 E5C4 20 73 E9              jsr   set_dir_base             ; GET_DIR_ENTRY (base=disp=0)
1621 E5C7 B0 53                 bcs   no_drivers               ; if cant count drivers
1622 E5C9 AD 73 E1              lda   |dir_entry_num           ; save number of entries in directory
1623 E5CC F0 4E                 beq   no_drivers               ; if no drivers
1624 E5CE              *
1625 E5CE              * Get directory entries for each file in the DRIVERS subdirectory.
1626 E5CE              * If a file has a FileType of $BB and an AuxType of $01XX then
1627 E5CE              * add the least significant six bits of the AuxType to the current
1628 E5CE              * driver count.  Loop until all directory entries in the DRIVER
1629 E5CE              * subdirectory have been examined.
1630 E5CE              *
1631 E5CE              get_entry_loop  
1632 E5CE 20 86 E9              jsr   next_entry               ; GET_DIR_ENTRY
1633 E5D1 B0 49                 bcs   no_drivers
1634 E5D3              have_drvr_cnt  
1635 E5D3 AD 75 E1              lda   |dir_entry_ft            ; is file type $BB?
1636 E5D6 29 FF 00              and   #$00FF
1637 E5D9 C9 BB 00              cmp   #$00BB
1638 E5DC D0 3C                 bne   not_a_driver             ; no
1639 E5DE
1640 E5DE AD 91 E1              lda   |dir_entry_aux           ; is aux type $01XX?
1641 E5E1 29 00 FF              and   #$FF00
1642 E5E4 C9 00 01              cmp   #$0100
1643 E5E7 D0 31                 bne   not_a_driver             ; no
1644 E5E9
1645 E5E9 AD 91 E1              lda   |dir_entry_aux           ; is it a device driver?
1646 E5EC 29 C0 00              and   #$00C0
1647 E5EF F0 13                 beq   device_drvr              ; yes
1648 E5F1
1649 E5F1 C9 40 00              cmp   #$0040                   ; is it a supervisory driver?
1650 E5F4 D0 24                 bne   not_a_driver             ; no
1651 E5F6
1652 E5F6 EE C3 E0              inc   |sup_drvr_cnt            ; yes, increment supervisor count
1653 E5F9
1654 E5F9 AF D0 01 E1           lda   >warm_cold_flag          ; is this a warm start?
1655 E5FD D0 1B                 bne   not_a_driver             ; yes
1656 E5FF
1657 E5FF EE 51 E0              inc   |file_list_cnt           ; and file count
1658 E602 80 16                 bra   not_a_driver
1659 E604              device_drvr  
1660 E604 AD 91 E1              lda   |dir_entry_aux           ; else add XX to driver count
1661 E607 29 3F 00              and   #$003F
1662 E60A 18                    clc   
1663 E60B 6D 7F E0              adc   |driver_count
1664 E60E 8D 7F E0              sta   |driver_count
1665 E611
1666 E611 AF D0 01 E1           lda   >warm_cold_flag          ; is this a warm start?
1667 E615 D0 03                 bne   not_a_driver             ; yes
1668 E617 EE 51 E0              inc   |file_list_cnt           ; and file count
1669 E61A              not_a_driver  
1670 E61A 80 B2                 bra   get_entry_loop           ; loop until no more entries
1671 E61C              no_drivers  
1672 E61C 20 F2 EA              jsr   do_my_close              ; close /boot/system/drivers
1673 E61F 90 03                 bcc   no_loaded_drvrs
1674 E621 4C 0B E5              jmp   time_to_die              ; die if can't get boot volume
1675 E624              no_loaded_drvrs  
1676 E624 60                    rts   
1677 E625
1678 E625                       eject 
1679 E625              ***************************************************************
1680 E625              *
1681 E625              * This routine is used to count the number of generated
1682 E625              * drivers to be loaded.  The number of device drivers
1683 E625              * is added to the current contents of DRVR_TRAN_CNT.
1684 E625              *
1685 E625              * ENTRY: Call via 'JSR'
1686 E625              *               A Reg = Undefined
1687 E625              *               X Reg = Undefined
1688 E625              *               Y Reg = Undefined
1689 E625              *             Dir Reg = GS/OS Direct Page
1690 E625              *            Bank Reg = Current bank executing in
1691 E625              *           Stack Reg = GS/OS Stack
1692 E625              *               P Reg = N V M X D I Z C  E
1693 E625              *                       • • 0 0 0 • • •  0
1694 E625              *
1695 E625              * EXIT:         A Reg = Undefined
1696 E625              *               X Reg = Undefined
1697 E625              *               Y Reg = Undefined
1698 E625              *             Dir Reg = GS/OS Direct Page
1699 E625              *            Bank Reg = Current bank executing in
1700 E625              *           Stack Reg = GS/OS Stack
1701 E625              *               P Reg = N V M X D I Z C  E
1702 E625              *                       • • 0 0 0 • • •  0
1703 E625              *
1704 E625              ***************************************************************
1705 E625              count_g_drvr  
1706 E625                       longa on
1707 E625                       longi on
1708 E625
1709 E625 A9 0F 00              lda   #$000F                   ; initial slot is 15 (7 external)
1710 E628 8D 5F E0              sta   |gen_slot_num
1711 E62B
1712 E62B              count_g_loop  
1713 E62B AD 5F E0              lda   |gen_slot_num            ; request the slot
1714 E62E 22 BC FC 01           jsl   dyn_slot_arbiter
1715 E632 B0 21                 bcs   next_g_slot              ; if slot was not available
1716 E634
1717 E634 AD 5F E0              lda   |gen_slot_num            ; create $Cn00 pointer
1718 E637 EB                    xba   
1719 E638 29 00 07              and   #$0700
1720 E63B 09 00 C0              ora   #$C000
1721 E63E 85 28                 sta   <fw_addr
1722 E640 64 2A                 stz   <fw_addr+2
1723 E642
1724 E642 20 5E E6              jsr   ident_slot               ; identify device in slot
1725 E645 48                    pha   
1726 E646 18                    clc                            ; adjust total driver count
1727 E647 6D 7F E0              adc   |driver_count
1728 E64A 8D 7F E0              sta   |driver_count
1729 E64D 68                    pla                            ; adjust generated driver count
1730 E64E 18                    clc   
1731 E64F 6D 61 E0              adc   |total_gen
1732 E652 8D 61 E0              sta   |total_gen
1733 E655              next_g_slot  
1734 E655 CE 5F E0              dec   |gen_slot_num            ; next slot to search
1735 E658 D0 D1                 bne   count_g_loop
1736 E65A CE 61 E0              dec   |total_gen               ; boot volume already exists
1737 E65D 60                    rts   
1738 E65E
1739 E65E                       eject 
1740 E65E              ***************************************************************
1741 E65E              *
1742 E65E              * This routine is used to identify the device in a slot.
1743 E65E              *
1744 E65E              * ENTRY:        fwaddr  = (lw) base address of slot to identify
1745 E65E              *               A Reg   = Undefined
1746 E65E              *               X Reg   = Undefined
1747 E65E              *               Y Reg   = Undefined
1748 E65E              *             Dir Reg   = GS/OS Direct Page
1749 E65E              *               B Reg   = Current bank executing in
1750 E65E              *               P Reg = N V M X D I Z C  E
1751 E65E              *                       • • 0 0 0 • • •  0
1752 E65E              *
1753 E65E              * EXIT:         A Reg   = Number of devices this slot
1754 E65E              *               X Reg   = Device Type (0,1 or 2 where 0 includes subtype)
1755 E65E              *               Y Reg   = Undefined
1756 E65E              *             Dir Reg   = GS/OS Direct Page
1757 E65E              *               B Reg   = Current bank executing in
1758 E65E              *               P Reg = N V M X D I Z C  E
1759 E65E              *                       • • 0 0 0 • • 0  0      if no error
1760 E65E              *                       • • 0 0 0 • • 1  0      if error
1761 E65E              *
1762 E65E              ***************************************************************
1763 E65E              ident_slot  
1764 E65E                       longa on
1765 E65E                       longi on
1766 E65E
1767 E65E E2 30                 sep   #$30                     ; 8 bit 'm' & 'x'
1768 E660                       longa off
1769 E660                       longi off
1770 E660 64 28                 stz   <fw_addr                 ; make sure it's $Cn00
1771 E662 A0 05                 ldy   #$05                     ; point at signature in rom
1772 E664 A2 00                 ldx   #$00                     ; point at signature list
1773 E666              chck_pro_sig  
1774 E666 B7 28                 lda   [<fw_addr],y             ; check signature bytes
1775 E668 DD 00 E0              cmp   pro_sig,x                ; is it ProDOS/SmartPort
1776 E66B D0 5A                 bne   check_pascal             ; no
1777 E66D 88                    dey                            ; point at next signature in rom
1778 E66E 88                    dey   
1779 E66F E8                    inx                            ; point at next signature in list
1780 E670 E0 03                 cpx   #$03                     ; done all ProDOS signatures?
1781 E672 D0 F2                 bne   chck_pro_sig             ; no
1782 E674 A0 07                 ldy   #$07                     ; point at signature in rom
1783 E676 B7 28                 lda   [<fw_addr],y             ; is it a SmartPort peripheral?
1784 E678 D0 3C                 bne   check_prodos             ; no
1785 E67A
1786 E67A                       eject 
1787 E67A              ***************************************************************
1788 E67A              *
1789 E67A              * Got here if it's a SmartPort device.  Need to make a status call
1790 E67A              * to unit 0 to determine number of devices.  Must execute the
1791 E67A              * stack futz, switch to emulation mode, place a SmartPort unit
1792 E67A              * zero status call in bank 0, execute the call and unfutz the
1793 E67A              * stack.
1794 E67A              *
1795 E67A              ***************************************************************
1796 E67A                       longa off
1797 E67A                       longi off
1798 E67A
1799 E67A              *  ___ ___ ___ ___ ___ ___ ___ ___
1800 E67A              * |   |   |   |   |   |   |   |   |
1801 E67A              * | 7 | 6 | 5 | 4 | 3 | 2 | 1 | 0 | SmartPort Type ID ($CnFB)
1802 E67A              * |___|___|___|___|___|___|___|___|
1803 E67A              *   |   |   |   |   |   |   |   |__ RAM Card
1804 E67A              *   |   |   |   |   |   |   |______ SCSI Interface Card
1805 E67A              *   |   |   |   |   |   |__________ Reserved (must be 0)
1806 E67A              *   |   |   |   |   |______________ Reserved (must be 0)
1807 E67A              *   |   |   |   |__________________ Reserved (must be 0)
1808 E67A              *   |   |   |______________________ Reserved (must be 0)
1809 E67A              *   |   |__________________________ Interface Supports Super Calls
1810 E67A              *   |______________________________ Interface Supports Extended Calls
1811 E67A              *
1812 E67A A0 FB                 ldy   #$FB                     ; get SmartPort ID Type
1813 E67C B7 28                 lda   [<fw_addr],y
1814 E67E 29 02                 and   #%00000010
1815 E680 08                    php   
1816 E681
1817 E681 A0 FF                 ldy   #$FF                     ; calculate SmartPort entry point
1818 E683 B7 28                 lda   [<fw_addr],y
1819 E685 18                    clc   
1820 E686 69 03                 adc   #$03
1821 E688 85 28                 sta   <fw_addr
1822 E68A
1823 E68A 28                    plp                            ; is this a SCSI device?
1824 E68B
1825 E68B C2 30                 rep   #$30                     ; 16 bit 'm' & 'x'
1826 E68D                       longa on
1827 E68D                       longi on
1828 E68D
1829 E68D D0 13                 bne   it_is_a_scsi             ; if SCSI install one device
1830 E68F
1831 E68F 20 1B E7              jsr   setup_sp_stat            ; setup for smartport status call
1832 E692 22 C5 AD 00           jsl   b0_core                  ; execute unit 0 status call
1833 E696 B0 79                 bcs   no_device                ; no device if error returned
1834 E698 AF 00 AA 00           lda   >sys_buffer              ; else get number of devices
1835 E69C              set_sp_class  
1836 E69C A2 01 00              ldx   #$0001                   ; driver class = 1
1837 E69F 4C 15 E7              jmp   g_search_done
1838 E6A2
1839 E6A2              it_is_a_scsi  
1840 E6A2 20 1B E7              jsr   setup_sp_stat            ; setup for smartport status call
1841 E6A5 22 C5 AD 00           jsl   b0_core                  ; execute unit 0 status call
1842 E6A9 B0 66                 bcs   no_device                ; no device if error returned
1843 E6AB AF 00 AA 00           lda   >sys_buffer              ; if no devices
1844 E6AF F0 EB                 beq   set_sp_class
1845 E6B1 A9 01 00              lda   #$0001                   ; SCSI is always one device
1846 E6B4 80 E6                 bra   set_sp_class
1847 E6B6
1848 E6B6                       eject 
1849 E6B6              ***************************************************************
1850 E6B6              *
1851 E6B6              * Got here if it's a ProDOS device.  Assume at least one device.
1852 E6B6              * If configuration ram is set, determine if a second device is
1853 E6B6              * present and update the count as appropriate.  No driver will
1854 E6B6              * be generated for DISK][ devices.  These devices will not be
1855 E6B6              * tallied by this routine.
1856 E6B6              *
1857 E6B6              ***************************************************************
1858 E6B6              check_prodos  
1859 E6B6                       longa off
1860 E6B6                       longi off
1861 E6B6
1862 E6B6 A2 00                 ldx   #$00                     ; driver class = 0, subclass = 0
1863 E6B8 A0 FF                 ldy   #$FF                     ; point at entry offset byte
1864 E6BA B7 28                 lda   [<fw_addr],y             ; is it a 16 sector DISK][?
1865 E6BC 85 28                 sta   <fw_addr                 ; set entry point
1866 E6BE F0 55                 beq   g_search_done            ; yes
1867 E6C0
1868 E6C0 1A                    inc   a                        ; is it a 13 sector DISK][?
1869 E6C1 F0 52                 beq   g_search_done            ; yes
1870 E6C3
1871 E6C3 A9 02                 lda   #$02                     ; assume 2 devices per slot for now
1872 E6C5 80 4E                 bra   g_search_done
1873 E6C7
1874 E6C7                       eject 
1875 E6C7              ***************************************************************
1876 E6C7              *
1877 E6C7              * It's not ProDOS or SmartPort so need to determine
1878 E6C7              * if it's Pascal1.1
1879 E6C7              *
1880 E6C7              ***************************************************************
1881 E6C7              check_pascal  
1882 E6C7                       longa off
1883 E6C7                       longi off
1884 E6C7
1885 E6C7 A0 05                 ldy   #$05                     ; point at signature in rom
1886 E6C9 A2 00                 ldx   #$00                     ; point at signature list
1887 E6CB              chck_p_sig  
1888 E6CB B7 28                 lda   [<fw_addr],y             ; check signature bytes
1889 E6CD DD 04 E0              cmp   pascal_sig,x             ; is it Pascal1.1
1890 E6D0 D0 27                 bne   check_basic              ; no
1891 E6D2
1892 E6D2 C8                    iny                            ; point at next signature in rom
1893 E6D3 C8                    iny   
1894 E6D4 E8                    inx                            ; point at next signature in list
1895 E6D5 E0 02                 cpx   #$02                     ; done all Pascal signatures?
1896 E6D7 D0 F2                 bne   chck_p_sig               ; no
1897 E6D9
1898 E6D9 A0 0B                 ldy   #$0B                     ; point at last signature
1899 E6DB B7 28                 lda   [<fw_addr],y             ; check signature bytes
1900 E6DD DD 04 E0              cmp   pascal_sig,x             ; is it Pascal1.1
1901 E6E0 D0 17                 bne   check_basic              ; no
1902 E6E2              *
1903 E6E2              * It's a Pascal1.1 device.  Need to know if it is one of the
1904 E6E2              * following Pascal1.1 device types:
1905 E6E2              *
1906 E6E2              *               Printer
1907 E6E2              *               Serial
1908 E6E2              *               Modem
1909 E6E2              *               80 Column
1910 E6E2              *               Network / Bus
1911 E6E2              *
1912 E6E2 C8                    iny                            ; point at signature in rom
1913 E6E3 B7 28                 lda   [<fw_addr],y             ; check signature bytes
1914 E6E5 29 F0                 and   #$F0                     ; most significant nibble only relevant
1915 E6E7              chck_p_type  
1916 E6E7 DD 04 E0              cmp   pascal_sig,x             ; is it a legal device?
1917 E6EA F0 07                 beq   legal_pascal             ; yes
1918 E6EC
1919 E6EC E8                    inx                            ; point at next signature in list
1920 E6ED E0 08                 cpx   #$08                     ; done all Pascal1.1 types?
1921 E6EF D0 F6                 bne   chck_p_type              ; no
1922 E6F1 80 1E                 bra   no_device
1923 E6F3              legal_pascal  
1924 E6F3 A9 01                 lda   #$01                     ; if legal, mark 1 device
1925 E6F5 A2 80                 ldx   #$80                     ; driver class = 0, subclass = 1
1926 E6F7 80 1C                 bra   g_search_done
1927 E6F9
1928 E6F9                       eject 
1929 E6F9              ***************************************************************
1930 E6F9              *
1931 E6F9              * Got here if it is not a Pascal1.1 device.  Need to determine
1932 E6F9              * if a rom resides in the slot to make an educated guess about
1933 E6F9              * the existance of a BASIC device.
1934 E6F9              *
1935 E6F9              ***************************************************************
1936 E6F9              check_basic  
1937 E6F9 A0 00                 ldy   #$00                     ; check rom
1938 E6FB BB                    tyx   
1939 E6FC B7 28                 lda   [<fw_addr],y
1940 E6FE F0 15                 beq   g_search_done            ; if initialization entry is a BRK
1941 E700
1942 E700 1A                    inc   a
1943 E701 F0 12                 beq   g_search_done            ; if initialization entry is a SBC LONG,X
1944 E703
1945 E703 3A                    dec   a                        ; restore A = ROM contents ($Cn00)
1946 E704              basic_rom_chk  
1947 E704 D7 28                 cmp   [<fw_addr],y             ; check rom
1948 E706 D0 09                 bne   no_device
1949 E708
1950 E708 CA                    dex   
1951 E709 D0 F9                 bne   basic_rom_chk
1952 E70B
1953 E70B A9 01                 lda   #$01                     ; rom appears stable, set 1 device
1954 E70D A2 80                 ldx   #$80                     ; driver class = 0, subclass = 1
1955 E70F 80 04                 bra   g_search_done
1956 E711              no_device  
1957 E711 E2 20                 sep   #$20                     ; 8 bit 'm'
1958 E713                       longa off
1959 E713
1960 E713 A9 00                 lda   #$00                     ; no device this slot
1961 E715              g_search_done  
1962 E715 C2 30                 rep   #$30                     ; 16 bit 'm' and 'x'
1963 E717                       longa on
1964 E717                       longi on
1965 E717
1966 E717 29 7F 00              and   #$007F                   ; maximum is 127 per slot
1967 E71A 60                    rts   
1968 E71B
1969 E71B                       eject 
1970 E71B              ***************************************************************
1971 E71B              *
1972 E71B              * This routine sets up the bank 0 dispatcher with a standard
1973 E71B              * SmartPort status call to unit 0 with a status code of 0.
1974 E71B              *
1975 E71B              * ENTRY: Call via 'JSR'
1976 E71B              *               A Reg = Undefined
1977 E71B              *               X Reg = Undefined
1978 E71B              *               Y Reg = Undefined
1979 E71B              *             Dir Reg = GS/OS Direct Page
1980 E71B              *            Bank Reg = Current bank executing in
1981 E71B              *           Stack Reg = GS/OS Stack
1982 E71B              *               P Reg = 0=m=x=e
1983 E71B              *
1984 E71B              * EXIT:         A Reg = Last byte of parameter list
1985 E71B              *               X Reg = Address of SmartPort command
1986 E71B              *               Y Reg = Address of parameter list+7
1987 E71B              *             Dir Reg = GS/OS Direct Page
1988 E71B              *            Bank Reg = Current bank executing in
1989 E71B              *           Stack Reg = GS/OS Stack
1990 E71B              *               P Reg = 0=m=x=e
1991 E71B              *
1992 E71B              ***************************************************************
1993 E71B              setup_sp_stat  
1994 E71B                       longa on
1995 E71B                       longi on
1996 E71B
1997 E71B AF 0F AC 00           lda   >call_list_ptr           ; get address where command resides
1998 E71F AA                    tax   
1999 E720 A9 00 00              lda   #$0000                   ; set command = status call
2000 E723 9F 00 00 00           sta   >0,x
2001 E727 A9 1D AC              lda   #param_list_ptr          ; set parameter list pointer
2002 E72A 9F 01 00 00           sta   >1,x
2003 E72E A8                    tay   
2004 E72F A9 EA EA              lda   #$EAEA                   ; 2 nop instructions
2005 E732 9F 03 00 00           sta   >3,x
2006 E736 DA                    phx   
2007 E737 BB                    tyx                            ; point into the parameter list
2008 E738 E2 20                 sep   #$20                     ; 8 bit 'm'
2009 E73A                       longa off
2010 E73A A0 0C E0              ldy   #sp_unit0                ; point at parameter list
2011 E73D              setup_unit0  
2012 E73D B9 00 00              lda   |0,y                     ; move parameter list to bank 0
2013 E740 9F 00 00 00           sta   >0,x
2014 E744 E8                    inx   
2015 E745 C8                    iny   
2016 E746 C0 13 E0              cpy   #sp_unit0+7
2017 E749 D0 F2                 bne   setup_unit0
2018 E74B FA                    plx   
2019 E74C 60                    rts   
2020 E74D
2021 E74D                       eject 
2022 E74D              ***************************************************************
2023 E74D              *
2024 E74D              * The following routine dereferences the device list handle and
2025 E74D              * stores the resulting pointer on GS/OS direct page.
2026 E74D              *
2027 E74D              * ENTRY: Call via 'JSR'
2028 E74D              *               A Reg = Undefined
2029 E74D              *               X Reg = Undefined
2030 E74D              *               Y Reg = Undefined
2031 E74D              *             Dir Reg = GS/OS Direct Page
2032 E74D              *            Bank Reg = Current bank executing in
2033 E74D              *           Stack Reg = GS/OS Stack
2034 E74D              *               P Reg = N V M X D I Z C  E
2035 E74D              *                       • • 0 0 0 • • •  0
2036 E74D              *
2037 E74D              * EXIT:         A Reg = Undefined
2038 E74D              *               X Reg = Undefined
2039 E74D              *               Y Reg = Unchanged
2040 E74D              *             Dir Reg = GS/OS Direct Page
2041 E74D              *        DRVR_DEV_PTR = Now points at device list
2042 E74D              *            Bank Reg = Current bank executing in
2043 E74D              *           Stack Reg = GS/OS Stack
2044 E74D              *               P Reg = N V M X D I Z C  E
2045 E74D              *                       • • 0 0 0 • • •  0
2046 E74D              ***************************************************************
2047 E74D              deref_dev_list  
2048 E74D                       longa on
2049 E74D                       longi on
2050 E74D
2051 E74D AE 39 E0              ldx   |dev_list_hndl+2         ; get file handle
2052 E750 AD 37 E0              lda   |dev_list_hndl
2053 E753 20 4D FE              jsr   deref_handle             ; dereference the handle
2054 E756 85 24                 sta   <drvr_dev_ptr            ; set pointer on direct page
2055 E758 84 26                 sty   <drvr_dev_ptr+2
2056 E75A 60                    rts   
2057 E75B
2058 E75B                       eject 
2059 E75B              *****************************************************************
2060 E75B              *
2061 E75B              * This routine optains the DIB pointer for the device specified
2062 E75B              * by the current DRVR_DEV_NUM from the device list to set the
2063 E75B              * DRVR_DIB_PTR on GS/OS direct page.
2064 E75B              *                  __________________
2065 E75B              *           $0000 |_                _|   ... Number of devices
2066 E75B              *           $0001 |_                _|
2067 E75B              *           $0002 |_                _|
2068 E75B              *           $0003 |__________________|
2069 E75B              *           $0004 |_                _|   ... Pointer to device #1 DIB
2070 E75B              *           $0005 |_                _|
2071 E75B              *           $0006 |_                _|
2072 E75B              *           $0007 |__________________|
2073 E75B              *           $0008 |_                _|   ... Device #1 disk switched status
2074 E75B              *           $0009 |__________________|
2075 E75B              *           $000A |_                _|   ... Device #1 User ID
2076 E75B              *           $000B |__________________|
2077 E75B              *           $000C |_                _|   ... Pointer to device #2 DIB
2078 E75B              *           $000D |_                _|
2079 E75B              *           $000E |_                _|
2080 E75B              *           $000F |__________________|
2081 E75B              *           $0010 |_                _|   ... Device #2 disk switched status
2082 E75B              *           $0011 |__________________|
2083 E75B              *           $0012 |_                _|   ... Device #2 User ID
2084 E75B              *           $0013 |__________________|
2085 E75B              *           $0014  ...
2086 E75B              *
2087 E75B              * ENTRY:        A Reg = Unspecified
2088 E75B              *               X Reg = Unspecified
2089 E75B              *               Y Reg = Unspecified
2090 E75B              *               B Reg = Same as execution bank
2091 E75B              *             Dir Reg = GS/OS Direct Page
2092 E75B              *               P Reg = N V M X D I Z C  E
2093 E75B              *                       x x 0 0 0 x x x  
2094 E75B              *
2095 E75B              * EXIT:         A Reg = Unchanged
2096 E75B              *               X Reg = Unchanged
2097 E75B              *               Y Reg = Unchanged
2098 E75B              *               B Reg = Same as execution bank
2099 E75B              *             Dir Reg = GS/OS Direct Page
2100 E75B              *        DRVR_DIB_PTR = Now points at DIB for current DRVR_DEV_NUM
2101 E75B              *               P Reg = N V M X D I Z C  E
2102 E75B              *                       • • 0 0 0 • • •  0
2103 E75B              *
2104 E75B              *****************************************************************
2105 E75B              set_dib_ptr  
2106 E75B                       longa on
2107 E75B                       longi on
2108 E75B
2109 E75B 48                    pha   
2110 E75C 5A                    phy   
2111 E75D 08                    php   
2112 E75E C2 30                 rep   #$30                     ; 16 bit 'm' & 'x'
2113 E760                       longa on
2114 E760                       longi on
2115 E760 A5 00                 lda   <drvr_dev_num            ; device number to set DIB pointer for
2116 E762 3A                    dec   a                        ; calculate index into device list
2117 E763 38                    sec   
2118 E764 2A                    rol   a
2119 E765 0A                    asl   a
2120 E766 0A                    asl   a
2121 E767 A8                    tay   
2122 E768 B7 24                 lda   [<drvr_dev_ptr],y        ; set the DIB pointer
2123 E76A 85 20                 sta   <drvr_dib_ptr
2124 E76C C8                    iny   
2125 E76D C8                    iny   
2126 E76E B7 24                 lda   [<drvr_dev_ptr],y
2127 E770 85 22                 sta   <drvr_dib_ptr+2
2128 E772 28                    plp   
2129 E773 7A                    ply   
2130 E774 68                    pla   
2131 E775 60                    rts   
2132 E776
2133 E776                       eject 
2134 E776              **************************************************************
2135 E776              *
2136 E776              * This routine is used to load and install all RAM LOADED
2137 E776              * DRIVERS.  After each driver is loaded, it is installed
2138 E776              * into the device list.  A DRVR_STARTUP call will be issued
2139 E776              * to each driver.  If a driver returns an error, the driver
2140 E776              * will be purged from the device list.
2141 E776              *
2142 E776              * ENTRY: via a 'JSR'
2143 E776              *               A Reg = Undefined
2144 E776              *               X Reg = Undefined
2145 E776              *               Y Reg = Undefined
2146 E776              *            Bank Reg = Current Program Bank
2147 E776              *             Dir Reg = GS/OS Direct Page
2148 E776              *           Stack Reg = GS/OS Stack
2149 E776              *               P Reg = N V M X D I Z C  E
2150 E776              *                       • • 0 0 0 • • •  0
2151 E776              *
2152 E776              * EXIT:  via 'RTS'
2153 E776              *               A Reg = Undefined
2154 E776              *               X Reg = Undefined
2155 E776              *               Y Reg = Undefined
2156 E776              *            Bank Reg = Current Program Bank
2157 E776              *             Dir Reg = GS/OS Direct Page
2158 E776              *           Stack Reg = GS/OS Stack
2159 E776              *               P Reg = N V M X D I Z C  E
2160 E776              *                       • • 0 0 0 • • •  0
2161 E776              *
2162 E776              ***************************************************************
2163 E776              load_drivers  
2164 E776                       longa on
2165 E776                       longi on
2166 E776
2167 E776 D4 04                 pei   <boot_slot               ; preserve for driver generation
2168 E778 A9 01 00              lda   #$0001                   ; 1st supervisor is supervisor #1
2169 E77B 87 70                 sta   [<sup_drvr_ptr]
2170 E77D 20 BE EA              jsr   do_my_open               ; open '/boot/system/drivers'
2171 E780 B0 11                 bcs   no_l_drivers
2172 E782
2173 E782 AD 5B E1              lda   |d_open_ref_num          ; save reference number for close
2174 E785 8D 63 E1              sta   |d_close_ref_num
2175 E788 20 B3 EA              jsr   set_my_prefix            ; set_prefix to /boot/system/drivers
2176 E78B B0 06                 bcs   no_l_drivers
2177 E78D
2178 E78D 20 AC E7              jsr   load_supervisor          ; load supervisory drivers
2179 E790 20 97 E8              jsr   load_dev_driver          ; load device drivers
2180 E793              no_l_drivers  
2181 E793 22 A8 00 E1           _get_boot_vol d_boot_vol_list 
2182 E79D 20 B3 EA              jsr   set_my_prefix            ; set prefix back to boot vol
2183 E7A0 20 F2 EA              jsr   do_my_close              ; close '/boot/system/drivers'
2184 E7A3 AD 81 E0              lda   |load_device             ; prepare to generate drivers
2185 E7A6 85 00                 sta   <drvr_dev_num
2186 E7A8 68                    pla   
2187 E7A9 85 04                 sta   <boot_slot
2188 E7AB 60                    rts   
2189 E7AC
2190 E7AC                       eject 
2191 E7AC              *****************************************************************
2192 E7AC              *
2193 E7AC              * Get directory entries for each file in the DRIVERS subdirectory.
2194 E7AC              * If a file has a FileType of $BB and an AuxType of $0140 then
2195 E7AC              * the driver is a supervisory driver and will be loaded and started.
2196 E7AC              *
2197 E7AC              * All drivers are of a FileType of $BB.  GS/OS Device drivers
2198 E7AC              * use a AuxType of $01XX for active drivers or $81XX for any
2199 E7AC              * inactive drivers.  The least significant 6 bits of the least
2200 E7AC              * significant byte of the AuxType indicates the number of
2201 E7AC              * devices supported by the driver.
2202 E7AC              *  ___ ___ ___ ___ ___ ___ ___ ___ ___ ___ ___ ___ ___ ___ ___ ___
2203 E7AC              * |   |   |   |   |   |   |   |   |   |   |   |   |   |   |   |   | Supervisory
2204 E7AC              * | F | E | D | C | B | A | 9 | 8 | 7 | 6 | 5 | 4 | 3 | 2 | 1 | 0 | Drivers:
2205 E7AC              * |___|___|___|___|___|___|___|___|___|___|___|___|___|___|___|___|
2206 E7AC              *   |   |   |   |   |   |   |   |   |   |   |___|___|___|___|___|__ %xxxxxxxx
2207 E7AC              *   |   |   |   |   |   |   |   |   |   |__________________________ 1
2208 E7AC              *   |   |   |   |   |   |   |   |   |______________________________ 0
2209 E7AC              *   |___|___|___|___|___|___|___|__________________________________ %00000001
2210 E7AC              *
2211 E7AC              * ENTRY: via a 'JSR'
2212 E7AC              *               A Reg = Undefined
2213 E7AC              *               X Reg = Undefined
2214 E7AC              *               Y Reg = Undefined
2215 E7AC              *            Bank Reg = Current Program Bank
2216 E7AC              *             Dir Reg = GS/OS Direct Page
2217 E7AC              *           Stack Reg = GS/OS Stack
2218 E7AC              *               P Reg = N V M X D I Z C  E
2219 E7AC              *                       • • 0 0 0 • • •  0
2220 E7AC              *
2221 E7AC              * EXIT:  via 'RTS'
2222 E7AC              *               A Reg = Undefined
2223 E7AC              *               X Reg = Undefined
2224 E7AC              *               Y Reg = Undefined
2225 E7AC              *            Bank Reg = Current Program Bank
2226 E7AC              *             Dir Reg = GS/OS Direct Page
2227 E7AC              *           Stack Reg = GS/OS Stack
2228 E7AC              *               P Reg = N V M X D I Z C  E
2229 E7AC              *                       • • 0 0 0 • • •  0
2230 E7AC              *
2231 E7AC              *****************************************************************
2232 E7AC              load_supervisor  
2233 E7AC                       longa on
2234 E7AC                       longi on
2235 E7AC
2236 E7AC 20 73 E9              jsr   set_dir_base             ; prepare to walk driver directory
2237 E7AF A9 01 00              lda   #$0001
2238 E7B2 87 70                 sta   [<sup_drvr_ptr]          ; init 1st supervisory load number
2239 E7B4 AD C3 E0              lda   |sup_drvr_cnt
2240 E7B7 D0 06                 bne   sup_entry_loop
2241 E7B9
2242 E7B9              *
2243 E7B9              * Supervisor driver count pointed at next entry to be loaded.  Since
2244 E7B9              * there was no entry to be loaded, the correct driver count is the
2245 E7B9              * current count-1.
2246 E7B9              *
2247 E7B9              no_sups   
2248 E7B9 A7 70                 lda   [<sup_drvr_ptr]
2249 E7BB 3A                    dec   a
2250 E7BC 87 70                 sta   [<sup_drvr_ptr]
2251 E7BE 60                    rts   
2252 E7BF
2253 E7BF              *
2254 E7BF              * Each GET_DIR_ENTRY call will automatically advance through the
2255 E7BF              * /boot/system/drivers/ directory.  Walk directory checking the
2256 E7BF              * filetype and auxtype for GS/OS supervisory drivers.
2257 E7BF              *
2258 E7BF              sup_entry_loop  
2259 E7BF 20 86 E9              jsr   next_entry               ; GET_DIR_ENTRY
2260 E7C2 B0 F5                 bcs   no_sups                  ; ** REVISED v0.07a02
2261 E7C4
2262 E7C4 20 90 EA              jsr   check_filetype           ; is it filetype $BB?
2263 E7C7 D0 F6                 bne   sup_entry_loop           ; no, try the next file
2264 E7C9 C9 40 01              cmp   #$0140                   ; is this a supervisory driver?
2265 E7CC D0 F1                 bne   sup_entry_loop           ; no
2266 E7CE
2267 E7CE                       eject 
2268 E7CE              *
2269 E7CE              * Driver is a supervisory driver.  Load and install the supervisory
2270 E7CE              * driver into the supervisory driver list.  A header must reside at
2271 E7CE              * the load address of the supervisory driver after an initialload2
2272 E7CE              * has been executed to bring in the supervisory driver.  The structure
2273 E7CE              * of this header is seen below:
2274 E7CE              *                ____________________
2275 E7CE              *       +$0000  |_                  _|
2276 E7CE              *               |_    Supervisor    _|
2277 E7CE              *               |_   Driver Entry   _|
2278 E7CE              *               |____________________|
2279 E7CE              *       +$0004  |_    Supervisor    _|
2280 E7CE              *               |_________ID_________|
2281 E7CE              *       +$0006  |_    Supervisor    _|
2282 E7CE              *               |_______Version______|
2283 E7CE              *       +$0008  |_                  _|
2284 E7CE              *               |_    Supervisor    _|
2285 E7CE              *       +$000A  |_   Name Pointer   _|
2286 E7CE              *               |____________________|
2287 E7CE              *       +$000C  |_  Characteristic  _|
2288 E7CE              *               |____________________|
2289 E7CE              *       +$000E  |_     Reserved     _|
2290 E7CE              *               |____________________|
2291 E7CE              *
2292 E7CE 38                    sec                            ; flag that load is a supervisor driver
2293 E7CF 20 D5 E9              jsr   do_file_load             ; and load the driver
2294 E7D2              *
2295 E7D2              * Install the supervisor into the supervisor list and start it.
2296 E7D2              *                _____________________  _
2297 E7D2              *   +$0000      |_                   _|  |
2298 E7D2              *               |_ Supervisor Driver _|  |_ Device list entry count
2299 E7D2              *               |_       Count       _|  |
2300 E7D2              *               |_____________________| _|
2301 E7D2              *   +$0004      |_                   _|  |
2302 E7D2              *               |_   Entry pointer   _|  |
2303 E7D2              *               |_   in supervisor   _|  |
2304 E7D2              *               |_____________________|  |_ Supervisory driver entry
2305 E7D2              *   +$0008      |_   Supervisor ID   _|  |
2306 E7D2              *               |_____________________|  |
2307 E7D2              *   +$000A      |_      User ID      _|  |
2308 E7D2              *               |_____________________| _|
2309 E7D2              *
2310 E7D2 B0 EB                 bcs   sup_entry_loop           ; if cannot load supervisor
2311 E7D4
2312 E7D4 A7 70                 lda   [<sup_drvr_ptr]          ; get current supervisor number
2313 E7D6 8D CB E0              sta   |cur_sup                 ; set in case purge is neccessary
2314 E7D9 20 8D E8              jsr   set_sup_index
2315 E7DC
2316 E7DC AD 8A EA              lda   |temp_user_id            ; set supervisor's USER ID
2317 E7DF 97 70                 sta   [<sup_drvr_ptr],y
2318 E7E1
2319 E7E1 20 1E EB              jsr   y_minus_6                ; point at SIB pointer
2320 E7E4 AD 86 EA              lda   |temp_load_addr          ; set SIB pointer in list and dp
2321 E7E7 97 70                 sta   [<sup_drvr_ptr],y
2322 E7E9 85 74                 sta   <sib_ptr
2323 E7EB C8                    iny   
2324 E7EC C8                    iny   
2325 E7ED AD 88 EA              lda   |temp_load_addr          +2
2326 E7F0 97 70                 sta   [<sup_drvr_ptr],y
2327 E7F2 85 76                 sta   <sib_ptr+2
2328 E7F4
2329 E7F4 5A                    phy   
2330 E7F5 A0 04 00              ldy   #sib_id                  ; SIB ID Number (SIB index)
2331 E7F8 B7 74                 lda   [<sib_ptr],y
2332 E7FA BB                    tyx   
2333 E7FB 7A                    ply                            ; and install in supervisor list
2334 E7FC C8                    iny   
2335 E7FD C8                    iny   
2336 E7FE 97 70                 sta   [<sup_drvr_ptr],y
2337 E800
2338 E800 8D C7 E0              sta   |cur_sib_id              ; save for duplicate check
2339 E803 9B                    txy   
2340 E804 C8                    iny   
2341 E805 C8                    iny   
2342 E806 B7 74                 lda   [<sib_ptr],y             ; get supervisor version #
2343 E808 8D C9 E0              sta   |cur_sib_ver             ; save for duplicate check
2344 E80B              *
2345 E80B              * Obtain the supervisor restart flag and install into the device
2346 E80B              * dispatcher file list structure.
2347 E80B              *
2348 E80B A0 0C 00              ldy   #sib_char                ; get supervisor characteristics
2349 E80E B7 74                 lda   [<sib_ptr],y
2350 E810 20 7D EA              jsr   set_restart
2351 E813              *
2352 E813              * Now that supervisory driver is loaded, issue a supervisor_startup
2353 E813              * call.  If supervisory driver returns an error as a result of the
2354 E813              * startup call, load next supervisor over this position.
2355 E813              *
2356 E813 A7 70                 lda   [<sup_drvr_ptr]          ; get current startup supervisor
2357 E815 A2 00 00              ldx   #$0000                   ; startup call
2358 E818 22 A4 FC 01           jsl   sup_drvr_disp            ; call supervisory driver
2359 E81C 90 0B                 bcc   dont_unload_sup          ; if no error on startup
2360 E81E              *
2361 E81E              * Supervisor driver couldnot startup.  Unload segment and purge
2362 E81E              * memory for this supervisory driver.
2363 E81E              *
2364 E81E CE 29 FE              dec   |current_file            ; next file list entry will be at same as current
2365 E821 AD CB E0              lda   |cur_sup                 ; go NUKE that supervisor driver
2366 E824 20 26 F2              jsr   purge_sup
2367 E827 80 96                 bra   sup_entry_loop
2368 E829              *
2369 E829              * Now check to see if this is a duplicate supervisory driver.
2370 E829              * The check is based on the supervisor ID only.  If a duplicate
2371 E829              * is found then the highest version supervisor will be kept.
2372 E829              * In the case of duplicate version numbers, the first supervisor
2373 E829              * loaded will be kept.
2374 E829              *
2375 E829              dont_unload_sup   
2376 E829 A7 70                 lda   [<sup_drvr_ptr]          ; point at previous supervisor ?????
2377 E82B 8D CB E0              sta   |cur_sup
2378 E82E
2379 E82E              unload_sup_loop  
2380 E82E CE CB E0              dec   |cur_sup                 ; decrement counter
2381 E831 F0 52                 beq   no_other_sup             ; if only 1 supervisor loaded
2382 E833
2383 E833 AD CB E0              lda   |cur_sup                 ; get the supervisor number
2384 E836 20 2C FD              jsr   set_sib_ptr              ; point at previous SIB
2385 E839 A0 04 00              ldy   #sib_id                  ; is this a duplicate SIB?
2386 E83C B7 74                 lda   [<sib_ptr],y
2387 E83E CD C7 E0              cmp   |cur_sib_id
2388 E841 D0 EB                 bne   unload_sup_loop          ; no
2389 E843
2390 E843 A0 06 00              ldy   #sib_ver                 ; is this a higher version SIB?
2391 E846 B7 74                 lda   [<sib_ptr],y
2392 E848 CD C9 E0              cmp   |cur_sib_ver
2393 E84B 90 0E                 blt   keep_cur_sib
2394 E84D              *
2395 E84D              * The new SIB is a lower or equal version.  In this case it must be
2396 E84D              * shutdown and purged.
2397 E84D              *
2398 E84D CE 29 FE              dec   |current_file            ; next file list entry will be at same as current
2399 E850 A7 70                 lda   [<sup_drvr_ptr]
2400 E852 8D CB E0              sta   |cur_sup
2401 E855 20 1D F2              jsr   shutdn_sup               ; shutdown & purge supervisor
2402 E858 4C BF E7              jmp   sup_entry_loop
2403 E85B              *
2404 E85B              * The new supervisor is a duplicate of a higher version of this supervisor.
2405 E85B              * The old supervisor must be shutdown and purged.
2406 E85B              *
2407 E85B              keep_cur_sib  
2408 E85B AD CB E0              lda   |cur_sup                 ; supervisor number
2409 E85E 20 1D F2              jsr   shutdn_sup               ; shutdown & purge supervisor
2410 E861 A7 70                 lda   [<sup_drvr_ptr]          ; get SIB list info to swap
2411 E863 20 8D E8              jsr   set_sup_index
2412 E866 A2 03 00              ldx   #$0003
2413 E869              sib_swap_loop0   
2414 E869 B7 70                 lda   [<sup_drvr_ptr],y
2415 E86B 48                    pha                            ; save SIB addr, user id & type
2416 E86C 88                    dey   
2417 E86D 88                    dey   
2418 E86E CA                    dex   
2419 E86F 10 F8                 bpl   sib_swap_loop0
2420 E871 AD CB E0              lda   |cur_sup
2421 E874 20 2C E2              jsr   times_8_plus_4           ; make index to list entry
2422 E877 A2 03 00              ldx   #$0003
2423 E87A              sib_swap_loop1   
2424 E87A 68                    pla   
2425 E87B 97 70                 sta   [<sup_drvr_ptr],y
2426 E87D C8                    iny   
2427 E87E C8                    iny   
2428 E87F CA                    dex   
2429 E880 10 F8                 bpl   sib_swap_loop1
2430 E882 4C BF E7              jmp   sup_entry_loop
2431 E885              *
2432 E885              * If driver loaded and started correctly then point at next entry
2433 E885              * to be loaded.
2434 E885              *
2435 E885              no_other_sup   
2436 E885 A7 70                 lda   [<sup_drvr_ptr]
2437 E887 1A                    inc   a
2438 E888 87 70                 sta   [<sup_drvr_ptr]
2439 E88A              *
2440 E88A              * Check if all entries in the /boot/system/drivers/ directory have
2441 E88A              * been checked as being a supervisory driver.  If unchecked entries
2442 E88A              * remain in the directory, loop to check remaining entries.
2443 E88A              *
2444 E88A              not_sup_drvr   
2445 E88A 4C BF E7              jmp   sup_entry_loop           ; yes
2446 E88D
2447 E88D                       eject 
2448 E88D              *****************************************************************
2449 E88D              *
2450 E88D              * This routine calculates an index into the supervisory driver
2451 E88D              * list for the supervisory driver specified in the A register.
2452 E88D              *
2453 E88D              * ENTRY: via a 'JSR'
2454 E88D              *               A Reg = Supervisory driver number
2455 E88D              *               X Reg = Undefined
2456 E88D              *               Y Reg = Undefined
2457 E88D              *            Bank Reg = Current Program Bank
2458 E88D              *             Dir Reg = GS/OS Direct Page
2459 E88D              *           Stack Reg = GS/OS Stack
2460 E88D              *               P Reg = N V M X D I Z C  E
2461 E88D              *                       • • 0 0 0 • • •  0
2462 E88D              *
2463 E88D              * EXIT:  via 'RTS'
2464 E88D              *               A Reg = Index to supervisory driver's User ID entry
2465 E88D              *               X Reg = Unchanged
2466 E88D              *               Y Reg = Index to supervisory driver's User ID entry
2467 E88D              *            Bank Reg = Current Program Bank
2468 E88D              *             Dir Reg = GS/OS Direct Page
2469 E88D              *           Stack Reg = GS/OS Stack
2470 E88D              *               P Reg = N V M X D I Z C  E
2471 E88D              *                       • • 0 0 0 • • •  0
2472 E88D              *
2473 E88D              *****************************************************************
2474 E88D              set_sup_index  
2475 E88D                       longa on
2476 E88D                       longi on
2477 E88D
2478 E88D 3A                    dec   a                        ; point at supervisor user id
2479 E88E 0A                    asl   a
2480 E88F 0A                    asl   a
2481 E890 0A                    asl   a
2482 E891 18                    clc   
2483 E892 69 0A 00              adc   #$000A
2484 E895 A8                    tay   
2485 E896 60                    rts   
2486 E897
2487 E897                       eject 
2488 E897              *****************************************************************
2489 E897              *
2490 E897              * Now that supervisory drivers are loaded, reset parameters for
2491 E897              * get_dir_entry to start at top of directory and load GS/OS device
2492 E897              * drivers.  All drivers are of a FileType of $BB.  GS/OS Device
2493 E897              * drivers use a AuxType of $01XX for active drivers or $81XX for
2494 E897              * any inactive drivers.  The least significant 6 bits of the least
2495 E897              * significant byte of the AuxType indicates the number of
2496 E897              * devices supported by the driver.
2497 E897              *  ___ ___ ___ ___ ___ ___ ___ ___ ___ ___ ___ ___ ___ ___ ___ ___
2498 E897              * |   |   |   |   |   |   |   |   |   |   |   |   |   |   |   |   | Device
2499 E897              * | F | E | D | C | B | A | 9 | 8 | 7 | 6 | 5 | 4 | 3 | 2 | 1 | 0 | Drivers:
2500 E897              * |___|___|___|___|___|___|___|___|___|___|___|___|___|___|___|___|
2501 E897              *   |   |   |   |   |   |   |   |   |   |   |___|___|___|___|___|__ DIB count
2502 E897              *   |   |   |   |   |   |   |   |   |   |__________________________ 0
2503 E897              *   |   |   |   |   |   |   |   |   |______________________________ 0
2504 E897              *   |___|___|___|___|___|___|___|__________________________________ %00000001
2505 E897              *
2506 E897              * The device driver list consists of a longword count specifying the
2507 E897              * number of devices followed by an four word entry for each device
2508 E897              * consisting of a longword pointer to the device's DIB, a disk switched
2509 E897              * status word and a memory USER ID word.
2510 E897              *                ____________________  _
2511 E897              *       +$0000  |_                  _|  |
2512 E897              *               |_     Number of    _|  |_ Driver list entry count
2513 E897              *               |_  Device Drivers  _|  |
2514 E897              *               |____________________| _|
2515 E897              *       +$0004  |_                  _|  |
2516 E897              *               |_      Pointer     _|  |
2517 E897              *               |_      to DIB      _|  |
2518 E897              *               |____________________|  |_ Device driver entry (8 bytes)
2519 E897              *       +$0008  |_    Disk Switch   _|  |
2520 E897              *               |____________________|  |
2521 E897              *       +$000A  |_      USER ID     _|  |
2522 E897              *               |____________________| _|
2523 E897              *
2524 E897              * ENTRY: via a 'JSR'
2525 E897              *               A Reg = Undefined
2526 E897              *               X Reg = Undefined
2527 E897              *               Y Reg = Undefined
2528 E897              *            Bank Reg = Current Program Bank
2529 E897              *             Dir Reg = GS/OS Direct Page
2530 E897              *           Stack Reg = GS/OS Stack
2531 E897              *               P Reg = N V M X D I Z C  E
2532 E897              *                       • • 0 0 0 • • •  0
2533 E897              *
2534 E897              * EXIT:  via 'RTS'
2535 E897              *               A Reg = Undefined
2536 E897              *               X Reg = Undefined
2537 E897              *               Y Reg = Undefined
2538 E897              *            Bank Reg = Current Program Bank
2539 E897              *             Dir Reg = GS/OS Direct Page
2540 E897              *           Stack Reg = GS/OS Stack
2541 E897              *               P Reg = N V M X D I Z C  E
2542 E897              *                       • • 0 0 0 • • •  0
2543 E897              *
2544 E897              *****************************************************************
2545 E897              load_dev_driver  
2546 E897                       longa on
2547 E897                       longi on
2548 E897
2549 E897 20 73 E9              jsr   set_dir_base             ; to reset to top of directory
2550 E89A 90 03                 bcc   drvr_entry_loop
2551 E89C              no_dev_drvrs  
2552 E89C 4C 58 E9              jmp   no_dev_drivers
2553 E89F              *
2554 E89F              * Get_dir_entry list is now at top of directory.  Ok to check next
2555 E89F              * directory entry for GS/OS device driver type & auxtype prior to
2556 E89F              * loading driver.
2557 E89F              *
2558 E89F              drvr_entry_loop  
2559 E89F 20 86 E9              jsr   next_entry               ; GET_DIR_ENTRY
2560 E8A2 B0 F8                 bcs   no_dev_drvrs
2561 E8A4 20 90 EA              jsr   check_filetype           ; is file type $BB (GS/OS driver)?
2562 E8A7 D0 F6                 bne   drvr_entry_loop          ; no
2563 E8A9 C9 00 01              cmp   #$0100                   ; is it a device driver?
2564 E8AC D0 F1                 bne   drvr_entry_loop          ; no
2565 E8AE              *
2566 E8AE              * File is a driver.  Call the system loader to bring in the
2567 E8AE              * driver file then issue a startup call to each device supported
2568 E8AE              * by the driver.  If all devices return errors as a result of the
2569 E8AE              * startup call then unload the driver.
2570 E8AE              *
2571 E8AE AD B7 E0              lda   |start_count             ; any drivers to startup?
2572 E8B1 F0 EC                 beq   drvr_entry_loop          ; no
2573 E8B3              many_dibs  
2574 E8B3 9C B9 E0              stz   |purge_flag              ; driver not started successfully yet.
2575 E8B6 18                    clc                            ; flag that load is a device driver
2576 E8B7 20 D5 E9              jsr   do_file_load             ; and load the driver
2577 E8BA              *
2578 E8BA              * Install the driver into the device list and startup the driver.
2579 E8BA              *
2580 E8BA 08                    php                            ; save any tool error
2581 E8BB AD 81 E0              lda   |load_device
2582 E8BE 85 00                 sta   <drvr_dev_num
2583 E8C0 20 24 E2              jsr   set_dev_index            ; set device list pointer
2584 E8C3 28                    plp   
2585 E8C4 BB                    tyx   
2586 E8C5 20 17 EB              jsr   y_plus_6                 ; point at User ID
2587 E8C8 AD 8A EA              lda   |temp_user_id            ; set device user ID
2588 E8CB 97 24                 sta   [<drvr_dev_ptr],y
2589 E8CD 8D AF E0              sta   |cur_user_id
2590 E8D0 9B                    txy                            ; point at DIB pointer
2591 E8D1 AD 86 EA              lda   |temp_load_addr          ; point at driver
2592 E8D4 85 20                 sta   <drvr_dib_ptr
2593 E8D6 AD 88 EA              lda   |temp_load_addr+2
2594 E8D9 85 22                 sta   <drvr_dib_ptr+2
2595 E8DB B0 C2                 bcs   drvr_entry_loop
2596 E8DD              *
2597 E8DD              * Now that we know where the file loaded, walk all the DIB's
2598 E8DD              * and install each device supported by the driver into the
2599 E8DD              * device list.  Each driver must support the following header:
2600 E8DD              *
2601 E8DD              *         _________________
2602 E8DD              * +$0000 |_               _| ... Offset to 1st DIB
2603 E8DD              *        |_________________|
2604 E8DD              * +$0002 |_               _| ... Number of devices
2605 E8DD              *        |_________________|
2606 E8DD              * +$0004 |_               _| ... Offset to 1st control parameter list
2607 E8DD              *        |_________________|
2608 E8DD              * +$0006 |_               _| ... Offset to 2nd control parameter list
2609 E8DD              *        |_________________|
2610 E8DD              *        etc...
2611 E8DD              *
2612 E8DD 18                    clc                            ; caclulate pointer to 1st DIB
2613 E8DE A7 20                 lda   [<drvr_dib_ptr]          ; offset + load addr = DIB addr
2614 E8E0 65 20                 adc   <drvr_dib_ptr
2615 E8E2 AA                    tax   
2616 E8E3 A9 00 00              lda   #$0000
2617 E8E6 65 22                 adc   <drvr_dib_ptr+2
2618 E8E8 85 22                 sta   <drvr_dib_ptr+2          ; set DIB addr
2619 E8EA 86 20                 stx   <drvr_dib_ptr
2620 E8EC 48                    pha                            ; insert DIB pointer in device list
2621 E8ED 8A                    txa   
2622 E8EE 97 24                 sta   [<drvr_dev_ptr],y
2623 E8F0 C8                    iny   
2624 E8F1 C8                    iny   
2625 E8F2 68                    pla   
2626 E8F3 97 24                 sta   [<drvr_dev_ptr],y
2627 E8F5              *
2628 E8F5              * Startup driver and check for duplicates.
2629 E8F5              *
2630 E8F5 20 25 EB              jsr   startup_l_drvr           ; startup & check for dupes
2631 E8F8 CE B5 E0              dec   |dib_count               ; so we dont load to many
2632 E8FB 90 0D                 bcc   next_link                ; if no dupe then walk link ptrs
2633 E8FD CE 81 E0              dec   |load_device             ; next device at this position
2634 E900 D0 08                 bne   next_link                ; if more dibs this driver ** v0.12a01
2635 E902
2636 E902 20 67 E9              jsr   set_dev_restart          ; insert startup flag in file list structure
2637 E905 EE 81 E0              inc   |load_device             ; else point at current entry
2638 E908 80 4F                 bra   check_purge
2639 E90A              *
2640 E90A              * Insert any linked DIB's into the device list.
2641 E90A              *
2642 E90A              next_link  
2643 E90A 20 67 E9              jsr   set_dev_restart          ; insert startup flag in file list structure
2644 E90D
2645 E90D 5A                    phy                            ; insert device number in file list structure
2646 E90E A0 3E 00              ldy   #dib_dev_num
2647 E911 B7 20                 lda   [<drvr_dib_ptr],y
2648 E913 7A                    ply   
2649 E914 C8                    iny   
2650 E915 C8                    iny   
2651 E916 97 56                 sta   [<file_entry_ptr],y
2652 E918
2653 E918 EE 81 E0              inc   |load_device             ; next loaded device
2654 E91B AD 81 E0              lda   |load_device
2655 E91E 85 00                 sta   <drvr_dev_num
2656 E920              *
2657 E920              * If link pointer in DIB is NIL then no more devices to install.
2658 E920              * If not NIL then need to continue installing devices if the DIB
2659 E920              * count does not exceed the number of DIB's that was indicated
2660 E920              * by the driver file's auxtype.
2661 E920              *
2662 E920 A0 02 00              ldy   #link_ptr+2              ; is there a linked DIB?
2663 E923 A7 20                 lda   [<drvr_dib_ptr]
2664 E925 AA                    tax   
2665 E926 17 20                 ora   [<drvr_dib_ptr],y
2666 E928 F0 2F                 beq   check_purge              ; no (v0.05 a09)
2667 E92A AD B5 E0              lda   |dib_count               ; done as many as specified in auxtype?
2668 E92D F0 2A                 beq   check_purge              ; if no more should it be purged
2669 E92F              *
2670 E92F              * The link field in the DIB was not NIL.  Need to create an entry
2671 E92F              * in the device list for the linked DIB.
2672 E92F              *
2673 E92F B7 20                 lda   [<drvr_dib_ptr],y
2674 E931 48                    pha   
2675 E932 DA                    phx   
2676 E933 20 24 E2              jsr   set_dev_index            ; point at DIB entry in device list
2677 E936 68                    pla                            ; and insert DIB entry
2678 E937 97 24                 sta   [<drvr_dev_ptr],y
2679 E939 AA                    tax   
2680 E93A C8                    iny   
2681 E93B C8                    iny   
2682 E93C 68                    pla   
2683 E93D 97 24                 sta   [<drvr_dev_ptr],y
2684 E93F 20 19 EB              jsr   y_plus_4
2685 E942 86 20                 stx   <drvr_dib_ptr            ; initialize DIB pointer
2686 E944 85 22                 sta   <drvr_dib_ptr+2
2687 E946 AD AF E0              lda   |cur_user_id             ; and insert USER ID in device list
2688 E949 97 24                 sta   [<drvr_dev_ptr],y
2689 E94B              *
2690 E94B              * Startup driver and check for duplicates.
2691 E94B              *
2692 E94B 20 25 EB              jsr   startup_l_drvr           ; startup & check for dupes
2693 E94E CE B5 E0              dec   |dib_count
2694 E951 90 B7                 bcc   next_link                ; if no error walk DIBs
2695 E953 CE 81 E0              dec   |load_device             ; else next device in this position
2696 E956 80 B2                 bra   next_link
2697 E958              no_dev_drivers  
2698 E958 60                    rts   
2699 E959
2700 E959              check_purge  
2701 E959 AD B9 E0              lda   |purge_flag              ; should driver be purged?
2702 E95C D0 06                 bne   to_drvr_entry            ; no
2703 E95E
2704 E95E AD AF E0              lda   |cur_user_id             ; else prepare to purge
2705 E961 20 40 F2              jsr   purge_driver
2706 E964              to_drvr_entry  
2707 E964 4C 9F E8              jmp   drvr_entry_loop
2708 E967
2709 E967              set_dev_restart  
2710 E967 A0 08 00              ldy   #dev_char                ; insert startup flag in file list structure
2711 E96A B7 20                 lda   [<drvr_dib_ptr],y
2712 E96C 0A                    asl   a
2713 E96D 0A                    asl   a
2714 E96E 0A                    asl   a
2715 E96F 0A                    asl   a
2716 E970 4C 7D EA              jmp   set_restart
2717 E973
2718 E973                       eject 
2719 E973              *****************************************************************
2720 E973              *
2721 E973              * The following routine sets the base and displacement for
2722 E973              * subsequent get_dir_entry calls to the top of the directory
2723 E973              * in preperation for walking the directory.  The second entry
2724 E973              * point is used to walk the directory.
2725 E973              *
2726 E973              * ENTRY: via a 'JSR'
2727 E973              *               A Reg = Undefined
2728 E973              *               X Reg = Undefined
2729 E973              *               Y Reg = Undefined
2730 E973              *            Bank Reg = Current Program Bank
2731 E973              *             Dir Reg = GS/OS Direct Page
2732 E973              *           Stack Reg = GS/OS Stack
2733 E973              *               P Reg = N V M X D I Z C  E
2734 E973              *                       • • 0 0 0 • • •  0
2735 E973              *
2736 E973              * EXIT:  via 'RTS'
2737 E973              *               A Reg = Undefined
2738 E973              *               X Reg = Undefined
2739 E973              *               Y Reg = Undefined
2740 E973              *            Bank Reg = Current Program Bank
2741 E973              *             Dir Reg = GS/OS Direct Page
2742 E973              *           Stack Reg = GS/OS Stack
2743 E973              *               P Reg = N V M X D I Z C  E
2744 E973              *                       • • 0 0 0 • • •  0
2745 E973              *
2746 E973              *****************************************************************
2747 E973              set_dir_base  
2748 E973                       longa on
2749 E973                       longi on
2750 E973
2751 E973 AF D0 01 E1           lda   >warm_cold_flag          ; is this a warm start?
2752 E977 F0 05                 beq   cold_dir_base            ; no
2753 E979
2754 E979 9C 29 FE              stz   |current_file            ; on warm start, point at base of file entry list
2755 E97C 18                    clc   
2756 E97D 60                    rts   
2757 E97E              cold_dir_base  
2758 E97E 9C 6B E1              stz   |dir_entry_base          ; to reset to top of directory
2759 E981 9C 6D E1              stz   |dir_entry_disp
2760 E984 80 44                 bra   make_the_call
2761 E986
2762 E986                       eject 
2763 E986              *****************************************************************
2764 E986              *
2765 E986              * The following routine sets the base and displacement for
2766 E986              * subsequent get_dir_entry calls to the top of the directory
2767 E986              * in preperation for walking the directory.  The second entry
2768 E986              * point is used to walk the directory.
2769 E986              *
2770 E986              * ENTRY: via a 'JSR'
2771 E986              *               A Reg = Undefined
2772 E986              *               X Reg = Undefined
2773 E986              *               Y Reg = Undefined
2774 E986              *            Bank Reg = Current Program Bank
2775 E986              *             Dir Reg = GS/OS Direct Page
2776 E986              *           Stack Reg = GS/OS Stack
2777 E986              *               P Reg = N V M X D I Z C  E
2778 E986              *                       • • 0 0 0 • • •  0
2779 E986              *
2780 E986              * EXIT:  via 'RTS'
2781 E986              *               A Reg = Undefined
2782 E986              *               X Reg = Undefined
2783 E986              *               Y Reg = Undefined
2784 E986              *            Bank Reg = Current Program Bank
2785 E986              *             Dir Reg = GS/OS Direct Page
2786 E986              *           Stack Reg = GS/OS Stack
2787 E986              *               P Reg = N V M X D I Z C  E
2788 E986              *                       • • 0 0 0 • • •  0
2789 E986              *
2790 E986              *****************************************************************
2791 E986              next_entry           
2792 E986                       longa on
2793 E986                       longi on
2794 E986
2795 E986 AF D0 01 E1           lda   >warm_cold_flag          ; is this a warm start?
2796 E98A F0 35                 beq   cold_next_entry          ; no
2797 E98C
2798 E98C EE 29 FE              inc   |current_file            ; reference next file list entry
2799 E98F AD 29 FE              lda   |current_file            ; is the next entry valid?
2800 E992 CD 51 E0              cmp   |file_list_cnt
2801 E995 90 04                 blt   get_file_entry           ; yes
2802 E997 F0 02                 beq   get_file_entry           ; yes
2803 E999 38                    sec                            ; no, return an error if past end of list
2804 E99A 60                    rts   
2805 E99B              get_file_entry  
2806 E99B 20 E8 FD              jsr   calc_file_index          ; point at current file entry
2807 E99E A0 02 00              ldy   #file_auxtype
2808 E9A1 A7 56                 lda   [<file_entry_ptr]        ; return filetype like get_dir_entry call
2809 E9A3 8D 75 E1              sta   |dir_entry_ft
2810 E9A6 B7 56                 lda   [<file_entry_ptr],y      ; return auxtype like get_dir_entry call
2811 E9A8 8D 91 E1              sta   |dir_entry_aux
2812 E9AB A0 0A 00              ldy   #file_name               ; return filename like get_dir_entry call
2813 E9AE A2 00 00              ldx   #0
2814 E9B1              xfer_name  
2815 E9B1 B7 56                 lda   [<file_entry_ptr],y
2816 E9B3 9D CF E1              sta   |file_name_str,x
2817 E9B6 C8                    iny   
2818 E9B7 C8                    iny   
2819 E9B8 E8                    inx   
2820 E9B9 E8                    inx   
2821 E9BA E0 20 00              cpx   #32                      ; always copy 32 bytes regardless of real length
2822 E9BD 90 F2                 blt   xfer_name
2823 E9BF 18                    clc   
2824 E9C0 60                    rts   
2825 E9C1
2826 E9C1              cold_next_entry  
2827 E9C1 A9 01 00              lda   #$0001                   ; base & displacement for next directory entry
2828 E9C4 8D 6B E1              sta   |dir_entry_base
2829 E9C7 8D 6D E1              sta   |dir_entry_disp
2830 E9CA              make_the_call  
2831 E9CA 22 A8 00 E1           _get_dir_entry dir_entry_list 
2832 E9D4 60                    rts   
2833 E9D5
2834 E9D5                       eject 
2835 E9D5              *****************************************************************
2836 E9D5              *
2837 E9D5              * The following routine executes the initial load of a supervisor
2838 E9D5              * or device driver.
2839 E9D5              *
2840 E9D5              * ENTRY: via a 'JSR'
2841 E9D5              *               A Reg = Undefined
2842 E9D5              *               X Reg = Undefined
2843 E9D5              *               Y Reg = Undefined
2844 E9D5              *            Bank Reg = Current Program Bank
2845 E9D5              *             Dir Reg = GS/OS Direct Page
2846 E9D5              *           Stack Reg = GS/OS Stack
2847 E9D5              *               P Reg = N V M X D I Z C  E
2848 E9D5              *                       • • 0 0 0 • • 0  0      load a device driver
2849 E9D5              *                       • • 0 0 0 • • 1  0      load a supervisor driver
2850 E9D5              *
2851 E9D5              * EXIT:  via 'RTS'
2852 E9D5              *               A Reg = Undefined
2853 E9D5              *               X Reg = Undefined
2854 E9D5              *               Y Reg = Undefined
2855 E9D5              *            Bank Reg = Current Program Bank
2856 E9D5              *             Dir Reg = GS/OS Direct Page
2857 E9D5              *           Stack Reg = GS/OS Stack
2858 E9D5              *               P Reg = N V M X D I Z C  E
2859 E9D5              *                       • • 0 0 0 • • •  0
2860 E9D5              *
2861 E9D5              *****************************************************************
2862 E9D5              do_file_load  
2863 E9D5                       longa on
2864 E9D5                       longi on
2865 E9D5
2866 E9D5 08                    php                            ; save carry (device vs. supervisor flag)
2867 E9D6 AF D0 01 E1           lda   >warm_cold_flag          ; is this a warm start?
2868 E9DA F0 26                 beq   do_cold_load             ; no
2869 E9DC 20 F7 FE              jsr   find_file                ; find file in file list
2870 E9DF B0 21                 bcs   do_cold_load             ; now found in list, load from disk
2871 E9E1
2872 E9E1              do_mem_load  
2873 E9E1              *	ldy	#file_auxtype	; set up carry in case need to load from disk
2874 E9E1              *	lda	[<file_entry_ptr],y
2875 E9E1              *	xba
2876 E9E1              *	rol	a
2877 E9E1              *	rol	a
2878 E9E1
2879 E9E1 A0 2A 00              ldy   #file_restart            ; is driver restartable from memory
2880 E9E4 B7 56                 lda   [<file_entry_ptr],y
2881 E9E6 F0 1A                 beq   do_cold_load             ; no, go get it from disk
2882 E9E8
2883 E9E8 28                    plp                            ; clean up stack (carry not used)
2884 E9E9 A0 04 00              ldy   #file_user_id            ; user ID of memory resident driver
2885 E9EC B7 56                 lda   [<file_entry_ptr],y
2886 E9EE 8D 8A EA              sta   |temp_user_id
2887 E9F1
2888 E9F1 A0 06 00              ldy   #file_load_addr          ; load address of memory resident driver
2889 E9F4 B7 56                 lda   [<file_entry_ptr],y
2890 E9F6 8D 86 EA              sta   |temp_load_addr
2891 E9F9 C8                    iny   
2892 E9FA C8                    iny   
2893 E9FB B7 56                 lda   [<file_entry_ptr],y
2894 E9FD 8D 88 EA              sta   |temp_load_addr+2
2895 EA00 18                    clc                            ; never return an error if loading from memory
2896 EA01 60                    rts   
2897 EA02
2898 EA02              do_cold_load  
2899 EA02 28                    plp                            ; retrieve carry
2900 EA03 48                    pha                            ; space for dir.page/stack size
2901 EA04 48                    pha                            ; space for dir.page/stack addr
2902 EA05 48                    pha                            ; space for starting address
2903 EA06 48                    pha   
2904 EA07 48                    pha                            ; space for ID
2905 EA08 A9 00 39              lda   #$3900                   ; assume device driver
2906 EA0B 90 03                 bcc   have_ld_id               ; assumed correctly
2907 EA0D A9 00 3A              lda   #$3A00                   ; ID to be assigned by loader for supervisor driver
2908 EA10              have_ld_id  
2909 EA10 48                    pha                            ; put desired ID on stack
2910 EA11 F4 E0 00              pea   file_name_str>>16
2911 EA14 F4 CF E1              pea   file_name_str
2912 EA17 F4 01 00              pea   $0001                    ; NO SPECIAL MEMORY!!!
2913 EA1A F4 01 00              pea   $0001                    ; class 1 pathname string
2914 EA1D A2 11 20 22           _InitialLoad2 
2915 EA24 7A                    ply                            ; save driver user ID
2916 EA25 8C 8A EA              sty   |temp_user_id
2917 EA28 7A                    ply                            ; save driver load address
2918 EA29 FA                    plx   
2919 EA2A 8C 86 EA              sty   |temp_load_addr
2920 EA2D 8E 88 EA              stx   |temp_load_addr+2
2921 EA30 7A                    ply                            ; dir. page / stack address
2922 EA31 FA                    plx                            ; dir. page / stack size
2923 EA32 B0 48                 bcs   no_file_entry            ; if error, dont create file list entry
2924 EA34 AF D0 01 E1           lda   >warm_cold_flag          ; is this a warm start?
2925 EA38 D0 03                 bne   refresh_list             ; yes, only update current file list entry
2926 EA3A              *
2927 EA3A              * GET_DIR_ENTRY should have already aquired the filetype and auxtype.
2928 EA3A              * Just set the pointer to the file entry and store all the parameters
2929 EA3A              * into the entry.
2930 EA3A              *
2931 EA3A EE 29 FE              inc   |current_file            ; on cold start point at next entry
2932 EA3D              refresh_list  
2933 EA3D AD 29 FE              lda   |current_file
2934 EA40 20 E8 FD              jsr   calc_file_index
2935 EA43
2936 EA43 AD 8C EA              lda   |temp_filetype           ; install filetype in file list entry
2937 EA46 87 56                 sta   [<file_entry_ptr]
2938 EA48
2939 EA48 A0 02 00              ldy   #file_auxtype            ; install auxtype in file list entry
2940 EA4B AD 8E EA              lda   |temp_auxtype
2941 EA4E 97 56                 sta   [<file_entry_ptr],y
2942 EA50
2943 EA50 A0 04 00              ldy   #file_user_id            ; install user ID in file list entry
2944 EA53 AD 8A EA              lda   |temp_user_id
2945 EA56 97 56                 sta   [<file_entry_ptr],y
2946 EA58
2947 EA58 A0 06 00              ldy   #file_load_addr          ; install load address in file list entry
2948 EA5B AD 86 EA              lda   |temp_load_addr
2949 EA5E 97 56                 sta   [<file_entry_ptr],y
2950 EA60 C8                    iny   
2951 EA61 C8                    iny   
2952 EA62 AD 88 EA              lda   |temp_load_addr+2
2953 EA65 97 56                 sta   [<file_entry_ptr],y
2954 EA67
2955 EA67 A0 0A 00              ldy   #file_name
2956 EA6A A2 CF E1              ldx   #file_name_str
2957 EA6D              insert_name  
2958 EA6D BD 00 00              lda   |0,x
2959 EA70 97 56                 sta   [<file_entry_ptr],y
2960 EA72 E8                    inx   
2961 EA73 E8                    inx   
2962 EA74 C8                    iny   
2963 EA75 C8                    iny   
2964 EA76 C0 2A 00              cpy   #file_restart
2965 EA79 D0 F2                 bne   insert_name
2966 EA7B 18                    clc   
2967 EA7C              *
2968 EA7C              * NOTE: the routine that called the DO_FILE_LOAD must initialize the restartable
2969 EA7C              * flag and dev_num flag entries in the file list.
2970 EA7C              *
2971 EA7C              no_file_entry  
2972 EA7C 60                    rts   
2973 EA7D
2974 EA7D              set_restart  
2975 EA7D A0 2A 00              ldy   #file_restart
2976 EA80 29 00 80              and   #$8000
2977 EA83 97 56                 sta   [<file_entry_ptr],y
2978 EA85 60                    rts   
2979 EA86
2980 EA86 27 93 02 00  temp_load_addr DC L:0                   ; load address of driver
2981 EA8A 0E 39        temp_user_id DC W:0                     ; driver user id
2982 EA8C BB 00        temp_filetype DC W:0                    ; driver filetype
2983 EA8E 01 01        temp_auxtype DC W:0                     ; driver auxtype
2984 EA90
2985 EA90                       eject 
2986 EA90              *****************************************************************
2987 EA90              *
2988 EA90              * The following routine checks the current filetype for use
2989 EA90              * as either a GS/OS device driver or supervisory driver.
2990 EA90              *
2991 EA90              * ENTRY: via a 'JSR'
2992 EA90              *        dir_entry_ft = FileType of current driver file
2993 EA90              *       dir_entry_aux = AuxType of current driver file
2994 EA90              *               A Reg = Undefined
2995 EA90              *               X Reg = Undefined
2996 EA90              *               Y Reg = Undefined
2997 EA90              *            Bank Reg = Current Program Bank
2998 EA90              *             Dir Reg = GS/OS Direct Page
2999 EA90              *           Stack Reg = GS/OS Stack
3000 EA90              *               P Reg = N V M X D I Z C  E
3001 EA90              *                       • • 0 0 0 • • •  0
3002 EA90              *
3003 EA90              * EXIT:  via 'RTS'
3004 EA90              *          |dib_count = AuxType ANDed with $003F
3005 EA90              *               A Reg = AuxType ANDed with $FFC0
3006 EA90              *               X Reg = Undefined
3007 EA90              *               Y Reg = Undefined
3008 EA90              *            Bank Reg = Current Program Bank
3009 EA90              *             Dir Reg = GS/OS Direct Page
3010 EA90              *           Stack Reg = GS/OS Stack
3011 EA90              *               P Reg = N V M X D I Z C  E
3012 EA90              *                       x x 0 0 0 x      0
3013 EA90              *                                   x x      Set by filetype compare
3014 EA90              *
3015 EA90              *****************************************************************
3016 EA90              check_filetype  
3017 EA90                       longa on
3018 EA90                       longi on
3019 EA90
3020 EA90 AD 75 E1              lda   |dir_entry_ft            ; is file type $BB (GS/OS driver)?
3021 EA93 8D 8C EA              sta   |temp_filetype
3022 EA96 29 FF 00              and   #$00FF
3023 EA99 C9 BB 00              cmp   #$00BB
3024 EA9C 08                    php   
3025 EA9D AD 91 E1              lda   |dir_entry_aux           ; prepare for auxtype checking
3026 EAA0 8D 8E EA              sta   |temp_auxtype
3027 EAA3 48                    pha   
3028 EAA4 29 3F 00              and   #$003F
3029 EAA7 8D B5 E0              sta   |dib_count               ; preserve dib count if neccessary
3030 EAAA 8D B7 E0              sta   |start_count
3031 EAAD 68                    pla   
3032 EAAE 29 C0 FF              and   #$FFC0
3033 EAB1 28                    plp   
3034 EAB2 60                    rts   
3035 EAB3
3036 EAB3                       eject 
3037 EAB3              *****************************************************************
3038 EAB3              *
3039 EAB3              * The following routine sets prefix 0 to the pathname passed
3040 EAB3              * in the prefix list.
3041 EAB3              *
3042 EAB3              *****************************************************************
3043 EAB3              set_my_prefix  
3044 EAB3                       longa on
3045 EAB3                       longi on
3046 EAB3
3047 EAB3 22 A8 00 E1           _set_prefix set_prefix_list 
3048 EABD 60                    rts   
3049 EABE
3050 EABE              *****************************************************************
3051 EABE              *
3052 EABE              * The following routine opens the pathname passed in the
3053 EABE              * open list.
3054 EABE              *
3055 EABE              *****************************************************************
3056 EABE              do_my_open  
3057 EABE                       longa on
3058 EABE                       longi on
3059 EABE
3060 EABE AF D0 01 E1           lda   >warm_cold_flag          ; is this a warm start?
3061 EAC2 F0 23                 beq   cold_open                ; no
3062 EAC4
3063 EAC4 AE 45 E0              ldx   |file_list_hndl          ; yes, lock the file list handle
3064 EAC7 AC 47 E0              ldy   |file_list_hndl+2
3065 EACA 5A                    phy   
3066 EACB DA                    phx   
3067 EACC A2 02 20 22           _hlock 
3068 EAD3 90 03                 bcc   warm_open
3069 EAD5 4C 0B E5              jmp   time_to_die
3070 EAD8              warm_open  
3071 EAD8 AD 45 E0              lda   |file_list_hndl          ; dereference the file list handle
3072 EADB AE 47 E0              ldx   |file_list_hndl+2
3073 EADE 20 4D FE              jsr   deref_handle
3074 EAE1 85 2C                 sta   <file_list_ptr
3075 EAE3 84 2E                 sty   <file_list_ptr+2
3076 EAE5 18                    clc   
3077 EAE6 60                    rts   
3078 EAE7
3079 EAE7              cold_open                               ; open /SYSTEM.DISK/SYSTEM/DRIVERS
3080 EAE7 22 A8 00 E1           _open d_open_list
3081 EAF1 60                    rts   
3082 EAF2
3083 EAF2              *****************************************************************
3084 EAF2              *
3085 EAF2              * The following routine closes the pathname passed in the
3086 EAF2              * close list.
3087 EAF2              *
3088 EAF2              *****************************************************************
3089 EAF2              do_my_close  
3090 EAF2                       longa on
3091 EAF2                       longi on
3092 EAF2
3093 EAF2 AF D0 01 E1           lda   >warm_cold_flag          ; is this a warm start?
3094 EAF6 F0 14                 beq   cold_close               ; no
3095 EAF8
3096 EAF8 AE 45 E0              ldx   |file_list_hndl          ; yes, unlock the file list handle
3097 EAFB AC 47 E0              ldy   |file_list_hndl+2
3098 EAFE 5A                    phy   
3099 EAFF DA                    phx   
3100 EB00 A2 02 22 22           _hunlock 
3101 EB07 90 0D                 bcc   warm_close
3102 EB09 4C 0B E5              jmp   time_to_die
3103 EB0C
3104 EB0C              cold_close                              ; close /SYSTEM.DISK/SYSTEM/DRIVERS
3105 EB0C 22 A8 00 E1           _close d_close_list
3106 EB16              warm_close  
3107 EB16 60                    rts   
3108 EB17
3109 EB17                       eject 
3110 EB17              *****************************************************************
3111 EB17              *
3112 EB17              * The following routines were implemented strictly for code
3113 EB17              * reduction.
3114 EB17              *
3115 EB17              *****************************************************************
3116 EB17              y_plus_6  
3117 EB17                       longi on
3118 EB17
3119 EB17 C8                    iny   
3120 EB18 C8                    iny   
3121 EB19              y_plus_4  
3122 EB19 C8                    iny   
3123 EB1A C8                    iny   
3124 EB1B C8                    iny   
3125 EB1C C8                    iny   
3126 EB1D 60                    rts   
3127 EB1E
3128 EB1E              y_minus_6  
3129 EB1E                       longi on
3130 EB1E
3131 EB1E 88                    dey   
3132 EB1F 88                    dey   
3133 EB20              y_minus_4  
3134 EB20 88                    dey   
3135 EB21 88                    dey   
3136 EB22 88                    dey   
3137 EB23 88                    dey   
3138 EB24 60                    rts   
3139 EB25
3140 EB25                       eject 
3141 EB25              ****************************************************************
3142 EB25              *
3143 EB25              * This routine is used to startup a loaded driver and check
3144 EB25              * that the driver is not a duplicate entry.  If a duplicate,
3145 EB25              * the device with the highest version number will be kept.
3146 EB25              * In the case of duplicate version number, the last loaded
3147 EB25              * device will be deleted.  Deletion of a device includes a
3148 EB25              * shutdown call to the driver prior to purging the driver.
3149 EB25              * Duplicate checking starts at one device below the currrent
3150 EB25              * device specified by DRVR_DEV_NUM and concludes with the
3151 EB25              * boot device.
3152 EB25              *
3153 EB25              * ENTRY: Call via 'JSR'
3154 EB25              *        drvr_dev_num = Device number of current device
3155 EB25              *               A Reg = Undefined
3156 EB25              *               X Reg = Undefined
3157 EB25              *               Y Reg = Undefined
3158 EB25              *               B Reg = Undefined
3159 EB25              *             Dir Reg = GSOS Direct Page
3160 EB25              *               P Reg = N V M X D I Z C  E
3161 EB25              *                       • • 0 0 0 • • •  0
3162 EB25              *
3163 EB25              * EXIT: via 'RTS'
3164 EB25              *               A Reg = Undefined
3165 EB25              *               X Reg = Undefined
3166 EB25              *               Y Reg = Undefined
3167 EB25              *               B Reg = Undefined
3168 EB25              *             Dir Reg = GSOS Direct Page
3169 EB25              *               P Reg = N V M X D I Z C  E
3170 EB25              *                       • • 0 0 0 • • 0  0  If device is not a duplicate
3171 EB25              *                       • • 0 0 0 • • 1  0  If device is a duplicate
3172 EB25              *
3173 EB25              ****************************************************************
3174 EB25              startup_l_drvr  
3175 EB25                       longa on
3176 EB25                       longi on
3177 EB25              *
3178 EB25              * Insert the device number in the DIB for startup.
3179 EB25              *
3180 EB25 A0 3E 00              ldy   #dib_dev_num
3181 EB28 A5 00                 lda   <drvr_dev_num
3182 EB2A 97 20                 sta   [<drvr_dib_ptr],y
3183 EB2C 8D 85 E0              sta   |cur_dev_num             ; needed in case startup fails
3184 EB2F              *
3185 EB2F              * Issue a startup call to the device.  If it cant start then
3186 EB2F              * the DIB contents are not valid and the device should be purged.
3187 EB2F              *
3188 EB2F 64 02                 stz   <drvr_call_num
3189 EB31 22 00 FC 01           jsl   dev_dispatcher           ; issue startup call to device
3190 EB35 90 0D                 bcc   dup_chk                  ; if startup succeeded check for dups
3191 EB37 60                    rts   
3192 EB38
3193 EB38              dup_chk_done  
3194 EB38 EE B9 E0              inc   |purge_flag              ; started successfully
3195 EB3B AD 85 E0              lda   |cur_dev_num             ; restore dib pointer to current device
3196 EB3E 85 00                 sta   <drvr_dev_num
3197 EB40 20 5B E7              jsr   set_dib_ptr
3198 EB43 60                    rts   
3199 EB44              *
3200 EB44              * This routine will check for duplicate devices.  A check by slot and unit
3201 EB44              * is attempted first.  If the slot & unit are unique, the name is checked to
3202 EB44              * verify that it is unique.  If either the slot & unit or the name is detected
3203 EB44              * as a duplicate then the version number is checked.  The lowest version
3204 EB44              * device (or last loaded if version numbers match) is shutdown and purged.
3205 EB44              *
3206 EB44              dup_chk   
3207 EB44 20 FF EB              jsr   copy_cur_name            ; copy current DIB info for dup check
3208 EB47 18                    clc   
3209 EB48              dup_chk_loop  
3210 EB48 C6 00                 dec   <drvr_dev_num            ; point at previous device
3211 EB4A F0 EC                 beq   dup_chk_done             ; if no more devices
3212 EB4C 20 5B E7              jsr   set_dib_ptr              ; point at dup check dib
3213 EB4F 20 CA EB              jsr   slot_unit_chk            ; check for dup slot & unit
3214 EB52 B0 05                 bcs   found_dup                ; if a duplicate was found
3215 EB54 20 E6 EB              jsr   name_chk                 ; check for dup name
3216 EB57 90 EF                 bcc   dup_chk_loop             ; if not a duplicate
3217 EB59
3218 EB59                       eject 
3219 EB59              *
3220 EB59              * A duplicate was detected.  Determine which device is the lower version
3221 EB59              * or last loaded and shutdown that device.  If device that was shutdown
3222 EB59              * was the first loaded then copy the current device list entry to the
3223 EB59              * position of the device that was shutdown.  Update the device count to
3224 EB59              * reflect the fact that a device was shutdown and purged.
3225 EB59              *
3226 EB59              found_dup  
3227 EB59                       longa on
3228 EB59                       longi on
3229 EB59
3230 EB59 A0 32 00              ldy   #ver_num                 ; determine lowest version
3231 EB5C B7 20                 lda   [<drvr_dib_ptr],y
3232 EB5E CD AB E0              cmp   |current_version
3233 EB61 B0 5A                 bge   keep_first               ; if first is highest or same, keep it
3234 EB63              *
3235 EB63              * Last loaded is a higher version number.  Shutdown the first loaded
3236 EB63              * duplicate and purge it.  Then copy the device list entry from the
3237 EB63              * last loaded device to the first loaded device's position.
3238 EB63              *
3239 EB63 A5 00                 lda   <drvr_dev_num            ; REV. 0.09a02
3240 EB65 8D 83 E0              sta   |old_dev_num
3241 EB68 3A                    dec   a                        ; are we replacing device #1 (possibly Boot.Driver)?
3242 EB69 D0 14                 bne   @not_boot_driver         ; no...
3243 EB6B A0 0A 00              ldy   #10                      ;offset to device #1 UserID in device list
3244 EB6E B7 24                 lda   [<drvr_dev_ptr],y
3245 EB70 C5 6A                 cmp   <boot_user_id            ; is it the Boot.Driver?
3246 EB72 D0 0B                 bne   @not_boot_driver         ; no, shutdown normally
3247 EB74
3248 EB74 A9 08 00              lda   #drvr_shutdn             ; else issue a shutdown call to the driver
3249 EB77 85 02                 sta   <drvr_call_num           ; but don't purge it from memory
3250 EB79 22 00 FC 01           jsl   dev_dispatcher
3251 EB7D 80 03                 bra   @unlink_driver           ; then replace the entry with the new entry
3252 EB7F
3253 EB7F              @not_boot_driver  
3254 EB7F 20 E0 F1              jsr   shutdn_driver            ; else shutdown & purge the first one
3255 EB82              @unlink_driver  
3256 EB82 EE B9 E0              inc   |purge_flag              ; started successfully
3257 EB85 20 24 E2              jsr   set_dev_index            ; now need device list index
3258 EB88 5A                    phy   
3259 EB89 AD 85 E0              lda   |cur_dev_num
3260 EB8C 85 00                 sta   <drvr_dev_num
3261 EB8E 20 24 E2              jsr   set_dev_index
3262 EB91
3263 EB91 A9 04 00              lda   #$0004                   ; words to relocate
3264 EB94 8F FA B9 00           sta   >post_index
3265 EB98              copy_dev_entry  
3266 EB98 B7 24                 lda   [<drvr_dev_ptr],y
3267 EB9A C8                    iny   
3268 EB9B C8                    iny   
3269 EB9C BB                    tyx                            ; save source pointer
3270 EB9D 7A                    ply                            ; get destination pointer
3271 EB9E 97 24                 sta   [<drvr_dev_ptr],y
3272 EBA0 C8                    iny   
3273 EBA1 C8                    iny   
3274 EBA2 5A                    phy                            ; save destination pointer
3275 EBA3 9B                    txy                            ; get source pointer
3276 EBA4 AF FA B9 00           lda   >post_index
3277 EBA8 3A                    dec   a
3278 EBA9 8F FA B9 00           sta   >post_index
3279 EBAD D0 E9                 bne   copy_dev_entry
3280 EBAF 7A                    ply   
3281 EBB0 20 5B E7              jsr   set_dib_ptr              ; point at the DIB that was kept
3282 EBB3 A0 3E 00              ldy   #dib_dev_num             ; V0.09a02 update DIB_DEV_NUM
3283 EBB6 AD 83 E0              lda   |old_dev_num
3284 EBB9 97 20                 sta   [<drvr_dib_ptr],y
3285 EBBB 80 0B                 bra   dup_all_gone
3286 EBBD              *
3287 EBBD              * First loaded was the higher version so shutdown and purge the last
3288 EBBD              * loaded.
3289 EBBD              *
3290 EBBD              keep_first  
3291 EBBD AD 85 E0              lda   |cur_dev_num             ; set device # for last loaded
3292 EBC0 85 00                 sta   <drvr_dev_num
3293 EBC2 20 E0 F1              jsr   shutdn_driver            ; shutdown & purge the driver
3294 EBC5 20 5B E7              jsr   set_dib_ptr              ; point at the DIB that was kept
3295 EBC8              dup_all_gone  
3296 EBC8 38                    sec   
3297 EBC9 60                    rts   
3298 EBCA
3299 EBCA                       eject 
3300 EBCA              ****************************************************************
3301 EBCA              *
3302 EBCA              * This routine checks to see that the slot & unit in the
3303 EBCA              * active DIB are not duplicates of the slot & unit contained
3304 EBCA              * in the current slot & unit images.
3305 EBCA              *
3306 EBCA              * ENTRY: Call via 'JSR'
3307 EBCA              *        drvr_dev_num = Device number of current device
3308 EBCA              *        drvr_dib_ptr = Points to DIB for current device
3309 EBCA              *        current_slot = Slot being checked
3310 EBCA              *        current_unit = Unit being checked
3311 EBCA              *               A Reg = Undefined
3312 EBCA              *               X Reg = Undefined
3313 EBCA              *               Y Reg = Undefined
3314 EBCA              *               B Reg = Undefined
3315 EBCA              *             Dir Reg = GSOS Direct Page
3316 EBCA              *               P Reg = N V M X D I Z C  E
3317 EBCA              *                       • • 0 0 0 • • •  0
3318 EBCA              *
3319 EBCA              * EXIT: via 'RTS'
3320 EBCA              *               A Reg = Undefined
3321 EBCA              *               X Reg = Undefined
3322 EBCA              *               Y Reg = Undefined
3323 EBCA              *               B Reg = Undefined
3324 EBCA              *             Dir Reg = GSOS Direct Page
3325 EBCA              *               P Reg = N V M X D I Z C  E
3326 EBCA              *                       • • 0 0 0 • • 0  0  If device is not a duplicate
3327 EBCA              *                       • • 0 0 0 • • 1  0  If device is a duplicate
3328 EBCA              *
3329 EBCA              ****************************************************************
3330 EBCA              slot_unit_chk  
3331 EBCA                       longa on
3332 EBCA                       longi on
3333 EBCA
3334 EBCA A0 2E 00              ldy   #slot_num                ; point at slot in DIB
3335 EBCD B7 20                 lda   [<drvr_dib_ptr],y
3336 EBCF 30 13                 bmi   not_a_dup                ; "hardware independent" bit is set
3337 EBD1 29 0F 00              and   #$000F
3338 EBD4 CD A7 E0              cmp   |current_slot            ; check slot against current
3339 EBD7 D0 0B                 bne   not_a_dup                ; if slot unique
3340 EBD9
3341 EBD9 C8                    iny                            ; else prepare to check unit
3342 EBDA C8                    iny   
3343 EBDB B7 20                 lda   [<drvr_dib_ptr],y
3344 EBDD CD A9 E0              cmp   |current_unit            ; check unit against current
3345 EBE0 D0 02                 bne   not_a_dup                ; if unit unique
3346 EBE2
3347 EBE2              its_a_dup  
3348 EBE2 38                    sec   
3349 EBE3 60                    rts   
3350 EBE4
3351 EBE4              not_a_dup  
3352 EBE4 18                    clc   
3353 EBE5 60                    rts   
3354 EBE6
3355 EBE6                       eject 
3356 EBE6              ****************************************************************
3357 EBE6              *
3358 EBE6              * This routine checks the name of the active DIB against the
3359 EBE6              * name in the current name image.
3360 EBE6              *
3361 EBE6              * ENTRY: Call via 'JSR'
3362 EBE6              *        drvr_dev_num = Device number of current device
3363 EBE6              *        drvr_dib_ptr = Points to DIB for current device
3364 EBE6              *        current_name = Name being checked
3365 EBE6              *               A Reg = Undefined
3366 EBE6              *               X Reg = Undefined
3367 EBE6              *               Y Reg = Undefined
3368 EBE6              *               B Reg = Undefined
3369 EBE6              *             Dir Reg = GSOS Direct Page
3370 EBE6              *               P Reg = N V M X D I Z C  E
3371 EBE6              *                       • • 0 0 0 • • •  0
3372 EBE6              *
3373 EBE6              * EXIT: via 'RTS'
3374 EBE6              *               A Reg = Undefined
3375 EBE6              *               X Reg = Undefined
3376 EBE6              *               Y Reg = Undefined
3377 EBE6              *               B Reg = Undefined
3378 EBE6              *             Dir Reg = GSOS Direct Page
3379 EBE6              *               P Reg = N V M X D I Z C  E
3380 EBE6              *                       • • 0 0 0 • • 0  0  If device is not a duplicate
3381 EBE6              *                       • • 0 0 0 • • 1  0  If device is a duplicate
3382 EBE6              *
3383 EBE6              ****************************************************************
3384 EBE6              name_chk  
3385 EBE6                       longa on
3386 EBE6                       longi on
3387 EBE6
3388 EBE6 E2 30                 sep   #$30                     ; 8 bit 'm' & 'x'
3389 EBE8                       longa off
3390 EBE8                       longi off
3391 EBE8
3392 EBE8 A0 0E                 ldy   #dev_name                ; point at name in DIB
3393 EBEA AE 87 E0              ldx   |current_name            ; get length of current name
3394 EBED              chk_dev_name  
3395 EBED B7 20                 lda   [<drvr_dib_ptr],y
3396 EBEF D9 79 E0              cmp   |current_name-dev_name,y
3397 EBF2 D0 07                 bne   not_dup_name
3398 EBF4 C8                    iny                            ; scan until no match or end of string
3399 EBF5 CA                    dex   
3400 EBF6 10 F5                 bpl   chk_dev_name
3401 EBF8
3402 EBF8 38                    sec                            ; if reached end of string then DUPE!
3403 EBF9 B0 01                 bcs   name_chk_done
3404 EBFB
3405 EBFB              not_dup_name  
3406 EBFB 18                    clc   
3407 EBFC
3408 EBFC              name_chk_done  
3409 EBFC C2 30                 rep   #$30                     ; 16 bit 'm' & 'x'
3410 EBFE                       longa on
3411 EBFE                       longi on
3412 EBFE
3413 EBFE 60                    rts   
3414 EBFF
3415 EBFF                       eject 
3416 EBFF              *****************************************************************
3417 EBFF              *
3418 EBFF              * This routine copies the name of the device specified by the
3419 EBFF              * current DIB pointer in preperation for checking for a duplicate
3420 EBFF              * device name.  The slot, unit, device ID and version number are
3421 EBFF              * also copied.
3422 EBFF              *
3423 EBFF              * ENTRY: via a 'JSR'
3424 EBFF              *       <drvr_dib_ptr = Points to DIB for current <drvr_dev_num
3425 EBFF              *               A Reg = Unspecified
3426 EBFF              *               X Reg = Unspecified
3427 EBFF              *               Y Reg = Unspecified
3428 EBFF              *               B Reg = Same as execution bank
3429 EBFF              *             Dir Reg = GS/OS Direct Page
3430 EBFF              *               P Reg = N V M X D I Z C  E
3431 EBFF              *                       • • 0 0 0 • • •  0
3432 EBFF              *
3433 EBFF              * EXIT: via an 'RTS'
3434 EBFF              *       |current_name = device name extracted from DIB
3435 EBFF              *
3436 EBFF              *               A Reg = Unspecified
3437 EBFF              *               X Reg = Unspecified
3438 EBFF              *               Y Reg = Unspecified
3439 EBFF              *               B Reg = Unchanged
3440 EBFF              *             Dir Reg = GS/OS Direct Page
3441 EBFF              *               P Reg = N V M X D I Z C  E
3442 EBFF              *                       • • 0 0 0 • • 0  0
3443 EBFF              *
3444 EBFF              *****************************************************************
3445 EBFF              copy_cur_name  
3446 EBFF                       longa on
3447 EBFF                       longi on
3448 EBFF
3449 EBFF A5 00                 lda   <drvr_dev_num
3450 EC01 8D 85 E0              sta   |cur_dev_num
3451 EC04
3452 EC04 E2 30                 sep   #$30                     ; 8 bit 'm' & 'x'
3453 EC06                       longa off
3454 EC06                       longi off
3455 EC06
3456 EC06 A0 0E                 ldy   #dev_name
3457 EC08              copy_dev_name  
3458 EC08 B7 20                 lda   [<drvr_dib_ptr],y
3459 EC0A 99 79 E0              sta   |current_name-dev_name,y
3460 EC0D C8                    iny   
3461 EC0E C0 36                 cpy   #head_link
3462 EC10 D0 F6                 bne   copy_dev_name
3463 EC12
3464 EC12              ;	stz	|current_slot+1
3465 EC12
3466 EC12 C2 30                 rep   #$30                     ; 16 bit 'm' & 'x'
3467 EC14                       longa on
3468 EC14                       longi on
3469 EC14
3470 EC14 60                    rts   
3471 EC15
3472 EC15                       eject 
3473 EC15              ***************************************************************
3474 EC15              *
3475 EC15              * This routine is used to generate drivers for existing slot
3476 EC15              * resident firmware interfaces.  As each slot is identified,
3477 EC15              * the slot is compared to existing loaded drivers in the device
3478 EC15              * list.  If a driver is found for the current slot, no driver
3479 EC15              * will be generated for that slot.  If a driver is generated,
3480 EC15              * a DRVR_STARTUP call will be issued to the driver.  If the
3481 EC15              * driver returns an error, the driver will be purged from
3482 EC15              * the device list.
3483 EC15              *
3484 EC15              * ENTRY:        A Reg = Unspecified
3485 EC15              *               X Reg = Unspecified
3486 EC15              *               Y Reg = Unspecified
3487 EC15              *               B Reg = Current execution bank
3488 EC15              *             Dir Reg = GS/OS Direct Page
3489 EC15              *               P Reg = N V M X D I Z C  E
3490 EC15              *                       • • 0 0 0 • • •  0
3491 EC15              *        drvr_dev_num = device number of 1st generated driver
3492 EC15              *
3493 EC15              * EXIT:         A Reg = Unspecified
3494 EC15              *               X Reg = Unspecified
3495 EC15              *               Y Reg = Unspecified
3496 EC15              *               B Reg = Current execution bank
3497 EC15              *             Dir Reg = GS/OS Direct Page
3498 EC15              *               P Reg = N V M X D I Z C  E
3499 EC15              *                       • • 0 0 0 • • •  0
3500 EC15              *
3501 EC15              ***************************************************************
3502 EC15              gen_drivers  
3503 EC15                       longa on
3504 EC15                       longi on
3505 EC15
3506 EC15 20 76 E5              jsr   deref_drv_list           ; set driver list pointer
3507 EC18 A2 00 00              ldx   #$0000
3508 EC1B 20 24 E2              jsr   set_dev_index            ; point into device list
3509 EC1E              dib_ptr_loop  
3510 EC1E A5 28                 lda   <gen_drvr_ptr            ; copy entry into device list
3511 EC20 97 24                 sta   [<drvr_dev_ptr],y
3512 EC22 C8                    iny   
3513 EC23 C8                    iny   
3514 EC24 A5 2A                 lda   <gen_drvr_ptr+2
3515 EC26 97 24                 sta   [<drvr_dev_ptr],y
3516 EC28 48                    pha   
3517 EC29 C8                    iny   
3518 EC2A C8                    iny   
3519 EC2B A9 00 00              lda   #$0000                   ; initialize driver disk switched flag
3520 EC2E 97 24                 sta   [<drvr_dev_ptr],y
3521 EC30 C8                    iny                            ; initialize driver User ID
3522 EC31 C8                    iny   
3523 EC32 97 24                 sta   [<drvr_dev_ptr],y
3524 EC34 C8                    iny                            ; point at next device list entry
3525 EC35 C8                    iny   
3526 EC36 A5 28                 lda   <gen_drvr_ptr            ; calculate next entry
3527 EC38 18                    clc   
3528 EC39 69 4C 00              adc   #dib_size                ; 66 bytes per DIB
3529 EC3C 85 28                 sta   <gen_drvr_ptr
3530 EC3E 68                    pla   
3531 EC3F 69 00 00              adc   #$0000
3532 EC42 85 2A                 sta   <gen_drvr_ptr+2
3533 EC44 E8                    inx   
3534 EC45 EC 61 E0              cpx   |total_gen
3535 EC48 D0 D4                 bne   dib_ptr_loop
3536 EC4A 20 76 E5              jsr   deref_drv_list           ; restore driver list pointer
3537 EC4D              *
3538 EC4D              * Copy default DIB/GDIB to generated driver list
3539 EC4D              *
3540 EC4D AC 59 E0              ldy   |drvr_list_size          ; number bytes to move -2 (last word)
3541 EC50 88                    dey   
3542 EC51 88                    dey   
3543 EC52              reset_src_addr  
3544 EC52 A2 1F E1              ldx   #boot_dib+74             ; Source address
3545 EC55              first_dib  
3546 EC55 BD 00 00              lda   |0,x                     ; copy default DIB/GDIB
3547 EC58 97 28                 sta   [<gen_drvr_ptr],y
3548 EC5A CA                    dex                            ; next source address
3549 EC5B CA                    dex   
3550 EC5C E0 D3 E0              cpx   #boot_dib-2
3551 EC5F D0 03                 bne   src_addr_ok              ; if haven't copied entire source
3552 EC61 A2 1F E1              ldx   #boot_dib+74             ; Reset pointer to source address
3553 EC64              src_addr_ok  
3554 EC64 88                    dey                            ; next destination address
3555 EC65 88                    dey   
3556 EC66 10 ED                 bpl   first_dib                ; 1 copy for each gen. driver
3557 EC68              *
3558 EC68              * Point at initial slot for proper device generation.
3559 EC68              *
3560 EC68 C2 30                 rep   #$30                     ; 16 bit 'm' & 'x'
3561 EC6A                       longa on
3562 EC6A                       longi on
3563 EC6A
3564 EC6A A9 0F 00              lda   #$000F                   ; initial slot is 15 (7 external)
3565 EC6D 8D 5F E0              sta   |gen_slot_num
3566 EC70 A9 02 00              lda   #$0002                   ; initialize generate counter
3567 EC73 8D 5D E0              sta   |gen_count
3568 EC76              *
3569 EC76              * While generating devices, always request that the slot be installed via
3570 EC76              * the slot arbiter.  This code was inserted in system disk 4.1.
3571 EC76              *
3572 EC76              gen_dib_loop  
3573 EC76 AD 5F E0              lda   |gen_slot_num            ; request slot from slot arbiter
3574 EC79 22 BC FC 01           jsl   dyn_slot_arbiter
3575 EC7D B0 27                 bcs   set_next_slot            ; point at next slot to generate a device for
3576 EC7F              *
3577 EC7F              * Ident_slot requires a pointer to the slot firmware.  The slot arbiter slot
3578 EC7F              * request is converted into a $00Cn00 address by limiting the slot address to 
3579 EC7F              * slots 0 through 7 (since only seven slots reside actively in the system).
3580 EC7F              *
3581 EC7F AD 5F E0              lda   |gen_slot_num            ; create a pointer to $Cn00 for current slot
3582 EC82 EB                    xba   
3583 EC83 29 00 07              and   #$0700
3584 EC86 09 00 C0              ora   #$C000
3585 EC89 85 28                 sta   <fw_addr
3586 EC8B 64 2A                 stz   <fw_addr+2
3587 EC8D              *
3588 EC8D              * Point at the DIB to be generated and identify the peripheral resident in the
3589 EC8D              * slot.  Note that if the peripheral exists, all DIB information will be
3590 EC8D              * constructed and placed into the current DIB data structure (the DIB pointed
3591 EC8D              * to by drvr_dib_ptr).
3592 EC8D              *
3593 EC8D 20 5B E7              jsr   set_dib_ptr              ; v0.01 a02 (init DIB ptr)
3594 EC90 20 5E E6              jsr   ident_slot               ; identify class of device
3595 EC93 F0 11                 beq   set_next_slot            ; if no devices this slot
3596 EC95              *
3597 EC95              * A peripheral exists in the current slot.  Go build a DIB for the peripheral
3598 EC95              * class that was detected in the slot.
3599 EC95              *
3600 EC95 A8                    tay                            ; save device count
3601 EC96 8A                    txa                            ; get driver peripheral class
3602 EC97 48                    pha   
3603 EC98 29 03 00              and   #$0003                   ; want peripheral class, not peripheral subclass
3604 EC9B 0A                    asl   a
3605 EC9C AA                    tax   
3606 EC9D 68                    pla   
3607 EC9E 08                    php                            ; save environment
3608 EC9F F4 A4 EC              pea   build_ret-1              ; return from build
3609 ECA2 7C F1 EC              jmp   (build_dib,x)            ; go build proper peripheral class of driver
3610 ECA5              build_ret  
3611 ECA5 28                    plp                            ; restore environment
3612 ECA6              set_next_slot  
3613 ECA6 CE 5F E0              dec   |gen_slot_num            ; point at next slot to generate a device for
3614 ECA9 D0 CB                 bne   gen_dib_loop             ; build more DIB's if not slot #0
3615 ECAB              *
3616 ECAB              * After completing generation of peripheral device DIB data structures, the
3617 ECAB              * device number is left at a value equal to the actual number of devices
3618 ECAB              * plus one.  Adjust the device count and install the device count into the
3619 ECAB              * device list before exiting back to the top level of the device dispatcher
3620 ECAB              * startup routine.
3621 ECAB              *
3622 ECAB C6 00                 dec   <drvr_dev_num            ; set number of devices
3623 ECAD A5 00                 lda   <drvr_dev_num
3624 ECAF 87 24                 sta   [<drvr_dev_ptr]
3625 ECB1 60                    rts   
3626 ECB2
3627 ECB2                       eject 
3628 ECB2              *****************************************************************
3629 ECB2              *
3630 ECB2              * This routine checks to see if a loaded driver is already
3631 ECB2              * installed for the current slot that at driver is being
3632 ECB2              * generated for.
3633 ECB2              *
3634 ECB2              * ENTRY: Call via a 'JSR'
3635 ECB2              *               A Reg = Undefined
3636 ECB2              *               X Reg = Undefined
3637 ECB2              *               Y Reg = Undefined
3638 ECB2              *            Bank Reg = Current Program Bank
3639 ECB2              *             Dir Reg = GS/OS Direct Page
3640 ECB2              *           Stack Reg = GS/OS Stack
3641 ECB2              *               P Reg = N V M X D I Z C  E
3642 ECB2              *                       • • 0 0 0 • • •  0
3643 ECB2              *
3644 ECB2              * EXIT:
3645 ECB2              *               A Reg = Undefined
3646 ECB2              *               X Reg = Undefined
3647 ECB2              *               Y Reg = Undefined
3648 ECB2              *            Bank Reg = Current Program Bank
3649 ECB2              *             Dir Reg = GS/OS Direct Page
3650 ECB2              *           Stack Reg = GS/OS Stack
3651 ECB2              *               P Reg = N V M X D I Z C  E
3652 ECB2              *                       • • 0 0 0 • • •  0
3653 ECB2              *
3654 ECB2              ***************************************************************
3655 ECB2              chk_dup_load  
3656 ECB2                       longa on
3657 ECB2                       longi on
3658 ECB2              *
3659 ECB2              * Move the current device name into a unique buffer
3660 ECB2              * and check against all other names.
3661 ECB2              *
3662 ECB2 48                    pha   
3663 ECB3 DA                    phx   
3664 ECB4 5A                    phy   
3665 ECB5
3666 ECB5 D4 2A                 pei   <fw_addr+2
3667 ECB7 D4 28                 pei   <fw_addr
3668 ECB9 D4 00                 pei   <drvr_dev_num
3669 ECBB
3670 ECBB 20 FF EB              jsr   copy_cur_name
3671 ECBE
3672 ECBE              check_name  
3673 ECBE C2 30                 rep   #$30                     ; 16 bit 'm' & 'x'
3674 ECC0                       longa on
3675 ECC0                       longi on
3676 ECC0
3677 ECC0 C6 00                 dec   <drvr_dev_num            ; point at previous device
3678 ECC2 D0 03                 bne   keep_checking
3679 ECC4 18                    clc   
3680 ECC5 80 08                 bra   check_done
3681 ECC7
3682 ECC7              keep_checking  
3683 ECC7 20 5B E7              jsr   set_dib_ptr              ; point at DIB under test
3684 ECCA 20 CA EB              jsr   slot_unit_chk            ; check for unique slot & unit
3685 ECCD 90 0D                 bcc   not_same_dev
3686 ECCF
3687 ECCF              check_done  
3688 ECCF 68                    pla                            ; restore device number
3689 ECD0 20 F4 FB              jsr   leave_dib_alone
3690 ECD3 68                    pla   
3691 ECD4 85 28                 sta   <fw_addr
3692 ECD6 68                    pla   
3693 ECD7 85 2A                 sta   <fw_addr+2
3694 ECD9 4C EC EF              jmp   pull_y_x_a
3695 ECDC
3696 ECDC                       eject 
3697 ECDC              *
3698 ECDC              * Slot, Unit & Device ID are not the same.  Check that the name is
3699 ECDC              * unique.  If not, modify the name and recheck until it is unique.
3700 ECDC              *
3701 ECDC              not_same_dev  
3702 ECDC                       longa on
3703 ECDC                       longi on
3704 ECDC
3705 ECDC 20 E6 EB              jsr   name_chk                 ; is this a duplicate name?
3706 ECDF 90 DD                 bcc   check_name               ; no
3707 ECE1
3708 ECE1 68                    pla                            ; reset to current device
3709 ECE2 48                    pha   
3710 ECE3 20 F4 FB              jsr   leave_dib_alone
3711 ECE6 EE 5D E0              inc   |gen_count               ; regenerate name with new #
3712 ECE9 20 CF F0              jsr   gen_name
3713 ECEC 20 FF EB              jsr   copy_cur_name            ; prepare to search for a duplicate
3714 ECEF 80 CD                 bra   check_name
3715 ECF1
3716 ECF1                       eject 
3717 ECF1              *****************************************************************
3718 ECF1              *
3719 ECF1              * Dispatch table for DIB construction.  Dispatch is based on
3720 ECF1              * class of driver being constructed.
3721 ECF1              *
3722 ECF1              * ENTRY:        A Reg = Driver Class & Subclass
3723 ECF1              *               X Reg = Driver Class
3724 ECF1              *               Y Reg = Number of devices in current slot
3725 ECF1              *               B Reg = Same as execution bank
3726 ECF1              *             Dir Reg = GS/OS Direct Page
3727 ECF1              *               P Reg = N V M X D I Z C  E
3728 ECF1              *                       • • 0 0 0 • • •  0
3729 ECF1              *
3730 ECF1              * EXIT:         A Reg =
3731 ECF1              *               X Reg =
3732 ECF1              *               Y Reg =
3733 ECF1              *               B Reg = Same as execution bank
3734 ECF1              *             Dir Reg = GS/OS Direct Page
3735 ECF1              *               P Reg = N V M X D I Z C  E
3736 ECF1              *                       • • 0 0 0 • • •  0
3737 ECF1              *
3738 ECF1              *****************************************************************
3739 ECF1 F7 EC        build_dib DC W:build_class0             ; vector for BASIC, Pascal1.1 & ProDOS
3740 ECF3 90 EE                 DC W:build_class1              ; vector for Standard SmartPort
3741 ECF5 90 EE                 DC W:build_class2              ; vector for Extended SmartPort
3742 ECF7
3743 ECF7              *
3744 ECF7              * Routine to build DIB/GDIB for class 0 drivers.
3745 ECF7              *
3746 ECF7              build_class0  
3747 ECF7                       longa on
3748 ECF7                       longi on
3749 ECF7
3750 ECF7 20 5B E7              jsr   set_dib_ptr              ; set DIB pointer current dev num
3751 ECFA A0 40 00              ldy   #drvr_class              ; set driver class
3752 ECFD 97 20                 sta   [<drvr_dib_ptr],y
3753 ECFF 29 80 00              and   #$0080                   ; BASIC or Pascal1.1?
3754 ED02 F0 03                 beq   build_prodos
3755 ED04 4C 15 EE              jmp   build_char
3756 ED07
3757 ED07                       eject 
3758 ED07              *
3759 ED07              * Device is a ProDOS block device if got here.
3760 ED07              * Default device characteristics apply as follows:
3761 ED07              *  ___ ___ ___ ___ ___ ___ ___ ___ ___ ___ ___ ___ ___ ___ ___ ___
3762 ED07              * |   |   |   |   |   |   |   |   |   |   |   |   |   |   |   |   |
3763 ED07              * | F | E | D | C | B | A | 9 | 8 | 7 | 6 | 5 | 4 | 3 | 2 | 1 | 0 |
3764 ED07              * |___|___|___|___|___|___|___|___|___|___|___|___|___|___|___|___|
3765 ED07              *   |   |   |   |   |   |   |   |   |   |   |   |   |   |   |___|__ Reserved
3766 ED07              *   |   |   |   |   |   |   |   |   |   |   |   |   |   |__________ Media remov
3767 ED07              *   |   |   |   |   |   |   |   |   |   |   |   |   |______________ Format
3768 ED07              *   |   |   |   |   |   |   |   |   |   |   |   |__________________ Driver follows guidelines
3769 ED07              *   |   |   |   |   |   |   |   |   |   |   |______________________ Read
3770 ED07              *   |   |   |   |   |   |   |   |   |   |__________________________ Write
3771 ED07              *   |   |   |   |   |   |   |   |   |______________________________ Block Dev
3772 ED07              *   |   |   |   |   |   |   |   |__________________________________ Speed Group
3773 ED07              *   |   |   |   |   |   |   |______________________________________ Speed Group
3774 ED07              *   |   |   |   |   |   |__________________________________________ Fixed Name
3775 ED07              *   |   |   |   |   |______________________________________________ Restartable
3776 ED07              *   |   |   |   |__________________________________________________ Device Busy
3777 ED07              *   |   |   |______________________________________________________ Linked
3778 ED07              *   |   |__________________________________________________________ Generated
3779 ED07              *   |______________________________________________________________ RamRom Disk
3780 ED07              *
3781 ED07 A9 01 00     build_prodos lda   #$0001               ; unit number
3782 ED0A 20 8F F0     next_prodos jsr   generate_slot         ; generate slot number
3783 ED0D              *
3784 ED0D              * Must set device characteristics based on contents
3785 ED0D              * of location $CnFE.
3786 ED0D              *  ___ ___ ___ ___ ___ ___ ___ ___
3787 ED0D              * |   |   |   |   |   |   |   |   |
3788 ED0D              * | 7 | 6 | 5 | 4 | 3 | 2 | 1 | 0 |
3789 ED0D              * |___|___|___|___|___|___|___|___|
3790 ED0D              *   |   |   |   |   |   |   |   |______  1 = Device status can be read
3791 ED0D              *   |   |   |   |   |   |   |__________  1 = Device can be read from
3792 ED0D              *   |   |   |   |   |   |______________  1 = Device can be written to
3793 ED0D              *   |   |   |   |   |__________________  1 = Device can be formatted
3794 ED0D              *   |   |   |___|______________________ nn = Number of volumes (0 - 3)
3795 ED0D              *   |   |______________________________  1 = Device is interruptable
3796 ED0D              *   |__________________________________  1 = Medium is removable
3797 ED0D              *
3798 ED0D 9C CD E0              stz   |pro_char
3799 ED10
3800 ED10 E2 30                 sep   #$30                     ; 8 bit 'm' & 'x'
3801 ED12                       longa off
3802 ED12                       longi off
3803 ED12
3804 ED12 64 28                 stz   <fw_addr
3805 ED14 A0 FE                 ldy   #$00FE                   ; get ProDOS characteristics
3806 ED16 B7 28                 lda   [<fw_addr],y
3807 ED18 48                    pha   
3808 ED19 29 08                 and   #%00001000               ; format bit
3809 ED1B 8D CD E0              sta   |pro_char
3810 ED1E 68                    pla   
3811 ED1F 2A                    rol   a                        ; convert remaining bits to GS/OS
3812 ED20 2A                    rol   a
3813 ED21 2A                    rol   a
3814 ED22 2A                    rol   a
3815 ED23 29 64                 and   #%01100100               ; read, write & removable bits
3816 ED25 0C CD E0              tsb   |pro_char
3817 ED28
3818 ED28              chk_done  
3819 ED28 C2 30                 rep   #$30                     ; 16 bit 'm' & 'x'
3820 ED2A                       longa on
3821 ED2A                       longi on
3822 ED2A
3823 ED2A AD CD E0              lda   |pro_char                ; generated, blockdev & speed group
3824 ED2D 09 80 43              ora   #%0100001110000000
3825 ED30 20 1B F1              jsr   set_dev_char             ; set device characteristics
3826 ED33 20 CF F0              jsr   gen_name                 ; generate device name 'DEVn'
3827 ED36 A9 00 00              lda   #$0000
3828 ED39 A0 40 00              ldy   #drvr_class              ; set driver class
3829 ED3C 97 20                 sta   [<drvr_dib_ptr],y
3830 ED3E              *
3831 ED3E              * Now need to know if device requires a status call
3832 ED3E              * in order to determine the total number of blocks
3833 ED3E              * on the media.
3834 ED3E              *
3835 ED3E A0 FC 00              ldy   #$00FC                   ; does device require status for size?
3836 ED41 B7 28                 lda   [<fw_addr],y
3837 ED43 D0 45                 bne   have_dev_size            ; no
3838 ED45              *
3839 ED45              * Device requires a status call to determine total
3840 ED45              * number of blocks.  Set <FW_ADDR to point to the
3841 ED45              * ProDOS device entry point = $Cn00 + ($CnFF) and
3842 ED45              * issue the status call to the device.
3843 ED45              *
3844 ED45 E2 20                 sep   #$20                     ; 8 bit 'm'
3845 ED47                       longa off
3846 ED47
3847 ED47 A0 FF 00              ldy   #$00FF                   ; set ProDOS entry point
3848 ED4A B7 28                 lda   [<fw_addr],y
3849 ED4C 85 28                 sta   <fw_addr
3850 ED4E
3851 ED4E C2 20                 rep   #$20                     ; 16 bit 'm'
3852 ED50                       longa on
3853 ED50
3854 ED50 AF 0F AC 00           lda   >call_list_ptr           ; get address where dispatch returns
3855 ED54 AA                    tax   
3856 ED55 A9 EA EA              lda   #$EAEA                   ; 'nop' 'nop'
3857 ED58 9F 00 00 00           sta   >0,x
3858 ED5C 9F 02 00 00           sta   >2,x
3859 ED60 9F 03 00 00           sta   >3,x
3860 ED64
3861 ED64 A0 30 00              ldy   #unit_num                ; create ProDOS Unit Number
3862 ED67 B7 20                 lda   [<drvr_dib_ptr],y
3863 ED69 3A                    dec   a
3864 ED6A 4A                    lsr   a                        ; carry is now unit number
3865 ED6B 08                    php   
3866 ED6C A0 2E 00              ldy   #slot_num
3867 ED6F B7 20                 lda   [<drvr_dib_ptr],y
3868 ED71 EB                    xba                            ; high byte is STATUS command
3869 ED72 0A                    asl   a
3870 ED73 0A                    asl   a
3871 ED74 0A                    asl   a
3872 ED75 0A                    asl   a
3873 ED76 0A                    asl   a
3874 ED77 28                    plp   
3875 ED78 6A                    ror   a
3876 ED79 8F 42 00 00           sta   >pcmd                    ; ProDOS command and unit number
3877 ED7D 22 C5 AD 00           jsl   b0_core                  ; execute class 0 status for size
3878 ED81 90 06                 bcc   have_c0_size             ; if status was successful
3879 ED83              *
3880 ED83              * Status may return WRPROT as an error.  In this case the size is
3881 ED83              * still available and the DIB should be built. (8-11-88 RBM).
3882 ED83              *
3883 ED83 C9 2B 00              cmp   #drvr_wr_prot            ; is it a WRPROT error?
3884 ED86 F0 01                 beq   have_c0_size             ; yes
3885 ED88 60                    rts                            ; else bomb out on this DIB
3886 ED89              *
3887 ED89              * On return from status call, the 16 bit native mode X
3888 ED89              * register contains the number of blocks on the ProDOS
3889 ED89              * block device.
3890 ED89              *
3891 ED89 8A           have_c0_size txa   
3892 ED8A A0 0A 00     have_dev_size ldy   #blk_cnt            ; set number of blocks in DIB
3893 ED8D 97 20                 sta   [<drvr_dib_ptr],y
3894 ED8F 48                    pha   
3895 ED90 A9 00 00              lda   #$0000
3896 ED93 C8                    iny   
3897 ED94 C8                    iny   
3898 ED95 97 20                 sta   [<drvr_dib_ptr],y
3899 ED97 A9 FF FF              lda   #$FFFF                   ; set cache priority
3900 ED9A A0 46 00              ldy   #cache_mask
3901 ED9D 97 20                 sta   [<drvr_dib_ptr],y
3902 ED9F 68                    pla   
3903 EDA0              *
3904 EDA0              * Now generate a device ID number based on the total
3905 EDA0              * block count (since we dont have any other method for
3906 EDA0              * ProDOS devices).
3907 EDA0              *
3908 EDA0 A2 02 00              ldx   #$0002                   ; ID number = ProFILE 10M
3909 EDA3 C9 00 4C              cmp   #19456                   ; is this a ProFILE 10M?
3910 EDA6 F0 11                 beq   set_dev_id               ; yes
3911 EDA8
3912 EDA8 C9 00 26              cmp   #9728                    ; is this a ProFILE 5M?
3913 EDAB D0 03                 bne   not_profile              ; no
3914 EDAD
3915 EDAD CA                    dex                            ; ID number = ProFILE 5M
3916 EDAE 80 09                 bra   set_dev_id
3917 EDB0
3918 EDB0 A2 14 00     not_profile ldx   #$0014                ; ID number = Generic Floppy
3919 EDB3 C9 40 06              cmp   #1600                    ; is the block count <= 1600 blocks?
3920 EDB6 90 01                 blt   set_dev_id               ; yes
3921 EDB8
3922 EDB8 CA                    dex                            ; ID number = Generic Hard Disk
3923 EDB9
3924 EDB9 20 15 F1     set_dev_id jsr   set_id_num             ; set device ID in DIB
3925 EDBC 20 20 F1              jsr   set_gen_ver              ; set driver version number in DIB
3926 EDBF              check_if_last  
3927 EDBF A0 2E 00              ldy   #slot_num                ; get current slot
3928 EDC2 B7 20                 lda   [<drvr_dib_ptr],y
3929 EDC4 29 0F 00              and   #$000F                   ; strip resource flags off
3930 EDC7 AA                    tax   
3931 EDC8 AF 11 AC 00           lda   >config_ram              ; get ProDOS configuration ram
3932 EDCC
3933 EDCC 6A           unit_counter ror   a                    ; get # ProDOS units into carry
3934 EDCD CA                    dex   
3935 EDCE 10 FC                 bpl   unit_counter
3936 EDD0 90 35                 bcc   prodos_done              ; if only 1 unit this slot
3937 EDD2
3938 EDD2 A0 30 00              ldy   #unit_num                ; done all ProDOS units?
3939 EDD5 A9 02 00              lda   #$0002                   ; max ProDOS unit number
3940 EDD8 D7 20                 cmp   [<drvr_dib_ptr],y
3941 EDDA F0 2B                 beq   prodos_done
3942 EDDC              *
3943 EDDC              * Some ProDOS block devices only support a single volume.
3944 EDDC              * Calls to unit 2 must be blocked on these cards.
3945 EDDC              *
3946 EDDC E2 20                 sep   #$20                     ; 8 bit 'm'
3947 EDDE                       longa off
3948 EDDE 64 28                 stz   <fw_addr
3949 EDE0 C2 20                 rep   #$20                     ; 16 bit 'm'
3950 EDE2                       longa on
3951 EDE2 A0 FE 00              ldy   #$00FE                   ; point at device characteristics
3952 EDE5 B7 28                 lda   [<fw_addr],y
3953 EDE7 29 10 00              and   #$0010                   ; any more devices?
3954 EDEA F0 1B                 beq   prodos_done              ; no
3955 EDEC
3956 EDEC A5 00                 lda   <drvr_dev_num            ; is this the boot unit?
3957 EDEE 3A                    dec   a
3958 EDEF F0 16                 beq   prodos_done              ; yes
3959 EDF1
3960 EDF1 A0 30 00              ldy   #unit_num                ; reset unit before checking dup boot
3961 EDF4 B7 20                 lda   [<drvr_dib_ptr],y
3962 EDF6 48                    pha                            ; save next unit
3963 EDF7 20 B2 EC              jsr   chk_dup_load             ; does a loaded driver already exist?
3964 EDFA B0 03                 bcs   dup_load_0               ; yes
3965 EDFC
3966 EDFC 20 73 F0              jsr   chk_dup_boot             ; check if device is same as boot
3967 EDFF
3968 EDFF 20 5B E7     dup_load_0 jsr   set_dib_ptr            ; point at DIB for next device
3969 EE02 68                    pla                            ; restore next unit
3970 EE03 1A                    inc   a
3971 EE04 4C 0A ED              jmp   next_prodos              ; more units to do
3972 EE07
3973 EE07 A5 00        prodos_done lda   <drvr_dev_num         ; **** CHANGE **** v0.28
3974 EE09 3A                    dec   a                        ; is this the boot unit?
3975 EE0A F0 08                 beq   dup_load_1               ; yes, dont check for dups
3976 EE0C
3977 EE0C 20 B2 EC              jsr   chk_dup_load             ; does a loaded driver already exist?
3978 EE0F B0 03                 bcs   dup_load_1               ; yes
3979 EE11
3980 EE11 20 73 F0              jsr   chk_dup_boot             ; check if device is same as boot
3981 EE14
3982 EE14 60           dup_load_1 rts   
3983 EE15
3984 EE15                       eject 
3985 EE15              *
3986 EE15              * Device is a BASIC or Pascal1.1 character device if got here.
3987 EE15              * Set the device characteristics as follows:
3988 EE15              *  ___ ___ ___ ___ ___ ___ ___ ___ ___ ___ ___ ___ ___ ___ ___ ___
3989 EE15              * |   |   |   |   |   |   |   |   |   |   |   |   |   |   |   |   |
3990 EE15              * | F | E | D | C | B | A | 9 | 8 | 7 | 6 | 5 | 4 | 3 | 2 | 1 | 0 |
3991 EE15              * |___|___|___|___|___|___|___|___|___|___|___|___|___|___|___|___|
3992 EE15              *   |   |   |   |   |   |   |   |   |   |   |   |   |   |   |___|__ Reserved
3993 EE15              *   |   |   |   |   |   |   |   |   |   |   |   |   |   |__________ Media remov
3994 EE15              *   |   |   |   |   |   |   |   |   |   |   |   |   |______________ Format
3995 EE15              *   |   |   |   |   |   |   |   |   |   |   |   |__________________ Driver follows guidelines
3996 EE15              *   |   |   |   |   |   |   |   |   |   |   |______________________ Read
3997 EE15              *   |   |   |   |   |   |   |   |   |   |__________________________ Write
3998 EE15              *   |   |   |   |   |   |   |   |   |______________________________ Block Dev
3999 EE15              *   |   |   |   |   |   |   |   |__________________________________ Speed Group
4000 EE15              *   |   |   |   |   |   |   |______________________________________ Speed Group
4001 EE15              *   |   |   |   |   |   |__________________________________________ Fixed Name
4002 EE15              *   |   |   |   |   |______________________________________________ Restartable
4003 EE15              *   |   |   |   |__________________________________________________ Device Busy
4004 EE15              *   |   |   |______________________________________________________ Linked
4005 EE15              *   |   |__________________________________________________________ Generated
4006 EE15              *   |______________________________________________________________ RamRom Disk
4007 EE15              *
4008 EE15 A9 60 43     build_char lda   #%0100001101100000
4009 EE18 20 1B F1              jsr   set_dev_char             ; set device characteristics
4010 EE1B A9 00 00              lda   #$0000                   ; no blocks on character device
4011 EE1E C8                    iny   
4012 EE1F C8                    iny   
4013 EE20 97 20                 sta   [<drvr_dib_ptr],y
4014 EE22 C8                    iny   
4015 EE23 C8                    iny   
4016 EE24 97 20                 sta   [<drvr_dib_ptr],y
4017 EE26 20 CF F0              jsr   gen_name                 ; generate device name 'Dn'
4018 EE29 A9 01 00              lda   #$0001                   ; unit number
4019 EE2C 20 8F F0              jsr   generate_slot            ; generate slot number
4020 EE2F              *
4021 EE2F              * Set the device ID number based on the driver's slot and
4022 EE2F              * battery ram parameters.  Internal slots 1, 2, 3 and 7 are
4023 EE2F              * special cased.  Internal slots 1 and 2 device ID's are
4024 EE2F              * based on battery ram configurations for these slots.
4025 EE2F              *
4026 EE2F A0 34 00              ldy   #dev_id_num              ; point at DIB device ID
4027 EE32 C9 01 00              cmp   #$0001                   ; is it internal slot 1?
4028 EE35 D0 20                 bne   id_not_slot1             ; no
4029 EE37
4030 EE37 3A                    dec   a
4031 EE38 48           id_slot1_2 pha                          ; space for result
4032 EE39 48                    pha                            ; parameter is 'Port1 Printer/Modem'
4033 EE3A A2 03 0C 22           _readbparm 
4034 EE41 A2 0B 00              ldx   #$000B                   ; assume ID = Printer
4035 EE44 68                    pla                            ; is ID a printer?
4036 EE45 F0 0B                 beq   have_char_id             ; yes
4037 EE47
4038 EE47 A2 09 00              ldx   #$0009                   ; assume ID = modem
4039 EE4A C9 01 00              cmp   #$0001                   ; no, is it a modem?
4040 EE4D F0 03                 beq   have_char_id             ; yes, go ID modem
4041 EE4F
4042 EE4F A2 18 00              ldx   #$0018                   ; not a modem or printer, set network generic
4043 EE52 20 15 F1     have_char_id jsr   set_id_num           ; now set ID number
4044 EE55 80 25                 bra   set_not_open             ; continue
4045 EE57
4046 EE57 C9 02 00     id_not_slot1 cmp   #$0002               ; is it internal slot 2?
4047 EE5A D0 05                 bne   id_not_slot2             ; no
4048 EE5C
4049 EE5C A9 0C 00              lda   #$000C
4050 EE5F 80 D7                 bra   id_slot1_2               ; continue
4051 EE61
4052 EE61 C9 03 00     id_not_slot2 cmp   #$0003               ; is it internal slot 3?
4053 EE64 D0 03                 bne   id_not_slot3             ; no
4054 EE66 38                    sec                            ; Dont generate a driver for slot 3
4055 EE67 80 26                 bra   dup_load_2
4056 EE69
4057 EE69 C9 07 00     id_not_slot3 cmp   #$0007               ; is it internal slot 7?
4058 EE6C D0 08                 bne   id_not_slot7             ; no
4059 EE6E A2 18 00              ldx   #$0018                   ; driver is a network
4060 EE71 20 15 F1              jsr   set_id_num               ; now set ID number
4061 EE74 80 06                 bra   set_not_open             ; continue
4062 EE76
4063 EE76              id_not_slot7  
4064 EE76 A2 16 00              ldx   #$0016                   ; driver is a generic character device
4065 EE79 20 15 F1              jsr   set_id_num               ; now set ID number
4066 EE7C              *
4067 EE7C              * Set device OPEN flag to 'Not Open'.
4068 EE7C              *
4069 EE7C              set_not_open  
4070 EE7C A0 46 00              ldy   #open_flag               ; set to not open
4071 EE7F A9 00 00              lda   #$0000
4072 EE82 97 20                 sta   [<drvr_dib_ptr],y
4073 EE84 20 20 F1              jsr   set_gen_ver              ; set driver version #
4074 EE87 20 B2 EC              jsr   chk_dup_load             ; does a loaded driver already exist?
4075 EE8A B0 03                 bcs   dup_load_2               ; yes
4076 EE8C 20 73 F0              jsr   chk_dup_boot             ; check if device is same as boot
4077 EE8F              dup_load_2  
4078 EE8F 60                    rts   
4079 EE90
4080 EE90                       eject 
4081 EE90              *
4082 EE90              * Device is a Standard SmartPort device if got here.
4083 EE90              * A status call to the device is required before the
4084 EE90              * device characteristics word can be set.  The default
4085 EE90              * device characteristics for a SmartPort device is as follows:
4086 EE90              *  ___ ___ ___ ___ ___ ___ ___ ___ ___ ___ ___ ___ ___ ___ ___ ___
4087 EE90              * |   |   |   |   |   |   |   |   |   |   |   |   |   |   |   |   |
4088 EE90              * | F | E | D | C | B | A | 9 | 8 | 7 | 6 | 5 | 4 | 3 | 2 | 1 | 0 |
4089 EE90              * |___|___|___|___|___|___|___|___|___|___|___|___|___|___|___|___|
4090 EE90              *   |   |   |   |   |   |   |   |   |   |   |   |   |   |   |___|__ Reserved
4091 EE90              *   |   |   |   |   |   |   |   |   |   |   |   |   |   |__________ Media remov
4092 EE90              *   |   |   |   |   |   |   |   |   |   |   |   |   |______________ Format
4093 EE90              *   |   |   |   |   |   |   |   |   |   |   |   |__________________ Driver follows guidelines
4094 EE90              *   |   |   |   |   |   |   |   |   |   |   |______________________ Read
4095 EE90              *   |   |   |   |   |   |   |   |   |   |__________________________ Write
4096 EE90              *   |   |   |   |   |   |   |   |   |______________________________ Block Dev
4097 EE90              *   |   |   |   |   |   |   |   |__________________________________ Speed Group
4098 EE90              *   |   |   |   |   |   |   |______________________________________ Speed Group
4099 EE90              *   |   |   |   |   |___|__________________________________________ Reserved
4100 EE90              *   |   |   |   |__________________________________________________ Device Busy
4101 EE90              *   |   |   |______________________________________________________ Linked
4102 EE90              *   |   |__________________________________________________________ Generated
4103 EE90              *   |______________________________________________________________ RamRom Disk
4104 EE90              *
4105 EE90              * The device characteristics word will be substantially modified
4106 EE90              * for a SmartPort character device.
4107 EE90              *
4108 EE90              build_class1  
4109 EE90                       longa on
4110 EE90                       longi on
4111 EE90
4112 EE90              *
4113 EE90              * Device may be an Extended SmartPort device if got here.
4114 EE90              * A status call to the device is required to determine if
4115 EE90              * the device as well as the firmware interface supports the
4116 EE90              * extended SmartPort device protocol.  If not, the device
4117 EE90              * class will be modified to a class 1 device.  All other
4118 EE90              * DIB/GDIB setup is identical to the class 1 device.
4119 EE90              *
4120 EE90 A9 01 00     build_class2 lda   #$0001               ; unit number
4121 EE93 8D F9 E1              sta   |x_unit                  ; init hardware unit number
4122 EE96              class2_loop  
4123 EE96 20 5B E7              jsr   set_dib_ptr              ; set DIB pointer current dev num
4124 EE99 5A                    phy                            ; Number of devices this slot
4125 EE9A DA                    phx                            ; initial class (needs verified)
4126 EE9B 48                    pha                            ; unit number
4127 EE9C A0 40 00              ldy   #drvr_class              ; set driver class
4128 EE9F 8A                    txa   
4129 EEA0 97 20                 sta   [<drvr_dib_ptr],y
4130 EEA2 A9 FF FF              lda   #$FFFF                   ; set cache priority
4131 EEA5 A0 46 00              ldy   #cache_mask
4132 EEA8 97 20                 sta   [<drvr_dib_ptr],y
4133 EEAA 68                    pla                            ; unit number
4134 EEAB 48                    pha   
4135 EEAC 08                    php   
4136 EEAD 20 8F F0              jsr   generate_slot            ; generate slot number
4137 EEB0 20 1B E7              jsr   setup_sp_stat            ; setup bank0 core for status call
4138 EEB3 28                    plp   
4139 EEB4 68                    pla                            ; need device unit number in parmlist
4140 EEB5 A2 1D AC              ldx   #param_list_ptr          ; pointer to parameter list
4141 EEB8
4142 EEB8 E2 20                 sep   #$20                     ; 8 bit 'm'
4143 EEBA                       longa off
4144 EEBA
4145 EEBA 9F 01 00 00           sta   >1,x                     ; set unit number in parameter list
4146 EEBE A9 03                 lda   #$03                     ; status code = DIB status = $03
4147 EEC0 9F 04 00 00           sta   >4,x
4148 EEC4
4149 EEC4 C2 20                 rep   #$20                     ; 16 bit 'm'
4150 EEC6                       longa on
4151 EEC6
4152 EEC6 22 C5 AD 00           jsl   b0_core                  ; execute device status call
4153 EECA A0 0A 00              ldy   #blk_cnt                 ; set number of blocks
4154 EECD AF 01 AA 00           lda   >sys_buffer+1
4155 EED1 97 20                 sta   [<drvr_dib_ptr],y
4156 EED3 C8                    iny   
4157 EED4 C8                    iny   
4158 EED5 AF 03 AA 00           lda   >sys_buffer+3
4159 EED9 29 FF 00              and   #$00FF
4160 EEDC 97 20                 sta   [<drvr_dib_ptr],y
4161 EEDE AF 00 AA 00           lda   >sys_buffer              ; get device general status byte
4162 EEE2 29 E8 00              and   #$00E8                   ; mask unused bits
4163 EEE5 09 00 43              ora   #$4300                   ; mark device as generated
4164 EEE8
4165 EEE8 E2 10                 sep   #$10                     ; 8 bit 'x'
4166 EEEA                       longi off
4167 EEEA
4168 EEEA 18                    clc                            ; assume not a Ram or Rom Disk
4169 EEEB 48                    pha   
4170 EEEC AF 16 AA 00           lda   >sys_buffer+$16          ; get device subtype
4171 EEF0 29 20 00              and   #%00100000               ; want media removable bit
4172 EEF3 49 20 00              eor   #%00100000
4173 EEF6 4A                    lsr   a
4174 EEF7 4A                    lsr   a
4175 EEF8 4A                    lsr   a
4176 EEF9 03 01                 ora   1,s                      ; place media romovable into dev_char
4177 EEFB 83 01                 sta   1,s
4178 EEFD AF 15 AA 00           lda   >sys_buffer+$15          ; get device type byte
4179 EF01 0A                    asl   a                        ; Extended to carry, keep type * 2
4180 EF02 A8                    tay                            ; Y = SmartPort device type * 2
4181 EF03 68                    pla   
4182 EF04 BB                    tyx                            ; X = SmartPort device type * 2
4183 EF05 D0 09                 bne   not_ram_disk
4184 EF07              ram_rom_disk  
4185 EF07 09 00 80              ora   #$8000                   ; set Ram/Rom Disk
4186 EF0A 29 F8 FF              and   #$FFF8                   ; Ram/Rom Disk not removable
4187 EF0D 38                    sec   
4188 EF0E 80 05                 bra   have_dev_char
4189 EF10              not_ram_disk  
4190 EF10 E0 08                 cpx   #$08                     ; is it a Ram Disk?
4191 EF12 F0 F3                 beq   ram_rom_disk             ; yes
4192 EF14 18                    clc   
4193 EF15              have_dev_char  
4194 EF15 C2 10                 rep   #$10                     ; 16 bit 'x'
4195 EF17                       longi on
4196 EF17
4197 EF17 20 1B F1              jsr   set_dev_char             ; set device characteristics
4198 EF1A B0 05                 bcs   disable_cache            ; dont modify mask if not a Ram or Rom Disk
4199 EF1C
4200 EF1C E0 02 00              cpx   #$0002                   ; is this an AppleDisk3.5?
4201 EF1F D0 08                 bne   cache_mask_ok            ; no
4202 EF21              disable_cache  
4203 EF21 A0 46 00              ldy   #cache_mask              ; no cache for Ram or Rom disk
4204 EF24 A9 00 00              lda   #$0000                   ; cache mask of zero disable caching for the device
4205 EF27 97 20                 sta   [<drvr_dib_ptr],y
4206 EF29              cache_mask_ok  
4207 EF29 A9 14 00              lda   #$0014                   ; assume a generic floppy disk
4208 EF2C E0 21 00              cpx   #$0021                   ; is it a known SmartPort id? (SmartPort Type * 2 +1)
4209 EF2F B0 03                 bge   have_sp_trans            ; no, use assumed ID
4210 EF31
4211 EF31 BD 13 E0              lda   |sp_trans_id,x           ; set device id number
4212 EF34              have_sp_trans  
4213 EF34 A0 34 00              ldy   #dev_id_num
4214 EF37 97 20                 sta   [<drvr_dib_ptr],y
4215 EF39 A0 42 00              ldy   #drvr_type               ; set GDIB type
4216 EF3C AF 15 AA 00           lda   >sys_buffer+$15
4217 EF40 48                    pha   
4218 EF41 29 FF 00              and   #$00FF
4219 EF44 97 20                 sta   [<drvr_dib_ptr],y
4220 EF46 68                    pla                            ; set GDIB subtype
4221 EF47 EB                    xba   
4222 EF48 29 FF 00              and   #$00FF
4223 EF4B C8                    iny   
4224 EF4C C8                    iny   
4225 EF4D 97 20                 sta   [<drvr_dib_ptr],y
4226 EF4F
4227 EF4F E2 20                 sep   #$20                     ; 8 bit 'm'
4228 EF51                       longa off
4229 EF51
4230 EF51 0A                    asl   a                        ; extended flag to carry
4231 EF52
4232 EF52 C2 20                 rep   #$20                     ; 16 bit 'm'
4233 EF54                       longa on
4234 EF54              *
4235 EF54              * Both the interface and the device itself must indicate that
4236 EF54              * extended calls are supported in order to have the device
4237 EF54              * installed as a class 2 (Extended SmartPort) device.
4238 EF54              *
4239 EF54 A0 40 00              ldy   #drvr_class
4240 EF57 B7 20                 lda   [<drvr_dib_ptr],y
4241 EF59 B0 08                 bcs   class_is_ok              ; if device is extended, dont mod class
4242 EF5B C9 02 00              cmp   #$0002                   ; is driver extended?
4243 EF5E D0 03                 bne   class_is_ok              ; no
4244 EF60 3A                    dec   a                        ; yes, must make it nonextended
4245 EF61 97 20                 sta   [<drvr_dib_ptr],y
4246 EF63              class_is_ok  
4247 EF63 AF 17 AA 00           lda   >sys_buffer+$17          ; set version number
4248 EF67 A0 32 00              ldy   #ver_num
4249 EF6A 97 20                 sta   [<drvr_dib_ptr],y
4250 EF6C              *
4251 EF6C              * Early versions of the SCSI Interface Card Firmware do not
4252 EF6C              * operate properly when using the Extended SmartPort interface
4253 EF6C              * with Interrupts running.  Any SCSI card with a firmware
4254 EF6C              * version number less than 2 will be installed as a class 1
4255 EF6C              * device thereby limiting the device to standard SmartPort calls.
4256 EF6C              *  ___ ___ ___ ___ ___ ___ ___ ___
4257 EF6C              * |   |   |   |   |   |   |   |   |
4258 EF6C              * | 7 | 6 | 5 | 4 | 3 | 2 | 1 | 0 |     SmartPort Type ID $CnFB
4259 EF6C              * |___|___|___|___|___|___|___|___|
4260 EF6C              *   |   |   |   |   |   |   |   |__ 0 = RAM CARD
4261 EF6C              *   |   |   |   |   |   |   |______ 1 = SCSI
4262 EF6C              *   |   |   |___|___|___|__________ 0 = RESERVED
4263 EF6C              *   |   |__________________________ 1 = Supports SuperCalls
4264 EF6C              *   |______________________________ 1 = Supports Extended Calls
4265 EF6C              *
4266 EF6C D4 28                 pei   <fw_addr                 ; save $Cn00+($CnFF)+3
4267 EF6E E2 20                 sep   #$20                     ; 8 bit 'm'
4268 EF70                       longa off
4269 EF70 64 28                 stz   <fw_addr                 ; need ($CnFB)
4270 EF72 A0 FB 00              ldy   #$00FB
4271 EF75 B7 28                 lda   [<fw_addr],y
4272 EF77 4A                    lsr   a                        ; is this a SCSI interface?
4273 EF78 4A                    lsr   a
4274 EF79 C2 20                 rep   #$20                     ; 16 bit 'm'
4275 EF7B                       longa on
4276 EF7B 68                    pla                            ; restore $Cn00+($CnFF)+3
4277 EF7C 85 28                 sta   <fw_addr
4278 EF7E 90 0F                 bcc   not_scsi                 ; no
4279 EF80 A0 32 00              ldy   #ver_num
4280 EF83 B7 20                 lda   [<drvr_dib_ptr],y
4281 EF85 C9 02 00              cmp   #$0002                   ; is this the NEW scsi rom?
4282 EF88 B0 05                 bge   not_scsi                 ; yes, don't modify the driver class
4283 EF8A A0 40 00              ldy   #drvr_class              ; else set the class to 1
4284 EF8D 97 20                 sta   [<drvr_dib_ptr],y
4285 EF8F              not_scsi  
4286 EF8F              *
4287 EF8F              * Now generate a name for the current device being
4288 EF8F              * installed into the device list.
4289 EF8F              *
4290 EF8F 20 CF F0              jsr   gen_name                 ; generate device name 'Dn'
4291 EF92              *
4292 EF92              * Check if done generating devices for this peripheral
4293 EF92              * card.  Make sure this device is not a duplicate device
4294 EF92              * for a driver already loaded or the generated boot device.
4295 EF92              *
4296 EF92 A0 30 00              ldy   #unit_num                ; get current device unit number
4297 EF95 B7 20                 lda   [<drvr_dib_ptr],y
4298 EF97 1A                    inc   a                        ; and set for next device
4299 EF98 FA                    plx                            ; driver class
4300 EF99 7A                    ply                            ; number of devices
4301 EF9A 88                    dey   
4302 EF9B F0 10                 beq   build_done
4303 EF9D 20 B2 EC              jsr   chk_dup_load             ; does a loaded driver already exist?
4304 EFA0 B0 08                 bcs   dup_load_3               ; yes
4305 EFA2 20 C4 EF              jsr   alert_check              ; check if ALERT for loaded driver should be displayed
4306 EFA5 B0 03                 bcs   dup_load_3               ; if ALERT was displayed and generated driver was tossed
4307 EFA7 20 73 F0              jsr   chk_dup_boot             ; check if device is same as boot
4308 EFAA              dup_load_3  
4309 EFAA 4C 96 EE              jmp   class2_loop              ; loop until all devices generated
4310 EFAD              build_done  
4311 EFAD A5 00                 lda   <drvr_dev_num            ; was this the boot device?
4312 EFAF 3A                    dec   a
4313 EFB0 F0 0E                 beq   dup_load_5               ; yes
4314 EFB2 20 B2 EC              jsr   chk_dup_load             ; does a loaded driver already exist?
4315 EFB5 B0 08                 bcs   dup_load_4               ; yes
4316 EFB7 20 C4 EF              jsr   alert_check              ; check if ALERT for loaded driver should be displayed
4317 EFBA B0 03                 bcs   dup_load_4
4318 EFBC 20 73 F0              jsr   chk_dup_boot             ; check if device is same as boot
4319 EFBF              dup_load_4  
4320 EFBF 60                    rts   
4321 EFC0              dup_load_5  
4322 EFC0 20 C4 EF              jsr   alert_check              ; check if ALERT for loaded driver should be displayed
4323 EFC3 60                    rts   
4324 EFC4
4325 EFC4                       eject 
4326 EFC4              *****************************************************************
4327 EFC4              *
4328 EFC4              * If this is a UniDisk3.5 drive then only build the device if it is
4329 EFC4              * unit $0001 and the slot number is equal to the boot slot.  The loaded
4330 EFC4              * driver for the UniDisk3.5 is absolutely neccessary to properly use
4331 EFC4              * the media and assure that corruption will not occur.
4332 EFC4              *
4333 EFC4              * This routine will also display alerts for the AppleDisk3.5 driver but
4334 EFC4              * will allow use of this driver without caching at reduced performance.
4335 EFC4              *
4336 EFC4              *
4337 EFC4              * ENTRY: via a 'JSR'
4338 EFC4              *               A Reg = Unspecified
4339 EFC4              *               X Reg = Unspecified
4340 EFC4              *               Y Reg = Unspecified
4341 EFC4              *               B Reg = Same as execution bank
4342 EFC4              *             Dir Reg = GS/OS Direct Page
4343 EFC4              *               P Reg = N V M X D I Z C  E
4344 EFC4              *                       • • 0 0 0 • • •  0
4345 EFC4              *           Boot_Slot = Slot number of boot volume
4346 EFC4              *
4347 EFC4              * EXIT: via an 'RTS'
4348 EFC4              *               A Reg = Unchanged
4349 EFC4              *               X Reg = Unchanged
4350 EFC4              *               Y Reg = Unchanged
4351 EFC4              *               B Reg = Same as execution bank
4352 EFC4              *             Dir Reg = GS/OS Direct Page
4353 EFC4              *               P Reg = N V M X D I Z C  E
4354 EFC4              *                       • • 0 0 0 • • 0  0 Not a LIRON or LIRON is boot device
4355 EFC4              *                       • • 0 0 0 • • 1  0 LIRON is not boot device
4356 EFC4              *
4357 EFC4              *****************************************************************
4358 EFC4              alert_check  
4359 EFC4                       longa on
4360 EFC4                       longi on
4361 EFC4
4362 EFC4 48                    pha   
4363 EFC5 DA                    phx   
4364 EFC6 5A                    phy   
4365 EFC7 A0 42 00              ldy   #drvr_type               ; get SmartPort driver type
4366 EFCA B7 20                 lda   [<drvr_dib_ptr],y
4367 EFCC C9 01 00              cmp   #$0001                   ; is it a UniDisk3.5 or AppleDisk3.5 drive?
4368 EFCF D0 4C                 bne   not_ad                   ; no, go ahead and build the device
4369 EFD1 A0 44 00              ldy   #drvr_subtype            ; get SmartPort driver subtype
4370 EFD4 B7 20                 lda   [<drvr_dib_ptr],y        ; is it a UniDisk3.5
4371 EFD6 D0 30                 bne   not_ud                   ; no
4372 EFD8 20 62 F0              jsr   boot_slot_unit           ; is it a boot device?
4373 EFDB F0 13                 beq   boot_ud                  ; yes, go ahead and generate it
4374 EFDD              not_ud_boot  
4375 EFDD AD CF E0              lda   |ud_count                ; has dialog already been displayed?
4376 EFE0 D0 06                 bne   no_ud_dialog             ; yes
4377 EFE2 A9 2C 00              lda   #unidisk_alert           ; display driver alert dialog
4378 EFE5 20 3F F0              jsr   driver_alert
4379 EFE8              no_ud_dialog  
4380 EFE8 38                    sec                            ; it's a unidisk & not in the boot position
4381 EFE9 EE CF E0              inc   |ud_count                ; only display dialog once!!!
4382 EFEC              pull_y_x_a  
4383 EFEC 7A                    ply   
4384 EFED FA                    plx   
4385 EFEE 68                    pla   
4386 EFEF 60                    rts   
4387 EFF0
4388 EFF0              boot_ud   
4389 EFF0 AD CF E0              lda   |ud_count                ; has UniDisk dialog been displayed?
4390 EFF3 D0 06                 bne   no_ud_alert              ; yes
4391 EFF5 A9 2C 00              lda   #unidisk_alert           ; display driver alert dialog
4392 EFF8 20 3F F0              jsr   driver_alert
4393 EFFB              no_ud_alert  
4394 EFFB EE CF E0              inc   |ud_count                ; only display dialog once!!!
4395 EFFE A0 46 00              ldy   #cache_mask              ; disable cache on UniDisk generated driver
4396 F001 A9 00 00              lda   #$0000
4397 F004 97 20                 sta   [<drvr_dib_ptr],y
4398 F006 80 33                 bra   alert_exit
4399 F008              not_ud    
4400 F008 C9 C0 00              cmp   #$00C0                   ; is it an AppleDisk3.5 drive?
4401 F00B D0 2E                 bne   alert_exit               ; no
4402 F00D AD D1 E0              lda   |ad_count                ; has dialog been displayed already?
4403 F010 D0 29                 bne   alert_exit               ; yes, dont redisplay it
4404 F012
4405 F012 A9 2D 00              lda   #appledisk_alert         ; display driver alert dialog
4406 F015 20 3F F0              jsr   driver_alert
4407 F018 EE D1 E0              inc   |ad_count                ; set flag so redisplay will not occur
4408 F01B 80 1E                 bra   alert_exit
4409 F01D              not_ad    
4410 F01D C9 05 00              cmp   #$0005                   ; is it a SCSI hard disk device?
4411 F020 F0 05                 beq   do_scsi_alert            ; yes
4412 F022 C9 07 00              cmp   #$0007                   ; is it a SCSI CD-ROM
4413 F025 D0 14                 bne   alert_exit               ; no
4414 F027              do_scsi_alert  
4415 F027 AD D3 E0              lda   |scsi_count              ; has dialog been displayed already?
4416 F02A D0 06                 bne   scsi_alert_exit          ; yes, dont redisplay it
4417 F02C
4418 F02C A9 2B 00              lda   #scsi_alert              ; display driver alert dialog
4419 F02F 20 3F F0              jsr   driver_alert
4420 F032              scsi_alert_exit  
4421 F032 EE D3 E0              inc   |scsi_count              ; set flag so redisplay will not occur
4422 F035 20 62 F0              jsr   boot_slot_unit           ; is it the boot device?
4423 F038 38                    sec   
4424 F039 D0 01                 bne   no_scsi_dialog           ; yes, flag as duplicate
4425 F03B              alert_exit  
4426 F03B 18                    clc                            ; indicate driver was not tossed
4427 F03C              no_scsi_dialog  
4428 F03C 4C EC EF              jmp   pull_y_x_a
4429 F03F
4430 F03F              driver_alert  
4431 F03F 48                    pha                            ; error number of driver alert
4432 F040 A9 00 00              lda   #0                       ; push NIL pointers (no substitution strings)
4433 F043 48                    pha   
4434 F044 48                    pha   
4435 F045 48                    pha   
4436 F046 48                    pha   
4437 F047 A8                    tay   
4438 F048 AF D0 01 E1           lda   >warm_cold_flag          ; is this a boot or an OS switch?
4439 F04C D0 0E                 bne   no_thermometer           ; it's an OS switch
4440 F04E
4441 F04E 98                    tya   
4442 F04F 22 D9 73 00           jsl   stop_scrn_chk            ; dont want text screen left up after dialog
4443 F053 22 94 FC 01           jsl   report_error             ; display the alert dialog
4444 F057 22 A8 73 00           jsl   start_scrn_chk           ; back to thermometer
4445 F05B 60                    rts   
4446 F05C              no_thermometer  
4447 F05C 98                    tya   
4448 F05D 22 94 FC 01           jsl   report_error             ; display the alert dialog
4449 F061 60                    rts   
4450 F062
4451 F062              boot_slot_unit  
4452 F062 A0 2E 00              ldy   #slot_num
4453 F065 B7 20                 lda   [<drvr_dib_ptr],y
4454 F067 CD BB E0              cmp   |d_boot_slot             ; is this the boot slot
4455 F06A D0 06                 bne   aint_boot                ; no
4456 F06C
4457 F06C A0 30 00              ldy   #unit_num
4458 F06F B7 20                 lda   [<drvr_dib_ptr],y
4459 F071 3A                    dec   a                        ; is this the boot unit
4460 F072              aint_boot  
4461 F072 60                    rts   
4462 F073
4463 F073                       eject 
4464 F073              *****************************************************************
4465 F073              *
4466 F073              * This routine verifies that the current device is not a
4467 F073              * duplicate of the boot volume device.  If so, the device
4468 F073              * number is not incremented.  If not, the device number is
4469 F073              * incremented.  When the device number is not incremented, the
4470 F073              * next device will be built over the current device thus purging
4471 F073              * the duplicate device.
4472 F073              *
4473 F073              * ENTRY:        A Reg = Undefined
4474 F073              *               X Reg = Unspecified
4475 F073              *               Y Reg = Unspecified
4476 F073              *               B Reg = Same as execution bank
4477 F073              *             Dir Reg = GS/OS Direct Page
4478 F073              *               P Reg = N V M X D I Z C  E
4479 F073              *                       • • 0 0 0 • • •  0
4480 F073              *           Boot_Slot = Slot number of boot volume
4481 F073              *
4482 F073              * EXIT:         A Reg = Unchanged
4483 F073              *               X Reg = Unchanged
4484 F073              *               Y Reg = Unchanged
4485 F073              *               B Reg = Same as execution bank
4486 F073              *             Dir Reg = GS/OS Direct Page
4487 F073              *               P Reg = N V M X D I Z C  E
4488 F073              *                       • • 0 0 0 • • •  0
4489 F073              *
4490 F073              *****************************************************************
4491 F073              chk_dup_boot  
4492 F073                       longa on
4493 F073                       longi on
4494 F073
4495 F073 48                    pha   
4496 F074 5A                    phy   
4497 F075 A0 2E 00              ldy   #slot_num                ; get current device slot
4498 F078 B7 20                 lda   [<drvr_dib_ptr],y
4499 F07A C5 04                 cmp   <boot_slot
4500 F07C D0 09                 bne   not_dup_boot             ; it's ok to generate next device
4501 F07E
4502 F07E C8                    iny                            ; get current unit #
4503 F07F C8                    iny   
4504 F080 B7 20                 lda   [<drvr_dib_ptr],y
4505 F082 C9 01 00              cmp   #$0001                   ; boot volume is always unit #1
4506 F085 F0 05                 beq   chk_dup_done             ; it's a duplicate, purge it
4507 F087              not_dup_boot  
4508 F087 EE 5D E0              inc   |gen_count               ; else setup for next device
4509 F08A E6 00                 inc   <drvr_dev_num
4510 F08C              chk_dup_done  
4511 F08C 7A                    ply   
4512 F08D 68                    pla   
4513 F08E 60                    rts   
4514 F08F
4515 F08F                       eject 
4516 F08F              *****************************************************************
4517 F08F              *
4518 F08F              * This routine sets the DIB unit and slot numbers.  The Unit
4519 F08F              * number is passed as input to this routine through the
4520 F08F              * accumulator.  The slot number is based on <fw_addr.
4521 F08F              * If the slot is external, $0008 will be added to the
4522 F08F              * initial slot value before placing the slot number into the DIB.
4523 F08F              *
4524 F08F              * ENTRY:        A Reg = Undefined
4525 F08F              *               X Reg = Undefined
4526 F08F              *               Y Reg = Undefined
4527 F08F              *               B Reg = Same as execution bank
4528 F08F              *             Dir Reg = GS/OS Direct Page
4529 F08F              *               P Reg = N V M X D I Z C  E
4530 F08F              *                       • • 0 0 0 • • •  0
4531 F08F              *           Boot_Slot = Slot number of boot volume
4532 F08F              *
4533 F08F              * EXIT:         A Reg = Slot number
4534 F08F              *               X Reg = Undefined
4535 F08F              *               Y Reg = Pointer to DIB slot number
4536 F08F              *               B Reg = Same as execution bank
4537 F08F              *             Dir Reg = GS/OS Direct Page
4538 F08F              *               P Reg = N V M X D I Z C  E
4539 F08F              *                       • • 0 0 0 • • •  0
4540 F08F              *
4541 F08F              *****************************************************************
4542 F08F              generate_slot  
4543 F08F                       longa on
4544 F08F                       longi on
4545 F08F
4546 F08F A0 30 00              ldy   #unit_num                ; set unit number
4547 F092 97 20                 sta   [<drvr_dib_ptr],y
4548 F094 88                    dey                            ; point at DIB slot number
4549 F095 88                    dey   
4550 F096 A5 28                 lda   <fw_addr                 ; get $CnXX
4551 F098 EB                    xba   
4552 F099 29 07 00              and   #$0007                   ; extract the slot number
4553 F09C 97 20                 sta   [<drvr_dib_ptr],y
4554 F09E 08                    php                            ; save environment
4555 F09F
4556 F09F E2 20                 sep   #$20                     ; 8 bit 'm'
4557 F0A1                       longa off
4558 F0A1
4559 F0A1 C9 03                 cmp   #$03                     ; is slot set to slot #3?
4560 F0A3 D0 07                 bne   not_slot3                ; if not
4561 F0A5 AF 17 C0 00           lda   >rdc3rom                 ; internal or external?
4562 F0A9 2A                    rol   a
4563 F0AA 80 09                 bra   set_int_ext
4564 F0AC              not_slot3  
4565 F0AC AA                    tax   
4566 F0AD AF 2D C0 00           lda   >sltromsel               ; get slot rom selection
4567 F0B1              slot_check  
4568 F0B1 6A                    ror   a
4569 F0B2 CA                    dex   
4570 F0B3 10 FC                 bpl   slot_check
4571 F0B5              set_int_ext  
4572 F0B5 A9 00                 lda   #$00                     ; assume internal
4573 F0B7 90 02                 bcc   int_slot
4574 F0B9 A9 08                 lda   #$08                     ; slots 8-15 are external
4575 F0BB              int_slot  
4576 F0BB 28                    plp                            ; restore environment
4577 F0BC
4578 F0BC                       longa on
4579 F0BC
4580 F0BC 29 FF 00              and   #$00FF                   ; insert SLOT_NUM
4581 F0BF 17 20                 ora   [<drvr_dib_ptr],y
4582 F0C1 97 20                 sta   [<drvr_dib_ptr],y
4583 F0C3
4584 F0C3 48                    pha   
4585 F0C4 5A                    phy   
4586 F0C5 A5 00                 lda   <drvr_dev_num            ; insert DIB_DEV_NUM ** REV. 0.10a02
4587 F0C7 A0 3E 00              ldy   #dib_dev_num
4588 F0CA 97 20                 sta   [<drvr_dib_ptr],y
4589 F0CC 7A                    ply   
4590 F0CD 68                    pla   
4591 F0CE 60                    rts   
4592 F0CF
4593 F0CF                       eject 
4594 F0CF              *****************************************************************
4595 F0CF              *
4596 F0CF              * This routine is used to generate an ASCII name for generated
4597 F0CF              * devices and places that name into the DIB.  The value of the
4598 F0CF              * generated driver counter is converted to decimal prior to
4599 F0CF              * converting the count to ASCII.  All leading zero's will be
4600 F0CF              * removed from the final string resulting in the name 'Dn' where
4601 F0CF              * n is the value of the generated driver counter.
4602 F0CF              *
4603 F0CF              * ENTRY:        A Reg = Undefined
4604 F0CF              *               X Reg = Undefined
4605 F0CF              *               Y Reg = Undefined
4606 F0CF              *               B Reg = Same as execution bank
4607 F0CF              *             Dir Reg = GS/OS Direct Page
4608 F0CF              *               P Reg = N V M X D I Z C  E
4609 F0CF              *                       • • 0 0 0 • • •  0
4610 F0CF              *           Boot_Slot = Slot number of boot volume
4611 F0CF              *
4612 F0CF              * EXIT:         A Reg = Undefined
4613 F0CF              *               X Reg = Undefined
4614 F0CF              *               Y Reg = Undefined
4615 F0CF              *               B Reg = Unchanged
4616 F0CF              *             Dir Reg = GS/OS Direct Page
4617 F0CF              *               P Reg = N V M X D I Z C  E
4618 F0CF              *                       • • 0 0 0 • • •  0
4619 F0CF              *
4620 F0CF              *****************************************************************
4621 F0CF              gen_name  
4622 F0CF                       longa on
4623 F0CF                       longi on
4624 F0CF
4625 F0CF 48                    pha                            ; preserve environment
4626 F0D0 DA                    phx   
4627 F0D1 5A                    phy   
4628 F0D2 AD 5D E0              lda   |gen_count               ; # of current generated driver
4629 F0D5 48                    pha                            ; is integer to be converted
4630 F0D6 F4 E0 00              pea   name_buff>>16            ; Pointer to output string
4631 F0D9 F4 63 E0              pea   name_buff
4632 F0DC F4 05 00              pea   $0005                    ; length of output string
4633 F0DF F4 00 00              pea   $0000                    ; unsigned integer
4634 F0E2 A2 0B 26 22           _int2dec 
4635 F0E9
4636 F0E9 E2 20                 sep   #$20                     ; 8 bit 'm'
4637 F0EB                       longa off
4638 F0EB
4639 F0EB A0 12 00              ldy   #dev_name+4              ; point into name after count & 'DEV'
4640 F0EE A2 00 00              ldx   #$0000
4641 F0F1              xfer_fl_name  
4642 F0F1 BD 63 E0              lda   |name_buff,x             ; get ascii
4643 F0F4 C9 20                 cmp   #$20                     ; is it a ' ' ascii character?
4644 F0F6 D0 03                 bne   move_string              ; no, now pointing at 1st character
4645 F0F8 E8                    inx                            ; else point at next character and
4646 F0F9 80 F6                 bra   xfer_fl_name             ; continue search for 1st valid char.
4647 F0FB
4648 F0FB              move_string                             ; ; now move string into DIB
4649 F0FB BD 63 E0              lda   |name_buff,x             ; get ascii
4650 F0FE 97 20                 sta   [<drvr_dib_ptr],y
4651 F100 C8                    iny   
4652 F101 E8                    inx   
4653 F102 E0 05 00              cpx   #$0005
4654 F105 D0 F4                 bne   move_string
4655 F107
4656 F107 98                    tya                            ; calculate string length
4657 F108 18                    clc                            ; -1 since ptr past string
4658 F109 E9 0E                 sbc   #dev_name
4659 F10B A0 0E 00              ldy   #dev_name                ; and set string length
4660 F10E 97 20                 sta   [<drvr_dib_ptr],y
4661 F110
4662 F110 C2 20                 rep   #$20                     ; 16 bit 'm'
4663 F112                       longa on
4664 F112
4665 F112 4C EC EF              jmp   pull_y_x_a
4666 F115
4667 F115                       eject 
4668 F115              *****************************************************************
4669 F115              *
4670 F115              * This routine sets the DIB device ID number based on the
4671 F115              * contents of the X register.
4672 F115              *
4673 F115              *****************************************************************
4674 F115              set_id_num  
4675 F115                       longa on
4676 F115                       longi on
4677 F115
4678 F115 A0 34 00              ldy   #dev_id_num              ; point at DIB ID number
4679 F118 8A                    txa                            ; and set the ID
4680 F119 80 0B                 bra   set_dib_parm
4681 F11B
4682 F11B              *****************************************************************
4683 F11B              *
4684 F11B              * This routine sets the DIB device characteristics based
4685 F11B              * on the contents of the A register.
4686 F11B              *
4687 F11B              *****************************************************************
4688 F11B              set_dev_char  
4689 F11B                       longa on
4690 F11B                       longi on
4691 F11B
4692 F11B A0 08 00              ldy   #dev_char                ; set device characteristics
4693 F11E 80 06                 bra   set_dib_parm
4694 F120
4695 F120              *****************************************************************
4696 F120              *
4697 F120              * This routine sets the DIB version number.
4698 F120              *
4699 F120              *****************************************************************
4700 F120              set_gen_ver  
4701 F120                       longa on
4702 F120                       longi on
4703 F120
4704 F120 A0 32 00              ldy   #ver_num                 ; point at DIB version number
4705 F123 A9 00 20              lda   #$2000                   ; and set the version number
4706 F126              set_dib_parm  
4707 F126 97 20                 sta   [<drvr_dib_ptr],y
4708 F128 60                    rts   
4709 F129
4710 F129                       eject 
4711 F129              ****************************************************************
4712 F129              *
4713 F129              * This routine sets the DIB pointer on direct page for the
4714 F129              * device specified by the Device ID Number.  This allows an
4715 F129              * FST direct access to DIB information for a particular device.
4716 F129              *
4717 F129              ****************************************************************
4718 F129              dd_get_dib  
4719 F129                       longa on
4720 F129                       longi on
4721 F129
4722 F129 A5 04                 lda   <dev_id_ref              ; check device number
4723 F12B C7 24                 cmp   [<drvr_dev_ptr]
4724 F12D 90 07                 blt   id_ref_ok
4725 F12F F0 05                 beq   id_ref_ok
4726 F131
4727 F131 A9 11 00              lda   #invalid_dev_num         ; incorrect ID, no device error
4728 F134 38                    sec   
4729 F135 60                    rts   
4730 F136
4731 F136              id_ref_ok  
4732 F136 85 00                 sta   <drvr_dev_num            ; set device number
4733 F138 20 5B E7              jsr   set_dib_ptr              ; set pointer to DIB
4734 F13B 64 00                 stz   <drvr_dev_num            ; restore device number
4735 F13D A9 04 00              lda   #$0004                   ; set transfer count
4736 F140 85 0C                 sta   <drvr_tran_cnt
4737 F142 64 0E                 stz   <drvr_tran_cnt+2
4738 F144 18                    clc                            ; no error has occured
4739 F145 60                    rts   
4740 F146
4741 F146                       eject 
4742 F146              ****************************************************************
4743 F146              *
4744 F146              * This function walks the device list looking for a driver that
4745 F146              * supports removeable media.  When one is found, an Eject call
4746 F146              * is made to the driver to have it eject it's media.  When the
4747 F146              * entire device list is scanned, the function falls through into
4748 F146              * the normal dispatcher shutdown procedure
4749 F146              *
4750 F146              ****************************************************************
4751 F146
4752 F146              dd_full_shutdn  
4753 F146
4754 F146 A7 24                 lda   [<drvr_dev_ptr]          ; point at last device
4755 F148 F0 37                 beq   no_drvr_shutdn
4756 F14A 85 00                 sta   <drvr_dev_num            ; save here
4757 F14C 64 04                 stz   <drvr_buf_ptr            ; not used, zero out
4758 F14E 64 06                 stz   <drvr_buf_ptr+2
4759 F150 64 08                 stz   <drvr_req_cnt            ; not used, zero out
4760 F152 64 0A                 stz   <drvr_req_cnt+2
4761 F154
4762 F154              loop      
4763 F154 20 5B E7              jsr   set_dib_ptr              ; make a dib pointer for this device
4764 F157 A0 08 00              ldy   #dev_char                ; index to characteristics
4765 F15A B7 20                 lda   [<drvr_dib_ptr],y
4766 F15C 29 04 00              and   #%0000000000000100       ; removeable media?
4767 F15F F0 0E                 beq   no_eject                 ; no, skip it
4768 F161 A9 02 00              lda   #2                       ; control subcall = Eject
4769 F164 85 16                 sta   <drvr_ctrl_code
4770 F166 A9 06 00              lda   #6                       ; driver call = Control
4771 F169 85 02                 sta   <drvr_call_num
4772 F16B 22 00 FC 01           jsl   dev_dispatcher           ; call the driver (recursive!)
4773 F16F              no_eject  
4774 F16F C6 00                 dec   <drvr_dev_num            ; loop through all devices
4775 F171 D0 E1                 bne   loop
4776 F173
4777 F173                                                      ; fall through into dd_shutdn
4778 F173
4779 F173                       eject 
4780 F173              ****************************************************************
4781 F173              *
4782 F173              * This function is used to shutdown the device dispatcher.
4783 F173              * Then a drvr_shutdn call will be issued to each device in the
4784 F173              * device list.  The memory used to maintain the device
4785 F173              * list will be released and the ID for the device list will
4786 F173              * be deleted.
4787 F173              *
4788 F173              * ENTRY: Call via 'JSL'
4789 F173              *               A Reg = Undefined
4790 F173              *               X Reg = Undefined
4791 F173              *               Y Reg = Undefined
4792 F173              *               B Reg = Undefined
4793 F173              *             Dir Reg = GSOS Direct Page
4794 F173              *               P Reg = N V M X D I Z C  E
4795 F173              *                       • • 0 0 0 • • •  0
4796 F173              *
4797 F173              * EXIT: via 'RTL'
4798 F173              *               A Reg = Undefined
4799 F173              *               X Reg = Undefined
4800 F173              *               Y Reg = Undefined
4801 F173              *               B Reg = Undefined
4802 F173              *             Dir Reg = GSOS Direct Page
4803 F173              *               P Reg = N V M X D I Z C  E
4804 F173              *                       • • 0 0 0 • • 0  0   if no error
4805 F173              *                       • • 0 0 0 • • 1  0   if error
4806 F173              *
4807 F173              ****************************************************************
4808 F173              dd_shutdn  
4809 F173                       longa on
4810 F173                       longi on
4811 F173
4812 F173 A7 24                 lda   [<drvr_dev_ptr]          ; point at last device
4813 F175 F0 0A                 beq   no_drvr_shutdn
4814 F177
4815 F177              shutdn_loop  
4816 F177 85 00                 sta   <drvr_dev_num
4817 F179 48                    pha                            ; save the device number
4818 F17A 20 E0 F1              jsr   shutdn_driver            ; shutdown the driver
4819 F17D 68                    pla                            ; retrieve the device number
4820 F17E 3A                    dec   a                        ; step backwards through device list
4821 F17F D0 F6                 bne   shutdn_loop              ; until all devices shut down
4822 F181
4823 F181              no_drvr_shutdn  
4824 F181 A7 70                 lda   [<sup_drvr_ptr]          ; point at last supervisor
4825 F183 F0 0A                 beq   no_sup_shutdn
4826 F185
4827 F185              sup_shutdn_loop  
4828 F185 20 1D F2              jsr   shutdn_sup               ; shutdown the supervisor
4829 F188 A7 70                 lda   [<sup_drvr_ptr]
4830 F18A 3A                    dec   a
4831 F18B 87 70                 sta   [<sup_drvr_ptr]
4832 F18D D0 F6                 bne   sup_shutdn_loop          ; no, then loop for next device
4833 F18F
4834 F18F              no_sup_shutdn  
4835 F18F AF D0 01 E1           lda   >warm_cold_flag          ; is this a warm start?
4836 F193 D0 37                 bne   warm_shutdown            ; no
4837 F195              *
4838 F195              * Purge memory used by the device list.
4839 F195              *
4840 F195 AD 35 E0              lda   |dev_list_id             ; device id of handle to dispose
4841 F198 AC 39 E0              ldy   |dev_list_hndl+2         ; handle to dispose
4842 F19B AE 37 E0              ldx   |dev_list_hndl
4843 F19E 20 55 E5              jsr   dispose_handle           ; toss the handle and user ID
4844 F1A1              *
4845 F1A1              * Purge memory used by the generated drivers.
4846 F1A1              *
4847 F1A1 AD 53 E0              lda   |gen_drvr_id             ; device id of handle to dispose
4848 F1A4 AC 57 E0              ldy   |gen_drvr_hndl+2         ; handle to dispose
4849 F1A7 AE 55 E0              ldx   |gen_drvr_hndl
4850 F1AA 20 55 E5              jsr   dispose_handle           ; toss the handle and user ID
4851 F1AD              *
4852 F1AD              * Purge memory used by the supervisory driver list.
4853 F1AD              *
4854 F1AD AD BD E0              lda   |sup_drvr_id             ; device id of handle to dispose
4855 F1B0 AC C1 E0              ldy   |sup_drvr_hndl+2         ; handle to dispose
4856 F1B3 AE BF E0              ldx   |sup_drvr_hndl
4857 F1B6 20 55 E5              jsr   dispose_handle           ; toss the handle and user ID
4858 F1B9              *
4859 F1B9              * Purge memory used by the file list.
4860 F1B9              *
4861 F1B9 AD 43 E0              lda   |file_list_id            ; device id of handle to dispose
4862 F1BC AC 47 E0              ldy   |file_list_hndl+2        ; handle to dispose
4863 F1BF AE 45 E0              ldx   |file_list_hndl
4864 F1C2 20 55 E5              jsr   dispose_handle           ; toss the handle and user ID
4865 F1C5              *
4866 F1C5              * If a BOOT.DRIVER is in place, dispose of it
4867 F1C5              *
4868 F1C5 A5 6A                 lda   <boot_user_id            ; get the ID
4869 F1C7 F0 03                 beq   warm_shutdown            ; no BOOT.DRIVER to dispose of
4870 F1C9 20 40 F2              jsr   purge_driver             ; go throw it away
4871 F1CC
4872 F1CC              warm_shutdown  
4873 F1CC A9 02 00              lda   #$0002                   ; preinit load device in case of warm start
4874 F1CF 8D 81 E0              sta   |load_device
4875 F1D2
4876 F1D2 9C CF E0              stz   |ud_count                ; display them dialogs next time!!!
4877 F1D5 9C D1 E0              stz   |ad_count
4878 F1D8 9C D3 E0              stz   |scsi_count
4879 F1DB              return_no_err  
4880 F1DB A9 00 00              lda   #no_error
4881 F1DE 18                    clc   
4882 F1DF 60                    rts   
4883 F1E0
4884 F1E0                       eject 
4885 F1E0              ****************************************************************
4886 F1E0              *
4887 F1E0              * This routine is used to shutdown a driver.  Note that if the
4888 F1E0              * driver returns an error then the memory for which that driver
4889 F1E0              * was initially loaded into will remain locked and fixed.  If
4890 F1E0              * the driver returned no error then the memory associated with
4891 F1E0              * the User ID entry in the device list will be purged.
4892 F1E0              *
4893 F1E0              * ENTRY: Call via 'JSR'
4894 F1E0              *               A Reg = Undefined
4895 F1E0              *               X Reg = Undefined
4896 F1E0              *               Y Reg = Undefined
4897 F1E0              *               B Reg = Undefined
4898 F1E0              *             Dir Reg = GSOS Direct Page
4899 F1E0              *               P Reg = N V M X D I Z C  E
4900 F1E0              *                       • • 0 0 0 • • •  0
4901 F1E0              *
4902 F1E0              * EXIT: via 'RTS'
4903 F1E0              *               A Reg = Undefined
4904 F1E0              *               X Reg = Undefined
4905 F1E0              *               Y Reg = Undefined
4906 F1E0              *               B Reg = Undefined
4907 F1E0              *             Dir Reg = GSOS Direct Page
4908 F1E0              *               P Reg = N V M X D I Z C  E
4909 F1E0              *                       • • 0 0 0 • • •  0
4910 F1E0              *
4911 F1E0              ****************************************************************
4912 F1E0              shutdn_driver  
4913 F1E0                       longa on
4914 F1E0                       longi on
4915 F1E0
4916 F1E0 A5 00                 lda   <drvr_dev_num            ; is this the boot device?
4917 F1E2 3A                    dec   a
4918 F1E3 D0 0D                 bne   not_boot                 ; no
4919 F1E5
4920 F1E5 20 5B E7              jsr   set_dib_ptr              ; get the correct DIB pointer
4921 F1E8 A0 08 00              ldy   #dev_char                ; is this a generated driver?
4922 F1EB B7 20                 lda   [<drvr_dib_ptr],y
4923 F1ED 29 00 40              and   #$4000
4924 F1F0 D0 2A                 bne   dont_unload              ; yes, don't shutdn since not started
4925 F1F2              not_boot  
4926 F1F2 A9 08 00              lda   #drvr_shutdn             ; set call = driver shut down
4927 F1F5 85 02                 sta   <drvr_call_num
4928 F1F7 22 00 FC 01           jsl   dev_dispatcher           ; and shut it down
4929 F1FB B0 1F                 bcs   dont_unload
4930 F1FD              check_type  
4931 F1FD AD B3 E0              lda   |dd_os_call              ; is driver being shutdown during startup?
4932 F200 F0 10                 beq   unload_it                ; yes, purge it & mark file list
4933 F202
4934 F202 AF D0 01 E1           lda   >warm_cold_flag          ; is this a warm start?
4935 F206 F0 0A                 beq   unload_it                ; yes
4936 F208
4937 F208 A0 08 00              ldy   #dev_char                ; is driver restartable?
4938 F20B B7 20                 lda   [<drvr_dib_ptr],y
4939 F20D 29 00 08              and   #$0800
4940 F210 D0 0A                 bne   dont_unload              ; no, else nuke the ma'ma
4941 F212              unload_it  
4942 F212 20 24 E2              jsr   set_dev_index            ; point at user ID in device list
4943 F215 20 17 EB              jsr   y_plus_6                 ; and get current user ID
4944 F218 B7 24                 lda   [<drvr_dev_ptr],y
4945 F21A D0 24                 bne   purge_driver             ; if !0, unload & release memory
4946 F21C              dont_unload  
4947 F21C 60                    rts   
4948 F21D
4949 F21D                       eject 
4950 F21D              ****************************************************************
4951 F21D              *
4952 F21D              * This routine is used to shutdown a supervisor.
4953 F21D              *
4954 F21D              * ENTRY: Call via 'JSR'
4955 F21D              *               A Reg = Supervisor driver number
4956 F21D              *               X Reg = Undefined
4957 F21D              *               Y Reg = Undefined
4958 F21D              *               B Reg = Undefined
4959 F21D              *             Dir Reg = GSOS Direct Page
4960 F21D              *               P Reg = N V M X D I Z C  E
4961 F21D              *                       • • 0 0 0 • • •  0
4962 F21D              *
4963 F21D              * EXIT: via 'RTS'
4964 F21D              *               A Reg = Undefined
4965 F21D              *               X Reg = Undefined
4966 F21D              *               Y Reg = Undefined
4967 F21D              *               B Reg = Undefined
4968 F21D              *             Dir Reg = GSOS Direct Page
4969 F21D              *               P Reg = N V M X D I Z C  E
4970 F21D              *                       • • 0 0 0 • • •  0
4971 F21D              *
4972 F21D              ****************************************************************
4973 F21D              shutdn_sup  
4974 F21D                       longa on
4975 F21D                       longi on
4976 F21D
4977 F21D A2 01 00              ldx   #$0001                   ; set call = supervisor shut down
4978 F220 48                    pha   
4979 F221 22 A4 FC 01           jsl   sup_drvr_disp            ; and shut it down
4980 F225 FA                    plx   
4981 F226
4982 F226                       eject 
4983 F226              ****************************************************************
4984 F226              *
4985 F226              * This routine is used to purge a supervisory driver.
4986 F226              *
4987 F226              * ENTRY: Call via 'JSR'
4988 F226              *               A Reg = Supervisor driver number
4989 F226              *               X Reg = Undefined
4990 F226              *               Y Reg = Undefined
4991 F226              *               B Reg = Undefined
4992 F226              *             Dir Reg = GSOS Direct Page
4993 F226              *               P Reg = N V M X D I Z C  E
4994 F226              *                       • • 0 0 0 • • •  0
4995 F226              *
4996 F226              * EXIT: via 'RTS'
4997 F226              *               A Reg = Undefined
4998 F226              *               X Reg = Undefined
4999 F226              *               Y Reg = Undefined
5000 F226              *               B Reg = Undefined
5001 F226              *             Dir Reg = GSOS Direct Page
5002 F226              *               P Reg = N V M X D I Z C  E
5003 F226              *                       • • 0 0 0 • • •  0
5004 F226              *
5005 F226              ****************************************************************
5006 F226              purge_sup  
5007 F226                       longa on
5008 F226                       longi on
5009 F226
5010 F226 AD B3 E0              lda   |dd_os_call              ; is driver being shutdown during startup?
5011 F229 F0 0D                 beq   purge_sup_1              ; yes, purge it & mark file list
5012 F22B
5013 F22B AF D0 01 E1           lda   >warm_cold_flag          ; is this a warm start?
5014 F22F F0 07                 beq   purge_sup_1              ; yes
5015 F231
5016 F231 A0 0C 00              ldy   #sib_char                ; is driver restartable?
5017 F234 B7 74                 lda   [<sib_ptr],y
5018 F236 30 E4                 bmi   dont_unload              ; no, else nuke the ma'ma
5019 F238              purge_sup_1  
5020 F238 8A                    txa                            ; point at user ID in supervisor list
5021 F239 20 8D E8              jsr   set_sup_index
5022 F23C B7 70                 lda   [<sup_drvr_ptr],y
5023 F23E F0 DC                 beq   dont_unload              ; NIL is not a valid driver user ID
5024 F240
5025 F240                       eject 
5026 F240              ***************************************************************
5027 F240              *
5028 F240              * This routine unloads and purges the segment defined by the
5029 F240              * user ID passed as input to the call.  The USER ID will be
5030 F240              * deleted from the system.
5031 F240              *
5032 F240              * ENTRY: via a 'JSR'
5033 F240              *               A Reg = USER ID of segment to shutdown
5034 F240              *               X Reg = Undefined
5035 F240              *               Y Reg = Undefined
5036 F240              *            Bank Reg = Current Program Bank
5037 F240              *             Dir Reg = GS/OS Direct Page
5038 F240              *           Stack Reg = GS/OS Stack
5039 F240              *               P Reg = N V M X D I Z C  E
5040 F240              *                       • • 0 0 0 • • •  0
5041 F240              *
5042 F240              * EXIT:  via 'RTS'
5043 F240              *               A Reg = USER ID of segment that was shutdown
5044 F240              *               X Reg = Unchanged
5045 F240              *               Y Reg = Unchanged
5046 F240              *            Bank Reg = Current Program Bank
5047 F240              *             Dir Reg = GS/OS Direct Page
5048 F240              *           Stack Reg = GS/OS Stack
5049 F240              *               P Reg = N V M X D I Z C  E
5050 F240              *                       • • 0 0 0 • • •  0
5051 F240              *
5052 F240              ***************************************************************
5053 F240              purge_driver  
5054 F240                       longa on
5055 F240                       longi on
5056 F240
5057 F240 8D B1 E0              sta   |shutdown_id             ; user ID to shutdown
5058 F243
5059 F243 DA                    phx   
5060 F244 5A                    phy   
5061 F245 48                    pha                            ; space for result
5062 F246 48                    pha                            ; USER ID
5063 F247 F4 00 00              pea   $0000                    ; Quit Flag
5064 F24A A2 11 12 22           _usershutdown 
5065 F251 68                    pla                            ; result User ID from shutdown
5066 F252
5067 F252 20 C0 FE              jsr   mark_file_list           ; mark the driver in the file list as purged
5068 F255
5069 F255 7A                    ply   
5070 F256 FA                    plx   
5071 F257 60                    rts   
5072 F258
5073 F258                       eject 
5074 F258              ****************************************************************
5075 F258              *
5076 F258              * This routine is the central dispatcher for generated driver
5077 F258              * calls.  This routine parses the command number and dispatches
5078 F258              * control to the device driver via the proper generated driver
5079 F258              * core routine.  The driver block number and buffer address are
5080 F258              * preserved throughout the driver call by the driver dispatcher.
5081 F258              *
5082 F258              * ENTRY:        A Reg = Call number
5083 F258              *               X Reg = Undefined
5084 F258              *               Y Reg = Undefined
5085 F258              *             DIR Reg = GS/OS Direct Page
5086 F258              *               B Reg = Undefined
5087 F258              *               P Reg = N V M X D I Z C  E
5088 F258              *                       • • 0 0 0 • • •  0
5089 F258              *
5090 F258              * EXIT:         A Reg = Error code
5091 F258              *               X Reg = Undefined
5092 F258              *               Y Reg = Undefined
5093 F258              *             DIR Reg = GS/OS Direct Page
5094 F258              *               B Reg = Same as on entry
5095 F258              *               P Reg = N V M X D I Z C  E
5096 F258              *                       • • 0 0 0 • • 0  0 if no error
5097 F258              *                       • • 0 0 0 • • 1  0 if error
5098 F258              *
5099 F258              ****************************************************************
5100 F258                       export g_dispatch
5101 F258              g_dispatch  
5102 F258                       longa on
5103 F258                       longi on
5104 F258
5105 F258 8B                    phb                            ; save environment
5106 F259 0B                    phd   
5107 F25A
5108 F25A 4B                    phk                            ; set environment in case call was
5109 F25B AB                    plb                            ; from the system service call table
5110 F25C F4 00 BD              pea   direct_base
5111 F25F 2B                    pld   
5112 F260
5113 F260              *
5114 F260              * Set MSLOT prior to dispatch since some Pascal1.1 devices
5115 F260              * dont setup this parameter.
5116 F260              *
5117 F260 A0 2E 00              ldy   #slot_num                ; obtain slot number from DIB
5118 F263 B7 20                 lda   [<drvr_dib_ptr],y
5119 F265
5120 F265 E2 20                 sep   #$20
5121 F267                       longa off
5122 F267
5123 F267 29 07                 and   #$07                     ; create $Cn for mslot
5124 F269 09 C0                 ora   #$C0
5125 F26B 8F F8 07 00           sta   >mslot
5126 F26F
5127 F26F C2 20                 rep   #$20
5128 F271                       longa on
5129 F271
5130 F271 A5 02                 lda   <drvr_call_num           ; redundant but system service needs it
5131 F273 C9 09 00              cmp   #max_command             ; is it a legal command?
5132 F276 B0 50                 bge   g_illegal_req            ; no
5133 F278 A8                    tay                            ; save command #
5134 F279 A2 00 00              ldx   #$0000
5135 F27C              save_parms  
5136 F27C B5 00                 lda   <drvr_dev_num,x          ; save GS/OS call parameters
5137 F27E 48                    pha   
5138 F27F B5 10                 lda   <drvr_blk_num,x
5139 F281 48                    pha   
5140 F282 E8                    inx   
5141 F283 E8                    inx   
5142 F284 E0 0C 00              cpx   #$000C                   ; up to but not including DRVR_TRAN_CNT
5143 F287 D0 F3                 bne   save_parms
5144 F289
5145 F289 AF 42 00 00           lda   >pcmd                    ; save absolute zero page parameters
5146 F28D 48                    pha   
5147 F28E AF 44 00 00           lda   >pbuffer
5148 F292 48                    pha   
5149 F293 AF 46 00 00           lda   >pblock
5150 F297 48                    pha   
5151 F298
5152 F298 AF FF CF 00           lda   >$00CFFF                 ; bang out all peripheral cards
5153 F29C 98                    tya                            ; restore command #
5154 F29D 0A                    asl   a                        ; make index to dispatch table
5155 F29E AA                    tax   
5156 F29F FC CF F2              jsr   (dispatch,x)             ; get dispatch entry
5157 F2A2 A8                    tay                            ; save error code
5158 F2A3
5159 F2A3 68                    pla   
5160 F2A4 8F 46 00 00           sta   >pblock
5161 F2A8 68                    pla   
5162 F2A9 8F 44 00 00           sta   >pbuffer
5163 F2AD 68                    pla   
5164 F2AE 8F 42 00 00           sta   >pcmd
5165 F2B2
5166 F2B2 A2 0A 00              ldx   #$000A                   ; number of words to restore
5167 F2B5              restore_parms  
5168 F2B5 68                    pla                            ; restore GS/OS call parameters
5169 F2B6 95 10                 sta   <drvr_blk_num,x
5170 F2B8 68                    pla   
5171 F2B9 95 00                 sta   <drvr_dev_num,x
5172 F2BB CA                    dex   
5173 F2BC CA                    dex   
5174 F2BD 10 F6                 bpl   restore_parms
5175 F2BF 2B                    pld                            ; restore environment
5176 F2C0 AB                    plb   
5177 F2C1 B0 03                 bcs   gen_exit                 ; force error code 0 if flag cleared
5178 F2C3 A0 00 00              ldy   #no_error
5179 F2C6              gen_exit  
5180 F2C6 98                    tya                            ; restore error code
5181 F2C7 6B                    rtl   
5182 F2C8              *
5183 F2C8              * Received an illegal request.  Return with an error.
5184 F2C8              *
5185 F2C8              g_illegal_req  
5186 F2C8 2B                    pld                            ; restore environment
5187 F2C9 AB                    plb   
5188 F2CA A9 20 00              lda   #drvr_bad_req            ; set error
5189 F2CD 38                    sec   
5190 F2CE 6B                    rtl   
5191 F2CF
5192 F2CF              *
5193 F2CF              * The following is a table of dispatch entry points for driver functions.
5194 F2CF              *
5195 F2CF E1 F2        dispatch DC W:g_startup                 ; entry for startup function
5196 F2D1 2A F3                 DC W:g_open                    ; entry for open function
5197 F2D3 55 F3                 DC W:g_read                    ; entry for read function
5198 F2D5 A7 F6                 DC W:g_write                   ; entry for write function
5199 F2D7 25 F8                 DC W:g_close                   ; entry for close function
5200 F2D9 4C F8                 DC W:g_status                  ; entry for status function
5201 F2DB 26 FA                 DC W:g_control                 ; entry for control function
5202 F2DD 54 FB                 DC W:g_flush                   ; entry for flush function
5203 F2DF 56 FB                 DC W:g_shutdn                  ; entry for shutdown function
5204 F2E1
5205 F2E1                       eject 
5206 F2E1              ****************************************************************
5207 F2E1              *
5208 F2E1              * This routine is used to startup a generated device driver.
5209 F2E1              * This routine will only be called by the device dispatcher
5210 F2E1              * when the device list is being constructed.
5211 F2E1              *
5212 F2E1              * ENTRY:        A Reg = Unspecified
5213 F2E1              *               X Reg = Unspecified
5214 F2E1              *               Y Reg = Unspecified
5215 F2E1              *               B Reg = Current Program Bank
5216 F2E1              *             Dir Reg = GSOS Direct Page
5217 F2E1              *               P Reg = N V M X D I Z C  E
5218 F2E1              *                       • • 0 0 0 • • •  0
5219 F2E1              *
5220 F2E1              * EXIT:         A Reg = Error code if carry set, else unspecified
5221 F2E1              *               X Reg = Unspecified
5222 F2E1              *               Y Reg = Unspecified
5223 F2E1              *               B Reg = Current Program Bank
5224 F2E1              *             Dir Reg = GSOS Direct Page
5225 F2E1              *               P Reg = N V M X D I Z C  E
5226 F2E1              *                       • • 0 0 0 • • •  0
5227 F2E1              *
5228 F2E1              ****************************************************************
5229 F2E1              g_startup  
5230 F2E1                       longa on
5231 F2E1                       longi on
5232 F2E1
5233 F2E1 4C DB F1              jmp   return_no_err
5234 F2E4
5235 F2E4                       eject 
5236 F2E4              *****************************************************************
5237 F2E4              *
5238 F2E4              * ENTRY:        A Reg = Unspecified
5239 F2E4              *               X Reg = Unspecified
5240 F2E4              *               Y Reg = SmartPort Command
5241 F2E4              *               B Reg = Current Program Bank
5242 F2E4              *             Dir Reg = GS/OS Direct Page
5243 F2E4              *               P Reg = N V M X D I Z C  E
5244 F2E4              *                       • • 0 0 0 • • •  0
5245 F2E4              *
5246 F2E4              * EXIT:         A Reg = SmartPort Command
5247 F2E4              *               X Reg = Points to parameter list in bank 0
5248 F2E4              *               Y Reg = Unspecified
5249 F2E4              *               B Reg = Current Program Bank
5250 F2E4              *             Dir Reg = GS/OS Direct Page
5251 F2E4              *               P Reg = N V M X D I Z C  E
5252 F2E4              *                       • • 0 0 0 • • •  0
5253 F2E4              *
5254 F2E4              *****************************************************************
5255 F2E4              setup_sp_call  
5256 F2E4                       longa on
5257 F2E4                       longi on
5258 F2E4
5259 F2E4 AF 0F AC 00           lda   >call_list_ptr           ; get address where command resides
5260 F2E8 AA                    tax   
5261 F2E9 98                    tya                            ; set SmartPort command
5262 F2EA 9F 00 00 00           sta   >0,x
5263 F2EE A9 1D AC              lda   #param_list_ptr          ; set parameter list pointer
5264 F2F1 9F 01 00 00           sta   >1,x
5265 F2F5 A8                    tay   
5266 F2F6 A9 EA EA              lda   #$EAEA                   ; 2 nop instructions
5267 F2F9 9F 03 00 00           sta   >3,x
5268 F2FD BB                    tyx                            ; point into parameter list
5269 F2FE A0 2E 00              ldy   #slot_num                ; setup fw_addr with entry point
5270 F301 B7 20                 lda   [<drvr_dib_ptr],y
5271 F303 29 07 00              and   #$0007                   ; limit to slots 1-7
5272 F306 EB                    xba   
5273 F307 09 FF C0              ora   #$C0FF
5274 F30A 85 28                 sta   <fw_addr
5275 F30C E2 20                 sep   #$20                     ; 8 bit 'm'
5276 F30E                       longa off
5277 F30E A7 28                 lda   [<fw_addr]               ; get entry point offset from $Cn00
5278 F310 18                    clc                            ; bias for SmartPort
5279 F311 69 03                 adc   #$03
5280 F313 85 28                 sta   <fw_addr
5281 F315 C8                    iny                            ; need correct unit number from dib
5282 F316 C8                    iny   
5283 F317 B7 20                 lda   [<drvr_dib_ptr],y
5284 F319 EB                    xba   
5285 F31A A9 03                 lda   #$03                     ; parameter count is 3
5286 F31C C2 20                 rep   #$20
5287 F31E                       longa on
5288 F31E 9F 00 00 00           sta   >0,x                     ; set SmartPort pcnt & unit number
5289 F322 A9 00 AA              lda   #sys_buffer              ; buffer pointer
5290 F325 9F 02 00 00           sta   >2,x
5291 F329 60                    rts   
5292 F32A
5293 F32A                       eject 
5294 F32A              ****************************************************************
5295 F32A              *
5296 F32A              * This routine is used to open a character device driver.
5297 F32A              *
5298 F32A              * ENTRY:        A Reg = Unspecified
5299 F32A              *               X Reg = Unspecified
5300 F32A              *               Y Reg = Unspecified
5301 F32A              *               B Reg = Current Program Bank
5302 F32A              *             Dir Reg = GSOS Direct Page
5303 F32A              *               P Reg = N V M X D I Z C  E
5304 F32A              *                       • • 0 0 0 • • •  0
5305 F32A              *
5306 F32A              * EXIT:         A Reg = Error code if carry set, else unspecified
5307 F32A              *               X Reg = Unspecified
5308 F32A              *               Y Reg = Unspecified
5309 F32A              *               B Reg = Current Program Bank
5310 F32A              *             Dir Reg = GSOS Direct Page
5311 F32A              *               P Reg = N V M X D I Z C  E
5312 F32A              *                       • • 0 0 0 • • •  0
5313 F32A              *
5314 F32A              ****************************************************************
5315 F32A              g_open    
5316 F32A                       longa on
5317 F32A                       longi on
5318 F32A
5319 F32A 20 4C F3              jsr   check_if_char            ; is the device a character device
5320 F32D D0 15                 bne   g_open_done              ; no, it's a block device
5321 F32F A0 46 00              ldy   #open_flag               ; is the device already open?
5322 F332 B7 20                 lda   [<drvr_dib_ptr],y
5323 F334 30 11                 bmi   g_prior_open             ; yes, don't need to do it again
5324 F336 22 0C AC 00           jsl   bank0_dsptch             ; and issue device level open
5325 F33A B0 0F                 bcs   cant_open
5326 F33C A9 FF FF              lda   #$FFFF                   ; else set device open
5327 F33F A0 46 00              ldy   #open_flag
5328 F342 97 20                 sta   [<drvr_dib_ptr],y
5329 F344              g_open_done  
5330 F344 4C DB F1              jmp   return_no_err
5331 F347
5332 F347              g_prior_open                            ; Driver error, already open
5333 F347 A9 24 00              lda   #drvr_prior_open
5334 F34A 38                    sec   
5335 F34B              cant_open  
5336 F34B 60                    rts   
5337 F34C
5338 F34C                       eject 
5339 F34C              ****************************************************************
5340 F34C              *
5341 F34C              * This routine is used determine if the device currently being
5342 F34C              * accessed is a character device.
5343 F34C              *
5344 F34C              * ENTRY:        A Reg = Unspecified
5345 F34C              *               X Reg = Unspecified
5346 F34C              *               Y Reg = Unspecified
5347 F34C              *               B Reg = Unspecified
5348 F34C              *             Dir Reg = GSOS Direct Page
5349 F34C              *               P Reg = N V M X D I Z C  E
5350 F34C              *                       • • 0 0 0 • • •  0
5351 F34C              *
5352 F34C              * EXIT:         A Reg = Block or character device bit from characteristics
5353 F34C              *               X Reg = Unchanged
5354 F34C              *               Y Reg = Unspecified
5355 F34C              *               B Reg = Unchanged
5356 F34C              *             Dir Reg = GSOS Direct Page
5357 F34C              *               P Reg = N V M X D I Z C  E
5358 F34C              *                       x x 0 0 0 x 0 x  0      if block device
5359 F34C              *                       x x 0 0 0 x 1 x  0      if character device
5360 F34C              *
5361 F34C              ****************************************************************
5362 F34C              check_if_char  
5363 F34C                       longa on
5364 F34C                       longi on
5365 F34C
5366 F34C A0 08 00              ldy   #dev_char                ; is the device a character device
5367 F34F B7 20                 lda   [<drvr_dib_ptr],y
5368 F351 29 80 00              and   #$0080
5369 F354 60                    rts   
5370 F355
5371 F355                       eject 
5372 F355              ****************************************************************
5373 F355              *
5374 F355              * This routine is used read data from either a generated
5375 F355              * character or block device.
5376 F355              *
5377 F355              * ENTRY:        A Reg = Unspecified
5378 F355              *               X Reg = Unspecified
5379 F355              *               Y Reg = Unspecified
5380 F355              *               B Reg = Current Program Bank
5381 F355              *             Dir Reg = GSOS Direct Page
5382 F355              *               P Reg = N V M X D I Z C  E
5383 F355              *                       • • 0 0 0 • • •  0
5384 F355              *
5385 F355              * EXIT:         A Reg = Error code if carry set, else unspecified
5386 F355              *               X Reg = Unspecified
5387 F355              *               Y Reg = Unspecified
5388 F355              *               B Reg = Current Program Bank
5389 F355              *             Dir Reg = GSOS Direct Page
5390 F355              *               P Reg = N V M X D I Z C  E
5391 F355              *                       • • 0 0 0 • • •  0
5392 F355              *
5393 F355              ****************************************************************
5394 F355              g_read    
5395 F355                       longa on
5396 F355                       longi on
5397 F355
5398 F355 A0 08 00              ldy   #dev_char                ; check device for read allowed
5399 F358 B7 20                 lda   [<drvr_dib_ptr],y
5400 F35A AA                    tax   
5401 F35B 29 20 00              and   #$0020
5402 F35E D0 05                 bne   read_allowed
5403 F360 A9 4E 00              lda   #invalid_access          ; read not allowed erruh
5404 F363 38                    sec   
5405 F364 60                    rts   
5406 F365              read_allowed  
5407 F365              *
5408 F365              * Determine if the device is a character or block device.
5409 F365              *
5410 F365 8A                    txa   
5411 F366 EB                    xba   
5412 F367 2A                    rol   a
5413 F368 90 03                 bcc   char_read                ; if device is a character device
5414 F36A 4C 34 F4              jmp   block_read               ; if device is a block device
5415 F36D
5416 F36D                       eject 
5417 F36D              *
5418 F36D              * The following routine is executed only if the read call
5419 F36D              * is directed toward a character device.  A read from the
5420 F36D              * device is only allowed if the device is open.
5421 F36D              *
5422 F36D              char_read  
5423 F36D A5 14                 lda   <drvr_blk_size           ; is it a character read?
5424 F36F F0 05                 beq   char_read_ok             ; yep
5425 F371 A9 58 00              lda   #not_block_dev           ; not a block device error
5426 F374 38                    sec   
5427 F375 60                    rts   
5428 F376
5429 F376              char_read_ok  
5430 F376 A0 46 00              ldy   #open_flag               ; is device open?
5431 F379 B7 20                 lda   [<drvr_dib_ptr],y
5432 F37B D0 05                 bne   dev_is_open              ; yes
5433 F37D A9 23 00              lda   #drvr_not_open
5434 F380 38                    sec   
5435 F381 60                    rts   
5436 F382              *
5437 F382              * The device is open.  Check for device class for dispatch
5438 F382              * to proper routine.
5439 F382              *
5440 F382              dev_is_open  
5441 F382 A5 08                 lda   <drvr_req_cnt
5442 F384 05 0A                 ora   <drvr_req_cnt+2
5443 F386 D0 03                 bne   valid_req_c0
5444 F388 4C DB F1              jmp   return_no_err
5445 F38B
5446 F38B              valid_req_c0  
5447 F38B A0 40 00              ldy   #drvr_class              ; is this a class 0 character device?
5448 F38E B7 20                 lda   [<drvr_dib_ptr],y
5449 F390 29 0F 00              and   #$000F
5450 F393 D0 39                 bne   not_c0_char              ; no
5451 F395
5452 F395                       eject 
5453 F395              *
5454 F395              * Only single character I/O transactions are possible with
5455 F395              * class 0 devices.  Need to know if this is a class 0 device.
5456 F395              *
5457 F395 A0 00 00              ldy   #$0000                   ; buffer index
5458 F398              c0_char_loop  
5459 F398 5A                    phy   
5460 F399 22 0C AC 00           jsl   bank0_dsptch             ; read character from device
5461 F39D 7A                    ply   
5462 F39E 08                    php                            ; save carry
5463 F39F E2 20                 sep   #$20                     ; 8 bit 'm'
5464 F3A1                       longa off
5465 F3A1 97 04                 sta   [<drvr_buf_ptr],y        ; place returned character into buffer
5466 F3A3 C2 20                 rep   #$20                     ; 16 bit 'm'
5467 F3A5                       longa on
5468 F3A5 E6 0C                 inc   <drvr_tran_cnt           ; bump transfer count
5469 F3A7 D0 02                 bne   c0_tran_bump
5470 F3A9 E6 0E                 inc   <drvr_tran_cnt+2
5471 F3AB              c0_tran_bump  
5472 F3AB C8                    iny                            ; next buffer location
5473 F3AC D0 02                 bne   c0_buf_loc
5474 F3AE E6 06                 inc   <drvr_buf_ptr+2
5475 F3B0              c0_buf_loc  
5476 F3B0 28                    plp                            ; retrieve error status returned by bank 0
5477 F3B1 B0 06                 bcs   c0_char_err              ; if device returned an error
5478 F3B3 20 BE F3              jsr   chk_request_cnt          ; was requested count exhausted?
5479 F3B6 B0 E0                 bcs   c0_char_loop             ; no
5480 F3B8 60                    rts   
5481 F3B9
5482 F3B9              c0_char_err  
5483 F3B9 EB                    xba                            ; place error code in low byte
5484 F3BA 29 FF 00              and   #$00FF                   ; clear high byte
5485 F3BD 60                    rts                            ; and back to dispatcher
5486 F3BE
5487 F3BE              chk_request_cnt  
5488 F3BE A5 08                 lda   <drvr_req_cnt            ; was requested count exhausted?
5489 F3C0 C5 0C                 cmp   <drvr_tran_cnt
5490 F3C2 D0 08                 bne   req_pending
5491 F3C4 A5 0A                 lda   <drvr_req_cnt+2
5492 F3C6 C5 0E                 cmp   <drvr_tran_cnt+2
5493 F3C8 D0 02                 bne   req_pending
5494 F3CA 18                    clc   
5495 F3CB 60                    rts   
5496 F3CC              req_pending  
5497 F3CC 38                    sec   
5498 F3CD 60                    rts   
5499 F3CE
5500 F3CE                       eject 
5501 F3CE              *
5502 F3CE              * Class 1 devices must be double buffered if the buffer address
5503 F3CE              * is not in bank 0.  Need to know if this is a class 1 device.
5504 F3CE              *
5505 F3CE              not_c0_char  
5506 F3CE 3A                    dec   a
5507 F3CF D0 3B                 bne   not_c1_char              ; it must be a class 2 device
5508 F3D1              c1_char_loop  
5509 F3D1 38                    sec                            ; calculate remaining request count
5510 F3D2 A5 08                 lda   <drvr_req_cnt
5511 F3D4 E5 0C                 sbc   <drvr_tran_cnt
5512 F3D6 A8                    tay   
5513 F3D7 A5 0A                 lda   <drvr_req_cnt+2
5514 F3D9 E5 0E                 sbc   <drvr_tran_cnt+2
5515 F3DB D0 09                 bne   c1_req_max               ; remainder exceeds max packet
5516 F3DD C0 00 03              cpy   #768
5517 F3E0 B0 04                 bge   c1_req_max               ; remainder exceeds max packet
5518 F3E2 84 14                 sty   <drvr_blk_size           ; set remainder as size
5519 F3E4 80 05                 bra   c1_size_ok
5520 F3E6              c1_req_max  
5521 F3E6 A9 FF 02              lda   #767                     ; set request = max packet size
5522 F3E9 85 14                 sta   <drvr_blk_size
5523 F3EB              c1_size_ok  
5524 F3EB A5 04                 lda   <drvr_buf_ptr            ; setup for double buffering
5525 F3ED 85 7C                 sta   <buf_ptr
5526 F3EF A5 06                 lda   <drvr_buf_ptr+2
5527 F3F1 85 7E                 sta   <buf_ptr+2
5528 F3F3 A9 00 AA              lda   #sys_buffer
5529 F3F6 85 04                 sta   <drvr_buf_ptr
5530 F3F8 64 06                 stz   <drvr_buf_ptr+2
5531 F3FA 22 0C AC 00           jsl   bank0_dsptch             ; read character from device
5532 F3FE B0 09                 bcs   c1_err_exit
5533 F400 22 0C B1 00           jsl   system_to_buf            ; copy data to ultimate destination
5534 F404 20 BE F3              jsr   chk_request_cnt          ; was requested count exhausted?
5535 F407 B0 C8                 bcs   c1_char_loop
5536 F409              c1_err_exit  
5537 F409 64 14                 stz   <drvr_blk_size           ; $0000 for character devices
5538 F40B 60                    rts   
5539 F40C
5540 F40C                       eject 
5541 F40C              *
5542 F40C              * Class 2 devices require no double buffering.
5543 F40C              *
5544 F40C              not_c1_char  
5545 F40C              c2_char_loop  
5546 F40C 38                    sec                            ; calculate remaining request count
5547 F40D A5 08                 lda   <drvr_req_cnt
5548 F40F E5 0C                 sbc   <drvr_tran_cnt
5549 F411 A8                    tay   
5550 F412 A5 0A                 lda   <drvr_req_cnt+2
5551 F414 E5 0E                 sbc   <drvr_tran_cnt+2
5552 F416 D0 09                 bne   c2_req_max               ; remainder exceeds max packet
5553 F418 C0 00 03              cpy   #768
5554 F41B B0 04                 bge   c2_req_max               ; remainder exceeds max packet
5555 F41D 84 14                 sty   <drvr_blk_size           ; set remainder as size
5556 F41F 80 05                 bra   c2_size_ok
5557 F421              c2_req_max  
5558 F421 A9 FF 02              lda   #767                     ; set request = max packet size
5559 F424 85 14                 sta   <drvr_blk_size
5560 F426              c2_size_ok  
5561 F426 22 0C AC 00           jsl   bank0_dsptch             ; read character from device
5562 F42A B0 05                 bcs   c2_err_exit
5563 F42C 20 BE F3              jsr   chk_request_cnt          ; was requested count exhausted?
5564 F42F B0 DB                 bcs   c2_char_loop
5565 F431              c2_err_exit  
5566 F431 64 14                 stz   <drvr_blk_size           ; $0000 for character devices
5567 F433 60                    rts   
5568 F434
5569 F434                       eject 
5570 F434              *****************************************************************
5571 F434              *
5572 F434              * The following routine is executed only if the read call is
5573 F434              * directed toward a block device.  If the request count or initial
5574 F434              * block number is invalid, return with the appropriate error.
5575 F434              *
5576 F434              *****************************************************************
5577 F434              block_read  
5578 F434                       longa on
5579 F434                       longi on
5580 F434
5581 F434 20 2E F5              jsr   calc_n_blk               ; check request_cnt = block_size * n
5582 F437 90 01                 bcc   req_cnt_ok               ; ok if integral multiple
5583 F439 60                    rts                            ; else return with error
5584 F43A              req_cnt_ok  
5585 F43A A5 08                 lda   <drvr_req_cnt
5586 F43C 05 0A                 ora   <drvr_req_cnt+2
5587 F43E D0 03                 bne   valid_req_b
5588 F440 4C DB F1              jmp   return_no_err
5589 F443
5590 F443              *
5591 F443              * Generated drivers maintain a cache enable mask in
5592 F443              * the GDIB to prevent RAM or ROM disks from being
5593 F443              * cached.  Set the current cache enable based on
5594 F443              * the mask.
5595 F443              *
5596 F443              valid_req_b  
5597 F443 A0 46 00              ldy   #cache_mask
5598 F446 B7 20                 lda   [<drvr_dib_ptr],y
5599 F448 25 1A                 and   <drvr_cache
5600 F44A 85 1A                 sta   <drvr_cache
5601 F44C              *
5602 F44C              * A different algorithm is executed for class 2 devices.
5603 F44C              * Determine what class device is being used before
5604 F44C              * executing the block read.
5605 F44C              *
5606 F44C A0 40 00              ldy   #drvr_class
5607 F44F B7 20                 lda   [<drvr_dib_ptr],y
5608 F451 C9 02 00              cmp   #$0002
5609 F454 D0 03                 bne   block_read_01            ; if it's a class 0 or 1 device
5610 F456 4C C9 F4              jmp   block_read_2             ; only if it's a class 2 device
5611 F459
5612 F459                       eject 
5613 F459              *
5614 F459              * The following routine is executed for read calls directed
5615 F459              * toward class 0 or class 1 block devices.
5616 F459              *
5617 F459              block_read_01  
5618 F459 24 16                 bit   <drvr_fst_num            ; is this a deferred ID access
5619 F45B 30 2F                 bmi   c01_dev_acc              ; yes, force device access
5620 F45D 18                    clc                            ; specify block search
5621 F45E 22 04 FC 01           jsl   cache_find_blk           ; is the block in the cache?
5622 F462 B0 28                 bcs   c01_dev_acc              ; no, may want to cache it though.
5623 F464 22 3F B1 00           jsl   cache_to_buff            ; yes, read block from cache to buffer
5624 F468 A0 08 00              ldy   #dev_char                ; is device removable media?
5625 F46B B7 20                 lda   [<drvr_dib_ptr],y
5626 F46D 29 04 00              and   #$0004
5627 F470 F0 0D                 beq   c01_next_block           ; not removable - dont status
5628 F472 20 B7 F5              jsr   c0_dev_stat              ; check for disk switched error
5629 F475              *
5630 F475              * The following five lines were added to accomodate ProDOS devices that return
5631 F475              * a write protected error on a readblock call.  
5632 F475              *
5633 F475 90 08                 bcc   c01_next_block           ; if no error was returned from firmware
5634 F477 C9 2B 00              cmp   #drvr_wr_prot            ; was the error a write protect error?
5635 F47A F0 03                 beq   c01_next_block           ; Yes, ignore it (not valid error on readblock)
5636 F47C 38                    sec                            ; else normal error handling follows
5637 F47D 80 0C                 bra   c01_error
5638 F47F              c01_next_block  
5639 F47F              *
5640 F47F              * Block has been read.  Need to adjust the block address
5641 F47F              * and buffer pointer in preperation for the next read if
5642 F47F              * a multiple block transaction is in process.  If the
5643 F47F              * request count has been satisfied, no further action is required.
5644 F47F              *
5645 F47F 20 5F F5              jsr   adj_buf_ptr              ; point at next buffer
5646 F482 20 12 F5              jsr   adjust_block             ; prepare for next block
5647 F485 90 D2                 bcc   block_read_01            ; more blocks to read
5648 F487 18                    clc                            ; all done with no errors
5649 F488 A9 00 00              lda   #$0000
5650 F48B              c01_error  
5651 F48B 60                    rts   
5652 F48C              *
5653 F48C              * This routine accesses the device directly.  If the buffer
5654 F48C              * address specified in the call is not in bank0, the data
5655 F48C              * must be double buffered through the bank0 system buffer.
5656 F48C              *
5657 F48C              c01_dev_acc  
5658 F48C A5 06                 lda   <drvr_buf_ptr+2          ; is buffer in bank 0?
5659 F48E D0 1A                 bne   double_buffer            ; no, must double buffer data
5660 F490 22 0C AC 00           jsl   bank0_dsptch             ; read data from device to buffer
5661 F494 B0 F5                 bcs   c01_error                ; if error from device
5662 F496              c01_cache  
5663 F496 24 16                 bit   <drvr_fst_num            ; is this a deferred ID access
5664 F498 30 E5                 bmi   c01_next_block           ; no, dont cache this block
5665 F49A A5 1A                 lda   <drvr_cache              ; should this block be cached
5666 F49C F0 E1                 beq   c01_next_block           ; no
5667 F49E 22 08 FC 01           jsl   cache_add_blk            ; request a block from the cache
5668 F4A2 B0 DB                 bcs   c01_next_block           ; no block was available for caching
5669 F4A4 22 49 B1 00           jsl   buff_to_cache            ; copy data to cached block
5670 F4A8 80 D5                 bra   c01_next_block           ; and loop for next block
5671 F4AA              *
5672 F4AA              * Preserve the current buffer pointer while redirecting the
5673 F4AA              * current I/O request to the system buffer in bank 0.
5674 F4AA              *
5675 F4AA              double_buffer  
5676 F4AA A4 06                 ldy   <drvr_buf_ptr+2          ; save current buffer pointer
5677 F4AC A6 04                 ldx   <drvr_buf_ptr
5678 F4AE 5A                    phy   
5679 F4AF DA                    phx   
5680 F4B0 A9 00 AA              lda   #sys_buffer              ; new destination is system buffer
5681 F4B3 85 04                 sta   <drvr_buf_ptr
5682 F4B5 64 06                 stz   <drvr_buf_ptr+2
5683 F4B7 22 0C AC 00           jsl   bank0_dsptch             ; read block into system buffer
5684 F4BB FA                    plx                            ; restore current buffer pointer
5685 F4BC 7A                    ply   
5686 F4BD 84 06                 sty   <drvr_buf_ptr+2
5687 F4BF 86 04                 stx   <drvr_buf_ptr
5688 F4C1 B0 C8                 bcs   c01_error                ; if driver error
5689 F4C3 22 0C B1 00           jsl   system_to_buf            ; copy data to ultimate destination
5690 F4C7 80 CD                 bra   c01_cache                ; now execute caching
5691 F4C9
5692 F4C9                       eject 
5693 F4C9              *
5694 F4C9              * The following routine is executed for read calls
5695 F4C9              * directed toward class 2 block devices.
5696 F4C9              *
5697 F4C9              block_read_2  
5698 F4C9 24 16                 bit   <drvr_fst_num            ; force device access
5699 F4CB 30 27                 bmi   c2_dev_acc
5700 F4CD
5701 F4CD 18                    clc                            ; specify block search
5702 F4CE 22 04 FC 01           jsl   cache_find_blk           ; is the block in the cache?
5703 F4D2 B0 28                 bcs   c2_not_cached            ; no, may want to cache it though.
5704 F4D4
5705 F4D4 22 3F B1 00           jsl   cache_to_buff            ; yes, read block from cache to buffer
5706 F4D8 A0 08 00              ldy   #dev_char                ; is device removable media?
5707 F4DB B7 20                 lda   [<drvr_dib_ptr],y
5708 F4DD 29 04 00              and   #$0004
5709 F4E0 F0 05                 beq   c2_no_purge              ; not removable - dont status
5710 F4E2
5711 F4E2 20 5A F6              jsr   c2_dev_stat              ; check for disk switched error
5712 F4E5 B0 0C                 bcs   c2_error
5713 F4E7              c2_no_purge  
5714 F4E7              *
5715 F4E7              * Block has been read.  Need to adjust the block address
5716 F4E7              * and buffer pointer in preperation for the next read if
5717 F4E7              * a multiple block transaction is in process.  If the
5718 F4E7              * request count has been satisfied, no further action is required.
5719 F4E7              *
5720 F4E7 20 5F F5              jsr   adj_buf_ptr              ; adjust new buffer address
5721 F4EA 20 12 F5              jsr   adjust_block             ; prepare for next block
5722 F4ED 90 DA                 bcc   block_read_2             ; more blocks to read
5723 F4EF
5724 F4EF 18                    clc                            ; all done with no errors
5725 F4F0 A9 00 00              lda   #$0000
5726 F4F3              c2_error  
5727 F4F3 60                    rts   
5728 F4F4              *
5729 F4F4              * If block is not in cache or volume ID is zero, must force
5730 F4F4              * access to the device to read the block.
5731 F4F4              *
5732 F4F4              c2_dev_acc  
5733 F4F4 22 0C AC 00           jsl   bank0_dsptch             ; force access to the device
5734 F4F8 B0 F9                 bcs   c2_error                 ; if error from device
5735 F4FA 80 EB                 bra   c2_no_purge              ; and continue with transaction
5736 F4FC              *
5737 F4FC              * If block is not cached, action depends on the cache enable in the
5738 F4FC              * current call.  If the cache enable is zero then must force access
5739 F4FC              * to the device.  If cache enable is nonzero, a request for a block
5740 F4FC              * for caching must be made of the cache manager.  If no block is granted,
5741 F4FC              * then must force access to the device while reading only to the buffer.
5742 F4FC              * if the block is granted, the block is read from the device to the buffer
5743 F4FC              * and then transferred from the buffer to the cache.
5744 F4FC              *
5745 F4FC              c2_not_cached  
5746 F4FC A5 1A                 lda   <drvr_cache              ; is the enable = 0?
5747 F4FE F0 F4                 beq   c2_dev_acc               ; yes, force device access w/o caching
5748 F500
5749 F500 22 0C AC 00           jsl   bank0_dsptch             ; force access to the device
5750 F504 B0 ED                 bcs   c2_error                 ; if error from device
5751 F506
5752 F506 22 08 FC 01           jsl   cache_add_blk            ; request a block for caching
5753 F50A B0 04                 bcs   c2_no_cache
5754 F50C
5755 F50C 22 49 B1 00           jsl   buff_to_cache            ; copy data to the cache
5756 F510              c2_no_cache  
5757 F510 80 D5                 bra   c2_no_purge              ; and continue with transaction
5758 F512
5759 F512                       eject 
5760 F512              *****************************************************************
5761 F512              *
5762 F512              * The following routine is used to increment the block address
5763 F512              * in preperation for the next I/O transaction. Then the transfer
5764 F512              * count is compared to the request count with the carry set as a
5765 F512              * result of the compare.
5766 F512              *
5767 F512              * ENTRY:        A Reg = Unspecified
5768 F512              *               X Reg = Unspecified
5769 F512              *               Y Reg = Unspecified
5770 F512              *               B Reg = Unspecified
5771 F512              *             Dir Reg = GS/OS Direct Page
5772 F512              *               P Reg = N V M X D I Z C  E
5773 F512              *                       • • 0 0 0 • • •  0
5774 F512              *
5775 F512              * EXIT:         A Reg = Unspecified
5776 F512              *               X Reg = Unspecified
5777 F512              *               Y Reg = Unspecified
5778 F512              *               B Reg = Same as entry
5779 F512              *             Dir Reg = GS/OS Direct Page
5780 F512              *               P Reg = 16 bit 'm' & 'x'
5781 F512              *               P Reg = N V M X D I Z C  E
5782 F512              *                       • • 0 0 0 • • 1  0 if transfer count ³ request count
5783 F512              *                       • • 0 0 0 • • 0  0 if transfer count < request count
5784 F512              *
5785 F512              *****************************************************************
5786 F512              adjust_block  
5787 F512                       longa on
5788 F512                       longi on
5789 F512
5790 F512 18                    clc                            ; update transfer count
5791 F513 A5 14                 lda   <drvr_blk_size
5792 F515 65 0C                 adc   <drvr_tran_cnt
5793 F517 85 0C                 sta   <drvr_tran_cnt
5794 F519 90 02                 bcc   no_tran_carry
5795 F51B E6 0E                 inc   <drvr_tran_cnt+2
5796 F51D              no_tran_carry  
5797 F51D E6 10                 inc   <drvr_blk_num            ; point at next block
5798 F51F D0 02                 bne   no_blk_carry
5799 F521 E6 12                 inc   <drvr_blk_num+2
5800 F523              no_blk_carry  
5801 F523 A5 0E                 lda   <drvr_tran_cnt+2
5802 F525 C5 0A                 cmp   <drvr_req_cnt+2          ; compare MSB trans to req
5803 F527 90 04                 bcc   tran_req_done
5804 F529 A5 0C                 lda   <drvr_tran_cnt           ; compare LSB trans to req
5805 F52B C5 08                 cmp   <drvr_req_cnt
5806 F52D              tran_req_done  
5807 F52D 60                    rts                            ; carry set if I/O transaction done
5808 F52E
5809 F52E                       eject 
5810 F52E              *****************************************************************
5811 F52E              *
5812 F52E              * This routine is used to calculate the number of contiguous
5813 F52E              * blocks to be read from the device.  An error will be
5814 F52E              * returned if the request count is zero or is not an
5815 F52E              * integral multiple of the block size.
5816 F52E              *
5817 F52E              * ENTRY:        A Reg = Unspecified
5818 F52E              *               X Reg = Unspecified
5819 F52E              *               Y Reg = Unspecified
5820 F52E              *               B Reg = Unspecified
5821 F52E              *             Dir Reg = GS/OS Direct Page
5822 F52E              *               P Reg = N V M X D I Z C  E
5823 F52E              *                       • • 0 0 0 • • •  0
5824 F52E              *
5825 F52E              * EXIT:         A Reg = Error code or unspecified
5826 F52E              *               X Reg = Unspecified
5827 F52E              *               Y Reg = Unspecified
5828 F52E              *               B Reg = Same as entry
5829 F52E              *             Dir Reg = GS/OS Direct Page
5830 F52E              *               P Reg = N V M X D I Z C  E
5831 F52E              *                       • • 0 0 0 • • 0  0 if no error
5832 F52E              *                       • • 0 0 0 • • 1  0 if error
5833 F52E              *
5834 F52E              *****************************************************************
5835 F52E              calc_n_blk  
5836 F52E                       longa on
5837 F52E                       longi on
5838 F52E
5839 F52E A9 00 00              lda   #$0000
5840 F531 48                    pha                            ; space for remainder
5841 F532 48                    pha   
5842 F533 48                    pha                            ; space for quotient
5843 F534 48                    pha   
5844 F535 D4 0A                 pei   <drvr_req_cnt+2          ; numerator
5845 F537 D4 08                 pei   <drvr_req_cnt
5846 F539 F4 00 00              pea   $0000                    ; denominator
5847 F53C D4 14                 pei   <drvr_blk_size
5848 F53E A2 0B 0D 22           _longdivide 
5849 F545 A2 22 00              ldx   #drvr_bad_parm           ; bad parameter error
5850 F548 68                    pla                            ; number of blocks to read
5851 F549 8F 2F AC 00           sta   >block_cnt
5852 F54D 68                    pla   
5853 F54E 8F 31 AC 00           sta   >block_cnt+2
5854 F552 68                    pla                            ; remainder count
5855 F553 03 01                 ora   1,s
5856 F555 83 01                 sta   1,s
5857 F557 68                    pla   
5858 F558 B0 03                 bcs   req_error                ; if tool returned error (div by 0?)
5859 F55A F0 02                 beq   no_req_error
5860 F55C 38                    sec   
5861 F55D              req_error  
5862 F55D 8A                    txa                            ; restore error code
5863 F55E              no_req_error  
5864 F55E 60                    rts   
5865 F55F
5866 F55F                       eject 
5867 F55F              *****************************************************************
5868 F55F              *
5869 F55F              * The following routine updates the buffer pointer after a
5870 F55F              * block read.
5871 F55F              *
5872 F55F              * ENTRY:        A Reg = Error code from device
5873 F55F              *               X Reg = Transfer Count
5874 F55F              *               Y Reg = Unspecified
5875 F55F              *               B Reg = Unspecified
5876 F55F              *             Dir Reg = GS/OS Direct Page
5877 F55F              *               P Reg = N V M X D I Z C  E
5878 F55F              *                       • • 0 0 0 • • •  0
5879 F55F              *
5880 F55F              * EXIT:         A Reg = Unchanged
5881 F55F              *               X Reg = Unchanged
5882 F55F              *               Y Reg = Unchanged
5883 F55F              *               B Reg = Unchanged
5884 F55F              *             Dir Reg = Unchanged
5885 F55F              *               P Reg = N V M X D I Z C  E
5886 F55F              *                           0 0 0        0
5887 F55F              *                       x x       x x x     PRESERVED
5888 F55F              *
5889 F55F              *****************************************************************
5890 F55F              adj_buf_ptr  
5891 F55F                       longa on
5892 F55F                       longi on
5893 F55F
5894 F55F 08                    php   
5895 F560 48                    pha   
5896 F561 18                    clc                            ; adjust buffer pointer
5897 F562 A5 14                 lda   <drvr_blk_size
5898 F564 65 04                 adc   <drvr_buf_ptr
5899 F566 85 04                 sta   <drvr_buf_ptr
5900 F568 A9 00 00              lda   #$0000
5901 F56B 65 06                 adc   <drvr_buf_ptr+2
5902 F56D 85 06                 sta   <drvr_buf_ptr+2
5903 F56F 68                    pla   
5904 F570 28                    plp   
5905 F571 60                    rts   
5906 F572
5907 F572                       eject 
5908 F572              *****************************************************************
5909 F572              *
5910 F572              * The following routine sets up location FW_ADDR to point at
5911 F572              * the SmartPort entry point prior to executing a call to the
5912 F572              * midpoint entry within the bank 0 dispatcher.
5913 F572              *
5914 F572              * ENTRY:        A Reg = Unspecified
5915 F572              *               X Reg = Unspecified
5916 F572              *               Y Reg = Unspecified
5917 F572              *               B Reg = Unspecified
5918 F572              *             Dir Reg = GS/OS Direct Page
5919 F572              *               P Reg = N V M X D I Z C  E
5920 F572              *                       • • 0 0 0 • • •  0
5921 F572              *
5922 F572              * EXIT:         A Reg = Unchanged
5923 F572              *               X Reg = Unchanged
5924 F572              *               Y Reg = Unchanged
5925 F572              *               B Reg = Unchanged
5926 F572              *             Dir Reg = GS/OS Direct Page
5927 F572              *               P Reg = N V M X D I Z C  E
5928 F572              *                       • • 0 0 0 • • •  0
5929 F572              *
5930 F572              *****************************************************************
5931 F572              setup_fwaddr  
5932 F572                       longa on
5933 F572                       longi on
5934 F572
5935 F572 48                    pha   
5936 F573 5A                    phy   
5937 F574 A0 2E 00              ldy   #slot_num                ; get current device slot #
5938 F577 B7 20                 lda   [<drvr_dib_ptr],y
5939 F579 29 07 00              and   #$0007                   ; limit to internal slot ref
5940 F57C EB                    xba   
5941 F57D 09 FF C0              ora   #$C0FF                   ; now have $CnFF
5942 F580 85 28                 sta   <fw_addr
5943 F582 64 2A                 stz   <fw_addr+2
5944 F584 E2 20                 sep   #$20                     ; 8 bit 'm'
5945 F586                       longa off
5946 F586 A7 28                 lda   [<fw_addr]               ; ($CnFF)
5947 F588 18                    clc   
5948 F589 69 03                 adc   #$03
5949 F58B 85 28                 sta   <fw_addr                 ; $Cn00 + ($CnFF) + 3
5950 F58D C2 20                 rep   #$20                     ; 16 bit 'm'
5951 F58F 7A                    ply   
5952 F590 68                    pla   
5953 F591 60                    rts   
5954 F592
5955 F592                       eject 
5956 F592              *****************************************************************
5957 F592              *
5958 F592              * The following routine issues a status call to any class
5959 F592              * device to check for disk switched or offline.
5960 F592              *
5961 F592              * ENTRY:        A Reg = Unspecified
5962 F592              *               X Reg = Unspecified
5963 F592              *               Y Reg = Unspecified
5964 F592              *               B Reg = Unspecified
5965 F592              *             Dir Reg = GS/OS Direct Page
5966 F592              *               P Reg = N V M X D I Z C  E
5967 F592              *                       • • 0 0 0 • • •  0
5968 F592              *
5969 F592              * EXIT:         A Reg = Condition code
5970 F592              *               X Reg = Unchanged
5971 F592              *               Y Reg = Unchanged
5972 F592              *               B Reg = Unchanged
5973 F592              *             Dir Reg = GS/OS Direct Page
5974 F592              *               P Reg = N V M X D I Z C  E
5975 F592              *                       • • 0 0 0 • • 0  0 if no error
5976 F592              *                       • • 0 0 0 • • 1  0 if error
5977 F592              *
5978 F592              *****************************************************************
5979 F592              get_dev_stat  
5980 F592                       longa on
5981 F592                       longi on
5982 F592
5983 F592 DA                    phx   
5984 F593 5A                    phy   
5985 F594 A0 40 00              ldy   #drvr_class
5986 F597 B7 20                 lda   [<drvr_dib_ptr],y
5987 F599 29 3F 00              and   #$003F                   ; is this a class 0 device?
5988 F59C F0 1B                 beq   c0_stat_entry            ; yes
5989 F59E 3A                    dec   a                        ; is this a class 1 device?
5990 F59F F0 18                 beq   c0_stat_entry            ; yes
5991 F5A1 8B                    phb   
5992 F5A2 F4 00 00              pea   $0000                    ; data bank must point at parameter list
5993 F5A5 AB                    plb   
5994 F5A6 AB                    plb   
5995 F5A7
5996 F5A7 A0 30 00              ldy   #unit_num                ; insert the unit number into the parameter lists
5997 F5AA B7 20                 lda   [<drvr_dib_ptr],y
5998 F5AC
5999 F5AC E2 20                 sep   #$20                     ; 8 bit 'm'
6000 F5AE                       longa off
6001 F5AE
6002 F5AE 8F 61 AC 00           sta   >esp_stat3+6
6003 F5B2
6004 F5B2 C2 20                 rep   #$20                     ; 16 bit 'm'
6005 F5B4                       longa on
6006 F5B4
6007 F5B4 4C 86 F6              jmp   c2_stat_entry            ; then must be a class 2 device
6008 F5B7
6009 F5B7                       eject 
6010 F5B7              *****************************************************************
6011 F5B7              *
6012 F5B7              * The following routine issues a status call to a class 0 or 1
6013 F5B7              * device to check for disk switched.  If the device is a UniDISK3.5,
6014 F5B7              * then a condition code will be returned from the device.  All
6015 F5B7              * other class 1 devices indicate disk switched through bit 0 of
6016 F5B7              * the general status byte returned on a device status call.
6017 F5B7              *
6018 F5B7              * ENTRY:        A Reg = Unspecified
6019 F5B7              *               X Reg = Unspecified
6020 F5B7              *               Y Reg = Unspecified
6021 F5B7              *               B Reg = Unspecified
6022 F5B7              *             Dir Reg = GS/OS Direct Page
6023 F5B7              *               P Reg = N V M X D I Z C  E
6024 F5B7              *                       • • 0 0 0 • • •  0
6025 F5B7              *
6026 F5B7              * EXIT:         A Reg = Condition code
6027 F5B7              *               X Reg = Unchanged
6028 F5B7              *               Y Reg = Unchanged
6029 F5B7              *               B Reg = Unchanged
6030 F5B7              *             Dir Reg = GS/OS Direct Page
6031 F5B7              *               P Reg = N V M X D I Z C  E
6032 F5B7              *                       • • 0 0 0 • • 0  0 if no error
6033 F5B7              *                       • • 0 0 0 • • 1  0 if error
6034 F5B7              *
6035 F5B7              *****************************************************************
6036 F5B7              c0_dev_stat  
6037 F5B7                       longa on
6038 F5B7                       longi on
6039 F5B7
6040 F5B7 DA                    phx   
6041 F5B8 5A                    phy   
6042 F5B9              c0_stat_entry  
6043 F5B9 A0 40 00              ldy   #drvr_class
6044 F5BC B7 20                 lda   [<drvr_dib_ptr],y
6045 F5BE 29 3F 00              and   #$003F                   ; is this a class 0 device?
6046 F5C1 F0 3E                 beq   c0_disksw_stat           ; yes, can only check for offline
6047 F5C3 A0 30 00              ldy   #unit_num
6048 F5C6 B7 20                 lda   [<drvr_dib_ptr],y
6049 F5C8 48                    pha   
6050 F5C9 20 1B E7              jsr   setup_sp_stat            ; setup bank0 core for status call
6051 F5CC                       longa off
6052 F5CC 68                    pla                            ; need device unit number in parmlist
6053 F5CD A2 1D AC              ldx   #param_list_ptr          ; pointer to parameter list
6054 F5D0 9F 01 00 00           sta   >1,x                     ; set unit number in parameter list
6055 F5D4 68                    pla                            ; clean up stack
6056 F5D5 C2 20                 rep   #$20                     ; 16 bit 'm'
6057 F5D7                       longa on
6058 F5D7 20 72 F5              jsr   setup_fwaddr             ; fw_addr = $Cn00 + ($CnFF) + 3
6059 F5DA 22 C5 AD 00           jsl   b0_core                  ; execute device status call
6060 F5DE AA                    tax   
6061 F5DF B0 1C                 bcs   c0_dsw_done
6062 F5E1              *  ___ ___ ___ ___ ___ ___ ___ ___
6063 F5E1              * |   |   |   |   |   |   |   |   |
6064 F5E1              * | 7 | 6 | 5 | 4 | 3 | 2 | 1 | 0 | SmartPort General Status Byte
6065 F5E1              * |___|___|___|___|___|___|___|___|
6066 F5E1              *   |   |   |   |   |   |   |   |__ 1 = Disk switched
6067 F5E1              *   |   |   |   |   |   |   |______ 1 = Device currently interrupting
6068 F5E1              *   |   |   |   |   |   |__________ 1 = Write protect
6069 F5E1              *   |   |   |   |   |______________ 1 = Format allowed
6070 F5E1              *   |   |   |   |__________________ 1 = Device online or Disk in drive
6071 F5E1              *   |   |   |______________________ 1 = Read allowed
6072 F5E1              *   |   |__________________________ 1 = Write allowed
6073 F5E1              *   |______________________________ 1 = Block device
6074 F5E1              *
6075 F5E1 A2 2E 00              ldx   #drvr_disk_sw            ; assume it's switched
6076 F5E4 AF 00 AA 00           lda   >sys_buffer
6077 F5E8 49 10 00              eor   #$0010                   ; change online to offline
6078 F5EB 29 11 00              and   #$0011                   ; offline or disksw?
6079 F5EE 4A                    lsr   a
6080 F5EF B0 0C                 bcs   c0_dsw_done              ; assumed correct
6081 F5F1 38                    sec   
6082 F5F2 08                    php   
6083 F5F3 A2 2F 00              ldx   #drvr_off_line           ; assume it's offline
6084 F5F6 28                    plp   
6085 F5F7 D0 04                 bne   c0_dsw_done              ; assumed correct
6086 F5F9 A2 00 00              ldx   #no_error
6087 F5FC 18                    clc   
6088 F5FD              c0_dsw_done   
6089 F5FD 8A                    txa                            ; restore error code
6090 F5FE 7A                    ply   
6091 F5FF FA                    plx   
6092 F600 60                    rts   
6093 F601              *
6094 F601              * If a class 0 block device, can only determine online from
6095 F601              * a status call.  This will be mapped into a diskswitched
6096 F601              * error resulting in flushing the volume from the cache and
6097 F601              * a subsequent swap_out call.  Note that a status call cannot
6098 F601              * be issued to a ProFILE at this time due to firmware problems.
6099 F601              * Device specific code may be added later to handle the ProFILE.
6100 F601              *
6101 F601              c0_disksw_stat  
6102 F601 A2 00 00              ldx   #no_error                ; assume it's a ProFILE
6103 F604 18                    clc   
6104 F605 A0 34 00              ldy   #dev_id_num              ; is it a ProFILE?
6105 F608 B7 20                 lda   [<drvr_dib_ptr],y
6106 F60A 3A                    dec   a
6107 F60B F0 F0                 beq   c0_dsw_done              ; yes, it's ProFILE 5meg
6108 F60D 3A                    dec   a
6109 F60E F0 ED                 beq   c0_dsw_done              ; yes, it's ProFILE 10meg
6110 F610              *
6111 F610              * It's not a ProFILE so set up the bank 0 dispatcher to issue a
6112 F610              * status call to the ProDOS interface to determine device status.
6113 F610              *
6114 F610 AF 0F AC 00           lda   >call_list_ptr           ; insert 5 dispatcher 'NOP's
6115 F614 AA                    tax   
6116 F615 A9 EA EA              lda   #$EAEA
6117 F618 9F 00 00 00           sta   >0,x
6118 F61C 9F 02 00 00           sta   >2,x
6119 F620 9F 03 00 00           sta   >3,x
6120 F624 A0 2E 00              ldy   #slot_num                ; set up fw_addr = $Cn00 + ($CnFF)
6121 F627 B7 20                 lda   [<drvr_dib_ptr],y
6122 F629 29 07 00              and   #$0007
6123 F62C EB                    xba   
6124 F62D 09 FF C0              ora   #$C0FF
6125 F630 85 28                 sta   <fw_addr
6126 F632 64 2A                 stz   <fw_addr+2               ; fw_addr = $00Cn00 + ($00CnFF)
6127 F634 E2 20                 sep   #$20                     ; 8 bit 'm'
6128 F636                       longa off
6129 F636 A7 28                 lda   [<fw_addr]
6130 F638 85 28                 sta   <fw_addr
6131 F63A              *
6132 F63A              * Need to setup absolute direct page for dispatch to ProDOS
6133 F63A              * block device status call.  Only the slot/unit parameter
6134 F63A              * needs to be constructed as follows:
6135 F63A              *  ___ ___ ___ ___ ___ ___ ___ ___
6136 F63A              * |   |   |   |   |   |   |   |   |
6137 F63A              * | 7 | 6 | 5 | 4 | 3 | 2 | 1 | 0 | = PUNIT
6138 F63A              * |___|___|___|___|___|___|___|___|
6139 F63A              *   |   |   |   |   |___|___|___|____ UNDEFINED
6140 F63A              *   |   |___|___|____________________ SLOT NUMBER
6141 F63A              *   |________________________________ UNIT NUMBER
6142 F63A              *
6143 F63A A0 30 00              ldy   #unit_num                ; get unit number (v0.06 a02)
6144 F63D B7 20                 lda   [<drvr_dib_ptr],y
6145 F63F 3A                    dec   a
6146 F640 4A                    lsr   a                        ; unit to carry
6147 F641 08                    php   
6148 F642 A5 29                 lda   <fw_addr+1               ; get $Cn
6149 F644 6A                    ror   a
6150 F645 6A                    ror   a
6151 F646 6A                    ror   a
6152 F647 6A                    ror   a
6153 F648 28                    plp   
6154 F649 6A                    ror   a                        ; now have slot/unit
6155 F64A EB                    xba   
6156 F64B A9 00                 lda   #$00
6157 F64D C2 20                 rep   #$20                     ; 16 bit 'm'
6158 F64F                       longa on
6159 F64F 8F 42 00 00           sta   >pcmd                    ; set up for dispatch
6160 F653 22 C5 AD 00           jsl   b0_core                  ; and execute status call
6161 F657 AA                    tax                            ; return device status
6162 F658 80 A3                 bra   c0_dsw_done
6163 F65A
6164 F65A                       eject 
6165 F65A              *****************************************************************
6166 F65A              *
6167 F65A              * The following routine issues a status call to a class 2 device
6168 F65A              * to check for disk switched.  Class 2 devices indicate disk
6169 F65A              * switched through bit 0 of the general status byte returned
6170 F65A              * on a device status call.
6171 F65A              *
6172 F65A              * ENTRY:        A Reg = Unspecified
6173 F65A              *               X Reg = Unspecified
6174 F65A              *               Y Reg = Unspecified
6175 F65A              *               B Reg = K
6176 F65A              *             Dir Reg = GS/OS Direct Page
6177 F65A              *               P Reg = N V M X D I Z C  E
6178 F65A              *                       • • 0 0 0 • • •  0
6179 F65A              *
6180 F65A              * EXIT:         A Reg = Condition code
6181 F65A              *               X Reg = Unchanged
6182 F65A              *               Y Reg = Unchanged
6183 F65A              *               B Reg = Unchanged
6184 F65A              *             Dir Reg = GS/OS Direct Page
6185 F65A              *               P Reg = N V M X D I Z C  E
6186 F65A              *                       • • 0 0 0 • • 0  0 if no error
6187 F65A              *                       • • 0 0 0 • • 1  0 if error
6188 F65A              *
6189 F65A              *****************************************************************
6190 F65A              c2_dev_stat  
6191 F65A                       longa on
6192 F65A                       longi on
6193 F65A
6194 F65A DA                    phx   
6195 F65B 5A                    phy   
6196 F65C 8B                    phb   
6197 F65D
6198 F65D F4 00 00              pea   $0000                    ; point data bank at call list bank
6199 F660 AB                    plb   
6200 F661 AB                    plb   
6201 F662
6202 F662 A0 30 00              ldy   #unit_num                ; insert the unit number into the parameter lists
6203 F665 B7 20                 lda   [<drvr_dib_ptr],y
6204 F667
6205 F667 E2 20                 sep   #$20                     ; 8 bit 'm'
6206 F669                       longa off
6207 F669
6208 F669 8F 55 AC 00           sta   >sp_stat3+4
6209 F66D 8F 61 AC 00           sta   >esp_stat3+6
6210 F671
6211 F671 C2 20                 rep   #$20                     ; 16 bit 'm'
6212 F673                       longa on
6213 F673
6214 F673 A0 40 00              ldy   #drvr_class              ; is this SmartPort or extended SmartPort?
6215 F676 B7 20                 lda   [<drvr_dib_ptr],y
6216 F678 3A                    dec   a
6217 F679 D0 0B                 bne   c2_stat_entry            ; it's extended SmartPort
6218 F67B
6219 F67B A2 51 AC              ldx   #sp_stat3                ; X = pointer to call list
6220 F67E A5 00                 lda   <drvr_dev_num            ; execute SmartPort call
6221 F680 22 80 FC 01           jsl   to_b0_core
6222 F684 80 09                 bra   sp_stat_check
6223 F686
6224 F686              c2_stat_entry  
6225 F686 A2 5B AC              ldx   #esp_stat3               ; X = pointer to call list
6226 F689 A5 00                 lda   <drvr_dev_num            ; execute extended SmartPort call
6227 F68B 22 80 FC 01           jsl   to_b0_core
6228 F68F
6229 F68F                       eject 
6230 F68F              *
6231 F68F              *  ___ ___ ___ ___ ___ ___ ___ ___
6232 F68F              * |   |   |   |   |   |   |   |   |
6233 F68F              * | 7 | 6 | 5 | 4 | 3 | 2 | 1 | 0 | SmartPort General Status Byte
6234 F68F              * |___|___|___|___|___|___|___|___|
6235 F68F              *   |   |   |   |   |   |   |   |__ 1 = Disk switched
6236 F68F              *   |   |   |   |   |   |   |______ 1 = Device currently interrupting
6237 F68F              *   |   |   |   |   |   |__________ 1 = Write protect
6238 F68F              *   |   |   |   |   |______________ 1 = Format allowed
6239 F68F              *   |   |   |   |__________________ 1 = Device online or Disk in drive
6240 F68F              *   |   |   |______________________ 1 = Read allowed
6241 F68F              *   |   |__________________________ 1 = Write allowed
6242 F68F              *   |______________________________ 1 = Block device
6243 F68F              *
6244 F68F              sp_stat_check  
6245 F68F AB                    plb   
6246 F690 A2 00 00              ldx   #$0000                   ; assume no error
6247 F693 AF 00 AA 00           lda   >sys_buffer              ; get general status byte
6248 F697 6A                    ror   a                        ; bit 0 = DISKSW
6249 F698 B0 05                 bcs   c2_dsw_stat              ; if disk switch occured
6250 F69A 29 08 00              and   #$0008                   ; is device off line?
6251 F69D D0 04                 bne   c2_dsw_done              ; no
6252 F69F              c2_dsw_stat  
6253 F69F 38                    sec   
6254 F6A0 A2 2E 00              ldx   #drvr_disk_sw            ; else report error
6255 F6A3              c2_dsw_done  
6256 F6A3 8A                    txa                            ; restore error code
6257 F6A4 7A                    ply   
6258 F6A5 FA                    plx   
6259 F6A6 60                    rts   
6260 F6A7
6261 F6A7                       eject 
6262 F6A7              ****************************************************************
6263 F6A7              *
6264 F6A7              * This routine is used to write to either a character or a
6265 F6A7              * block device. Note that a deferred write mode has been
6266 F6A7              * implemented for block devices.  If a block has a cache
6267 F6A7              * priority of =>$8000 then the block will only be written
6268 F6A7              * to the device if a cached block is not available for the
6269 F6A7              * data.  If a cached block is available then the data will
6270 F6A7              * be written to the cache and NOT to the device.
6271 F6A7              *
6272 F6A7              * ENTRY:        A Reg = Unspecified
6273 F6A7              *               X Reg = Unspecified
6274 F6A7              *               Y Reg = Unspecified
6275 F6A7              *               B Reg = Current Program Bank
6276 F6A7              *             Dir Reg = GSOS Direct Page
6277 F6A7              *               P Reg = N V M X D I Z C  E
6278 F6A7              *                       • • 0 0 0 • • •  0
6279 F6A7              *
6280 F6A7              * EXIT:         A Reg = Error code if carry set, else unspecified
6281 F6A7              *               X Reg = Unspecified
6282 F6A7              *               Y Reg = Unspecified
6283 F6A7              *               B Reg = Current Program Bank
6284 F6A7              *             Dir Reg = GSOS Direct Page
6285 F6A7              *               P Reg = N V M X D I Z C  E
6286 F6A7              *                       • • 0 0 0 • • •  0
6287 F6A7              *
6288 F6A7              ****************************************************************
6289 F6A7              g_write   
6290 F6A7                       longa on
6291 F6A7                       longi on
6292 F6A7
6293 F6A7 A0 08 00              ldy   #dev_char                ; check device for write allowed
6294 F6AA B7 20                 lda   [<drvr_dib_ptr],y
6295 F6AC AA                    tax   
6296 F6AD 29 40 00              and   #$0040
6297 F6B0 D0 05                 bne   write_allowed
6298 F6B2 A9 4E 00              lda   #invalid_access          ; write not allowed erruh
6299 F6B5 38                    sec   
6300 F6B6 60                    rts   
6301 F6B7              write_allowed  
6302 F6B7              *
6303 F6B7              * Determine if the device is a character or block device.
6304 F6B7              *
6305 F6B7 8A                    txa   
6306 F6B8 EB                    xba   
6307 F6B9 2A                    rol   a
6308 F6BA 90 03                 bcc   char_write               ; it's a character device
6309 F6BC 4C 76 F7              jmp   block_write              ; it's a block device
6310 F6BF
6311 F6BF                       eject 
6312 F6BF              *
6313 F6BF              * The following routine is executed only if the write call
6314 F6BF              * is directed toward a character device.
6315 F6BF              *
6316 F6BF              char_write  
6317 F6BF A5 14                 lda   <drvr_blk_size           ; is it a character read?
6318 F6C1 F0 05                 beq   char_write_ok            ; yep
6319 F6C3 A9 58 00              lda   #not_block_dev           ; not a block device error
6320 F6C6 38                    sec   
6321 F6C7 60                    rts   
6322 F6C8
6323 F6C8              char_write_ok  
6324 F6C8 A0 46 00              ldy   #open_flag               ; is device open?
6325 F6CB B7 20                 lda   [<drvr_dib_ptr],y
6326 F6CD D0 05                 bne   device_is_open           ; yes
6327 F6CF A9 23 00              lda   #drvr_not_open
6328 F6D2 38                    sec   
6329 F6D3 60                    rts   
6330 F6D4              *
6331 F6D4              * The device is open.  Only single character I/O transactions
6332 F6D4              * are possible with class 0 devices.  Need to know if this is
6333 F6D4              * a class 0 device.
6334 F6D4              *
6335 F6D4              device_is_open  
6336 F6D4 A5 08                 lda   <drvr_req_cnt            ; any request?
6337 F6D6 05 0A                 ora   <drvr_req_cnt+2
6338 F6D8 D0 03                 bne   valid_req_c0w
6339 F6DA 4C DB F1              jmp   return_no_err
6340 F6DD
6341 F6DD              valid_req_c0w  
6342 F6DD A0 40 00              ldy   #drvr_class              ; is this a class 0 character device?
6343 F6E0 B7 20                 lda   [<drvr_dib_ptr],y
6344 F6E2 29 0F 00              and   #$000F
6345 F6E5 D0 27                 bne   not_cl0_char             ; no
6346 F6E7 A0 00 00              ldy   #$0000                   ; buffer index
6347 F6EA              cl0_char_loop  
6348 F6EA E2 20                 sep   #$20                     ; 8 bit 'm'
6349 F6EC                       longa off
6350 F6EC B7 04                 lda   [<drvr_buf_ptr],y
6351 F6EE C2 20                 rep   #$20                     ; 16 bit 'm'
6352 F6F0                       longa on
6353 F6F0 5A                    phy   
6354 F6F1 22 0C AC 00           jsl   bank0_dsptch             ; read character from device
6355 F6F5 7A                    ply   
6356 F6F6 E6 0C                 inc   <drvr_tran_cnt           ; bump transfer count
6357 F6F8 D0 02                 bne   cl0_tran_bump
6358 F6FA E6 0E                 inc   <drvr_tran_cnt+2
6359 F6FC              cl0_tran_bump  
6360 F6FC C8                    iny                            ; next buffer location
6361 F6FD D0 02                 bne   cl0_buf_loc
6362 F6FF E6 06                 inc   <drvr_buf_ptr+2
6363 F701              cl0_buf_loc  
6364 F701 B0 06                 bcs   cl0_char_err             ; if device returned an error
6365 F703 20 BE F3              jsr   chk_request_cnt          ; was requested count exhausted?
6366 F706 B0 E2                 bcs   cl0_char_loop
6367 F708 60                    rts   
6368 F709
6369 F709              cl0_char_err  
6370 F709 EB                    xba                            ; place error code in low byte
6371 F70A 29 FF 00              and   #$00FF                   ; clear high byte
6372 F70D 60                    rts                            ; and back to dispatcher
6373 F70E
6374 F70E                       eject 
6375 F70E              *
6376 F70E              * Class 1 devices must be double buffered if the buffer address
6377 F70E              * is not in bank 0.  Need to know if this is a class 1 device.
6378 F70E              *
6379 F70E              not_cl0_char  
6380 F70E 3A                    dec   a
6381 F70F D0 3B                 bne   not_cl1_char             ; it must be a class 2 device
6382 F711              cl1_char_loop  
6383 F711 38                    sec                            ; calculate remaining request count
6384 F712 A5 08                 lda   <drvr_req_cnt
6385 F714 E5 0C                 sbc   <drvr_tran_cnt
6386 F716 A8                    tay   
6387 F717 A5 0A                 lda   <drvr_req_cnt+2
6388 F719 E5 0E                 sbc   <drvr_tran_cnt+2
6389 F71B D0 09                 bne   cl1_req_max              ; remainder exceeds max packet
6390 F71D C0 00 03              cpy   #768
6391 F720 B0 04                 bge   cl1_req_max              ; remainder exceeds max packet
6392 F722
6393 F722 84 14                 sty   <drvr_blk_size           ; set remainder as size
6394 F724 80 05                 bra   cl1_size_ok
6395 F726              cl1_req_max  
6396 F726 A9 FF 02              lda   #767                     ; set request = max packet size
6397 F729 85 14                 sta   <drvr_blk_size
6398 F72B              cl1_size_ok  
6399 F72B A5 04                 lda   <drvr_buf_ptr            ; setup for double buffering
6400 F72D 85 7C                 sta   <buf_ptr
6401 F72F A5 06                 lda   <drvr_buf_ptr+2
6402 F731 85 7E                 sta   <buf_ptr+2
6403 F733 A9 00 AA              lda   #sys_buffer
6404 F736 85 04                 sta   <drvr_buf_ptr
6405 F738 64 06                 stz   <drvr_buf_ptr+2
6406 F73A 22 0F B1 00           jsl   buf_to_system            ; copy data from ultimate destination
6407 F73E 22 0C AC 00           jsl   bank0_dsptch             ; read character from device
6408 F742 B0 05                 bcs   cl1_err_exit
6409 F744 20 BE F3              jsr   chk_request_cnt          ; was requested count exhausted?
6410 F747 B0 C8                 bcs   cl1_char_loop
6411 F749              cl1_err_exit  
6412 F749 64 14                 stz   <drvr_blk_size           ; $0000 for character devices
6413 F74B 60                    rts   
6414 F74C
6415 F74C                       eject 
6416 F74C              *
6417 F74C              * Class 2 devices require no double buffering.
6418 F74C              *
6419 F74C              not_cl1_char  
6420 F74C              cl2_char_loop  
6421 F74C 38                    sec                            ; calculate remaining request count
6422 F74D A5 08                 lda   <drvr_req_cnt
6423 F74F E5 0C                 sbc   <drvr_tran_cnt
6424 F751 A8                    tay   
6425 F752 A5 0A                 lda   <drvr_req_cnt+2
6426 F754 E5 0E                 sbc   <drvr_tran_cnt+2
6427 F756 D0 09                 bne   cl2_req_max              ; remainder exceeds max packet
6428 F758 C0 00 03              cpy   #768
6429 F75B B0 04                 bge   cl2_req_max              ; remainder exceeds max packet
6430 F75D 84 14                 sty   <drvr_blk_size           ; set remainder as size
6431 F75F 80 05                 bra   cl2_size_ok
6432 F761              cl2_req_max  
6433 F761 A9 FF 02              lda   #767                     ; set request = max packet size
6434 F764 85 14                 sta   <drvr_blk_size
6435 F766              cl2_size_ok  
6436 F766 22 0C AC 00           jsl   bank0_dsptch             ; read character from device
6437 F76A B0 07                 bcs   c2_error_exit
6438 F76C A5 0C                 lda   <drvr_tran_cnt           ; was requested count exhausted?
6439 F76E 20 BE F3              jsr   chk_request_cnt          ; was requested count exhausted?
6440 F771 B0 D9                 bcs   cl2_char_loop
6441 F773              c2_error_exit  
6442 F773 64 14                 stz   <drvr_blk_size           ; $0000 for character devices
6443 F775 60                    rts   
6444 F776
6445 F776                       eject 
6446 F776              *
6447 F776              * The following routine is executed only if the write call is
6448 F776              * directed toward a block device.  If the request count or initial
6449 F776              * block number is invalid, return with the appropriate error.
6450 F776              *
6451 F776              block_write  
6452 F776 20 2E F5              jsr   calc_n_blk               ; check request_cnt = block_size * n
6453 F779 90 01                 bcc   bwr_req_cnt_ok           ; ok if integral multiple
6454 F77B 60                    rts                            ; else return with error
6455 F77C              bwr_req_cnt_ok  
6456 F77C A5 08                 lda   <drvr_req_cnt            ; any request?
6457 F77E 05 0A                 ora   <drvr_req_cnt+2
6458 F780 D0 03                 bne   valid_req_b0w
6459 F782 4C DB F1              jmp   return_no_err
6460 F785
6461 F785              *
6462 F785              * Generated drivers maintain a cache priority mask in
6463 F785              * the GDIB to prevent RAM or ROM disks from being
6464 F785              * cached.  Set the current cache priority based on
6465 F785              * the mask.
6466 F785              *
6467 F785              valid_req_b0w  
6468 F785 A0 46 00              ldy   #cache_mask
6469 F788 B7 20                 lda   [<drvr_dib_ptr],y
6470 F78A 25 1A                 and   <drvr_cache
6471 F78C 85 1A                 sta   <drvr_cache
6472 F78E              *
6473 F78E              * A different algorithm is executed for class 2 devices.
6474 F78E              * Determine what class device is being used before
6475 F78E              * executing the block write.
6476 F78E              *
6477 F78E A0 40 00              ldy   #drvr_class
6478 F791 B7 20                 lda   [<drvr_dib_ptr],y
6479 F793 C9 02 00              cmp   #$0002
6480 F796 D0 03                 bne   block_wr_01              ; if it's a class 0 or 1 device
6481 F798 4C FB F7              jmp   block_wr_2               ; only if it's a class 2 device
6482 F79B
6483 F79B                       eject 
6484 F79B              *
6485 F79B              * The following routine is executed for write calls directed
6486 F79B              * toward class 0 or class 1 block devices.
6487 F79B              *
6488 F79B              block_wr_01  
6489 F79B 18                    clc                            ; specify block search
6490 F79C 22 04 FC 01           jsl   cache_find_blk           ; is block in cache?
6491 F7A0 90 0A                 bcc   c01_wr_cache             ; yes, write to cache
6492 F7A2 A5 1A                 lda   <drvr_cache              ; should block be cached?
6493 F7A4 F0 14                 beq   c01_wr_dev               ; no
6494 F7A6 22 08 FC 01           jsl   cache_add_blk            ; else request a block
6495 F7AA B0 0E                 bcs   c01_wr_dev               ; if block couldn't be allocated
6496 F7AC              c01_wr_cache  
6497 F7AC 22 49 B1 00           jsl   buff_to_cache            ; write block to cache
6498 F7B0 18                    clc                            ; no error in case deferred mode
6499 F7B1 24 1A                 bit   <drvr_cache              ; deferred mode?
6500 F7B3 10 05                 bpl   c01_wr_dev               ; no
6501 F7B5 20 5F F5              jsr   adj_buf_ptr              ; set next buffer address
6502 F7B8 80 36                 bra   wr01_done
6503 F7BA              c01_wr_dev  
6504 F7BA A5 06                 lda   <drvr_buf_ptr+2          ; is buffer in bank 0?
6505 F7BC D0 09                 bne   dbl_buffer               ; no, must double buffer data
6506 F7BE 22 0C AC 00           jsl   bank0_dsptch             ; write data to device from buffer
6507 F7C2 20 5F F5              jsr   adj_buf_ptr              ; set next buffer address
6508 F7C5 80 29                 bra   wr01_done
6509 F7C7              dbl_buffer  
6510 F7C7 22 0F B1 00           jsl   buf_to_system
6511 F7CB A5 04                 lda   <drvr_buf_ptr            ; save destination pointer
6512 F7CD 85 7C                 sta   <buf_ptr
6513 F7CF A5 06                 lda   <drvr_buf_ptr+2
6514 F7D1 85 7E                 sta   <buf_ptr+2
6515 F7D3 A9 00 AA              lda   #sys_buffer              ; new destination is system buffer
6516 F7D6 85 04                 sta   <drvr_buf_ptr
6517 F7D8 64 06                 stz   <drvr_buf_ptr+2
6518 F7DA 22 0C AC 00           jsl   bank0_dsptch             ; read block into system buffer
6519 F7DE 08                    php                            ; save device error flag
6520 F7DF 48                    pha                            ; save device error code
6521 F7E0 18                    clc                            ; calculate next destination address
6522 F7E1 A5 7C                 lda   <buf_ptr
6523 F7E3 65 14                 adc   <drvr_blk_size
6524 F7E5 85 04                 sta   <drvr_buf_ptr
6525 F7E7 A5 7E                 lda   <buf_ptr+2
6526 F7E9 69 00 00              adc   #$0000
6527 F7EC 85 06                 sta   <drvr_buf_ptr+2
6528 F7EE 68                    pla                            ; restore device error code
6529 F7EF 28                    plp                            ; restore device error flag
6530 F7F0              wr01_done  
6531 F7F0 B0 08                 bcs   wr_error                 ; exit if an error occured!
6532 F7F2 20 12 F5              jsr   adjust_block             ; else, prepare for next block
6533 F7F5 90 A4                 bcc   block_wr_01              ; more blocks to write
6534 F7F7 4C DB F1              jmp   return_no_err
6535 F7FA              wr_error  
6536 F7FA 60                    rts   
6537 F7FB
6538 F7FB                       eject 
6539 F7FB              *
6540 F7FB              * The following routine is executed for write calls
6541 F7FB              * directed toward class 2 block devices.
6542 F7FB              *
6543 F7FB              block_wr_2  
6544 F7FB 18                    clc                            ; specify block search
6545 F7FC 22 04 FC 01           jsl   cache_find_blk           ; is the block in the cache?
6546 F800 90 0A                 bcc   c2_wr_cache              ; yes, xfer from buf to cache
6547 F802 A5 1A                 lda   <drvr_cache              ; add to cache?
6548 F804 F0 0E                 beq   c2_wr_dev                ; no
6549 F806 22 08 FC 01           jsl   cache_add_blk            ; else add block to cache
6550 F80A B0 08                 bcs   c2_wr_dev                ; if block was not allocated
6551 F80C              c2_wr_cache  
6552 F80C 22 49 B1 00           jsl   buff_to_cache            ; yes, read block from cache to buffer
6553 F810 24 1A                 bit   <drvr_cache              ; deferred mode?
6554 F812 30 06                 bmi   c2_wr_done               ; yes, dont xfer to device
6555 F814              c2_wr_dev  
6556 F814 22 0C AC 00           jsl   bank0_dsptch             ; write through to the device
6557 F818 B0 E0                 bcs   wr_error                 ; if device returned error
6558 F81A              c2_wr_done  
6559 F81A 20 5F F5              jsr   adj_buf_ptr              ; set next buffer address
6560 F81D 20 12 F5              jsr   adjust_block             ; set next block address
6561 F820 90 D9                 bcc   block_wr_2               ; if more blocks to write
6562 F822 4C DB F1              jmp   return_no_err
6563 F825
6564 F825                       eject 
6565 F825              ****************************************************************
6566 F825              *
6567 F825              * This routine is used to close a character device driver.
6568 F825              *
6569 F825              * ENTRY:        A Reg = Unspecified
6570 F825              *               X Reg = Unspecified
6571 F825              *               Y Reg = Unspecified
6572 F825              *               B Reg = Current Program Bank
6573 F825              *             Dir Reg = GSOS Direct Page
6574 F825              *               P Reg = N V M X D I Z C  E
6575 F825              *                       • • 0 0 0 • • •  0
6576 F825              *
6577 F825              * EXIT:         A Reg = Error code if carry set, else unspecified
6578 F825              *               X Reg = Unspecified
6579 F825              *               Y Reg = Unspecified
6580 F825              *               B Reg = Current Program Bank
6581 F825              *             Dir Reg = GSOS Direct Page
6582 F825              *               P Reg = N V M X D I Z C  E
6583 F825              *                       • • 0 0 0 • • •  0
6584 F825              *
6585 F825              ****************************************************************
6586 F825              g_close   
6587 F825                       longa on
6588 F825                       longi on
6589 F825
6590 F825 20 4C F3              jsr   check_if_char            ; is the device a character device
6591 F828 D0 1B                 bne   g_close_done             ; no, it's a block device
6592 F82A A0 46 00              ldy   #open_flag               ; is the device already closed?
6593 F82D B7 20                 lda   [<drvr_dib_ptr],y
6594 F82F 10 16                 bpl   g_prior_close            ; yes, don't need to do it again
6595 F831 A9 00 00              lda   #$0000                   ; else set device closed
6596 F834 97 20                 sta   [<drvr_dib_ptr],y
6597 F836 A0 40 00              ldy   #drvr_class              ; is this a class 0 device
6598 F839 B7 20                 lda   [<drvr_dib_ptr],y
6599 F83B 29 0F 00              and   #$000F
6600 F83E F0 05                 beq   g_close_done             ; yes, dont issue a device call
6601 F840 22 0C AC 00           jsl   bank0_dsptch             ; and issue device level close
6602 F844 60                    rts   
6603 F845              g_close_done  
6604 F845 18                    clc   
6605 F846 60                    rts   
6606 F847
6607 F847              g_prior_close                           ; ; Driver error, already closed
6608 F847 A9 23 00              lda   #drvr_not_open
6609 F84A 38                    sec   
6610 F84B 60                    rts   
6611 F84C
6612 F84C                       eject 
6613 F84C              ****************************************************************
6614 F84C              *
6615 F84C              * This routine is used to startup a generated device driver.
6616 F84C              * This routine will only be called by the device dispatcher
6617 F84C              * when the device list is being constructed.
6618 F84C              *
6619 F84C              * Status calls include: $0000 Return Device Status
6620 F84C              *                       $0001 Return Control Parameters
6621 F84C              *                       $0002 Return Wait / No Wait Status
6622 F84C              *                       $0003 Return Format Options
6623 F84C              *                       $0004 Return Partition Map
6624 F84C              *
6625 F84C              * ENTRY:        A Reg = Unspecified
6626 F84C              *               X Reg = Unspecified
6627 F84C              *               Y Reg = Unspecified
6628 F84C              *               B Reg = Current Program Bank
6629 F84C              *             Dir Reg = GSOS Direct Page
6630 F84C              *               P Reg = N V M X D I Z C  E
6631 F84C              *                       • • 0 0 0 • • •  0
6632 F84C              *
6633 F84C              * EXIT:         A Reg = Error code if carry set, else unspecified
6634 F84C              *               X Reg = Unspecified
6635 F84C              *               Y Reg = Unspecified
6636 F84C              *               B Reg = Current Program Bank
6637 F84C              *             Dir Reg = GSOS Direct Page
6638 F84C              *               P Reg = N V M X D I Z C  E
6639 F84C              *                       • • 0 0 0 • • •  0
6640 F84C              *
6641 F84C              ****************************************************************
6642 F84C              g_status  
6643 F84C                       longa on
6644 F84C                       longi on
6645 F84C              *
6646 F84C              * Need to verify that the status code specifies a
6647 F84C              * legal status request.
6648 F84C              *
6649 F84C A5 16                 lda   <drvr_stat_code          ; is this a legal status request?
6650 F84E C9 05 00              cmp   #$0005
6651 F851 90 04                 blt   legal_status             ; yes
6652 F853 A9 21 00              lda   #drvr_bad_code           ; else return 'BAD CODE' error
6653 F856 60                    rts   
6654 F857              *
6655 F857              * It's a legal status.  Dispatch to the appropriate status routine.
6656 F857              *
6657 F857              legal_status  
6658 F857 0A                    asl   a
6659 F858 AA                    tax   
6660 F859 7C 1C FA              jmp   (status_dispatch,x)      ; return through appropriate handler
6661 F85C
6662 F85C                       eject 
6663 F85C              *****************************************************************
6664 F85C              *
6665 F85C              * Class 0 generated drivers do not support any meaningful device
6666 F85C              * status call.  A device status word will be generated based on
6667 F85C              * information in the DIB for class 0 devices.  Class 1 and 2 devices
6668 F85C              * support a device status call.  A SmartPort status 0 call will be
6669 F85C              * issued to these devices and the general SmartPort status byte will
6670 F85C              * be used to generate a device status word.  Character device status
6671 F85C              * is based on the open flag maintained in the GDIB.
6672 F85C              *
6673 F85C              * Status List:  Word    Device Status
6674 F85C              *               Long    Block Count
6675 F85C              *
6676 F85C              *****************************************************************
6677 F85C              dev_status  
6678 F85C                       longa on
6679 F85C                       longi on
6680 F85C
6681 F85C A2 22 00              ldx   #drvr_bad_parm           ; assume invalid request count
6682 F85F A5 0A                 lda   <drvr_req_cnt+2          ; request must be for 6 bytes!
6683 F861 D0 0C                 bne   to_stat_err
6684 F863              chk_lo_req  
6685 F863 A5 08                 lda   <drvr_req_cnt
6686 F865 C9 02 00              cmp   #$0002                   ; request > or = to minimum?
6687 F868 90 05                 blt   to_stat_err              ; no
6688 F86A C9 07 00              cmp   #$0007                   ; request < or = to maximum?
6689 F86D 90 03                 blt   ds_req_cnt_ok            ; yes
6690 F86F              to_stat_err  
6691 F86F 4C 20 F9              jmp   status_err
6692 F872
6693 F872              ds_req_cnt_ok  
6694 F872 20 4C F3              jsr   check_if_char            ; is the device a character device?
6695 F875 D0 3A                 bne   block_dev_s              ; no, it's a block device
6696 F877              *
6697 F877              * Character device status is returned as follows:
6698 F877              *  ___ ___ ___ ___ ___ ___ ___ ___ ___ ___ ___ ___ ___ ___ ___ ___
6699 F877              * |   |   |   |   |   |   |   |   |   |   |   |   |   |   |   |   |
6700 F877              * | F | E | D | C | B | A | 9 | 8 | 7 | 6 | 5 | 4 | 3 | 2 | 1 | 0 |
6701 F877              * |___|___|___|___|___|___|___|___|___|___|___|___|___|___|___|___|
6702 F877              *   |   |   |   |   |   |   |   |   |   |   |   |   |   |   |   |__ OPEN
6703 F877              *   |   |   |   |   |   |   |   |   |   |   |   |   |   |   |______ INTERRUPT
6704 F877              *   |   |   |   |   |   |   |   |   |   |   |   |   |___|__________ 0 RESERVED
6705 F877              *   |   |   |   |   |   |   |   |   |   |   |   |__________________ ONLINE
6706 F877              *   |   |   |   |   |   |   |   |   |   |   |______________________ BUFFER FULL
6707 F877              *   |   |   |   |___|___|___|___|___|___|__________________________ 0 RESERVED
6708 F877              *   |   |   |______________________________________________________ BACKGROUND BUSY
6709 F877              *   |   |__________________________________________________________ LINKED
6710 F877              *   |______________________________________________________________ 0 RESERVED
6711 F877              *
6712 F877 A9 10 00              lda   #%0000000000010000       ; preinitialize device status
6713 F87A 87 04                 sta   [<drvr_slist_ptr]
6714 F87C
6715 F87C A9 01 00              lda   #$0001                   ; Pascal1.1 status is request for input ready
6716 F87F 22 0C AC 00           jsl   bank0_dsptch
6717 F883 90 07                 bcc   have_c_stat              ; if no character available
6718 F885
6719 F885 A7 04                 lda   [<drvr_slist_ptr]        ; indicate buffer not empty
6720 F887 09 20 00              ora   #%0000000000100000
6721 F88A 87 04                 sta   [<drvr_slist_ptr]
6722 F88C              have_c_stat  
6723 F88C A0 46 00              ldy   #open_flag               ; driver must have a GDIB
6724 F88F B7 20                 lda   [<drvr_dib_ptr],y
6725 F891 29 01 00              and   #%0000000000000001
6726 F894 07 04                 ora   [<drvr_slist_ptr]        ; insert open/closed status bit
6727 F896 87 04                 sta   [<drvr_slist_ptr]
6728 F898
6729 F898 E2 20                 sep   #$20                     ; 8 bit 'm'
6730 F89A                       longa off
6731 F89A
6732 F89A A0 02 00              ldy   #$0002                   ; block count is zero for character
6733 F89D A9 00                 lda   #$00
6734 F89F              c_stat_loop  
6735 F89F C4 08                 cpy   <drvr_req_cnt            ; xfer data to status list
6736 F8A1 F0 05                 beq   c_stat_done
6737 F8A3 97 04                 sta   [<drvr_slist_ptr],y
6738 F8A5 C8                    iny   
6739 F8A6 80 F7                 bra   c_stat_loop
6740 F8A8              c_stat_done  
6741 F8A8
6742 F8A8 C2 20                 rep   #$20                     ; 16 bit 'b'
6743 F8AA                       longa on
6744 F8AA
6745 F8AA              dev_stat_xfer  
6746 F8AA A5 08                 lda   <drvr_req_cnt            ; set transfer count
6747 F8AC 85 0C                 sta   <drvr_tran_cnt
6748 F8AE 4C C8 F9              jmp   stat_done
6749 F8B1
6750 F8B1                       eject 
6751 F8B1              *
6752 F8B1              * Block device status is returned as follows:
6753 F8B1              *  ___ ___ ___ ___ ___ ___ ___ ___ ___ ___ ___ ___ ___ ___ ___ ___
6754 F8B1              * |   |   |   |   |   |   |   |   |   |   |   |   |   |   |   |   |
6755 F8B1              * | F | E | D | C | B | A | 9 | 8 | 7 | 6 | 5 | 4 | 3 | 2 | 1 | 0 |
6756 F8B1              * |___|___|___|___|___|___|___|___|___|___|___|___|___|___|___|___|
6757 F8B1              *   |   |   |   |   |   |   |   |   |   |   |   |   |   |   |   |__ DISK SW
6758 F8B1              *   |   |   |   |   |   |   |   |   |   |   |   |   |   |   |______ INTERRUPT
6759 F8B1              *   |   |   |   |   |   |   |   |   |   |   |   |   |   |__________ WRITE PROT
6760 F8B1              *   |   |   |   |   |   |   |   |   |   |   |   |   |______________ 0 RESERVED
6761 F8B1              *   |   |   |   |   |   |   |   |   |   |   |   |__________________ ONLINE
6762 F8B1              *   |   |   |   |___|___|___|___|___|___|__________________________ 0 RESERVED
6763 F8B1              *   |   |   |______________________________________________________ BACKGROUND BUSY
6764 F8B1              *   |   |__________________________________________________________ LINKED
6765 F8B1              *   |______________________________________________________________ BLOCK COUNT UNCERTAIN
6766 F8B1              *
6767 F8B1              block_dev_s  
6768 F8B1 A0 40 00              ldy   #drvr_class              ; is this a class 0 device?
6769 F8B4 B7 20                 lda   [<drvr_dib_ptr],y
6770 F8B6 29 0F 00              and   #$000F
6771 F8B9 D0 3B                 bne   not_class_0              ; no
6772 F8BB              *
6773 F8BB              * Class 0 device's can only return wrprot or offline as an
6774 F8BB              * error code.  Issue a status call and check the error status
6775 F8BB              * in order to generate a general status word.  Then set the
6776 F8BB              * block count based on the DIB contents.
6777 F8BB              *
6778 F8BB 22 0C AC 00           jsl   bank0_dsptch             ; call ProDOS block device
6779 F8BF A8                    tay   
6780 F8C0 A9 10 00              lda   #$0010                   ; assume media online
6781 F8C3 90 0B                 bcc   set_c0_dstat             ; assumed correct
6782 F8C5 A9 14 00              lda   #$0014                   ; else, assume write protected
6783 F8C8 C0 2B 00              cpy   #drvr_wr_prot            ; is device write protected?
6784 F8CB F0 03                 beq   set_c0_dstat             ; yes
6785 F8CD A9 00 00              lda   #$0000                   ; else it's off line
6786 F8D0              set_c0_dstat   
6787 F8D0 87 04                 sta   [<drvr_slist_ptr]
6788 F8D2 8F 00 AA 00           sta   >sys_buffer
6789 F8D6
6790 F8D6 A0 40 00              ldy   #drvr_class              ; is this a class 0 device?
6791 F8D9 B7 20                 lda   [<drvr_dib_ptr],y
6792 F8DB F0 17                 beq   to_c0_blk_stat           ; yes, DIB block count is not dynamic
6793 F8DD
6794 F8DD A0 08 00              ldy   #dev_char                ; is this a removable media device?
6795 F8E0 B7 20                 lda   [<drvr_dib_ptr],y
6796 F8E2 29 04 00              and   #$0004
6797 F8E5 F0 7D                 beq   c0_blk_stat              ; no, DIB block count is not dynamic
6798 F8E7
6799 F8E7 A0 0A 00              ldy   #blk_cnt                 ; set block count in DIB
6800 F8EA 8A                    txa   
6801 F8EB 97 20                 sta   [<drvr_dib_ptr],y
6802 F8ED C8                    iny   
6803 F8EE C8                    iny   
6804 F8EF A9 00 00              lda   #$0000
6805 F8F2 97 20                 sta   [<drvr_dib_ptr],y
6806 F8F4              to_c0_blk_stat  
6807 F8F4 80 6E                 bra   c0_blk_stat
6808 F8F6              *
6809 F8F6              * Class 1 and 2 devices may support dynamic block counts based
6810 F8F6              * on the media type currently inserted.  Issue a call to the
6811 F8F6              * device to determine the size and update the DIB prior to
6812 F8F6              * returning the status and block count.
6813 F8F6              *
6814 F8F6              not_class_0  
6815 F8F6 A0 0A 00              ldy   #blk_cnt                 ; assume that an error will occur
6816 F8F9 B7 20                 lda   [<drvr_dib_ptr],y
6817 F8FB 8F 01 AA 00           sta   >sys_buffer+1
6818 F8FF C8                    iny   
6819 F900 C8                    iny   
6820 F901 B7 20                 lda   [<drvr_dib_ptr],y
6821 F903 8F 03 AA 00           sta   >sys_buffer+3
6822 F907 22 0C AC 00           jsl   bank0_dsptch             ; call SmartPort device
6823 F90B AA                    tax                            ; save error status
6824 F90C 90 24                 bcc   no_c1_err                ; don't check error if wasnt one
6825 F90E 29 FF 00              and   #$00FF
6826 F911 C9 2E 00              cmp   #drvr_disk_sw            ; was there a disk switched error?
6827 F914 F0 10                 beq   set_dsw_off              ; yes
6828 F916 C9 2F 00              cmp   #drvr_off_line           ; was the device off line?
6829 F919 F0 17                 beq   no_c1_err                ; yes
6830 F91B C9 2B 00              cmp   #drvr_wr_prot            ; was the device write protected?
6831 F91E F0 12                 beq   no_c1_err                ; yes
6832 F920              status_err   
6833 F920 38                    sec                            ; assume error and set error flag
6834 F921 8A                    txa                            ; restore error code
6835 F922 D0 01                 bne   stat_err                 ; assumed correct
6836 F924 18                    clc   
6837 F925              stat_err  
6838 F925 60                    rts   
6839 F926
6840 F926              set_dsw_off  
6841 F926 E2 20                 sep   #$20                     ; 8 bit 'm'
6842 F928                       longa off
6843 F928
6844 F928 A9 01                 lda   #$01                     ; set media switched & offline
6845 F92A 8F 00 AA 00           sta   >sys_buffer              ; fake diskswitched status
6846 F92E
6847 F92E C2 20                 rep   #$20                     ; 16 bit 'm'
6848 F930                       longa on
6849 F930 80 00                 bra   no_c1_err
6850 F932
6851 F932                       eject 
6852 F932              *
6853 F932              * The SmartPort general status byte returned from the SmartPort
6854 F932              * status call is as follows:
6855 F932              *  ___ ___ ___ ___ ___ ___ ___ ___
6856 F932              * |   |   |   |   |   |   |   |   |
6857 F932              * | 7 | 6 | 5 | 4 | 3 | 2 | 1 | 0 |     SmartPort general status byte
6858 F932              * |___|___|___|___|___|___|___|___|
6859 F932              *   |   |   |   |   |   |   |   |___    1 = Disk Switched or Open
6860 F932              *   |   |   |   |   |   |   |_______    1 = Interrupt
6861 F932              *   |   |   |   |   |   |___________    1 = Write Protect or Data Available
6862 F932              *   |   |   |   |   |_______________    1 = Format Allowed
6863 F932              *   |   |   |   |___________________    1 = Online
6864 F932              *   |   |   |_______________________    1 = Read Allowed
6865 F932              *   |   |___________________________    1 = Write Allowed
6866 F932              *   |_______________________________    1 = Block Device, 0 = Character Device
6867 F932              *
6868 F932              * Device manager D_INFO call has DRVR_SLIST_PTR set to the
6869 F932
6870 F932              * SYS_BUFFER.  Updating the status word will write over the
6871 F932              * block count so update the block count in the DIB prior to
6872 F932              * returning the device status.
6873 F932              *
6874 F932              no_c1_err  
6875 F932 A0 08 00              ldy   #dev_char                ; is this a removable media device?
6876 F935 B7 20                 lda   [<drvr_dib_ptr],y
6877 F937 29 04 00              and   #$0004
6878 F93A F0 1D                 beq   c1_static                ; yes, DIB block count is not dynamic
6879 F93C
6880 F93C AF 00 AA 00           lda   >sys_buffer              ; is device online?
6881 F940 29 10 00              and   #$0010
6882 F943 F0 14                 beq   c1_static                ; no, dynamic DIB block count cannot be determined
6883 F945
6884 F945 A0 0A 00              ldy   #blk_cnt                 ; adjust block count in DIB
6885 F948 AF 01 AA 00           lda   >sys_buffer+1
6886 F94C 97 20                 sta   [<drvr_dib_ptr],y
6887 F94E C8                    iny   
6888 F94F C8                    iny   
6889 F950 AF 03 AA 00           lda   >sys_buffer+3
6890 F954 29 FF 00              and   #$00FF
6891 F957 97 20                 sta   [<drvr_dib_ptr],y
6892 F959              *
6893 F959              * Now it is safe to return the general status word.
6894 F959              *
6895 F959              c1_static  
6896 F959 AF 00 AA 00           lda   >sys_buffer              ; get SmartPort general status byte
6897 F95D 29 17 00              and   #$0017                   ; mask for GS/OS status
6898 F960 8F 00 AA 00           sta   >sys_buffer
6899 F964              *
6900 F964              * Obtain the block count from the DIB and stuff it into the
6901 F964              * caller's status list.
6902 F964              *
6903 F964              c0_blk_stat  
6904 F964 A0 0A 00              ldy   #blk_cnt                 ; get block count in DIB
6905 F967 B7 20                 lda   [<drvr_dib_ptr],y
6906 F969 8F 02 AA 00           sta   >sys_buffer+2
6907 F96D AA                    tax   
6908 F96E C8                    iny   
6909 F96F C8                    iny   
6910 F970 B7 20                 lda   [<drvr_dib_ptr],y
6911 F972 8F 04 AA 00           sta   >sys_buffer+4
6912 F976
6913 F976              *
6914 F976              * Copy status information to status list as specified by
6915 F976              * the current request count.
6916 F976              *
6917 F976              get_blk_stat  
6918 F976 E2 20                 sep   #$20                     ; 8 bit 'm'
6919 F978                       longa off
6920 F978
6921 F978 A0 00 00              ldy   #$0000
6922 F97B BB                    tyx   
6923 F97C              b_stat_loop   
6924 F97C BF 00 AA 00           lda   >sys_buffer,x
6925 F980 97 04                 sta   [<drvr_slist_ptr],y
6926 F982 E8                    inx   
6927 F983 C8                    iny   
6928 F984 C4 08                 cpy   <drvr_req_cnt
6929 F986 D0 F4                 bne   b_stat_loop
6930 F988
6931 F988 C2 20                 rep   #$20                     ; 16 bit 'm'
6932 F98A                       longa on
6933 F98A              *
6934 F98A              * Check for a disk switched or offline condition.  If either of these
6935 F98A              * conditions exist then a disk switch must be posted to the system service
6936 F98A              * call tables for cache/vcr management.
6937 F98A              *
6938 F98A A7 04                 lda   [<drvr_slist_ptr]        ; get current status
6939 F98C 49 10 00              eor   #$0010                   ; is device offline or disk switched?
6940 F98F 29 11 00              and   #$0011
6941 F992 F0 04                 beq   dev_stat_xfer0           ; no
6942 F994 22 90 FC 01           jsl   set_disksw               ; else, swapout and del_cache_vol
6943 F998              dev_stat_xfer0  
6944 F998 A5 14                 lda   <drvr_blk_size           ; is this a standard block?
6945 F99A C9 00 02              cmp   #512
6946 F99D D0 07                 bne   std_blk_ok               ; yes
6947 F99F A7 04                 lda   [<drvr_slist_ptr]
6948 F9A1 09 00 80              ora   #$8000                   ; set unvalidated block count bit
6949 F9A4 87 04                 sta   [<drvr_slist_ptr]
6950 F9A6              std_blk_ok  
6951 F9A6 4C AA F8              jmp   dev_stat_xfer
6952 F9A9
6953 F9A9                       eject 
6954 F9A9              *****************************************************************
6955 F9A9              *
6956 F9A9              * Generated drivers have no configuration parameter list.
6957 F9A9              *
6958 F9A9              * Status List:  Word    Length of configuration parameter list
6959 F9A9              *               Data    Configuration parameter list
6960 F9A9              *
6961 F9A9              *****************************************************************
6962 F9A9              get_ctrl_parm  
6963 F9A9                       longa on
6964 F9A9                       longi on
6965 F9A9
6966 F9A9                       eject 
6967 F9A9              *****************************************************************
6968 F9A9              *
6969 F9A9              * Generated drivers only operate in wait moded since there is
6970 F9A9              * no way to find out if data is available from a device.
6971 F9A9              *
6972 F9A9              * Status List:  Word    Wait Mode
6973 F9A9              *
6974 F9A9              *****************************************************************
6975 F9A9              get_wait_stat  
6976 F9A9                       longa on
6977 F9A9                       longi on
6978 F9A9
6979 F9A9 A2 22 00              ldx   #drvr_bad_parm           ; assume that the request count is invalid
6980 F9AC A5 0A                 lda   <drvr_req_cnt+2          ; is the request count = $00000002?
6981 F9AE F0 03                 beq   get_wait                 ; yes, do the call
6982 F9B0              x_stat_err  
6983 F9B0 4C 20 F9              jmp   status_err               ; else exit with error
6984 F9B3              get_wait  
6985 F9B3 A5 08                 lda   <drvr_req_cnt            ; was any data requested?
6986 F9B5 F0 0F                 beq   nil_req                  ; no, no error & exit
6987 F9B7 C9 02 00              cmp   #$0002                   ; were the correct number of bytes requested?
6988 F9BA D0 F4                 bne   x_stat_err               ; no
6989 F9BC              give_em_squat  
6990 F9BC A9 00 00              lda   #$0000                   ; return NO WAIT status
6991 F9BF 87 04                 sta   [<drvr_slist_ptr]
6992 F9C1              set_tran_cnt  
6993 F9C1 A9 02 00              lda   #$0002                   ; update transfer count
6994 F9C4 85 0C                 sta   <drvr_tran_cnt
6995 F9C6              nil_req   
6996 F9C6 80 00                 bra   stat_done
6997 F9C8
6998 F9C8              *****************************************************************
6999 F9C8              *
7000 F9C8              * Generated drivers do not support partitioning.  No partition map
7001 F9C8              * will be returned in the status list.
7002 F9C8              *
7003 F9C8              * Status List:  To be defined...
7004 F9C8              *
7005 F9C8              *****************************************************************
7006 F9C8              get_partition  
7007 F9C8                       longa on
7008 F9C8                       longi on
7009 F9C8
7010 F9C8              stat_done  
7011 F9C8 A9 00 00              lda   #$0000                   ; no error from this call
7012 F9CB 18                    clc   
7013 F9CC 60                    rts   
7014 F9CD
7015 F9CD                       eject 
7016 F9CD              *****************************************************************
7017 F9CD              *
7018 F9CD              * Generated drivers have limited support of the get format options
7019 F9CD              * status call.  This call is issued directly to SmartPort devices.
7020 F9CD              * If an error results, a default options list will be returned.
7021 F9CD              * If an error is not generated, the list returned from the SmartPort
7022 F9CD              * device is passed to the caller verbatim.
7023 F9CD              *
7024 F9CD              * Status List:  Word    Entry count
7025 F9CD              *               Word    Displayed entry count
7026 F9CD              *               Word    Recommended default option
7027 F9CD              *               Word    Option that current media is formatted
7028 F9CD              * 16 byte entry:
7029 F9CD              *               Word    Refnum
7030 F9CD              *               Word    Linknum
7031 F9CD              *               Word    Flags
7032 F9CD              *               Long    Block count
7033 F9CD              *               Word    Block size
7034 F9CD              *               Word    Interleave factor
7035 F9CD              *               Word    Media size
7036 F9CD              *
7037 F9CD              *****************************************************************
7038 F9CD              get_format  
7039 F9CD                       longa on
7040 F9CD                       longi on
7041 F9CD
7042 F9CD              *
7043 F9CD              * Character Devices and class 0 block devices do not support this call.
7044 F9CD              *
7045 F9CD A0 40 00              ldy   #drvr_class
7046 F9D0 B7 20                 lda   [<drvr_dib_ptr],y
7047 F9D2 C9 02 00              cmp   #$0002
7048 F9D5 D0 42                 bne   no_options               ; don't dispatch if can't get options
7049 F9D7
7050 F9D7 A0 44 00              ldy   #drvr_subtype            ; does this device support it?
7051 F9DA B7 20                 lda   [<drvr_dib_ptr],y
7052 F9DC 29 40 00              and   #$0040                   ; bit 6 = SuperCalls ...
7053 F9DF F0 38                 beq   no_options               ; device doesnt support fmt options
7054 F9E1 A9 22 00              lda   #drvr_bad_parm           ; assume bad request count
7055 F9E4 A6 0A                 ldx   <drvr_req_cnt+2          ; verify request count
7056 F9E6 D0 31                 bne   no_options               ; if invalid request count
7057 F9E8
7058 F9E8 E2 20                 sep   #$20                     ; 8 bit 'm'
7059 F9EA                       longa off
7060 F9EA
7061 F9EA 4B                    phk   
7062 F9EB F4 00 00              pea   $0000
7063 F9EE AB                    plb   
7064 F9EF AB                    plb   
7065 F9F0
7066 F9F0 A0 30 00              ldy   #unit_num                ; install unit for device call
7067 F9F3 B7 20                 lda   [<drvr_dib_ptr],y
7068 F9F5 8D 3D AC              sta   |get_fmt_unit
7069 F9F8
7070 F9F8 C2 20                 rep   #$20                     ; 16 bit 'm'
7071 F9FA                       longa on
7072 F9FA
7073 F9FA A5 04                 lda   <drvr_slist_ptr
7074 F9FC 8D 3E AC              sta   |get_fmt_slist
7075 F9FF A5 06                 lda   <drvr_slist_ptr+2
7076 FA01 8D 40 AC              sta   |get_fmt_slist+2
7077 FA04 A5 08                 lda   <drvr_req_cnt            ; and list buffer size
7078 FA06 8D 42 AC              sta   |get_fmt_reqcnt
7079 FA09
7080 FA09 A2 37 AC              ldx   #get_fmt_list            ; execute device call
7081 FA0C A5 00                 lda   <drvr_dev_num
7082 FA0E 22 80 FC 01           jsl   to_b0_core
7083 FA12 AB                    plb   
7084 FA13
7085 FA13 B0 04                 bcs   no_options               ; no options if call unsuccessful
7086 FA15 A5 08                 lda   <drvr_req_cnt            ; else indicate buffer size
7087 FA17 85 0C                 sta   <drvr_tran_cnt
7088 FA19
7089 FA19              no_options  
7090 FA19 4C DB F1              jmp   return_no_err
7091 FA1C
7092 FA1C                       eject 
7093 FA1C              *****************************************************************
7094 FA1C              *
7095 FA1C              * The following table is used to dispatch to status functions
7096 FA1C              * specified by the status code passed on GS/OS direct page.
7097 FA1C              *
7098 FA1C              *****************************************************************
7099 FA1C 5C F8        status_dispatch DC W:dev_status
7100 FA1E A9 F9                 DC W:get_ctrl_parm
7101 FA20 A9 F9                 DC W:get_wait_stat
7102 FA22 CD F9                 DC W:get_format
7103 FA24 C8 F9                 DC W:get_partition
7104 FA26
7105 FA26                       eject 
7106 FA26              ****************************************************************
7107 FA26              *
7108 FA26              * This routine is used to startup a generated device driver.
7109 FA26              * This routine will only be called by the device dispatcher
7110 FA26              * when the device list is being constructed.
7111 FA26              *
7112 FA26              * Control call: $0000   Reset Device
7113 FA26              *               $0001   Format Device
7114 FA26              *               $0002   Eject Media
7115 FA26              *               $0003   Set Control Parameters
7116 FA26              *               $0004   Set Wait / No Wait Mode
7117 FA26              *               $0005   Set Format Options
7118 FA26              *               $0006   Set Partition Owner
7119 FA26              *               $0007   Arm Signal
7120 FA26              *               $0008   Disarm Signal
7121 FA26              *               $0009   Set Partition Map
7122 FA26              *       $000A - $7FFF   Reserved by Apple Computer, Inc.
7123 FA26              *       $8000 - $FFFF   Device Specific
7124 FA26              *
7125 FA26              * ENTRY:        A Reg = Unspecified
7126 FA26              *               X Reg = Unspecified
7127 FA26              *               Y Reg = Unspecified
7128 FA26              *               B Reg = Current Program Bank
7129 FA26              *             Dir Reg = GSOS Direct Page
7130 FA26              *               P Reg = 16 bit 'm' & 'x' native mode
7131 FA26              *
7132 FA26              * EXIT:         A Reg = Error code if carry set, else unspecified
7133 FA26              *               X Reg = Unspecified
7134 FA26              *               Y Reg = Unspecified
7135 FA26              *               B Reg = Current Program Bank
7136 FA26              *             Dir Reg = GSOS Direct Page
7137 FA26              *               P Reg = 16 bit 'm' & 'x' native mode
7138 FA26              *
7139 FA26              ****************************************************************
7140 FA26              g_control  
7141 FA26                       longa on
7142 FA26                       longi on
7143 FA26
7144 FA26              *
7145 FA26              * Need to verify that the control code specifies a
7146 FA26              * legal control request.
7147 FA26              *
7148 FA26 A5 16                 lda   <drvr_ctrl_code          ; is this a legal control request?
7149 FA28 C9 0A 00              cmp   #$000A
7150 FA2B 90 04                 blt   legal_control            ; yes
7151 FA2D              bad_code_err  
7152 FA2D A9 21 00              lda   #drvr_bad_code           ; else return 'BAD CODE' error
7153 FA30 60                    rts   
7154 FA31              *
7155 FA31              * It's a legal control request.  Dispatch to the appropriate control routine.
7156 FA31              *
7157 FA31              legal_control  
7158 FA31 0A                    asl   a
7159 FA32 AA                    tax   
7160 FA33 7C 3E FB              jmp   (ctrl_dispatch,x)        ;return through appropriate handler
7161 FA36
7162 FA36                       eject 
7163 FA36              *****************************************************************
7164 FA36              *
7165 FA36              * This routine supports the device reset call.  Note that class
7166 FA36              * 0 devices cannot be reset.  Also, of class 1 devices, the UniDisk3.5
7167 FA36              * requires special attention.  The reset call does not work properly
7168 FA36              * on this device.  Instead, an execute call will be issued to this
7169 FA36              * device with an address of $E7D9.  This address forces all original
7170 FA36              * hooks to be restored within the UniDisk3.5.  This entry point is
7171 FA36              * supported on all versions of the UniDisk3.5 firmware.  All other
7172 FA36              * class 1 & 2 devices will receive a RESET call.
7173 FA36              *
7174 FA36              * Control List: None
7175 FA36              *
7176 FA36              *****************************************************************
7177 FA36              dev_reset  
7178 FA36                       longa on
7179 FA36                       longi on
7180 FA36
7181 FA36 A0 40 00              ldy   #drvr_class              ; is this a class 0 device?
7182 FA39 B7 20                 lda   [<drvr_dib_ptr],y
7183 FA3B 29 7F 00              and   #$007F
7184 FA3E D0 03                 bne   maybe_unidisk
7185 FA40 4C F0 FA              jmp   no_can_do
7186 FA43              maybe_unidisk  
7187 FA43 A0 42 00              ldy   #drvr_type               ; is it a 3.5 inch disk?
7188 FA46 B7 20                 lda   [<drvr_dib_ptr],y
7189 FA48 3A                    dec   a
7190 FA49 D0 37                 bne   do_reset                 ; no, go ahead and issue a reset
7191 FA4B C8                    iny                            ; is it a UniDisk3.5
7192 FA4C C8                    iny   
7193 FA4D B7 20                 lda   [<drvr_dib_ptr],y
7194 FA4F D0 31                 bne   do_reset                 ; no, go ahead and issue a reset
7195 FA51              *
7196 FA51              * This routine executes the RESET_HOOK routine in the UniDisk3.5 firmware.
7197 FA51              *
7198 FA51 A0 04 00              ldy   #$0004                   ; SmartPort command is CONTROL
7199 FA54 20 E4 F2              jsr   setup_sp_call            ; setup for SmartPort control call
7200 FA57 E2 20                 sep   #$20                     ; 8 bit 'm'
7201 FA59                       longa off
7202 FA59 A9 05                 lda   #$05                     ; ctrl code = Execute
7203 FA5B 9F 04 00 00           sta   >4,x
7204 FA5F C2 20                 rep   #$20                     ; 16 bit 'm'
7205 FA61                       longa on
7206 FA61 A9 06 00              lda   #$0006                   ; count word
7207 FA64 8F 00 AA 00           sta   >sys_buffer
7208 FA68 A9 00 00              lda   #$0000                   ; A = $00, X = $00
7209 FA6B 8F 02 AA 00           sta   >sys_buffer+2
7210 FA6F A9 00 24              lda   #$2400                   ; Y = $00, P   $24
7211 FA72 8F 04 AA 00           sta   >sys_buffer+4
7212 FA76 A9 D9 E7              lda   #$E7D9                   ; PC = $E7D9
7213 FA79 8F 06 AA 00           sta   >sys_buffer+6
7214 FA7D 22 C5 AD 00           jsl   b0_core                  ; execute
7215 FA81 60                    rts   
7216 FA82              do_reset  
7217 FA82 22 0C AC 00           jsl   bank0_dsptch             ; issue reset to device
7218 FA86 60                    rts   
7219 FA87
7220 FA87                       eject 
7221 FA87              *****************************************************************
7222 FA87              *
7223 FA87              * This routine is used to format a block device.  If the device is not
7224 FA87              * a block device then no action is taken and an INVALID_ACCESS error
7225 FA87              * will be returned.
7226 FA87              *
7227 FA87              * Control List: None
7228 FA87              *
7229 FA87              *****************************************************************
7230 FA87              dev_format  
7231 FA87                       longa on
7232 FA87                       longi on
7233 FA87
7234 FA87 20 4C F3              jsr   check_if_char            ; is the device a block device?
7235 FA8A F0 64                 beq   no_can_do
7236 FA8C              *
7237 FA8C              * It's a block device.  Go ahead and attempt to format the media.
7238 FA8C              *
7239 FA8C              format_blk_dev  
7240 FA8C 18                    clc   
7241 FA8D A0 08 00              ldy   #dev_char                ; is device format supported?
7242 FA90 B7 20                 lda   [<drvr_dib_ptr],y
7243 FA92 29 08 00              and   #$0008                   ; if not formattable then a=0 for no error
7244 FA95 F0 04                 beq   dont_format              ; no
7245 FA97 22 0C AC 00           jsl   bank0_dsptch             ; else issue the format
7246 FA9B              dont_format  
7247 FA9B 60                    rts   
7248 FA9C
7249 FA9C                       eject 
7250 FA9C              *****************************************************************
7251 FA9C              *
7252 FA9C              * Issue an eject to a block device.  If this call is issued to a
7253 FA9C              * character device then no action will be taken and no error will be returned.
7254 FA9C              *
7255 FA9C              * Control List: None
7256 FA9C              *
7257 FA9C              *****************************************************************
7258 FA9C              dev_eject  
7259 FA9C                       longa on
7260 FA9C                       longi on
7261 FA9C
7262 FA9C 20 4C F3              jsr   check_if_char            ; is the device a block device?
7263 FA9F F0 4F                 beq   no_can_do                ; no - no action required
7264 FAA1 A0 40 00              ldy   #drvr_class              ; is it a class 0 device
7265 FAA4 B7 20                 lda   [<drvr_dib_ptr],y
7266 FAA6 F0 48                 beq   no_can_do                ; yes - no action required
7267 FAA8 A0 42 00              ldy   #drvr_type               ; is it a UniDisk3.5 drive?
7268 FAAB B7 20                 lda   [<drvr_dib_ptr],y
7269 FAAD C9 01 00              cmp   #$0001
7270 FAB0 F0 25                 beq   do_dev_eject             ; yes, eject it!
7271 FAB2 AA                    tax   
7272 FAB3 A0 40 00              ldy   #drvr_class              ; is it a class 2 device
7273 FAB6 B7 20                 lda   [<drvr_dib_ptr],y
7274 FAB8 C9 02 00              cmp   #$0002
7275 FABB D0 33                 bne   no_can_do                ; no - no action required
7276 FABD 8A                    txa   
7277 FABE C9 05 00              cmp   #$0005                   ; is it a SCSI CD-ROM?
7278 FAC1 F0 0A                 beq   do_scsi_eject            ; yes, try to eject it
7279 FAC3 C9 06 00              cmp   #$0006                   ; is it a SCSI Tape?
7280 FAC6 F0 05                 beq   do_scsi_eject            ; yes, try to eject it
7281 FAC8 C9 07 00              cmp   #$0007                   ; is it a SCSI Hard Disk?
7282 FACB D0 23                 bne   no_can_do                ; no - no action required
7283 FACD              do_scsi_eject  
7284 FACD A0 40 00              ldy   #drvr_class              ; is this SCSI a class 2 device?
7285 FAD0 B7 20                 lda   [<drvr_dib_ptr],y
7286 FAD2 C9 02 00              cmp   #$0002
7287 FAD5 D0 19                 bne   no_can_do                ; no, don't try to eject it!
7288 FAD7              do_dev_eject  
7289 FAD7 22 0C AC 00           jsl   bank0_dsptch             ; else do eject
7290 FADB 60                    rts   
7291 FADC
7292 FADC                       eject 
7293 FADC              *****************************************************************
7294 FADC              *
7295 FADC              * This routine supports the set configuration parameter call.
7296 FADC              * Generated drivers do not support configuration parameters.
7297 FADC              *
7298 FADC              * Control List: Word    Length of control list
7299 FADC              *               Data    Configuration parameters
7300 FADC              *
7301 FADC              *****************************************************************
7302 FADC              set_ctrl  
7303 FADC                       longa on
7304 FADC                       longi on
7305 FADC
7306 FADC 80 12                 bra   no_can_do
7307 FADE
7308 FADE              *****************************************************************
7309 FADE              *
7310 FADE              * This routine supports the set wait/no wait function.  Note that only
7311 FADE              * wait mode is supported by generated drivers.  Any attempt to set no
7312 FADE              * wait mode for generated drivers results in a BAD REQUEST error.
7313 FADE              *
7314 FADE              * Control list: Word    Wait / No Wait Mode
7315 FADE              *               Long    No Wait Mode Completion Vector
7316 FADE              *
7317 FADE              *****************************************************************
7318 FADE              set_wait  
7319 FADE                       longa on
7320 FADE                       longi on
7321 FADE
7322 FADE A2 22 00              ldx   #drvr_bad_parm           ; assume that the request count is invalid
7323 FAE1 A5 0A                 lda   <drvr_req_cnt+2
7324 FAE3 D0 10                 bne   go_status_err
7325 FAE5 A5 08                 lda   <drvr_req_cnt            ; is the request count = $00000002?
7326 FAE7 C9 02 00              cmp   #$0002
7327 FAEA D0 09                 bne   go_status_err            ; no, error
7328 FAEC A7 04                 lda   [<drvr_clist_ptr]        ; setting wait mode on?
7329 FAEE D0 05                 bne   go_status_err            ; no, can't do it
7330 FAF0              no_can_do  
7331 FAF0 A9 00 00              lda   #$0000                   ; no error
7332 FAF3 18                    clc   
7333 FAF4 60                    rts   
7334 FAF5
7335 FAF5 4C 20 F9     go_status_err jmp   status_err
7336 FAF8
7337 FAF8                       eject 
7338 FAF8              *****************************************************************
7339 FAF8              *
7340 FAF8              * This routine sets the format options in preperation
7341 FAF8              * for a subsequent format call.  Only class 2 SmartPort
7342 FAF8              * devices support this function.  *** NOTE *** This entire
7343 FAF8              * call was rewritten for revision v0.29.
7344 FAF8              *
7345 FAF8              * Control List: Word    Length of control list
7346 FAF8              *               Word    Format reference number
7347 FAF8              *               Word    Interleave factor
7348 FAF8              *
7349 FAF8              *****************************************************************
7350 FAF8              set_fmt   
7351 FAF8                       longa on
7352 FAF8                       longi on
7353 FAF8
7354 FAF8 A0 40 00              ldy   #drvr_class              ; is this a class 2 device
7355 FAFB B7 20                 lda   [<drvr_dib_ptr],y
7356 FAFD C9 02 00              cmp   #$0002
7357 FB00 D0 EE                 bne   no_can_do                ; no
7358 FB02
7359 FB02 4B                    phk   
7360 FB03 F4 00 00              pea   $0000
7361 FB06 AB                    plb   
7362 FB07 AB                    plb   
7363 FB08
7364 FB08 A0 30 00              ldy   #unit_num                ; set SmartPort unit #
7365 FB0B B7 20                 lda   [<drvr_dib_ptr],y
7366 FB0D 8D 4A AC              sta   |set_fmt_unit
7367 FB10
7368 FB10 A5 04                 lda   <drvr_clist_ptr          ; set SmartPort control list ptr
7369 FB12 8D 4B AC              sta   |set_fmt_clist
7370 FB15 A5 06                 lda   <drvr_clist_ptr+2
7371 FB17 8D 4D AC              sta   |set_fmt_clist+2
7372 FB1A
7373 FB1A A5 08                 lda   <drvr_req_cnt            ; set SmartPort request count
7374 FB1C 8D 4F AC              sta   |set_fmt_req
7375 FB1F
7376 FB1F A5 00                 lda   <drvr_dev_num
7377 FB21 A2 44 AC              ldx   #set_fmt_list
7378 FB24 22 5A FC E0           jsl   to_bank0_core            ; call SmartPort
7379 FB28 AB                    plb   
7380 FB29
7381 FB29 90 07                 bcc   set_fmt_done             ; if SmartPort returned with no error
7382 FB2B A5 08                 lda   <drvr_req_cnt            ; else indicate buffer size
7383 FB2D 85 0C                 sta   <drvr_tran_cnt
7384 FB2F 4C DB F1              jmp   return_no_err
7385 FB32
7386 FB32              set_fmt_done  
7387 FB32 A5 08                 lda   <drvr_req_cnt            ; indicate buffer size
7388 FB34 85 0C                 sta   <drvr_tran_cnt
7389 FB36 A5 0A                 lda   <drvr_req_cnt+2
7390 FB38 85 0E                 sta   <drvr_tran_cnt+2
7391 FB3A 80 B4                 bra   no_can_do                ; not supported
7392 FB3C
7393 FB3C                       eject 
7394 FB3C              *****************************************************************
7395 FB3C              *
7396 FB3C              * This routine is used to support partitioned devices and will
7397 FB3C              * reassign an existing partition to the current FST.  Generated
7398 FB3C              * drivers do not support this function.
7399 FB3C              *
7400 FB3C              * Control List: Word    String Length
7401 FB3C              *               String  Partition Owner
7402 FB3C              *
7403 FB3C              *****************************************************************
7404 FB3C              set_partn  
7405 FB3C                       longa on
7406 FB3C                       longi on
7407 FB3C
7408 FB3C              *****************************************************************
7409 FB3C              *
7410 FB3C              * This routine is used to arm a signal tied to a driver and
7411 FB3C              * envoked from an application.
7412 FB3C              *
7413 FB3C              * Control List: Word    Signal Code
7414 FB3C              *               Word    Priority
7415 FB3C              *               Long    Signal Handler Address
7416 FB3C              *
7417 FB3C              *****************************************************************
7418 FB3C              dev_arm   
7419 FB3C                       longa on
7420 FB3C                       longi on
7421 FB3C
7422 FB3C              *****************************************************************
7423 FB3C              *
7424 FB3C              * This routine is used to disarm a signal tied to a driver and
7425 FB3C              * envoked from an application.
7426 FB3C              *
7427 FB3C              * Control List: Word    Signal Code
7428 FB3C              *
7429 FB3C              *****************************************************************
7430 FB3C              dev_disarm  
7431 FB3C                       longa on
7432 FB3C                       longi on
7433 FB3C
7434 FB3C              *****************************************************************
7435 FB3C              *
7436 FB3C              * This routine is used to set the partition map.  This call is
7437 FB3C              * not supported by the generated driver.
7438 FB3C              *
7439 FB3C              * Control List: To be defined....
7440 FB3C              *
7441 FB3C              *****************************************************************
7442 FB3C              set_p_map  
7443 FB3C                       longa on
7444 FB3C                       longi on
7445 FB3C
7446 FB3C 80 B2                 bra   no_can_do
7447 FB3E
7448 FB3E                       eject 
7449 FB3E              *****************************************************************
7450 FB3E              *
7451 FB3E              * The following table is used to dispatch to status functions
7452 FB3E              * specified by the status code passed on GS/OS direct page.
7453 FB3E              *
7454 FB3E              *****************************************************************
7455 FB3E 36 FA        ctrl_dispatch DC W:dev_reset
7456 FB40 87 FA                 DC W:dev_format
7457 FB42 9C FA                 DC W:dev_eject
7458 FB44 DC FA                 DC W:set_ctrl
7459 FB46 DE FA                 DC W:set_wait
7460 FB48 F8 FA                 DC W:set_fmt
7461 FB4A 3C FB                 DC W:set_partn
7462 FB4C 3C FB                 DC W:dev_arm
7463 FB4E 3C FB                 DC W:dev_disarm
7464 FB50 2D FA                 DC W:bad_code_err
7465 FB52 3C FB                 DC W:set_p_map
7466 FB54
7467 FB54                       eject 
7468 FB54              ****************************************************************
7469 FB54              *
7470 FB54              * This routine is used to write any data remaining in a drivers
7471 FB54              * internal buffer to the device in preperation for a driver
7472 FB54              * shutdown call.
7473 FB54              *
7474 FB54              * ENTRY:        A Reg = Unspecified
7475 FB54              *               X Reg = Unspecified
7476 FB54              *               Y Reg = Unspecified
7477 FB54              *               B Reg = Current Program Bank
7478 FB54              *             Dir Reg = GSOS Direct Page
7479 FB54              *               P Reg = N V M X D I Z C  E
7480 FB54              *                       • • 0 0 0 • • •  0
7481 FB54              *
7482 FB54              * EXIT:         A Reg = Error code if carry set, else unspecified
7483 FB54              *               X Reg = Unspecified
7484 FB54              *               Y Reg = Unspecified
7485 FB54              *               B Reg = Current Program Bank
7486 FB54              *             Dir Reg = GSOS Direct Page
7487 FB54              *               P Reg = N V M X D I Z C  E
7488 FB54              *                       • • 0 0 0 • • •  0
7489 FB54              *
7490 FB54              ****************************************************************
7491 FB54              g_flush   
7492 FB54                       longa on
7493 FB54                       longi on
7494 FB54
7495 FB54 18                    clc   
7496 FB55 60                    rts   
7497 FB56
7498 FB56                       eject 
7499 FB56              ****************************************************************
7500 FB56              *
7501 FB56              * This call is issued to a device to shutdown the device prior
7502 FB56              * to purging a driver from the device list.  The driver will
7503 FB56              * release any system resources it has aquired as a result of
7504 FB56              * the driver startup call or an open call.  If neccessary, a
7505 FB56              * close call will be issued to the device.
7506 FB56              *
7507 FB56              * ENTRY:        A Reg = Unspecified
7508 FB56              *               X Reg = Unspecified
7509 FB56              *               Y Reg = Unspecified
7510 FB56              *               B Reg = Current Program Bank
7511 FB56              *             Dir Reg = GSOS Direct Page
7512 FB56              *               P Reg = N V M X D I Z C  E
7513 FB56              *                       • • 0 0 0 • • •  0
7514 FB56              *
7515 FB56              * EXIT:         A Reg = Error code if carry set, else unspecified
7516 FB56              *               X Reg = Unspecified
7517 FB56              *               Y Reg = Unspecified
7518 FB56              *               B Reg = Current Program Bank
7519 FB56              *             Dir Reg = GSOS Direct Page
7520 FB56              *               P Reg = N V M X D I Z C  E
7521 FB56              *                       • • 0 0 0 • • •  0
7522 FB56              *
7523 FB56              ****************************************************************
7524 FB56              g_shutdn  
7525 FB56                       longa on
7526 FB56                       longi on
7527 FB56
7528 FB56 A0 40 00              ldy   #drvr_class              ; is this a class 0 or 2 device?
7529 FB59 B7 20                 lda   [<drvr_dib_ptr],y
7530 FB5B 29 01 00              and   #$0001
7531 FB5E F0 0E                 beq   g_shutdn_done            ; yes, dont need to dispatch
7532 FB60
7533 FB60 A0 34 00              ldy   #dev_id_num              ; is it a LIRON?
7534 FB63 B7 20                 lda   [<drvr_dib_ptr],y
7535 FB65 C9 03 00              cmp   #$0003
7536 FB68 F0 04                 beq   g_shutdn_done            ; yes
7537 FB6A              not_liron  
7538 FB6A 22 0C AC 00           jsl   bank0_dsptch             ; execute device reset call
7539 FB6E              g_shutdn_done  
7540 FB6E 4C DB F1              jmp   return_no_err
7541 FB71
7542 FB71                       eject 
7543 FB71              *****************************************************************
7544 FB71              *
7545 FB71              * ROUTINE:      GET_DNUM
7546 FB71              *
7547 FB71              * This routine searches the DIB tables for each device that
7548 FB71              * has been installed into the device list to determine the
7549 FB71              * device number for a given device name.  The device names
7550 FB71              * contained in the DIB's must be in UPPER case.  The search
7551 FB71              * will be case insensitive (bit 5 will be masked).  Note that
7552 FB71              * devices names contained within the DIB are real ASCII, not
7553 FB71              * Apple-ASCII (in other words, the MSB is cleared).
7554 FB71              *
7555 FB71              * ENTRY: via a 'JSL'
7556 FB71              *               A Reg = Unspecified
7557 FB71              *               X Reg = Low word pointer to P-String
7558 FB71              *               Y Reg = High word pointer to P-String
7559 FB71              *               B Reg = Unspecified
7560 FB71              *             Dir Reg = GS/OS Direct Page
7561 FB71              *               P Reg = N V M X D I Z C  E
7562 FB71              *                       • • 0 0 0 • • •  0
7563 FB71              *
7564 FB71              * EXIT: return via an 'RTL'
7565 FB71              *               A Reg = Error code if error, Device number if no error
7566 FB71              *               X Reg = Low word pointer to P-String
7567 FB71              *               Y Reg = High word pointer to P-String
7568 FB71              *               B Reg = Unspecified
7569 FB71              *             Dir Reg = GS/OS Direct Page
7570 FB71              *               P Reg = N V M X D I Z C  E
7571 FB71              *                       • • 0 0 0 • • 0  0 if no error & A Reg = DevNum
7572 FB71              *                       • • 0 0 0 • • 1  0 if error & A Reg = Error Code
7573 FB71              *
7574 FB71              *****************************************************************
7575 FB71                       export get_dnum
7576 FB71              get_dnum  
7577 FB71                       longa on
7578 FB71                       longi on
7579 FB71
7580 FB71 8B                    phb   
7581 FB72 4B                    phk   
7582 FB73 AB                    plb   
7583 FB74 86 28                 stx   <fw_addr                 ; set pointer for indirection
7584 FB76 84 2A                 sty   <fw_addr+2
7585 FB78 A5 00                 lda   <drvr_dev_num            ; preserve last device accessed
7586 FB7A 48                    pha   
7587 FB7B A7 24                 lda   [<drvr_dev_ptr]          ; get total number of devices
7588 FB7D 85 00                 sta   <drvr_dev_num
7589 FB7F              id_dev_loop  
7590 FB7F 20 5B E7              jsr   set_dib_ptr              ; set pointer to the devices dib
7591 FB82 E2 20                 sep   #$20                     ; 8 bit 'm'
7592 FB84                       longa off
7593 FB84 A0 0E 00              ldy   #dev_name                ; point at device name count byte
7594 FB87 B7 20                 lda   [<drvr_dib_ptr],y
7595 FB89 8D 4E FC              sta   |char_cnt                ; char_cnt = length of name in DIB
7596 FB8C C7 28                 cmp   [<fw_addr]               ; same application character count?
7597 FB8E F0 76                 beq   check_dev_name           ; yes, see if it's the same name
7598 FB90 C2 20                 rep   #$20                     ; 16 bit 'm'
7599 FB92                       longa on
7600 FB92 C6 00                 dec   <drvr_dev_num            ; point at next device
7601 FB94 D0 E9                 bne   id_dev_loop              ; $0001 is last device
7602 FB96              cant_find_it  
7603 FB96              *
7604 FB96              * If cant find name check for .Dn or .Dnn.  If either of these
7605 FB96              * cases is found then convert the ascii number suffix to a hex
7606 FB96              * number and return it as the device number.
7607 FB96              *
7608 FB96 A0 01 00              ldy   #$0001                   ; make sure it's a 'D'
7609 FB99 B7 28                 lda   [<fw_addr],y
7610 FB9B 29 5F 00              and   #$005F                   ; strip high bit and convert to upper
7611 FB9E C9 44 00              cmp   #$0044                   ; uppercase 'D'
7612 FBA1 D0 59                 bne   not_dot_d_n              ; sorry, no .xn, only .Dn
7613 FBA3 C8                    iny   
7614 FBA4 A7 28                 lda   [<fw_addr]               ; get application string length
7615 FBA6 29 FF 00              and   #$00FF
7616 FBA9 C9 02 00              cmp   #$0002                   ; is it a .Dn format?
7617 FBAC F0 0C                 beq   strip_n                  ; yes
7618 FBAE C9 03 00              cmp   #$0003                   ; is it a .Dnn format?
7619 FBB1 D0 49                 bne   not_dot_d_n              ; no
7620 FBB3              strip_nn  
7621 FBB3 B7 28                 lda   [<fw_addr],y             ; copy n portion of string
7622 FBB5 8D 50 FC              sta   |dn_string
7623 FBB8 80 0C                 bra   convert_it
7624 FBBA              strip_n   
7625 FBBA B7 28                 lda   [<fw_addr],y             ; copy n portion of string
7626 FBBC 29 FF 00              and   #$00FF
7627 FBBF 09 00 20              ora   #$2000
7628 FBC2 8D 50 FC              sta   |dn_string
7629 FBC5 88                    dey   
7630 FBC6              convert_it  
7631 FBC6 48                    pha                            ; space for result
7632 FBC7 F4 E0 00              pea   dn_string>>16            ; pointer to string
7633 FBCA F4 50 FC              pea   dn_string
7634 FBCD 5A                    phy                            ; length of string
7635 FBCE F4 00 00              pea   $0000                    ; not a signed integer
7636 FBD1 A2 0B 28 22           _dec2int 
7637 FBD8 68                    pla                            ; assume it was legal
7638 FBD9 B0 21                 bcs   not_dot_d_n              ; no
7639 FBDB F0 1F                 beq   not_dot_d_n              ; bad dev num!
7640 FBDD 85 00                 sta   <drvr_dev_num            ; assume it's good & set device number
7641 FBDF 20 5B E7              jsr   set_dib_ptr              ; set DIB pointer so device type can be checked
7642 FBE2 A5 00                 lda   <drvr_dev_num            ; but is it really a good device number?
7643 FBE4 C7 24                 cmp   [<drvr_dev_ptr]
7644 FBE6 90 3E                 blt   have_n                   ; good dev num!
7645 FBE8 F0 3C                 beq   have_n                   ; good dev num!
7646 FBEA              *
7647 FBEA              * REVISION: v0.04 a05
7648 FBEA              * If .Dnn and nn exceeds device count, return invalid_dev_num.
7649 FBEA              *
7650 FBEA 68                    pla                            ; restore device number
7651 FBEB 20 F4 FB              jsr   leave_dib_alone
7652 FBEE AB                    plb   
7653 FBEF 38                    sec                            ; invalid device number error
7654 FBF0 A9 11 00              lda   #invalid_dev_num
7655 FBF3 6B                    rtl   
7656 FBF4
7657 FBF4              leave_dib_alone  
7658 FBF4 F0 05                 beq   leave_dib
7659 FBF6
7660 FBF6 85 00                 sta   <drvr_dev_num
7661 FBF8 20 5B E7              jsr   set_dib_ptr
7662 FBFB              leave_dib  
7663 FBFB 60                    rts   
7664 FBFC
7665 FBFC              not_dot_d_n  
7666 FBFC 68                    pla                            ; restore device number
7667 FBFD 20 F4 FB              jsr   leave_dib_alone
7668 FC00 AB                    plb   
7669 FC01 38                    sec                            ; device not found error
7670 FC02 A9 10 00              lda   #dev_not_found
7671 FC05 6B                    rtl   
7672 FC06              *
7673 FC06              * Device name has same number of characters as pathname so
7674 FC06              * check the device name against the pathname.
7675 FC06              *
7676 FC06              *     [<drvr_dib_ptr] = pointer to current device's DIB
7677 FC06              *          [<fw_addr] = pointer to search name (P-String)
7678 FC06              *               A Reg = character count
7679 FC06              *               X Reg = Unspecified
7680 FC06              *               Y Reg = points at device name character count in DIB
7681 FC06              *
7682 FC06              check_dev_name  
7683 FC06                       longa off
7684 FC06                       longi on
7685 FC06
7686 FC06 C8                    iny                            ; point at first characters
7687 FC07 A2 01 00              ldx   #$0001
7688 FC0A              check_name_loop  
7689 FC0A 5A                    phy   
7690 FC0B 9B                    txy   
7691 FC0C B7 28                 lda   [<fw_addr],y             ; character from P-String
7692 FC0E 29 7F                 and   #%01111111               ; make sure MSB off
7693 FC10 7A                    ply   
7694 FC11 C9 61                 cmp   #'a'                     ; $00-60 does not need case changed
7695 FC13 90 06                 blt   case_ok
7696 FC15 C9 7B                 cmp   #$7B                     ; $7B-7F does not need case changed
7697 FC17 B0 02                 bge   case_ok
7698 FC19 29 DF                 and   #%11011111
7699 FC1B              case_ok   
7700 FC1B D7 20                 cmp   [<drvr_dib_ptr],y
7701 FC1D D0 23                 bne   wrong_dev                ; name miscompared
7702 FC1F E8                    inx                            ; point at next character
7703 FC20 C8                    iny   
7704 FC21 CE 4E FC              dec   |char_cnt
7705 FC24 D0 E4                 bne   check_name_loop
7706 FC26
7707 FC26              have_n    
7708 FC26 C2 20                 rep   #$20                     ; 16 bit 'm'
7709 FC28                       longa on
7710 FC28
7711 FC28 A0 08 00              ldy   #dev_char                ; is this a character device?
7712 FC2B B7 20                 lda   [<drvr_dib_ptr],y
7713 FC2D EB                    xba   
7714 FC2E 29 00 80              and   #$8000
7715 FC31 49 00 80              eor   #$8000
7716 FC34 8F F8 B9 00           sta   >char_dev_flag           ; flag = $8000 if character device or $0000 if block device
7717 FC38
7718 FC38 A6 00                 ldx   <drvr_dev_num            ; current devnum is it
7719 FC3A 68                    pla                            ; restore device number
7720 FC3B 20 F4 FB              jsr   leave_dib_alone
7721 FC3E AB                    plb   
7722 FC3F 18                    clc                            ; no error, A will have devnum
7723 FC40 8A                    txa   
7724 FC41 6B                    rtl   
7725 FC42
7726 FC42              wrong_dev  
7727 FC42                       longa off
7728 FC42 C2 20                 rep   #$20                     ; 16 bit 'm'
7729 FC44                       longa on
7730 FC44 C6 00                 dec   <drvr_dev_num            ; next device to check
7731 FC46 F0 03                 beq   cant_find_what           ; error if no more devices
7732 FC48 4C 7F FB              jmp   id_dev_loop              ; check if more devices
7733 FC4B              cant_find_what  
7734 FC4B 4C 96 FB              jmp   cant_find_it
7735 FC4E
7736 FC4E 00 00        char_cnt DC W:0                         ; number of characters
7737 FC50 00 00        dn_string DC W:0                        ; string .Dn or .Dnn conversion
7738 FC52
7739 FC52                       export console_string
7740 FC52 07           console_string DC B:7                   ; this string is required by the INIT Manager
7741 FC53 43 4F 4E 53           DC B:'CONSOLE'
7742 FC5A
7743 FC5A                       eject 
7744 FC5A              ****************************************************************
7745 FC5A              *
7746 FC5A              * This routine is used to set up the bank 0 core routine for
7747 FC5A              * a dispatch.  This routine assumes a GDIB is located
7748 FC5A              * contiguous to the DIB for the device being accessed.
7749 FC5A              *
7750 FC5A              * WARNING:      This call can only be called from within a
7751 FC5A              *               device driver.  Note that bank 0 of the
7752 FC5A              *               language card must be banked in.
7753 FC5A              *
7754 FC5A              * ENTRY: via a 'JSL'
7755 FC5A              *               A Reg = Undefined
7756 FC5A              *               X Reg = Pointer to dispatcher list
7757 FC5A              *               Y Reg = Unspecified
7758 FC5A              *               B Reg = Dispatcher list Bank
7759 FC5A              *             Dir Reg = Unspecified
7760 FC5A              *         DIB Pointer = Pointer to DIB containing slot & class
7761 FC5A              *               P Reg = N V M X D I Z C  E
7762 FC5A              *                       • • 0 0 0 • • •  0
7763 FC5A              *
7764 FC5A              * EXIT:         A Reg = Error code if carry set, else unspecified
7765 FC5A              *               X Reg = Unspecified
7766 FC5A              *               Y Reg = Unspecified
7767 FC5A              *               B Reg = Unchanged
7768 FC5A              *             Dir Reg = Unchanged
7769 FC5A              *               P Reg = N V M X D I Z C  E
7770 FC5A              *                       • • 0 0 0 • • •  0
7771 FC5A              *
7772 FC5A              ****************************************************************
7773 FC5A                       export to_bank0_core
7774 FC5A              to_bank0_core  
7775 FC5A                       longa on
7776 FC5A                       longi on
7777 FC5A
7778 FC5A 0B                    phd                            ; need GS/OS direct page
7779 FC5B 8B                    phb   
7780 FC5C F4 00 BD              pea   direct_base
7781 FC5F 2B                    pld   
7782 FC60 A0 40 00              ldy   #drvr_class              ; is this a class 1 or 2 device?
7783 FC63 B7 20                 lda   [<drvr_dib_ptr],y
7784 FC65 29 3F 00              and   #$003F
7785 FC68 D0 07                 bne   ok_for_core              ; yes, prepare for dispatch
7786 FC6A AB                    plb   
7787 FC6B 2B                    pld   
7788 FC6C 38                    sec                            ; else return an error
7789 FC6D A9 4E 00              lda   #invalid_access
7790 FC70 6B                    rtl   
7791 FC71
7792 FC71              ok_for_core  
7793 FC71 20 77 FC              jsr   go_to_core               ; dispatch to SmartPort device
7794 FC74 AB                    plb   
7795 FC75 2B                    pld   
7796 FC76 6B                    rtl   
7797 FC77
7798 FC77                       eject 
7799 FC77              *****************************************************************
7800 FC77              *
7801 FC77              * ENTRY: via a 'JSR'
7802 FC77              *               A Reg = Unspecified
7803 FC77              *               X Reg = Pointer to dispatcher list
7804 FC77              *               Y Reg = Unspecified
7805 FC77              *               B Reg = Unspecified
7806 FC77              *             Dir Reg = GS/OS Direct Page
7807 FC77              *                       DRVR_DEV_NUM specifies current device
7808 FC77              *                       DRVR_DIB_PTR points to current DIB
7809 FC77              *               P Reg = N V M X D I Z C  E
7810 FC77              *                       • • 0 0 0 • • •  0
7811 FC77              *
7812 FC77              * EXIT:         A Reg = Error code if carry set, else unspecified
7813 FC77              *               X Reg = Unspecified
7814 FC77              *               Y Reg = Unspecified
7815 FC77              *               B Reg = Unchanged
7816 FC77              *             Dir Reg = Unchanged
7817 FC77              *               P Reg = N V M X D I Z C  E
7818 FC77              *                       • • 0 0 0 • • •  0
7819 FC77              *
7820 FC77              *****************************************************************
7821 FC77              go_to_core  
7822 FC77                       longa on
7823 FC77                       longi on
7824 FC77
7825 FC77 BD 03 00              lda   |3,x                     ; get 3 words of dispatch list
7826 FC7A 48                    pha   
7827 FC7B BD 01 00              lda   |1,x
7828 FC7E 48                    pha   
7829 FC7F BD 00 00              lda   |0,x
7830 FC82 A8                    tay   
7831 FC83 48                    pha   
7832 FC84 AF 0F AC 00           lda   >call_list_ptr           ; get address where command resides
7833 FC88 AA                    tax   
7834 FC89 68                    pla                            ; set command
7835 FC8A 9F 00 00 00           sta   >0,x
7836 FC8E 68                    pla                            ; and parameter list pointer
7837 FC8F 9F 01 00 00           sta   >1,x
7838 FC93 68                    pla   
7839 FC94 9F 03 00 00           sta   >3,x
7840 FC98 98                    tya                            ; validate extended command
7841 FC99 29 40 00              and   #$0040
7842 FC9C D0 07                 bne   do_extended              ; if extended
7843 FC9E A9 EA EA              lda   #$EAEA                   ; else patch 2 NOP's over upper pointer
7844 FCA1 9F 03 00 00           sta   >3,x
7845 FCA5              do_extended  
7846 FCA5 A0 2E 00              ldy   #slot_num                ; set up for dispatch
7847 FCA8 B7 20                 lda   [<drvr_dib_ptr],y
7848 FCAA 29 07 00              and   #$0007
7849 FCAD EB                    xba   
7850 FCAE 09 00 C0              ora   #$C000                   ; now have $Cn00
7851 FCB1 85 28                 sta   <fw_addr
7852 FCB3 64 2A                 stz   <fw_addr+2
7853 FCB5 A0 FF 00              ldy   #$00FF                   ; need #Cn00 + ($CnFF) + 3
7854 FCB8 E2 20                 sep   #$20                     ; 8 bit 'm'
7855 FCBA                       longa off
7856 FCBA B7 28                 lda   [<fw_addr],y
7857 FCBC 18                    clc   
7858 FCBD 69 03                 adc   #$03
7859 FCBF 85 28                 sta   <fw_addr
7860 FCC1 C2 20                 rep   #$20                     ; 16 bit 'm'
7861 FCC3                       longa on
7862 FCC3 22 C5 AD 00           jsl   b0_core                  ; dispatch to bank 0 core routines
7863 FCC7 60                    rts   
7864 FCC8
7865 FCC8                       eject 
7866 FCC8              ****************************************************************
7867 FCC8              *
7868 FCC8              * This routine returns the address of the bank 0 system buffer.
7869 FCC8              *
7870 FCC8              * ENTRY: via a 'JSL'
7871 FCC8              *               A Reg = Undefined
7872 FCC8              *               X Reg = Undefined
7873 FCC8              *               Y Reg = Undefined
7874 FCC8              *               B Reg = Undefined
7875 FCC8              *             Dir Reg = Undefined
7876 FCC8              *               P Reg = N V M X D I Z C  E
7877 FCC8              *                       • • 0 0 0 • • •  0
7878 FCC8              *
7879 FCC8              * EXIT:         A Reg = Unchanged
7880 FCC8              *               X Reg = Address of bank 0 system buffer
7881 FCC8              *               Y Reg = Unchanged
7882 FCC8              *               B Reg = Unchanged
7883 FCC8              *             Dir Reg = Unchanged
7884 FCC8              *               P Reg = N V M X D I Z C  E
7885 FCC8              *                       • • 0 0 0 • • •  0
7886 FCC8              *
7887 FCC8              ****************************************************************
7888 FCC8                       export get_b0_buff
7889 FCC8              get_b0_buff  
7890 FCC8                       longa on
7891 FCC8                       longi on
7892 FCC8
7893 FCC8 A2 00 AA              ldx   #sys_buffer
7894 FCCB 18                    clc   
7895 FCCC 6B                    rtl   
7896 FCCD
7897 FCCD                       eject 
7898 FCCD              ****************************************************************
7899 FCCD              *
7900 FCCD              * This is the supervisory dispatcher.  It is responsible for
7901 FCCD              * dispatching to the correct supervisory driver.  Calls with
7902 FCCD              * a supervisory driver number of zero reference the dispatcher
7903 FCCD              * itself.
7904 FCCD              *
7905 FCCD              * Calls to supevisor driver dispatcher (driver #0):
7906 FCCD              *
7907 FCCD              *               $0000   Return driver number for driver ID
7908 FCCD              *               $0001   Set SIB Pointer
7909 FCCD              *
7910 FCCD              * Calls to supervisory drivers (driver #1 - n):
7911 FCCD              *
7912 FCCD              *               $0000   Startup
7913 FCCD              *               $0001   Shutdown
7914 FCCD              *               $0002   Call specified in parameter block
7915 FCCD              *
7916 FCCD              * ENTRY: via a 'JSL'
7917 FCCD              *               A Reg = Supervisory Driver Number
7918 FCCD              *               X Reg = Call Number
7919 FCCD              *               Y Reg = Supervisory ID
7920 FCCD              *               B Reg = Dispatcher list Bank
7921 FCCD              *             Dir Reg = Unspecified
7922 FCCD              *               P Reg = N V M X D I C Z  E
7923 FCCD              *                       • • 0 0 0 • • •  0
7924 FCCD              *
7925 FCCD              * EXIT: via an 'RTL'
7926 FCCD              *               A Reg = Error code
7927 FCCD              *               X Reg = Supervisory driver number
7928 FCCD              *               Y Reg = Unspecified
7929 FCCD              *               B Reg = Unchanged
7930 FCCD              *             Dir Reg = Unchanged
7931 FCCD              *               P Reg = N V M X D I C Z  E
7932 FCCD              *                       • • 0 0 0 • • •  0
7933 FCCD              *
7934 FCCD              ****************************************************************
7935 FCCD                       export supervisory
7936 FCCD              supervisory  
7937 FCCD                       longa on
7938 FCCD                       longi on
7939 FCCD
7940 FCCD 8B                    phb   
7941 FCCE 4B                    phk   
7942 FCCF AB                    plb   
7943 FCD0 48                    pha                            ; is this a driver call?
7944 FCD1 68                    pla   
7945 FCD2 D0 13                 bne   get_sib                  ; yes
7946 FCD4 8A                    txa                            ; call number
7947 FCD5 C9 02 00              cmp   #$0002                   ; get sup or get sib?
7948 FCD8 B0 07                 bge   bad_sup_call             ; if illegal call
7949 FCDA 0A                    asl   a
7950 FCDB AA                    tax   
7951 FCDC FC 0A FD              jsr   (sup_table,x)
7952 FCDF AB                    plb   
7953 FCE0 6B                    rtl   
7954 FCE1              bad_sup_call  
7955 FCE1 A9 20 00              lda   #drvr_bad_req
7956 FCE4 38                    sec   
7957 FCE5 AB                    plb   
7958 FCE6 6B                    rtl   
7959 FCE7
7960 FCE7              get_sib   
7961 FCE7 DA                    phx                            ; preserve call number
7962 FCE8 48                    pha                            ; preserve supervisor number
7963 FCE9 20 2C FD              jsr   set_sib_ptr              ; set pointer to SIB
7964 FCEC 68                    pla   
7965 FCED FA                    plx   
7966 FCEE 90 02                 bcc   have_sib
7967 FCF0 AB                    plb   
7968 FCF1 6B                    rtl   
7969 FCF2
7970 FCF2              have_sib  
7971 FCF2 48                    pha   
7972 FCF3 A0 01 00              ldy   #$0001                   ; point at supervisory entry point
7973 FCF6 A7 74                 lda   [<sib_ptr]
7974 FCF8 8D 02 FD              sta   |call_sup+1
7975 FCFB B7 74                 lda   [<sib_ptr],y
7976 FCFD 8D 03 FD              sta   |call_sup+2
7977 FD00 68                    pla   
7978 FD01              call_sup  
7979 FD01 22 00 00 00           jsl   >$000000                 ; call supervisory driver
7980 FD05 AB                    plb   
7981 FD06 6B                    rtl   
7982 FD07
7983 FD07              do_sib_ptr  
7984 FD07 98                    tya   
7985 FD08 80 22                 bra   set_sib_ptr
7986 FD0A
7987 FD0A 0E FD        sup_table DC W:get_sup_num
7988 FD0C 07 FD                 DC W:do_sib_ptr
7989 FD0E
7990 FD0E                       eject 
7991 FD0E              *****************************************************************
7992 FD0E              *
7993 FD0E              * ENTRY: via a 'JSL'
7994 FD0E              *               A Reg = Supervisory Driver Number
7995 FD0E              *               X Reg = Unspecified
7996 FD0E              *               Y Reg = Unspecified
7997 FD0E              *               B Reg = Dispatcher list Bank
7998 FD0E              *             Dir Reg = Unspecified
7999 FD0E              *               P Reg = N V M X D I C Z  E
8000 FD0E              *                       • • 0 0 0 • • •  0
8001 FD0E              *
8002 FD0E              * EXIT: via an 'RTL'
8003 FD0E              *               A Reg = Error code
8004 FD0E              *               X Reg = Supervisory driver number
8005 FD0E              *               Y Reg = Unspecified
8006 FD0E              *               B Reg = Unchanged
8007 FD0E              *             Dir Reg = Unchanged
8008 FD0E              *               P Reg = N V M X D I C Z  E
8009 FD0E              *                       • • 0 0 0 • • •  0
8010 FD0E              *
8011 FD0E              ****************************************************************
8012 FD0E              get_sup_num  
8013 FD0E                       longa on
8014 FD0E                       longi on
8015 FD0E
8016 FD0E 8C C5 E0              sty   |sup_drvr_num            ; supervisory ID to search for
8017 FD11 A9 01 00              lda   #$0001
8018 FD14              sib_search  
8019 FD14 20 2C FD              jsr   set_sib_ptr              ; point at this sib
8020 FD17 B0 12                 bcs   no_sup                   ; if cant find supervisor
8021 FD19 A0 04 00              ldy   #$0004                   ; point at supervisory ID in SIB
8022 FD1C B7 74                 lda   [<sib_ptr],y
8023 FD1E CD C5 E0              cmp   |sup_drvr_num            ; is it the ID we are searching for?
8024 FD21 F0 04                 beq   found_sup                ; yes
8025 FD23
8026 FD23 E8                    inx                            ; advance to the next driver please
8027 FD24 8A                    txa                            ; else point at next sib and
8028 FD25 80 ED                 bra   sib_search               ; continue search
8029 FD27              found_sup  
8030 FD27 A9 00 00              lda   #no_error
8031 FD2A 18                    clc   
8032 FD2B              no_sup    
8033 FD2B 60                    rts   
8034 FD2C
8035 FD2C                       eject 
8036 FD2C              *****************************************************************
8037 FD2C              *
8038 FD2C              * Supevisory driver number is valid.  Calculate the entry point in
8039 FD2C              * the supervisory driver list for this driver and set the SIB pointer
8040 FD2C              * prior to calling the driver.
8041 FD2C              *                ______________________  _
8042 FD2C              *               |_                    _|  |
8043 FD2C              *               |_ Supervisory Driver _|  |_ Device list entry count
8044 FD2C              *               |_        Count       _|  |
8045 FD2C              *               |______________________| _|
8046 FD2C              *               |_                    _|  |
8047 FD2C              *               |_    Pointer to      _|  |
8048 FD2C              *               |_        SIB         _|  |
8049 FD2C              *               |______________________|  |_ Supervisory driver entry
8050 FD2C              *               |_   Supervisor ID    _|  |
8051 FD2C              *               |______________________|  |
8052 FD2C              *               |_       User ID      _|  |
8053 FD2C              *               |______________________| _|
8054 FD2C              *
8055 FD2C              * ENTRY: via a 'JSL'
8056 FD2C              *               A Reg = Supervisory Driver Number
8057 FD2C              *               X Reg = Unspecified
8058 FD2C              *               Y Reg = Unspecified
8059 FD2C              *               B Reg = Dispatcher list Bank
8060 FD2C              *             Dir Reg = Unspecified
8061 FD2C              *               P Reg = N V M X D I C Z  E
8062 FD2C              *                       • • 0 0 0 • • •  0
8063 FD2C              *
8064 FD2C              * EXIT: via an 'RTL'
8065 FD2C              *               A Reg = Error code
8066 FD2C              *               X Reg = Supervisory driver number
8067 FD2C              *               Y Reg = Unspecified
8068 FD2C              *               B Reg = Unchanged
8069 FD2C              *             Dir Reg = Unchanged
8070 FD2C              *               P Reg = N V M X D I C Z  E
8071 FD2C              *                       • • 0 0 0 • • •  0
8072 FD2C              *
8073 FD2C              ****************************************************************
8074 FD2C              set_sib_ptr  
8075 FD2C                       longa on
8076 FD2C                       longi on
8077 FD2C
8078 FD2C AA                    tax                            ; save supervisory number
8079 FD2D C7 70                 cmp   [<sup_drvr_ptr]          ; valid supervisory driver?
8080 FD2F 90 07                 blt   valid_sup
8081 FD31 F0 05                 beq   valid_sup
8082 FD33 A9 10 00              lda   #dev_not_found
8083 FD36 38                    sec   
8084 FD37 60                    rts   
8085 FD38
8086 FD38              valid_sup  
8087 FD38 20 2C E2              jsr   times_8_plus_4           ; Y = (A * 8) + 4
8088 FD3B B7 70                 lda   [<sup_drvr_ptr],y
8089 FD3D 85 74                 sta   <sib_ptr
8090 FD3F C8                    iny   
8091 FD40 C8                    iny   
8092 FD41 B7 70                 lda   [<sup_drvr_ptr],y
8093 FD43 85 76                 sta   <sib_ptr+2
8094 FD45 4C DB F1              jmp   return_no_err
8095 FD48
8096 FD48                       eject 
8097 FD48              ****************************************************************
8098 FD48              *
8099 FD48              * This system service routine installs into the device list the
8100 FD48              * driver whose DIB address is passed in the X and Y registers.
8101 FD48              * Then a startup call is issued to the new device.  If the device
8102 FD48              * returns an error it will be purged from the device list.
8103 FD48              *
8104 FD48              * ENTRY: via a 'JSR'
8105 FD48              *               A Reg = Undefined
8106 FD48              *               X Reg = Undefined
8107 FD48              *               Y Reg = Undefined
8108 FD48              *               B Reg = Undefined
8109 FD48              *             Dir Reg = GS/OS Direct Page
8110 FD48              *               P Reg = N V M X D I Z C  E
8111 FD48              *                       • • 0 0 0 • • •  0
8112 FD48              *
8113 FD48              * EXIT: via an 'RTS'
8114 FD48              *               A Reg = Unspecified
8115 FD48              *               X Reg = Unspecified
8116 FD48              *               Y Reg = Unspecified
8117 FD48              *               B Reg = Unchanged
8118 FD48              *             Dir Reg = Unchanged
8119 FD48              *               P Reg = N V M X D I Z C  E
8120 FD48              *                       • • 0 0 0 • • •  0
8121 FD48              *
8122 FD48              ****************************************************************
8123 FD48                       export insert_driver
8124 FD48              insert_driver  
8125 FD48                       longa on
8126 FD48                       longi on
8127 FD48
8128 FD48 8B                    phb                            ; need my data bank
8129 FD49 4B                    phk   
8130 FD4A AB                    plb   
8131 FD4B
8132 FD4B A5 6C                 lda   <post_drvr_tbl           ; any drivers to install?
8133 FD4D 05 6E                 ora   <post_drvr_tbl+2
8134 FD4F D0 03                 bne   do_install               ; yes
8135 FD51 4C BD FD              jmp   none_posted              ; off to common exit
8136 FD54
8137 FD54              do_install  
8138 FD54 D4 00                 pei   <drvr_dev_num
8139 FD56 D4 02                 pei   <drvr_call_num
8140 FD58 A9 00 00              lda   #0000
8141 FD5B 8F FA B9 00           sta   >post_index
8142 FD5F
8143 FD5F              insert_loop  
8144 FD5F AF FA B9 00           lda   >post_index              ; any drivers to install?
8145 FD63 C7 6C                 cmp   [<post_drvr_tbl]
8146 FD65 F0 44                 beq   install_done             ; no
8147 FD67
8148 FD67 48                    pha   
8149 FD68 A7 24                 lda   [<drvr_dev_ptr]          ; increment device count
8150 FD6A 1A                    inc   a
8151 FD6B 87 24                 sta   [<drvr_dev_ptr]
8152 FD6D 85 00                 sta   <drvr_dev_num            ; init device number for startup
8153 FD6F 20 24 E2              jsr   set_dev_index            ; point into device list entry
8154 FD72              *
8155 FD72              * Calculate index into high DIB address in post driver list as follows:
8156 FD72              * Index = (post_index * 4) + 6
8157 FD72              * Index will be pointed at the high word of the DIB address to install.
8158 FD72              *
8159 FD72 68                    pla                            ; reference driver to install
8160 FD73 38                    sec   
8161 FD74 1A                    inc   a
8162 FD75 2A                    rol   a
8163 FD76 0A                    asl   a
8164 FD77 5A                    phy   
8165 FD78 A8                    tay   
8166 FD79 AF FA B9 00           lda   >post_index
8167 FD7D 1A                    inc   a
8168 FD7E 8F FA B9 00           sta   >post_index
8169 FD82              *
8170 FD82              * Aquire the DIB address from the post table.
8171 FD82              *
8172 FD82 B7 6C                 lda   [<post_drvr_tbl],y
8173 FD84 AA                    tax   
8174 FD85 88                    dey   
8175 FD86 88                    dey   
8176 FD87 B7 6C                 lda   [<post_drvr_tbl],y
8177 FD89 7A                    ply   
8178 FD8A              *
8179 FD8A              * Install the DIB, disk switched status and USER ID into the device list.
8180 FD8A              *
8181 FD8A 97 24                 sta   [<drvr_dev_ptr],y
8182 FD8C C8                    iny   
8183 FD8D C8                    iny   
8184 FD8E 8A                    txa   
8185 FD8F 97 24                 sta   [<drvr_dev_ptr],y
8186 FD91 C8                    iny   
8187 FD92 C8                    iny   
8188 FD93 A9 00 00              lda   #$0000                   ; init device disk switched
8189 FD96 97 24                 sta   [<drvr_dev_ptr],y
8190 FD98 C8                    iny                            ; init device USER ID = $0000
8191 FD99 C8                    iny   
8192 FD9A 97 24                 sta   [<drvr_dev_ptr],y
8193 FD9C              *
8194 FD9C              * Set DIB pointer for driver and then issue a startup call
8195 FD9C              * to the driver.
8196 FD9C              *
8197 FD9C 20 5B E7              jsr   set_dib_ptr              ; set DIB pointer for startup
8198 FD9F 20 25 EB              jsr   startup_l_drvr           ; startup the driver
8199 FDA2 90 BB                 bcc   insert_loop              ; if startup is ok
8200 FDA4 A7 24                 lda   [<drvr_dev_ptr]          ; next driver same place startup failed
8201 FDA6 3A                    dec   a
8202 FDA7 87 24                 sta   [<drvr_dev_ptr]
8203 FDA9 80 B4                 bra   insert_loop              ; see if more devices to install
8204 FDAB
8205 FDAB              install_done  
8206 FDAB 20 C6 FD              jsr   fix_dev_handle           ; set device list handle size
8207 FDAE FA                    plx   
8208 FDAF 86 02                 stx   <drvr_call_num
8209 FDB1 FA                    plx   
8210 FDB2 86 00                 stx   <drvr_dev_num
8211 FDB4 F0 03                 beq   leave_dib_3
8212 FDB6
8213 FDB6 20 5B E7              jsr   set_dib_ptr              ; restore original DIB pointer
8214 FDB9              leave_dib_3  
8215 FDB9 64 6C                 stz   <post_drvr_tbl
8216 FDBB 64 6E                 stz   <post_drvr_tbl+2
8217 FDBD
8218 FDBD A9 00 00     none_posted lda   #0000
8219 FDC0 8F FA B9 00           sta   >post_index              ; clear post in progress flag
8220 FDC4 AB                    plb   
8221 FDC5 6B                    rtl   
8222 FDC6
8223 FDC6                       eject 
8224 FDC6              *****************************************************************
8225 FDC6              *
8226 FDC6              * Driver installation is complete.  To cleanup, set the device list
8227 FDC6              * handle size to the size of the current device list.  The number
8228 FDC6              * of entries in the device list is multiplied by eight and the
8229 FDC6              * device count is added to the result to calculate the device list
8230 FDC6              * handle size.
8231 FDC6              *
8232 FDC6              * ENTRY: via a 'JSR'
8233 FDC6              *               A Reg = Undefined
8234 FDC6              *               X Reg = Undefined
8235 FDC6              *               Y Reg = Undefined
8236 FDC6              *               B Reg = Undefined
8237 FDC6              *             Dir Reg = GS/OS Direct Page
8238 FDC6              *               P Reg = N V M X D I Z C  E
8239 FDC6              *                       • • 0 0 0 • • •  0
8240 FDC6              *
8241 FDC6              * EXIT: via an 'RTS'
8242 FDC6              *               A Reg = Undefined
8243 FDC6              *               X Reg = Undefined
8244 FDC6              *               Y Reg = Undefined
8245 FDC6              *               B Reg = Undefined
8246 FDC6              *             Dir Reg = Undefined
8247 FDC6              *               P Reg = N V M X D I Z C  E
8248 FDC6              *                       • • 0 0 0 • • •  0
8249 FDC6              *
8250 FDC6              ****************************************************************
8251 FDC6              fix_dev_handle  
8252 FDC6                       longa on
8253 FDC6                       longi on
8254 FDC6
8255 FDC6 08                    php   
8256 FDC7 48                    pha   
8257 FDC8 DA                    phx   
8258 FDC9 5A                    phy   
8259 FDCA
8260 FDCA A7 24                 lda   [<drvr_dev_ptr]          ; get number of devices
8261 FDCC 20 A9 FE              jsr   calc_dev_size            ; get device list size
8262 FDCF 20 A2 FE              jsr   put_handle_size          ; save parameters for set_handle_size
8263 FDD2
8264 FDD2 AC 39 E0              ldy   |dev_list_hndl+2         ; handle to set size of...
8265 FDD5 AE 37 E0              ldx   |dev_list_hndl
8266 FDD8 20 10 E5              jsr   set_handle_size          ; set the size of the handle
8267 FDDB 90 03                 bcc   have_d_h
8268 FDDD 4C 0B E5              jmp   time_to_die
8269 FDE0              have_d_h  
8270 FDE0 20 4D E7              jsr   deref_dev_list           ; dereference device list handle
8271 FDE3
8272 FDE3 7A                    ply   
8273 FDE4 FA                    plx   
8274 FDE5 68                    pla   
8275 FDE6 28                    plp   
8276 FDE7 60                    rts   
8277 FDE8
8278 FDE8                       eject 
8279 FDE8              *****************************************************************
8280 FDE8              *
8281 FDE8              * This routine calculates the index into the file list.
8282 FDE8              *                        _________________
8283 FDE8              *       BASE            |_               _|   Filename entry #1
8284 FDE8              *                       |_               _|
8285 FDE8              *                       |_               _|
8286 FDE8              *                       |_________________|
8287 FDE8              *                                •
8288 FDE8              *                                •
8289 FDE8              *                                •
8290 FDE8              *                        _________________
8291 FDE8              *       BASE+(n*48)     |_               _|   Filename entry #n
8292 FDE8              *                       |_               _|
8293 FDE8              *                       |_               _|
8294 FDE8              *                       |_________________|
8295 FDE8              *
8296 FDE8              * The structure of each filename entry is a 48 byte structure as follows:
8297 FDE8              *
8298 FDE8              *                        _________________
8299 FDE8              *       BASE=0          |_               _|   FileType of filename entry
8300 FDE8              *                       |_________________|
8301 FDE8              *       BASE+2          |_               _|   AuxType of filename entry
8302 FDE8              *                       |_________________|
8303 FDE8              *       BASE+4          |_               _|   User ID of filename entry
8304 FDE8              *                       |_________________|
8305 FDE8              *       BASE+6          |_               _|   Load Address of filename entry
8306 FDE8              *                       |_               _|
8307 FDE8              *                       |_               _|
8308 FDE8              *                       |_________________|
8309 FDE8              *       BASE+10         |_               _|   32 byte filename
8310 FDE8              *                       |                 |
8311 FDE8              *                                •
8312 FDE8              *                                •
8313 FDE8              *                                •
8314 FDE8              *                       |_               _|
8315 FDE8              *                       |_________________|
8316 FDE8              *       BASE+42         |_               _|   Restart Flag of filename entry
8317 FDE8              *                       |_________________|
8318 FDE8              *       BASE+44         |_               _|   Base device number of filename entry
8319 FDE8              *                       |_________________|
8320 FDE8              *       BASE+46         |_               _|   RESERVED for filename entry
8321 FDE8              *                       |_________________|
8322 FDE8              *
8323 FDE8              * ENTRY: via a 'JSR'
8324 FDE8              *               A Reg = File list entry number
8325 FDE8              *               X Reg = Undefined
8326 FDE8              *               Y Reg = Undefined
8327 FDE8              *               B Reg = Undefined
8328 FDE8              *             Dir Reg = GS/OS Direct Page
8329 FDE8              *               P Reg = N V M X D I Z C  E
8330 FDE8              *                       • • 0 0 0 • • •  0
8331 FDE8              *
8332 FDE8              * EXIT: via an 'RTS'
8333 FDE8              *               A Reg = Least significant word size of file list
8334 FDE8              *               X Reg = Most significant word size of file list
8335 FDE8              *               Y Reg = Index into file list
8336 FDE8              *               B Reg = Undefined
8337 FDE8              *             Dir Reg = Undefined
8338 FDE8              *               P Reg = N V M X D I Z C  E
8339 FDE8              *                       • • 0 0 0 • • •  0
8340 FDE8              *
8341 FDE8              ****************************************************************
8342 FDE8              calc_file_index  
8343 FDE8                       longa on
8344 FDE8                       longi on
8345 FDE8
8346 FDE8 8D 29 FE              sta   |current_file            ; need current file number
8347 FDEB A8                    tay   
8348 FDEC F0 37                 beq   no_file_index
8349 FDEE 3A                    dec   a
8350 FDEF 29 0F 00              and   #$000F
8351 FDF2 0A                    asl   a
8352 FDF3 AA                    tax   
8353 FDF4 BD 2D FE              lda   |file_list_tbl,x
8354 FDF7 8D 2B FE              sta   |file_index
8355 FDFA AD 29 FE              lda   |current_file
8356 FDFD 3A                    dec   a
8357 FDFE 29 F0 00              and   #$00F0
8358 FE01 4A                    lsr   a
8359 FE02 4A                    lsr   a
8360 FE03 4A                    lsr   a
8361 FE04 AA                    tax   
8362 FE05 BD 2D FE              lda   |file_list_tbl,x
8363 FE08 0A                    asl   a
8364 FE09 0A                    asl   a
8365 FE0A 0A                    asl   a
8366 FE0B 0A                    asl   a
8367 FE0C 6D 2B FE              adc   |file_index
8368 FE0F 8D 2B FE              sta   |file_index
8369 FE12
8370 FE12 48                    pha   
8371 FE13 18                    clc   
8372 FE14 65 2C                 adc   <file_list_ptr           ; set pointer to entry
8373 FE16 85 56                 sta   <file_entry_ptr
8374 FE18 A9 00 00              lda   #0
8375 FE1B 65 2E                 adc   <file_list_ptr+2
8376 FE1D 85 58                 sta   <file_entry_ptr+2
8377 FE1F 68                    pla   
8378 FE20
8379 FE20 A8                    tay                            ; Y = index to current entry
8380 FE21 18                    clc   
8381 FE22 69 30 00              adc   #$0030                   ; A = size from base to top of this entry
8382 FE25              no_file_index  
8383 FE25 A2 00 00              ldx   #0
8384 FE28 60                    rts   
8385 FE29
8386 FE29 02 00        current_file DC W:0
8387 FE2B 30 00        file_index DC W:0
8388 FE2D
8389 FE2D 00 00        file_list_tbl DC W:$0000                ; entry # 1 index
8390 FE2F 30 00                 DC W:$0030                     ; entry # 2 index
8391 FE31 60 00                 DC W:$0060                     ; entry # 3 index
8392 FE33 90 00                 DC W:$0090                     ; entry # 4 index
8393 FE35 C0 00                 DC W:$00C0                     ; entry # 5 index
8394 FE37 F0 00                 DC W:$00F0                     ; entry # 6 index
8395 FE39 20 01                 DC W:$0120                     ; entry # 7 index
8396 FE3B 50 01                 DC W:$0150                     ; entry # 8 index
8397 FE3D 80 01                 DC W:$0180                     ; entry # 9 index
8398 FE3F B0 01                 DC W:$01B0                     ; entry # 10 index
8399 FE41 E0 01                 DC W:$01E0                     ; entry # 11 index
8400 FE43 10 02                 DC W:$0210                     ; entry # 12 index
8401 FE45 40 02                 DC W:$0240                     ; entry # 13 index
8402 FE47 70 02                 DC W:$0270                     ; entry # 14 index
8403 FE49 A0 02                 DC W:$02A0                     ; entry # 15 index
8404 FE4B D0 02                 DC W:$02D0                     ; entry # 16 index
8405 FE4D
8406 FE4D
8407 FE4D                       eject 
8408 FE4D              *****************************************************************
8409 FE4D              *
8410 FE4D              * This routine dereferences a handle.
8411 FE4D              *
8412 FE4D              * ENTRY: via a 'JSR'
8413 FE4D              *               A Reg = Least significant word of handle
8414 FE4D              *               X Reg = Most significant word of handle
8415 FE4D              *               Y Reg = Undefined
8416 FE4D              *               B Reg = Undefined
8417 FE4D              *             Dir Reg = GS/OS Direct Page
8418 FE4D              *               P Reg = N V M X D I Z C  E
8419 FE4D              *                       • • 0 0 0 • • •  0
8420 FE4D              *
8421 FE4D              * EXIT: via an 'RTS'
8422 FE4D              *               A Reg = Least significant word of pointer
8423 FE4D              *               X Reg = Most significant word of pointer
8424 FE4D              *               Y Reg = Unchanged
8425 FE4D              *               B Reg = Unchanged
8426 FE4D              *             Dir Reg = Unchanged
8427 FE4D              *               P Reg = N V M X D I Z C  E
8428 FE4D              *                       • • 0 0 0 • • •  0
8429 FE4D              *
8430 FE4D              ****************************************************************
8431 FE4D              deref_handle  
8432 FE4D                       longa on
8433 FE4D                       longi on
8434 FE4D
8435 FE4D 8B                    phb   
8436 FE4E
8437 FE4E DA                    phx   
8438 FE4F AB                    plb   
8439 FE50 AA                    tax   
8440 FE51 BC 02 00              ldy   |2,x
8441 FE54 BD 00 00              lda   |0,x
8442 FE57 BB                    tyx   
8443 FE58 AB                    plb   
8444 FE59
8445 FE59 AB                    plb   
8446 FE5A 60                    rts   
8447 FE5B
8448 FE5B                       eject 
8449 FE5B              ****************************************************************
8450 FE5B              *
8451 FE5B              * This system service routine posts a DIB address for future
8452 FE5B              * driver installation.  Installation will occur following the
8453 FE5B              * current or next return from the device dispatcher.
8454 FE5B              *
8455 FE5B              *                _____________________
8456 FE5B              *       +$0000  |_                   _|
8457 FE5B              *               |_  Count of number  _|
8458 FE5B              *               |_  DIBs to install  _|
8459 FE5B              *               |_____________________|
8460 FE5B              *       +$0004  |_                   _|
8461 FE5B              *               |_    Pointer to     _|
8462 FE5B              *               |_    first DIB      _|
8463 FE5B              *               |_____________________|
8464 FE5B              *       +$0008  |_                   _|
8465 FE5B              *               |_    Pointer to     _|
8466 FE5B              *               |_    second DIB     _|
8467 FE5B              *               |_____________________|
8468 FE5B              *
8469 FE5B              * ENTRY: via a 'JSL'
8470 FE5B              *               A Reg = Undefined
8471 FE5B              *               X Reg = DIB address (low)
8472 FE5B              *               Y Reg = DIB address (high)
8473 FE5B              *               B Reg = Undefined
8474 FE5B              *             Dir Reg = GS/OS Direct Page
8475 FE5B              *               P Reg = N V M X D I Z C  E
8476 FE5B              *                       • • 0 0 0 • • •  0
8477 FE5B              *
8478 FE5B              * EXIT: via an 'RTL'
8479 FE5B              *               A Reg = Error code (no_error, drvr_busy or out_of_mem)
8480 FE5B              *               X Reg = Unspecified
8481 FE5B              *               Y Reg = Unspecified
8482 FE5B              *               B Reg = Unchanged
8483 FE5B              *             Dir Reg = Unchanged
8484 FE5B              *               P Reg = N V M X D I Z C  E
8485 FE5B              *                       • • 0 0 0 • • 0  0 if drivers can be installed
8486 FE5B              *                       • • 0 0 0 • • 1  0 if drivers cannot be installed
8487 FE5B              *
8488 FE5B              ****************************************************************
8489 FE5B                       export post_driver
8490 FE5B              post_driver              
8491 FE5B                       longa on
8492 FE5B                       longi on
8493 FE5B
8494 FE5B 8B                    phb   
8495 FE5C 4B                    phk   
8496 FE5D AB                    plb   
8497 FE5E 0B                    phd   
8498 FE5F A9 00 BD              lda   #direct_base
8499 FE62 5B                    tcd   
8500 FE63
8501 FE63 A5 6C                 lda   <post_drvr_tbl           ; is a call pending?
8502 FE65 05 6E                 ora   <post_drvr_tbl+2
8503 FE67 F0 03                 beq   post_it                  ; no
8504 FE69 4C 9B FE              jmp   cant_post_drvr           ; yes, cant install this one!
8505 FE6C              post_it   
8506 FE6C 86 6C                 stx   <post_drvr_tbl           ; save addr of posted driver table
8507 FE6E 84 6E                 sty   <post_drvr_tbl+2
8508 FE70
8509 FE70              *
8510 FE70              * Current device list size is added to size of post driver install
8511 FE70              * list to set device list handle size (8 bytes per device).
8512 FE70              *
8513 FE70 18                    clc   
8514 FE71 A7 6C                 lda   [<post_drvr_tbl]
8515 FE73 67 24                 adc   [<drvr_dev_ptr]
8516 FE75 20 A9 FE              jsr   calc_dev_size            ; get device list size
8517 FE78 20 A2 FE              jsr   put_handle_size
8518 FE7B AC 39 E0              ldy   |dev_list_hndl+2         ; handle to set size of...
8519 FE7E AE 37 E0              ldx   |dev_list_hndl
8520 FE81 20 10 E5              jsr   set_handle_size          ; set the handle size
8521 FE84
8522 FE84              post_exit  
8523 FE84 08                    php                            ; save exit status
8524 FE85 48                    pha   
8525 FE86
8526 FE86 20 4D E7              jsr   deref_dev_list           ; dereference device list handle
8527 FE89
8528 FE89 68                    pla                            ; restore exit status
8529 FE8A 28                    plp   
8530 FE8B 2B                    pld   
8531 FE8C AB                    plb   
8532 FE8D 6B                    rtl   
8533 FE8E              *
8534 FE8E              * If memory could not be allocated then an error indicating this
8535 FE8E              * condition must be returned.
8536 FE8E              *
8537 FE8E              no_memory  
8538 FE8E                       longa on
8539 FE8E                       longi on
8540 FE8E
8541 FE8E 64 6C                 stz   <post_drvr_tbl
8542 FE90 64 6E                 stz   <post_drvr_tbl+2
8543 FE92
8544 FE92 20 C6 FD              jsr   fix_dev_handle           ; set device list handle size
8545 FE95
8546 FE95 A9 54 00              lda   #out_of_mem              ; cant allocate for post_driver
8547 FE98 38                    sec   
8548 FE99 80 E9                 bra   post_exit
8549 FE9B
8550 FE9B              cant_post_drvr  
8551 FE9B A9 29 00              lda   #drvr_busy               ; cannot install driver right now.
8552 FE9E 38                    sec   
8553 FE9F 2B                    pld   
8554 FEA0 AB                    plb   
8555 FEA1 6B                    rtl   
8556 FEA2
8557 FEA2              put_handle_size  
8558 FEA2 8D 3F E0              sta   |handle_size
8559 FEA5 8E 41 E0              stx   |handle_size+2
8560 FEA8 60                    rts   
8561 FEA9
8562 FEA9                       eject 
8563 FEA9              *****************************************************************
8564 FEA9              *
8565 FEA9              * The following routine calculates the handle size for the
8566 FEA9              * device list based on the number of devices passed as input
8567 FEA9              * in A.  NOTE that an artificial limit of 63 devices currently
8568 FEA9              * exists.
8569 FEA9              *
8570 FEA9              * ENTRY: via a 'JSR'
8571 FEA9              *               A Reg = Low word number of devices
8572 FEA9              *               X Reg = Undefined
8573 FEA9              *               Y Reg = Undefined
8574 FEA9              *               B Reg = Undefined
8575 FEA9              *             Dir Reg = GS/OS Direct Page
8576 FEA9              *               P Reg = N V M X D I Z C  E
8577 FEA9              *                       • • 0 0 0 • • •  0
8578 FEA9              *
8579 FEA9              * EXIT: via an 'RTS'
8580 FEA9              *      |dev_list_size = Size of device list
8581 FEA9              *               A Reg = Device list handle size
8582 FEA9              *               X Reg = Unchanged
8583 FEA9              *               Y Reg = Unchanged
8584 FEA9              *               B Reg = Unchanged
8585 FEA9              *             Dir Reg = Unchanged
8586 FEA9              *               P Reg = N V M X D I Z C  E
8587 FEA9              *                       • • 0 0 0 • • •  0
8588 FEA9              *
8589 FEA9              ****************************************************************
8590 FEA9              calc_dev_size  
8591 FEA9                       longa on
8592 FEA9                       longi on
8593 FEA9
8594 FEA9 9C 3D E0              stz   |dev_list_size+2
8595 FEAC              *
8596 FEAC              * Size = (device count * 8) + 4
8597 FEAC              *
8598 FEAC 38                    sec   
8599 FEAD 2A                    rol   a
8600 FEAE 0E 3D E0              asl   |dev_list_size+2
8601 FEB1 0A                    asl   a
8602 FEB2 0E 3D E0              asl   |dev_list_size+2
8603 FEB5 0A                    asl   a
8604 FEB6 0E 3D E0              asl   |dev_list_size+2
8605 FEB9              *
8606 FEB9              * Return with device list size.
8607 FEB9              *
8608 FEB9 8D 3B E0              sta   |dev_list_size
8609 FEBC AE 3D E0              ldx   |dev_list_size+2
8610 FEBF 60                    rts   
8611 FEC0
8612 FEC0                       eject 
8613 FEC0              *****************************************************************
8614 FEC0              *
8615 FEC0              * The following routine walks each entry of the file list to find
8616 FEC0              * the file entry with the user ID (shutdown_id) of a driver being
8617 FEC0              * purged.  The file entry will be marked as purged by writting a
8618 FEC0              * zero to the file entry file type.
8619 FEC0              *
8620 FEC0              * ENTRY: via a 'JSR'
8621 FEC0              *               A Reg = Low word number of devices
8622 FEC0              *               X Reg = Undefined
8623 FEC0              *               Y Reg = Undefined
8624 FEC0              *               B Reg = Undefined
8625 FEC0              *             Dir Reg = GS/OS Direct Page
8626 FEC0              *               P Reg = N V M X D I Z C  E
8627 FEC0              *                       • • 0 0 0 • • •  0
8628 FEC0              *
8629 FEC0              * EXIT: via an 'RTS'
8630 FEC0              *      |dev_list_size = Size of device list
8631 FEC0              *               A Reg = Device list handle size
8632 FEC0              *               X Reg = Unchanged
8633 FEC0              *               Y Reg = Unchanged
8634 FEC0              *               B Reg = Unchanged
8635 FEC0              *             Dir Reg = Unchanged
8636 FEC0              *               P Reg = N V M X D I Z C  E
8637 FEC0              *                       • • 0 0 0 • • •  0
8638 FEC0              *
8639 FEC0              ****************************************************************
8640 FEC0              mark_file_list  
8641 FEC0                       longa on
8642 FEC0                       longi on
8643 FEC0
8644 FEC0 AD 29 FE              lda   |current_file
8645 FEC3 48                    pha   
8646 FEC4
8647 FEC4 AD B3 E0              lda   |dd_os_call              ; is purge during os startup?
8648 FEC7 D0 26                 bne   no_file_entries          ; no, dont remove it from the list
8649 FEC9
8650 FEC9 AD 51 E0              lda   |file_list_cnt           ; point at last entry
8651 FECC F0 21                 beq   no_file_entries
8652 FECE
8653 FECE 8D 29 FE              sta   |current_file
8654 FED1              walk_loop_1  
8655 FED1 AD 29 FE              lda   |current_file            ; set pointer to file entry
8656 FED4 20 E8 FD              jsr   calc_file_index
8657 FED7
8658 FED7 A0 04 00              ldy   #file_user_id            ; is current entry the shutdown ID?
8659 FEDA B7 56                 lda   [<file_entry_ptr],y
8660 FEDC CD B1 E0              cmp   |shutdown_id
8661 FEDF F0 07                 beq   found_file_id            ; yes
8662 FEE1
8663 FEE1 CE 29 FE              dec   |current_file            ; else check if more entries
8664 FEE4 D0 EB                 bne   walk_loop_1              ; if more entries
8665 FEE6 80 07                 bra   no_file_entries          ; ID is not in the file entry
8666 FEE8              *
8667 FEE8              * Mark the current file entry as purged by zeroing out the file type
8668 FEE8              * in the file list entry.
8669 FEE8              *
8670 FEE8              found_file_id  
8671 FEE8 A9 00 00              lda   #0                       ; zero out file type
8672 FEEB 87 56                 sta   [<file_entry_ptr]
8673 FEED 97 56                 sta   [<file_entry_ptr],y      ; zero out user ID so for subsequent search
8674 FEEF              no_file_entries  
8675 FEEF 68                    pla   
8676 FEF0 8D 29 FE              sta   |current_file
8677 FEF3 20 E8 FD              jsr   calc_file_index
8678 FEF6 60                    rts   
8679 FEF7
8680 FEF7                       eject 
8681 FEF7              *****************************************************************
8682 FEF7              *
8683 FEF7              * The following routine walks each entry of the file list to find
8684 FEF7              * the file containing the file name that matches the string in
8685 FEF7              * file_name_str.
8686 FEF7              *
8687 FEF7              * ENTRY: via a 'JSR'
8688 FEF7              *               A Reg = Low word number of devices
8689 FEF7              *               X Reg = Undefined
8690 FEF7              *               Y Reg = Undefined
8691 FEF7              *               B Reg = Undefined
8692 FEF7              *             Dir Reg = GS/OS Direct Page
8693 FEF7              *               P Reg = N V M X D I Z C  E
8694 FEF7              *                       • • 0 0 0 • • •  0
8695 FEF7              *
8696 FEF7              * EXIT: via an 'RTS'
8697 FEF7              *      |dev_list_size = Size of device list
8698 FEF7              *               A Reg = Device list handle size
8699 FEF7              *               X Reg = Unchanged
8700 FEF7              *               Y Reg = Unchanged
8701 FEF7              *               B Reg = Unchanged
8702 FEF7              *             Dir Reg = Unchanged
8703 FEF7              *               P Reg = N V M X D I Z C  E
8704 FEF7              *                       • • 0 0 0 • • 0  0      File found in memory
8705 FEF7              *                       • • 0 0 0 • • 1  0      File not found in memory
8706 FEF7              *
8707 FEF7              ****************************************************************
8708 FEF7              find_file  
8709 FEF7                       longa on
8710 FEF7                       longi on
8711 FEF7
8712 FEF7 AD 51 E0              lda   |file_list_cnt           ; are there any file list entries?
8713 FEFA F0 3B                 beq   no_fl_entry              ; no, return error to load from disk
8714 FEFC
8715 FEFC A9 01 00              lda   #$0001                   ; start at first entry
8716 FEFF 8D 29 FE              sta   |current_file
8717 FF02              find_loop_1  
8718 FF02 AD 29 FE              lda   |current_file            ; set pointer to file entry
8719 FF05 20 E8 FD              jsr   calc_file_index
8720 FF08
8721 FF08 A0 0A 00              ldy   #file_name               ; is current entry the target driver?
8722 FF0B B7 56                 lda   [<file_entry_ptr],y
8723 FF0D F0 1B                 beq   wrong_entry              ; nil string length is not valid!
8724 FF0F CD CF E1              cmp   |file_name_str           ; same length?
8725 FF12 D0 18                 bne   wrong_entry_2            ; no, can't be equal
8726 FF14
8727 FF14 AA                    tax                            ; put length into X
8728 FF15 38                    sec                            ; allow for string length word
8729 FF16 69 0A 00              adc   #file_name               ; make index to last character of name
8730 FF19 A8                    tay   
8731 FF1A
8732 FF1A E2 20                 sep   #$20                     ; 8 bit 'm'
8733 FF1C                       longa off
8734 FF1C
8735 FF1C              find_loop_2  
8736 FF1C B7 56                 lda   [<file_entry_ptr],y
8737 FF1E DD D0 E1              cmp   |file_name_str+1,x
8738 FF21 D0 07                 bne   wrong_entry              ; wrong file list entry if string mismatch
8739 FF23 88                    dey   
8740 FF24 CA                    dex   
8741 FF25 D0 F5                 bne   find_loop_2
8742 FF27
8743 FF27 C2 21                 rep   #$21                     ; 16 bit 'm' and CLC to
8744 FF29                       longa on                       ;   indicate file found in memory
8745 FF29 60                    rts   
8746 FF2A
8747 FF2A              wrong_entry  
8748 FF2A C2 20                 rep   #$20                     ; 16 bit 'm'
8749 FF2C                       longa on
8750 FF2C              wrong_entry_2  
8751 FF2C EE 29 FE              inc   |current_file            ; else check if more entries
8752 FF2F AD 51 E0              lda   |file_list_cnt
8753 FF32 CD 29 FE              cmp   |current_file
8754 FF35 B0 CB                 bge   find_loop_1              ; if more entries
8755 FF37              no_fl_entry  
8756 FF37 38                    sec                            ; indicate file not found in memory
8757 FF38 60                    rts   
8758 FF39
8759 FF39                       endp 
8760 FF39
8761 FF39                       end   
